<?php

/**
 * @package 	: 	PowerBBLang
 * @author 		: 	Suleiman Daoud Suleiman <xxx_abu_rakan_xxx@hotmail.com>
 * @start 		: 	25/5/2009 , 8:38 PM
 * @end   		: 	27/5/2009 , 9:47 PM
 */


(!defined('IN_PowerBB')) ? die() : '';

define('IN_ADMIN',true);

$CALL_SYSTEM			=	array();
$CALL_SYSTEM['LANG'] 	= 	true;

include('common.php');

define('CLASS_NAME','PowerBBLangMOD');

class PowerBBLangMOD extends _functions
{
	function run()
	{
		global $PowerBB;

		$PowerBB->template->display('header');

			if ($PowerBB->_CONF['rows']['group_info']['admincp_lang'] == '0')
			{
			  $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}


		if ($PowerBB->_CONF['member_permission'])
		{
			if ($PowerBB->_GET['add'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_AddMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_AddStart();
				}
			}
			elseif ($PowerBB->_GET['control'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_ControlMain();
				}
			}
			elseif ($PowerBB->_GET['edit'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_EditMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_EditStart();
				}
			}
			elseif ($PowerBB->_GET['del'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_DelMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_DelStart();
				}
			}
			if ($PowerBB->_GET['default'])
			{
				$this->_DefaultMain();
			}

			$PowerBB->template->display('footer');
		}
	}

	function _AddMain()
	{
		global $PowerBB;

		$LangDir = ('lang/');

		if (is_dir($LangDir))
		{
			$dir = opendir($LangDir);

			if ($dir)
			{
				while (($file = readdir($dir)) !== false)
				{
					if ($file == '.'
						or $file == '..')
					{
						continue;
					}

					$LanguageList[]['filename'] = $file;
				}

				closedir($dir);
			}
		}

		$PowerBB->_CONF['template']['foreach']['LanguageList'] = $LanguageList;

		 $TotalLanguageNm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['lang'] . " WHERE id"));
		 $PowerBB->template->assign('order',$TotalLanguageNm+1);

		$PowerBB->template->display('lang_add');
	}

	function _AddStart()
	{
		global $PowerBB;

		if (empty($PowerBB->_POST['name']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_write_the_name_of_Language']);
		}

		if (empty($PowerBB->_POST['lang_order']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_enter_the_order_number_language']);
		}

		if (empty($PowerBB->_POST['foldr']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_write_the_name_of_the_folder_path_language']);
		}

		if ($PowerBB->lang->GetLangList(array('where' => array('lang_title',$PowerBB->_POST['name']))))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['please_write_the_Language_name_of_another']);
		}

		if ($PowerBB->_POST['default'] == '1')
	     {
		   $update = array();
           $update = $PowerBB->info->UpdateInfo(array('value'=>$PowerBB->_POST['lang_path'],'var_name'=>'def_lang'));
         }

		if ($PowerBB->lang->IsLang(array('where' => array('lang_path',$PowerBB->_POST['foldr']))))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['This_language'] . $PowerBB->_POST['foldr'] . $PowerBB->_CONF['template']['lang']['Already_added']);
		}


		$LangArr 					= 	array();
		$LangArr['field']			=	array();

		$LangArr['field']['lang_title'] 	= 	$PowerBB->_POST['name'];
		$LangArr['field']['lang_order'] 	= 	$PowerBB->_POST['lang_order'];
		$LangArr['field']['lang_path'] 		= 	$PowerBB->_POST['foldr'];
		$LangArr['field']['lang_on'] 		= 	$PowerBB->_POST['lang_on'];


		$insert = $PowerBB->lang->InsertLang($LangArr);


		if ($insert)
		{
               	$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['language_has_been_added_successfully']);
	            $PowerBB->functions->redirect('admin.php?page=lang&amp;control=1&amp;main=1');

         }

	}

	function _ControlMain()
	{
		global $PowerBB;

		$LangArr 					= 	array();
		$LangArr['proc'] 			= 	array();
		$LangArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');
		$LangArr['order']			=	array();
		$LangArr['order']['field']	=	'id';
		$LangArr['order']['type']	=	'DESC';

		$PowerBB->_CONF['template']['while']['LangList'] = $PowerBB->lang->GetLangList($LangArr);

		$LangDefArr 					= 	array();
		$LangDefArr['proc'] 			= 	array();
		$LangDefArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');
		$LangDefArr['order']			=	array();
		$LangDefArr['order']['field']	=	'id';
		$LangDefArr['order']['type']	=	'DESC';

		$PowerBB->_CONF['template']['while']['LangDef'] = $PowerBB->lang->GetLangList($LangDefArr);

		$PowerBB->template->display('lang_main');
	}

	function _EditMain()
	{
		global $PowerBB;

		$this->check_by_id($PowerBB->_CONF['template']['Inf']);

		$PowerBB->template->display('lang_edit');
	}

	function _EditStart()
	{
		global $PowerBB;

		$this->check_by_id($Inf);

		if (empty($PowerBB->_POST['name']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_write_the_name_of_Language']);
		}

		if (empty($PowerBB->_POST['lang_order']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_enter_the_order_number_language']);
		}

		if (empty($PowerBB->_POST['lang_path']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_write_the_name_of_the_folder_path_language']);
		}

		//////////

		$LangArr 					= 	array();
		$LangArr['field']			=	array();

		$LangArr['field']['lang_title'] 	= 	$PowerBB->_POST['name'];
		$LangArr['field']['lang_path'] 		= 	$PowerBB->_POST['lang_path'];
		$LangArr['field']['lang_order'] 	= 	$PowerBB->_POST['lang_order'];
		$LangArr['field']['lang_on'] 		= 	$PowerBB->_POST['lang_on'];
		$LangArr['where']					= 	array('id',$Inf['id']);

		$update = $PowerBB->lang->UpdateLang($LangArr);


		//////////

		if ($update)
		{
  			if ($PowerBB->_POST['lang_on'] == '0')
			{
			$UpdateMemArr 				= 	array();
			$UpdateMemArr['field']		=	array();

			$UpdateMemArr['field']['lang'] 	= 	$PowerBB->_CONF['info_row']['def_lang'];
			$UpdateMemArr['where'] 				= 	array('lang',$Inf['id']);

			$update = $PowerBB->member->UpdateMember($UpdateMemArr);
			}

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['language_has_been_updated_successfully']);
			$PowerBB->functions->redirect('admin.php?page=lang&amp;control=1&amp;main=1');

			//////////
		}

		//////////
	}

	function _DelMain()
	{
		global $PowerBB;

		$this->check_by_id($PowerBB->_CONF['template']['Inf']);

		$PowerBB->template->display('lang_del');
	}

	function _DelStart()
	{
		global $PowerBB;

		$this->check_by_id($Inf);



	     if ($PowerBB->_CONF['info_row']['def_lang'] == $Inf['id'])
	     {
             $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_can_not_delete_the_default_language']);
         }

         //
		if ($PowerBB->member->IsMember(array('where' => array('lang',$Inf['id']))))
		{
		 $UpdateArr 				                = 	array();
		 $UpdateArr['field'] 	                    = 	array();
		 $UpdateArr['field']['lang'] 			    = 	'1';
		 $UpdateArr['where']						=	array('lang',$Inf['id']);

		 $update = $PowerBB->member->UpdateMember($UpdateArr);
		}

		$DelArr 			= 	array();
		$DelArr['where'] 	= 	array('id',$Inf['id']);

		$del = $PowerBB->lang->DeleteLang($DelArr);

		if ($del)
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['language_has_been_deleted_successfully']);
			$PowerBB->functions->redirect('admin.php?page=lang&amp;control=1&amp;main=1');
		}
	}

	function _DefaultMain()
	{
		global $PowerBB;

        $update = array();
        $update = $PowerBB->info->UpdateInfo(array('value'=>$PowerBB->_POST['default'],'var_name'=>'def_lang'));


		//////////

		if ($update)
		{
			//////////

           $getmember_query = $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['member'] . " ORDER BY id DESC");

             while ($getmember_row = $PowerBB->DB->sql_fetch_array($getmember_query))
             {

				$UpdateArr 				                = 	array();
				$UpdateArr['field'] 	                    = 	array();
				$UpdateArr['field']['lang'] 			    = 	$PowerBB->_POST['default'];
				$UpdateArr['where']						=	array('id',$getmember_row['id']);

				$update = $PowerBB->member->UpdateMember($UpdateArr);

             }

            $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['language_has_been_updated_successfully']);
			$PowerBB->functions->redirect('admin.php?page=lang&amp;control=1&amp;main=1');

			//////////
		}

    }
}

class _functions
{
	function check_by_id(&$Inf)
	{
		global $PowerBB;

		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['The_request_is_not_valid']);
		}

		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		$LangArr 			= 	array();
		$LangArr['where'] 	= 	array('id',$PowerBB->_GET['id']);

		$Inf = $PowerBB->lang->GetLangInfo($LangArr);

		if ($Inf == false)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['language_requested_does_not_exist']);
		}

		$PowerBB->functions->CleanVariable($Inf,'html');
	}
}

?>
