<?php

(!defined('IN_PowerBB')) ? die() : '';

define('IN_ADMIN',true);

$CALL_SYSTEM			=	array();
$CALL_SYSTEM['STYLE'] 	= 	true;

include('common.php');

define('CLASS_NAME','PowerBBStyleMOD');

class PowerBBStyleMOD extends _functions
{
	function run()
	{
		global $PowerBB;

		$PowerBB->template->display('header');
			if ($PowerBB->_CONF['rows']['group_info']['admincp_style'] == '0')
			{
			  $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}

		if ($PowerBB->_CONF['member_permission'])
		{
			if ($PowerBB->_GET['add'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_AddMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_AddStart();
				}
			}
			elseif ($PowerBB->_GET['control'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_ControlMain();
				}
			}
			elseif ($PowerBB->_GET['edit'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_EditMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_EditStart();
				}
			}
			elseif ($PowerBB->_GET['del'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_DelMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_DelStart();
				}
			}
			elseif ($PowerBB->_GET['export'])
			{
				if ($PowerBB->_GET['start'])
				{
					$this->_ExportStart();
				}
			}
			elseif ($PowerBB->_GET['edit_css'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_CssMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_CssStart();
				}
			}
			if ($PowerBB->_GET['default'])
			{
				$this->_DefaultMain();
			}

			$PowerBB->template->display('footer');
		}
	}

	function _AddMain()
	{
		global $PowerBB;

		$StyleDir = ('look/styles/forum/');

		if (is_dir($StyleDir))
		{
			$dir = opendir($StyleDir);

			if ($dir)
			{
				while (($file = readdir($dir)) !== false)
				{
					if ($file == '.'
						or $file == '..')
					{
						continue;
					}

					$StylesList[]['filename'] = $file;
				}

				closedir($dir);
			}
		}

		$PowerBB->_CONF['template']['foreach']['StyleList'] = $StylesList;

		 $TotalStylesNm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['style'] . " WHERE id"));
		 $PowerBB->template->assign('order',$TotalStylesNm+1);

		$PowerBB->template->display('style_add');
	}

	function _AddStart()
	{
		global $PowerBB;

        $this->_ExportStart();
	}

	function _ControlMain()
	{
		global $PowerBB;

		$StlArr 					= 	array();
		$StlArr['proc'] 			= 	array();
		$StlArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');
		$StlArr['order']			=	array();
		$StlArr['order']['field']	=	'id';
		$StlArr['order']['type']	=	'DESC';

		$PowerBB->_CONF['template']['while']['StlList'] = $PowerBB->style->GetStyleList($StlArr);

		$StlDefArr 					= 	array();
		$StlDefArr['proc'] 			= 	array();
		$StlDefArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');
		$StlDefArr['order']			=	array();
		$StlDefArr['order']['field']	=	'id';
		$StlDefArr['order']['type']	=	'DESC';

		$PowerBB->_CONF['template']['while']['StlDef'] = $PowerBB->style->GetStyleList($StlDefArr);

		$PowerBB->template->display('styles_main');
	}

	function _EditMain()
	{
		global $PowerBB;

		$this->check_by_id($PowerBB->_CONF['template']['Inf']);

		$PowerBB->template->display('style_edit');
	}

	function _EditStart()
	{
		global $PowerBB;

		$this->check_by_id($Inf);

		if (empty($PowerBB->_POST['name'])
			or empty($PowerBB->_POST['style_path'])
			or empty($PowerBB->_POST['image_path'])
			or empty($PowerBB->_POST['template_path']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_fill_in_all_the_information']);
		}

		if ($PowerBB->_POST['order'] == '')
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_fill_in_all_the_information']);
         }

		//////////

		$StlArr 			= 	array();
		$StlArr['field']	=	array();

		$StlArr['field']['style_title'] 	= 	$PowerBB->_POST['name'];
		$StlArr['field']['style_path'] 		= 	$PowerBB->_POST['style_path'];
		$StlArr['field']['style_order'] 	= 	$PowerBB->_POST['order'];
		$StlArr['field']['style_on'] 		= 	$PowerBB->_POST['style_on'];
		$StlArr['field']['image_path'] 		= 	$PowerBB->_POST['image_path'];
		$StlArr['field']['template_path'] 	= 	$PowerBB->_POST['template_path'];
		$StlArr['field']['cache_path'] 		= 	$PowerBB->_POST['cache_path'];
		$StlArr['where']					= 	array('id',$Inf['id']);

		$update = $PowerBB->style->UpdateStyle($StlArr);

		//////////

		if ($update)
		{
			//////////

			$UpdateArr 				= 	array();
			$UpdateArr['field']		=	array();

			$UpdateArr['field']['should_update_style_cache'] 	= 	1;
			$UpdateArr['where'] 								= 	array('style',$Inf['id']);

			$cache_update = $PowerBB->member->UpdateMember($UpdateArr);

			if ($PowerBB->_POST['style_on'] == '0')
			{
			$UpdateMemArr 				= 	array();
			$UpdateMemArr['field']		=	array();

			$UpdateMemArr['field']['style'] 	= 	$PowerBB->_CONF['info_row']['def_style'];
			$UpdateMemArr['where'] 				= 	array('style',$Inf['id']);

			$update = $PowerBB->member->UpdateMember($UpdateMemArr);
			}

			//////////

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Style_has_been_updated_successfully']);
			$PowerBB->functions->redirect('admin.php?page=style&amp;control=1&amp;main=1');

			//////////
		}

		//////////
	}

	function _DelMain()
	{
		global $PowerBB;

		$this->check_by_id($PowerBB->_CONF['template']['Inf']);

		$PowerBB->template->display('style_del');
	}

	function _DelStart()
	{
		global $PowerBB;

		$this->check_by_id($Inf);

		if ($PowerBB->_CONF['info_row']['def_style'] == $Inf['id'])
	     {
             $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_can_not_delete_the_default_Style']);
         }

        //
		if ($PowerBB->member->IsMember(array('where' => array('style',$Inf['id']))))
		{
		 $UpdateArr 				                = 	array();
		 $UpdateArr['field'] 	                    = 	array();
		 $UpdateArr['field']['style'] 			    = 	'1';
		 $UpdateArr['where']						=	array('style',$Inf['id']);

		 $update = $PowerBB->member->UpdateMember($UpdateArr);
		}

		$DelArr 			= 	array();
		$DelArr['where'] 	= 	array('id',$Inf['id']);

		$del = $PowerBB->style->DeleteStyle($DelArr);

		if ($del)
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Style_has_been_deleted_successfully']);
			$PowerBB->functions->redirect('admin.php?page=style&amp;control=1&amp;main=1');
		}
	}

   function _ExportStart()
   {
     global $PowerBB;

		//
		$path_foldr   = "look/styles/forum/".$PowerBB->_POST['foldr']."/templates";
		if ($PowerBB->style->IsStyle(array('where' => array('template_path',$path_foldr))))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['This_Style']. ' ' . $PowerBB->_POST['foldr'] . ' ' .$PowerBB->_CONF['template']['lang']['Already_added']);
		}
		else
	    {

			$name = $PowerBB->_POST['foldr'];
	        $path_t   = "look/styles/forum/".$name;
	        $path_s   = $path_t."/css/style.css";
	        $path_img = $path_t."/images";
	        $path_tpl = $path_t."/templates";
	        $path_ch  = $path_t."/compiler";


	       	$StlArr 					= 	array();
			$StlArr['field']			=	array();

			$StlArr['field']['style_title'] 	= 	$PowerBB->_POST['name'];
			$StlArr['field']['style_path'] 		= 	$path_s;
			$StlArr['field']['style_order'] 	= 	$PowerBB->_POST['order'];
			$StlArr['field']['style_on'] 		= 	$PowerBB->_POST['style_on'];
			$StlArr['field']['image_path'] 		= 	$path_img;
			$StlArr['field']['template_path'] 	= 	$path_tpl;
			$StlArr['field']['cache_path'] 		= 	$path_ch;

			$insert = $PowerBB->style->InsertStyle($StlArr);

			if ($insert)
			{

				$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Style_has_been_added_successfully']);
				$PowerBB->functions->redirect('admin.php?page=style&amp;control=1&amp;main=1');
			}
	        else
	        {
	        	$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Style_is_not_added']);
	         }
        }
    }

    function _CssMain()
	{
		global $PowerBB;

		$this->check_by_id($PowerBB->_CONF['template']['Inf']);

		if (empty($PowerBB->_GET['id']))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
    	}

		$CssArr 			= 	array();
		$CssArr['where'] 	= 	array('id',$PowerBB->_GET['id']);

        $Css = $PowerBB->style->GetStyleInfo($CssArr);

        $path = $Css['style_path'];

        if (!file_exists($path))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
    	}
    	$lines = file($path);
    	$context = '';

    	foreach ($lines as $line)
    	{
    		$context .= $line;
    	}

    	$context = $PowerBB->functions->CleanVariable($context,'unhtml');
        $PowerBB->template->assign('style_path',$Css['style_path']);
    	$PowerBB->template->assign('css_context',$context);

		$PowerBB->template->display('css_edit');
	}

	function _CssStart()
	{
		global $PowerBB;

		$this->check_by_id($Inf);

    	$StyleInfo = false;

    	$this->check_by_id($StyleInfo);

    	if (empty($PowerBB->_GET['style_path']))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
    	}
    	if (empty($PowerBB->_GET['id']))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
    	}

    	$PowerBB->_GET['style_path'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['style_path'],'html');

    	$path = $PowerBB->_GET['style_path'];

    	if (!file_exists($path))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
    	}

    	// To be more advanced :D
    	if (!is_writable($path))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['is_not_writable']);
    	}

    	$PowerBB->_POST['css_context'] = stripslashes($PowerBB->_POST['css_context']);

    	$fp = fopen($path,'w+');
    	$fw = fwrite($fp,$PowerBB->_POST['css_context']);

    	if ($fw)
    	{

            $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['CSS_has_been_updated_successfully']);
			$PowerBB->functions->redirect('admin.php?page=style&amp;edit_css=1&amp;main=1&amp;id=' . $PowerBB->_GET['id']);
    	}

		//////////
	}


	function _DefaultMain()
	{
		global $PowerBB;

        $update = array();
        $update = $PowerBB->info->UpdateInfo(array('value'=>$PowerBB->_POST['default'],'var_name'=>'def_style'));


		//////////

		if ($update)
		{
			//////////

           $getmember_query = $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['member'] . " ORDER BY id DESC");

             while ($getmember_row = $PowerBB->DB->sql_fetch_array($getmember_query))
             {

				$UpdateArr 				                = 	array();
				$UpdateArr['field'] 	                    = 	array();
				$UpdateArr['field']['style'] 			    = 	$PowerBB->_POST['default'];
				$UpdateArr['where']						=	array('id',$getmember_row['id']);

				$update = $PowerBB->member->UpdateMember($UpdateArr);

             }

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Last_updated_successfully']);
			$PowerBB->functions->redirect('admin.php?page=style&amp;control=1&amp;main=1');

			//////////
		}

    }
}
class _functions
{
	function check_by_id(&$Inf)
	{
		global $PowerBB;

		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['The_request_is_not_valid']);
		}

		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		$StyleArr 			= 	array();
		$StyleArr['where'] 	= 	array('id',$PowerBB->_GET['id']);

		$Inf = $PowerBB->style->GetStyleInfo($StyleArr);

		if ($Inf == false)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
		}

		$PowerBB->functions->CleanVariable($Inf,'html');
	}
}

?>
