<?php

(!defined('IN_PowerBB')) ? die() : '';

define('IN_ADMIN',true);

$CALL_SYSTEM				=	array();
$CALL_SYSTEM['STYLE'] 		= 	true;
$CALL_SYSTEM['TEMPLATE'] 	= 	true;
$CALL_SYSTEM['TEMPLATESEDITS'] 	= 	true;

include('common.php');

define('CLASS_NAME','PowerBBTemplateMOD');

class PowerBBTemplateMOD extends _functions
{

    var $dir_name;
    var $search_phrase;
    var $allowed_file_types = array('tpl');
    var $foundFiles;
    var $myfiles;

	function run()
	{
		global $PowerBB;

		if ($PowerBB->_CONF['member_permission'])
		{
			$PowerBB->template->display('header');

			if ($PowerBB->_CONF['rows']['group_info']['admincp_template'] == '0')
			{
			  $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}

			if ($PowerBB->_GET['add'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_AddMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_AddStart();
				}
			}
			elseif ($PowerBB->_GET['control'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_ControlMain();
				}
				elseif ($PowerBB->_GET['show'])
				{
					$this->_ControlShow();
				}
				elseif ($PowerBB->_GET['get'])
				{
					$this->_ControlGet();
				}
			}
			elseif ($PowerBB->_GET['edit'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_EditMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_EditStart();
				}
			}
			elseif ($PowerBB->_GET['del'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_DelStart();
				}
			}
			elseif ($PowerBB->_GET['delcache'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_DelAllcache();
				}
			}
			elseif ($PowerBB->_GET['delstartcache'])
			{
			  if ($PowerBB->_GET['main'])
			  {
			     $this->_DelStartAllcache();
			  }
			}
			elseif ($PowerBB->_GET['delcache_admin'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_DelAllcacheAdmin();
				}
			}
			elseif ($PowerBB->_GET['view'])
			{
				$PowerBB->template->display('header');

				if ($PowerBB->_GET['main'])
				{
					$this->_ViewOrginalTemplate();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_ViewStart();
				}
			}
			elseif ($PowerBB->_GET['search'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_SearchMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_SearchStart();
				}

			}

			$PowerBB->template->display('footer');
		}
	}

		function _AddMain()
	{
		global $PowerBB;

		$StyArr 					= 	array();
		$StyArr['order'] 			=	array();
		$StyArr['order']['field'] 	= 	'id';
		$StyArr['order']['type']	=	'DESC';
		$StyArr['proc'] 			= 	array();
		$StyArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');

		$PowerBB->_CONF['template']['while']['StyleList'] = $PowerBB->style->GetStyleList($StyArr);

		$PowerBB->template->display('template_add');
	}

	function _AddStart()
	{
		global $PowerBB;

		if (empty($PowerBB->_POST['filename'])
			or empty($PowerBB->_POST['style'])
			or empty($PowerBB->_POST['context']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_fill_in_all_the_information']);
		}

		$StyleArr 			= 	array();
		$StyleArr['where'] 	= 	array('id',$PowerBB->_POST['style']);

		$StyleInfo = $PowerBB->style->GetStyleInfo($StyleArr);

		if (!$StyleInfo)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
		}

	     $PowerBB->_POST['context'] = $PowerBB->functions->CleanVariable($PowerBB->_POST['context'],'unhtml');
	     $PowerBB->_POST['context'] = stripslashes($PowerBB->_POST['context']);

	     $fp = fopen('./' . $StyleInfo['template_path'] . '/' . $PowerBB->_POST['filename'],'w');
	     $fw = fwrite($fp,$PowerBB->_POST['context']);

	     fclose($fp);

	     if ($fw)
	     {
	     	$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Template_has_been_added_successfully']);
	     	$PowerBB->functions->redirect('admin.php?page=template&amp;&amp;control=1&amp;main=1');
	     }
	}

	function _ControlMain()
	{
		global $PowerBB;

		$StyleArr 					= 	array();
		$StyleArr['order'] 			=	array();
		$StyleArr['order']['field']	= 	'style_order';
		$StyleArr['order']['type']	=	'ASC';
		$StyleArr['proc'] 			= 	array();
		$StyleArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');

		$PowerBB->_CONF['template']['while']['StyleList'] = $PowerBB->style->GetStyleList($StyleArr);

		$PowerBB->template->display('templates_main');
	}

	function _ControlShow()
	{
		global $PowerBB;

		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$StyleArr 				= 	array();
		$StyleArr['where'] 		= 	array('id',$PowerBB->_GET['id']);

		$StyleInfo = $PowerBB->style->GetStyleInfo($StyleArr);

		if (!$StyleInfo)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
		}

		$PowerBB->functions->CleanVariable($StyleInfo,'html');

		$TemplatesList = array();

		if (is_dir($StyleInfo['template_path']))
		{
			$dir = opendir($StyleInfo['template_path']);

			if ($dir)
			{
				while (($file = readdir($dir)) !== false)
				{
					if ($file == '.'
						or $file == '..')
					{
						continue;
					}
                    @sort($file);
					$TemplatesList[]['filename'] = $file;
				}

				closedir($dir);
			}
		}

		$PowerBB->_CONF['template']['foreach']['TemplatesList'] = $TemplatesList;

		$PowerBB->template->assign('StyleInfo',$StyleInfo);

		$PowerBB->template->display('templates_show_templates_list');
	}

	function _ControlGet()
	{
		global $PowerBB;

		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$StyleArr 				= 	array();
		$StyleArr['where'] 		= 	array('id',$PowerBB->_GET['id']);

		$StyleInfo = $PowerBB->style->GetStyleInfo($StyleArr);

		if (!$StyleInfo)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
		}

		$PowerBB->functions->CleanVariable($StyleInfo,'html');

		$TemplatesList = array();

		if (is_dir($StyleInfo['template_path']))
		{
			$dir = opendir($StyleInfo['template_path']);

			if ($dir)
			{
				while (($file = readdir($dir)) !== false)
				{
					if ($file == '.'
						or $file == '..')
					{
						continue;
					}
                    @sort($file);
					$TemplatesList[]['filename'] = $file;
				}

				closedir($dir);
			}
		}

			foreach($TemplatesList as $template){

			  	$path = './' . $StyleInfo['template_path'] . '/' . $template['filename'];

		    	if (!file_exists($path))
		    	{
		    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Template_requested_does_not_exist']);
		    	}
		    	// To be more advanced :D
		    	if (!is_writable($path))
		    	{
		    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['is_not_writable']);
		    	}

                   $lines = file($path);
			    	$con = '';
			    	foreach ($lines as $line)
			    	{
			    		$con .= $line;
			    	}


	                     $filenametemplate = $template['filename'];
	                   	 $filenametemplate = str_replace(".tpl","",$filenametemplate);
				    	  $context .= "<context_".$filenametemplate."><![CDATA[".$con."]]></context_".$filenametemplate.">\n";


				     $filename = 'templates.xml';
				     $fp = fopen($filename,'w');
				     $fw = fwrite($fp,$context);
                      fclose($fp);
			}


	}

	function _EditMain()
    {
    	global $PowerBB;

    	$PowerBB->_CONF['template']['Inf'] = false;

    	$this->check_by_id($PowerBB->_CONF['template']['Inf']);

    	if (empty($PowerBB->_GET['filename']))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
    	}

    	$PowerBB->_GET['filename'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['filename'],'html');

    	$path = './' . $PowerBB->_CONF['template']['Inf']['template_path'] . '/' . $PowerBB->_GET['filename'];

    	if (!file_exists($path))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Template_requested_does_not_exist']);
    	}

    	// To be more advanced :D
    	if (!is_writable($path))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['is_not_writable']);
    	}

    	$lines = file($path);
    	$context = '';

    	foreach ($lines as $line)
    	{
    		$context .= $line;
    	}

    	$context = $PowerBB->functions->CleanVariable($context,'html');

    	$last_edit = date("d. M. Y", filectime($path));

    	$PowerBB->template->assign('filename',$PowerBB->_GET['filename']);
    	$PowerBB->template->assign('last_edit',$last_edit);
    	$PowerBB->template->assign('context',$context);

    	$PowerBB->template->display('template_edit');
	}

	function _EditStart()
	{
		global $PowerBB;

    	$StyleInfo = false;

    	$this->check_by_id($StyleInfo);

    	if (empty($PowerBB->_GET['filename']))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
    	}

    	$PowerBB->_GET['filename'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['filename'],'html');

    	$path = './' . $StyleInfo['template_path'] . '/' . $PowerBB->_GET['filename'];

    	if (!file_exists($path))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Template_requested_does_not_exist']);
    	}

    	// To be more advanced :D
    	if (!is_writable($path))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['is_not_writable']);
    	}

    	$PowerBB->_POST['context'] = stripslashes($PowerBB->_POST['context']);

    	$fp = fopen($path,'w+');
    	$fw = fwrite($fp,$PowerBB->_POST['context']);

    	if ($fw)
    	{
    		$compiled_filename = str_replace('.tpl','-compiler.php',$PowerBB->_GET['filename']);

    		// Use @ to avoid error messages such as (No such file or directory)
    		// Simply we can't ensure we have $compiled_filename in $StyleInfo['cache_path'] or not
    		$del = @unlink('./' . $StyleInfo['cache_path'] . '/' . $compiled_filename);

    		$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Template_has_been_updated_successfully']);
			$PowerBB->functions->redirect('admin.php?page=template&edit=1&main=1&filename=' . $PowerBB->_GET['filename'] . '&id=' .$StyleInfo['id']);
    	}
    }

	function _ViewOrginalTemplate()
    {
    	global $PowerBB;

    	if (empty($PowerBB->_GET['filename']))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
    	}
		$PowerBB->_GET['filename'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['filename'],'html');
		$PowerBB->_GET['filename'] = str_replace(".tpl","",$PowerBB->_GET['filename']);
		$filename = 'original_temp/default_temp/defaulttemplates.xml';
		$xml_code = @file_get_contents($filename);
		ereg("<context_".$PowerBB->_GET['filename'].">(.*)</context_".$PowerBB->_GET['filename'].">",$xml_code,$OrginalTemplate);
		$OrginalTemplate = $OrginalTemplate[0];
		$OrginalTemplate = preg_replace("#<context_".$PowerBB->_GET['filename'].">(.*)</context_".$PowerBB->_GET['filename'].">#si","$1",$OrginalTemplate);

		$PowerBB->template->assign('filename',$PowerBB->_GET['filename']);
		$OrginalTemplate = str_replace("<![CDATA[","",$OrginalTemplate);
		$OrginalTemplate = str_replace("]]>","",$OrginalTemplate);

		$OrginalTemplate = $PowerBB->functions->CleanVariable($OrginalTemplate,'html');
		$PowerBB->template->assign('context',$OrginalTemplate);
    	$PowerBB->template->display('view_orginal_template');
	}

	function _DelStart()
	{
		global $PowerBB;

		$this->check_by_id($StyleInfo);

		if (empty($PowerBB->_GET['filename']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		if (!file_exists('./' . $StyleInfo['template_path'] . '/' . $PowerBB->_GET['filename']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Template_requested_does_not_exist']);
		}

	   $del = unlink('./' . $StyleInfo['template_path'] . '/' . $PowerBB->_GET['filename']);

		if ($del)
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Template_has_been_deleted_successfully']);
			$PowerBB->functions->redirect('admin.php?page=template&amp;control=1&amp;show=1&amp;id=' . $StyleInfo['id']);
		}
	}

	function _DelAllcache()
	{
      		global $PowerBB;

		$StyleArr 					= 	array();
		$StyleArr['order'] 			=	array();
		$StyleArr['order']['field']	= 	'style_order';
		$StyleArr['order']['type']	=	'ASC';
		$StyleArr['proc'] 			= 	array();
		$StyleArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');

		$PowerBB->_CONF['template']['while']['StyleList'] = $PowerBB->style->GetStyleList($StyleArr);

		$PowerBB->template->display('cache_main');


	}

	function _DelStartAllcache()
	{
		global $PowerBB;

		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$StyleArr 				= 	array();
		$StyleArr['where'] 		= 	array('id',$PowerBB->_GET['id']);

		$StyleInfo = $PowerBB->style->GetStyleInfo($StyleArr);

		if (!$StyleInfo)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
		}

		$PowerBB->functions->CleanVariable($StyleInfo,'html');

		$TemplatesList = array();

		if (is_dir($StyleInfo['cache_path']))
		{
			$dir = opendir($StyleInfo['cache_path']);

			if ($dir)
			{
				while (($file = readdir($dir)) !== false)
				{
					if ($file == '.'
						or $file == '..')
					{
						continue;
					}

					$del = unlink('./' . $StyleInfo['cache_path'] . '/' . $file);

                     if ($del)
                     {
                         $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Deleted'].' ' . $file . ' '.$PowerBB->_CONF['template']['lang']['Successfully']);
                     }
                     else
                     {
                         $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['NotDeleted'].' ' . $file);
                     }
				}

				closedir($dir);
			}
		}


	}

	function _DelAllcacheAdmin()
	{
		global $PowerBB;


		$TemplatesList = 'look/styles/admin/main/compiler/';

		if (is_dir($TemplatesList))
		{
			$dir = opendir($TemplatesList);

			if ($dir)
			{
				while (($file = readdir($dir)) !== false)
				{
					if ($file == '.'
						or $file == '..')
					{
						continue;
					}

					$del = unlink('./' . $TemplatesList . $file);

                     if ($del)
                     {
                        $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Deleted'].' ' . $file . ' '.$PowerBB->_CONF['template']['lang']['Successfully']);
                     }
                     else
                     {
                         $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['NotDeleted'].' ' . $file);
                     }
				}

				closedir($dir);
			}
		}


	}

	function _SearchMain()
	{
		global $PowerBB;

		$StyArr 					= 	array();
		$StyArr['order'] 			=	array();
		$StyArr['order']['field'] 	= 	'id';
		$StyArr['order']['type']	=	'DESC';
		$StyArr['proc'] 			= 	array();
		$StyArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');

		$PowerBB->_CONF['template']['while']['StyleList'] = $PowerBB->style->GetStyleList($StyArr);

		$PowerBB->template->display('template_search');
	}

	function _SearchStart()
	{
		global $PowerBB;

		if (empty($PowerBB->_POST['text']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['no_enter_text']);
		}

		$PowerBB->template->display('templates_search_templates_list_top');

		if ($PowerBB->_POST['style'] == 'all')
		{

             $text = $PowerBB->_POST['text'];
             $Getstyles = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['style'] . " WHERE id ");
                  while ($getstyle_row = $PowerBB->DB->sql_fetch_array($Getstyles))
                  {
                        $this->myfiles = $this->GetDirContents($getstyle_row['template_path']);

				        foreach ( $this->myfiles as $f )
				        {
				            if ( in_array(array_pop(explode ( '.', $f )),  $this->allowed_file_types) ){

								if ($PowerBB->_POST['titlesonly'] == '1')
								{
					              if ( strpos($f, $text)){
	         					     $f = str_replace($getstyle_row['template_path'].'/', '', $f);
	         					     $PowerBB->template->assign('style',$getstyle_row);
	         					    $PowerBB->template->assign('found_template',$f);
                                     $PowerBB->template->assign('found',true);
                                     $PowerBB->template->display('templates_search_templates_list');

                                  }

				                }
				                else
								{
									$contents = file_get_contents($f);
					              if ( strpos($contents, $text)){
	         					     $f = str_replace($getstyle_row['template_path'].'/', '', $f);
	         					     $PowerBB->template->assign('style',$getstyle_row);
	         					     $PowerBB->template->assign('found_template',$f);
	         					     $PowerBB->template->assign('found',true);
                                      $PowerBB->template->display('templates_search_templates_list');
                                  }

								 }

				            }

				        }



				 }


		}
        else
        {
			$StyleArr 				= 	array();
			$StyleArr['where'] 		= 	array('id',$PowerBB->_POST['style']);

			$StyleInfo = $PowerBB->style->GetStyleInfo($StyleArr);

			if (!$StyleInfo)
			{
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
			}

			$PowerBB->functions->CleanVariable($StyleInfo,'html');
            $style = $PowerBB->_POST['style'];
             $text = $PowerBB->_POST['text'];
             $Getstyle = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['style'] . " WHERE id = '$style' ");
                    while ($getstyle = $PowerBB->DB->sql_fetch_array($Getstyle))
                  {
                        $this->myfiles = $this->GetDirContents($getstyle['template_path']);
			        foreach ( $this->myfiles as $f )
				        {
				            if ( in_array(array_pop(explode ( '.', $f )),  $this->allowed_file_types) ){

				                  //$contents = file_get_contents($f);
								if ($PowerBB->_POST['titlesonly'] == '1')
								{
					              if ( strpos($f, $text)){
	         					     $f = str_replace($getstyle['template_path'].'/', '', $f);
	         					     $PowerBB->template->assign('style',$getstyle);
	         					    $PowerBB->template->assign('found_template',$f);
                                     $PowerBB->template->assign('found',true);
                                     $PowerBB->template->display('templates_search_templates_list');

                                  }

				                }
				                else
								{
									$contents = file_get_contents($f);
					              if ( strpos($contents, $text)){
	         					     $f = str_replace($getstyle['template_path'].'/', '', $f);
	         					     $PowerBB->template->assign('style',$getstyle);
	         					     $PowerBB->template->assign('found_template',$f);
	         					     $PowerBB->template->assign('found',true);
                                      $PowerBB->template->display('templates_search_templates_list');
                                  }

								 }

				            }

				        }

				 }
         }

        $PowerBB->template->display('templates_search_templates_list_dun');

	}

    function GetDirContents($dir){
       if (!is_dir($dir)){die ("Function GetDirContents: Problem reading : $dir!");}
       if ($root=@opendir($dir)){
           while ($file=readdir($root)){
               if($file=="." || $file==".."){continue;}
               if(is_dir($dir."/".$file)){
                   $files=array_merge($files,$this->GetDirContents($dir."/".$file));
               }else{
               $files[]=$dir."/".$file;
               }
           }
       }
       return $files;
    }
}

class _functions
{
	function check_by_id(&$StyleInfo)
	{
		global $PowerBB;

		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['The_request_is_not_valid']);
		}

		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		$StyleArr 			= 	array();
		$StyleArr['where'] 	= 	array('id',$PowerBB->_GET['id']);

		$StyleInfo = $PowerBB->style->GetStyleInfo($StyleArr);

		if ($StyleInfo == false)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
		}

		$PowerBB->functions->CleanVariable($StyleInfo,'html');
	}
}



?>
