<?php
(!defined('IN_PowerBB')) ? die() : '';
include('common.php');
define('CLASS_NAME','PowerBBForumMOD');
class PowerBBForumMOD
{
	var $Section;
	var $SectionInfo;
	var $SectionGroup;

	function run()
	{
		global $PowerBB;

		$this->_GetJumpSectionsList();

		$PowerBB->template->assign('SECTION_RSS',true);
		$PowerBB->template->assign('SECTION_ID',$PowerBB->_GET['id']);

		$PowerBB->functions->ShowHeader();

		/** Browse the forum **/
		if ($PowerBB->_GET['show'])
		{
			$this->_BrowseForum();
		}
		/** **/
		elseif ($PowerBB->_GET['password_check'])
		{
			$this->_PasswordCheck();
		}
		/** Show the results of search **/
		elseif ($PowerBB->_GET['start'])
		{
			$this->_SearchSection();
		}
		/** Show the subject order by (oldr - new )**/
		elseif($PowerBB->_GET['order'])
		{
			$this->_Startorder();
		}
		/** Show the subject order by (reply_number - visitor - rating)**/
        elseif($PowerBB->_GET['orderby'])
        {
         $this->_StartorderBy();
        }
        elseif($PowerBB->_GET['option'] == '1')
	    {
		$this->_StartSearch();
		}
		else
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}


		$PowerBB->functions->GetFooter();
	}

	/**
	 * Get all things about section , subjects of the sections , announcement and sub sections to show it
	 * Yes it's long list :\
	 */
	function _BrowseForum()
	{
		global $PowerBB;

		$this->_GeneralProcesses();

		$this->_SectionOnline();

		$this->_GetModeratorsList();

		$this->_GetAnnouncementList();

		$this->_GetSubSection();

		$this->_GetSubjectList();

		$this->_CallTemplate();
	}

	function _PasswordCheck()
	{
		global $PowerBB;

		if (empty($PowerBB->_POST['password']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['PasswordCheck']);
		}

		$this->_GeneralProcesses(true);

		$PassArr 				= 	array();
     	$PassArr['id'] 			= 	$this->Section['id'];
     	$PassArr['password'] 	= 	$PowerBB->_POST['password'];

     	$IsTruePassword = $PowerBB->section->CheckPassword($PassArr);

     	if (!$IsTruePassword)
     	{
     		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['PasswordIsnotTrue']);
     	}
     	else
     	{
     		$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Please_wait']);
     		$PowerBB->functions->redirect('index.php?page=forum&amp;show=1&amp;id=' . $this->Section['id'] . '&amp;password=' . base64_encode($PowerBB->_POST['password']));
     	}
	}

	function _GeneralProcesses($check=false)
	{
		global $PowerBB;

		// Clean id from any strings
		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		// No _GET['id'] , so ? show a small error :)
		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		// Get section information and set it in $this->Section
		$SecArr 			= 	array();
		$SecArr['where'] 	= 	array('id',$PowerBB->_GET['id']);

		$this->Section = $PowerBB->section->GetSectionInfo($SecArr);

		// Clear section information from any denger
		$PowerBB->functions->CleanVariable($this->Section,'html');

		$PowerBB->template->assign('section_info',$this->Section);

		// Temporary array to save the parameter of GetSectionGroupList() in nice way
		$SecGroupArr 						= 	array();
		$SecGroupArr['where'] 				= 	array();

		$SecGroupArr['where'][0]			=	array(	'name' 	=> 'section_id',
														'oper'	=>	'=',
														'value'	=>	$this->Section['id']);

		$SecGroupArr['where'][1]			=	array();
		$SecGroupArr['where'][1]['con']		=	'AND';
		$SecGroupArr['where'][1]['name']	=	'group_id';
		$SecGroupArr['where'][1]['oper']	=	'=';
		$SecGroupArr['where'][1]['value']	=	$PowerBB->_CONF['group_info']['id'];


		// Ok :) , the permssion for this visitor/member in this section
		$this->SectionGroup = $PowerBB->group->GetSectionGroupInfo($SecGroupArr);
		// This section isn't exists
		if (!$this->Section)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Section_does_not_exist']);
		}

		// This member can't view this section
		if ($this->SectionGroup['view_section'] != 1)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['can_not_view_section']);
		}

		// This is main section , so we can't get subjects list from it
		if ($this->Section['main_section'])
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['thes_main_section']);
		}

		if ($PowerBB->_CONF['group_info']['view_section'] == 0)
		{
          if (!$PowerBB->_CONF['member_permission'])
              {
              $PowerBB->template->display('login');
              $PowerBB->functions->error_stop();
			}
	        else
	        {
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['can_not_view_section']);
	        }
		}

		// This section is link , so we should go to another site
		if ($this->Section['linksection'])
		{
   	        // The number of section's Visitors
			$SectionArr = array();
			$SectionArr['where'] = array('id',$PowerBB->_GET['id']);

			$SectionInfov = $PowerBB->section->GetSectionInfo($SectionArr);

			$SectionInfov['linkvisitor'] +=1;
	        $visitor = $SectionInfov['linkvisitor'];
			$Sectionid = $PowerBB->_GET['id'];
		    $update_visitor_Section = $PowerBB->DB->sql_query("UPDATE " . $PowerBB->table['section'] . " SET linkvisitor= '$visitor' WHERE id='$Sectionid'");

     		// Update section's cache
     		$UpdateArr 				= 	array();
     		$UpdateArr['parent'] 	= 	$SectionInfov['parent'];

     		$update_cache = $PowerBB->section->UpdateSectionsCache($UpdateArr);

     		unset($UpdateArr);

		    $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Please_wait_will_be_referred_to'] . $this->Section['linksite']);
			$PowerBB->functions->redirect($this->Section['linksite'],3);
			$PowerBB->functions->stop();
		}

		// hmmmm , this section protect by password so request the password
		if (!$check)
		{
			if (!empty($this->Section['section_password'])
				and !$PowerBB->_CONF['group_info']['admincp_allow'])
			{
     			if (empty($PowerBB->_GET['password']))
        		{
      				$PowerBB->template->display('forum_password');
      				$PowerBB->functions->stop();
     			}
     			else
     			{
     				$PassArr = array();
     				$PassArr['id'] 			= 	$this->Section['id'];
     				$PassArr['password'] 	= 	base64_decode($PowerBB->_GET['password']);

     				$IsTruePassword = $PowerBB->section->CheckPassword($PassArr);

     				if (!$IsTruePassword)
     				{
     					$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['The_password_notTrue']);
     				}

     				$PowerBB->_CONF['template']['password'] = '&amp;password=' . $PowerBB->_GET['password'];
     			}
     		}
     	}

     	if ($PowerBB->_CONF['member_permission'])
     	{
     		$UpdateOnline 			= 	array();
			$UpdateOnline['field']	=	array();

			$UpdateOnline['field']['user_location'] 	= $PowerBB->_CONF['template']['lang']['Seen_the'] .	' <a href="index.php?page=forum&show=1&amp;id=' . $this->Section['id'] . '">' . $this->Section['title'] . '</a>';
			$UpdateOnline['where']						=	array('username',$PowerBB->_CONF['member_row']['username']);

			$update = $PowerBB->online->UpdateOnline($UpdateOnline);
     	}


	}

	/**
	 * Know who is in section ?
	 */
	function _SectionOnline()
	{
		global $PowerBB;

		// Finally we get Who is in section
		$SecArr 						= 	array();
		$SecArr['proc'] 				= 	array();
		$SecArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');
		$SecArr['where']				=	array();

		$SecArr['where'][0]				=	array();
		$SecArr['where'][0]['name'] 	= 	'path';
		$SecArr['where'][0]['oper'] 	= 	'=';
		$SecArr['where'][0]['value'] 	= 	$PowerBB->_SERVER['QUERY_STRING'];

		$SecArr['order'] 				= 	array();
		$SecArr['order']['field'] 		= 	'user_id';
		$SecArr['order']['type'] 		= 	'DESC';

		$x = 1;

		if (!$PowerBB->_CONF['info_row']['show_onlineguest'])
		{
			$SecArr['where'][$x]				=	array();
			$SecArr['where'][$x]['con']			=	'AND';
			$SecArr['where'][$x]['name']		=	'username';
			$SecArr['where'][$x]['oper']		=	'<>';
			$SecArr['where'][$x]['value']		=	'Guest';

			$x += 1;
		}

		// This member can't see hidden member
		if (!$PowerBB->_CONF['group_info']['show_hidden'])
		{
			$SecArr['where'][$x] 			= 	array();
			$SecArr['where'][$x]['con'] 	= 	'AND';
			$SecArr['where'][$x]['name'] 	= 	'hide_browse';
			$SecArr['where'][$x]['oper'] 	= 	'<>';
			$SecArr['where'][$x]['value'] 	= 	'1';
		}

		$PowerBB->_CONF['template']['while']['SectionVisitor'] = $PowerBB->online->GetOnlineList($SecArr);

		$GuestNumberArr 						= 	array();
		$GuestNumberArr['where'] 				= 	array();

		$GuestNumberArr['where'][0] 			= 	array();
		$GuestNumberArr['where'][0]['name'] 	= 	'username';
		$GuestNumberArr['where'][0]['oper'] 	= 	'=';
		$GuestNumberArr['where'][0]['value'] 	= 	'Guest';

		$GuestNumberArr['where'][1] 			= 	array();
		$GuestNumberArr['where'][1]['con'] 		= 	'AND';
		$GuestNumberArr['where'][1]['name'] 	= 	'path';
		$GuestNumberArr['where'][1]['oper'] 	= 	'=';
        $GuestNumberArr['where'][1]['value'] 	= 	$PowerBB->_SERVER['QUERY_STRING'];

		$PowerBB->_CONF['template']['GuestNumber'] = $PowerBB->online->GetOnlineNumber($GuestNumberArr);

		$MemberNumberArr 						= 	array();
		$MemberNumberArr['where'] 				= 	array();

		$MemberNumberArr['where'][0] 			= 	array();
		$MemberNumberArr['where'][0]['name'] 	= 	'username';
		$MemberNumberArr['where'][0]['oper'] 	= 	'<>';
		$MemberNumberArr['where'][0]['value'] 	= 	'Guest';

		$MemberNumberArr['where'][1] 			= 	array();
		$MemberNumberArr['where'][1]['con'] 	= 	'AND';
		$MemberNumberArr['where'][1]['name'] 	= 	'path';
		$MemberNumberArr['where'][1]['oper'] 	= 	'=';
		$MemberNumberArr['where'][1]['value'] 	= 	$PowerBB->_SERVER['QUERY_STRING'];

		$PowerBB->_CONF['template']['MemberNumber'] = $PowerBB->online->GetOnlineNumber($MemberNumberArr);

		$online_number = $PowerBB->online->GetOnlineNumber($GuestNumberArr)+$PowerBB->online->GetOnlineNumber($MemberNumberArr);
       $PowerBB->template->assign('online_number',$online_number);
	}

	function _GetModeratorsList()
	{
		global $PowerBB;

		$ModArr 			= 	array();
		$ModArr['where'] 	= 	array('section_id',$this->Section['id']);

		$PowerBB->_CONF['template']['while']['ModeratorsList'] = $PowerBB->moderator->GetModeratorList($ModArr);

		if (is_array($PowerBB->_CONF['template']['while']['ModeratorsList'])
			and sizeof($PowerBB->_CONF['template']['while']['ModeratorsList']) > 0)
		{
			$PowerBB->template->assign('STOP_MODERATOR_TEMPLATE',false);
		}
		else
		{
			$PowerBB->template->assign('STOP_MODERATOR_TEMPLATE',true);
		}
	}

	/**
	 * Get announcement list
	 */
	function _GetAnnouncementList()
	{
		global $PowerBB;

		$AnnArr 					= 	array();

		$AnnArr['proc'] 			= 	array();
		$AnnArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');
		$AnnArr['proc']['date'] 	= 	array('method'=>'date','type'=>$PowerBB->_CONF['info_row']['timesystem']);

		$AnnArr['order']			=	array();
		$AnnArr['order']['field']	=	'id';
		$AnnArr['order']['type']	=	'DESC';


		$PowerBB->_CONF['template']['while']['AnnouncementList'] = $PowerBB->announcement->GetAnnouncementList($AnnArr);

		if ($PowerBB->_CONF['template']['while']['AnnouncementList'] != false)
		{
			$PowerBB->template->assign('STOP_ANNOUNCEMENT_TEMPLATE',false);
		}
		else
		{
			$PowerBB->template->assign('STOP_ANNOUNCEMENT_TEMPLATE',true);
		}
	}

	function _GetSubSection()
	{
		global $PowerBB;

		if (!empty($this->Section['forums_cache']))
		{
			$forums = unserialize(base64_decode($this->Section['forums_cache']));

			$PowerBB->_CONF['template']['foreach']['forums_list'] = array();

				foreach ($forums as $forum)
				{

                   if (isset($forum['last_subject']{$post_title_max}))
		     		{
                        $PowerBB->Powerparse->word_substr($forum['last_subject']);
		    		}

					// Get parent forums
					$sub_section = $forum['id'];
					$sub_section_num = $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['section'] . " WHERE parent = '$sub_section'");
					$t=0;
					$forum['sub'] .= "<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" ><tr valign=\"top\"> ";
					while($r=$PowerBB->DB->sql_fetch_array($sub_section_num))
					{
					if ($r['id'])
					{
					$forum['is_sub'] = 1;
					}
					if($t== $PowerBB->_CONF['info_row']['sub_columns_number']){
					$t=0;
					$forum['sub'] .="</tr><tr>";
					}
					$forum['sub'] .= "<td>";
					if ($PowerBB->_CONF['info_row']['rewriterule'] == '1')
					{
					$forum['sub'] .= '<a href="f' . $r['id'] . '.html"><img border="0" alt="" src="' . $PowerBB->_CONF['template']['image_path'] . '/address_bar_start.gif" />  ' . $r['title'] . '</a> ';
					}
					else
					{
					$forum['sub'] .= '<a href="index.php?page=forum&amp;show=1&amp;id=' . $r['id'] . '"><img border="0" alt="" src="' . $PowerBB->_CONF['template']['image_path'] . '/address_bar_start.gif" />  ' . $r['title'] . '</a>';
					}
					$forum['sub'] .= "&nbsp;</td>";
					$t=$t+1;
					}
					$forum['sub'] .="</tr></table>";

					// Get the moderators list
					$ModeratorsList = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['moderators'] . " WHERE section_id = " . $forum['id'] . "  ");
					while ($forum_moderator = $PowerBB->DB->sql_fetch_array($ModeratorsList))
					{
					$MemberArr 			= 	array();
					$MemberArr['where'] 	= 	array('username',$forum_moderator['username']);

					$StyleMemberInfo = $PowerBB->member->GetMemberInfo($MemberArr);

					$GrpArr 			= 	array();
					$GrpArr['where'] 	= 	array('id',$StyleMemberInfo['usergroup']);

					$GroupModeratorInfo = $PowerBB->group->GetGroupInfo($GrpArr);

					$GroupModeratorInfo['username_style'] = str_ireplace('[username]',$forum_moderator['username'],$GroupModeratorInfo['username_style']);

					$forum['moderators_list'] .= '<a href="index.php?page=profile&amp;show=1&amp;id=' . $forum_moderator['member_id'] . '">' . $GroupModeratorInfo['username_style'] . '</a> | ';
					}

					// Get online forums
					if ($PowerBB->_CONF['info_row']['active_forum_online_number'])
					{
					$pageForum = 'page=forum&show=1&id='.$forum['id'];
					$Forum_online_number = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['online'] . " WHERE path='" . $pageForum . "'"));
					$forum['online_number'] .= $Forum_online_number;
					$forum_id = $forum['id'];
					$SubjectInfo = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['subject'] . " WHERE section = '$forum_id' ");
					$Subject_online = $PowerBB->DB->sql_fetch_array($SubjectInfo);
					$pageSubject = 'page=topic&show=1&id='.$Subject_online['id'];
					$Subject_online_number = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['online'] . " WHERE path='" . $pageSubject . "'"));
					$forum['subject_online_number'] .= $Subject_online_number;
					$forum['forum_online'] = $forum['subject_online_number'] + $forum['online_number'];
					}

					// Get the rely numrs of reply and subject
					$Numrs = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['section'] . " WHERE parent = " . $forum['id'] . "  ");
					$ReplyInfo = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['reply'] . " WHERE section = " . $forum['id'] . "  "));
					$SubjectInfo = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['subject'] . " WHERE section = " . $forum['id'] . "  "));
					while ($num_rows = $PowerBB->DB->sql_fetch_array($Numrs))
					{
					$ReplyParentInfo = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['reply'] . " WHERE section = " . $num_rows['id'] . "  "));
					$SubjectParentInfo = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['subject'] . " WHERE section = " . $num_rows['id'] . "  "));
					}
					$forum['subject_num'] = $SubjectInfo+$SubjectParentInfo;
					$forum['reply_num']   = $ReplyInfo+$ReplyParentInfo;

					// Get username style of last_writer
					$MemberArr 			= 	array();
					$MemberArr['where'] 	= 	array('username',$forum['last_writer']);

					$StyleMemberInfo = $PowerBB->member->GetMemberInfo($MemberArr);

					$GrpArr 			= 	array();
					$GrpArr['where'] 	= 	array('id',$StyleMemberInfo['usergroup']);

					$GroupInfo = $PowerBB->group->GetGroupInfo($GrpArr);

					$GroupInfo['username_style'] = str_ireplace('[username]',$StyleMemberInfo['username'],$GroupInfo['username_style']);

					if ($PowerBB->_CONF['info_row']['rewriterule'] == '1')
					{
					$username_style = '<a href="' . $StyleMemberInfo['username'] . '.html">' . $GroupInfo['username_style'] . '</a> ';
					}
					else
					{
					$username_style = '<a href="index.php?page=profile&amp;show=1&amp;username=' . $StyleMemberInfo['username'] . '">' . $GroupInfo['username_style'] . '</a> ';
					}

					if ($forum['last_writer'] == 'Guest')
					{
					$GrpGuestArr 			= 	array();
					$GrpGuestArr['where'] 	= 	array('id','7');
					$GroupGuestInfo = $PowerBB->group->GetGroupInfo($GrpGuestArr);
					$GroupGuestInfo['username_style'] = str_ireplace('[username]',$PowerBB->_CONF['template']['lang']['Guest_'],$GroupGuestInfo['username_style']);
					$forum['last_writer'] = $GroupGuestInfo['username_style'];
					}
					else
					{
					$forum['last_writer'] = $username_style;
					}

					// Get time for last post
					$forum['last_date'] = $PowerBB->functions->date($forum['last_time']);
					$forum['last_time'] = $PowerBB->functions->time($forum['last_time']);

					$PowerBB->_CONF['template']['foreach']['forums_list'][$forum['id'] . '_f'] = $forum;
					unset($groups);



				} // end foreach ($forums)

			$PowerBB->template->assign('SHOW_SUB_SECTIONS',true);
		}
		else
		{
			$PowerBB->template->assign('SHOW_SUB_SECTIONS',false);
		}
	}

	  /**
	 * /** Show the subject order by (reply_number - visitor - rating)**/
	function _StartorderBy()
	{

	global $PowerBB;
		/**
		 * Ok , are you ready to get subjects list ? :)
		 */

		$TotalArr 				= 	array();
		$TotalArr['get_from'] 	= 	'db';
		$TotalArr['where'] 		= 	array('section',$this->Section['id']);

		$SubjectArr = array();

		$SubjectArr['where'] 				= 	array();

		$SubjectArr['where'][0] 			= 	array();
		$SubjectArr['where'][0]['name'] 	= 	'section';
		$SubjectArr['where'][0]['oper'] 	= 	'=';
		$SubjectArr['where'][0]['value'] 	= 	$this->Section['id'];

		$SubjectArr['where'][1] 			= 	array();
		$SubjectArr['where'][1]['con']		=	'AND';
		$SubjectArr['where'][1]['name'] 	= 	'stick';
		$SubjectArr['where'][1]['oper'] 	= 	'<>';
		$SubjectArr['where'][1]['value'] 	= 	'1';

		$SubjectArr['where'][2] 			= 	array();
		$SubjectArr['where'][2]['con']		=	'AND';
		$SubjectArr['where'][2]['name'] 	= 	'delete_topic';
		$SubjectArr['where'][2]['oper'] 	= 	'<>';
		$SubjectArr['where'][2]['value'] 	= 	'1';

		$SubjectArr['where'][3] 			= 	array();
		$SubjectArr['where'][3]['con']		=	'AND';
		$SubjectArr['where'][3]['name'] 	= 	'review_subject';
		$SubjectArr['where'][3]['oper'] 	= 	'<>';
		$SubjectArr['where'][3]['value'] 	= 	'1';

		if ($this->Section['hide_subject']
			and !$PowerBB->_CONF['group_info']['admincp_allow'])
		{
			$SubjectArr['where'][4] 			= 	array();
			$SubjectArr['where'][4]['con'] 		= 	'AND';
			$SubjectArr['where'][4]['name'] 	= 	'writer';
			$SubjectArr['where'][4]['oper'] 	= 	'=';
			$SubjectArr['where'][4]['value'] 	= 	$PowerBB->_CONF['member_row']['username'];
		}

		$SubjectArr['order'] = array();

		if ($PowerBB->_GET['sort'] == 'reply_number')
		{
			$SubjectArr['order']['field'] 	= 	'reply_number';
			$SubjectArr['order']['type'] 	= 	'DESC';
		}
		elseif ($PowerBB->_GET['sort'] == 'visitor')
		{
			$SubjectArr['order']['field'] 	= 	'visitor';
			$SubjectArr['order']['type'] 	= 	'DESC';
		}
		elseif ($PowerBB->_GET['sort'] == 'rating')
		{
			$SubjectArr['order']['field'] 	= 	'rating';
			$SubjectArr['order']['type'] 	= 	'DESC';
		}
		elseif ($PowerBB->_GET['sort'] == 'writer')
		{
			$SubjectArr['order']['field'] 	= 	'writer';
			$SubjectArr['order']['type'] 	= 	'DESC';
		}
		elseif ($PowerBB->_GET['sort'] == 'title')
		{
			$SubjectArr['order']['field'] 	= 	'title';
			$SubjectArr['order']['type'] 	= 	'DESC';
		}
		else
		{
			$SubjectArr['order']['field'] 	= 	'write_time';
			$SubjectArr['order']['type'] 	= 	'DESC';
		}


		$PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
		$PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');

		$SubjectArr['proc'] 						= 	array();
		// Ok Mr.XSS go to hell !
		$SubjectArr['proc']['*'] 					= 	array('method'=>'clean','param'=>'html');
		$SubjectArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
		$SubjectArr['proc']['write_time'] 			= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);



		// Pager setup
		$SubjectArr['pager'] 				= 	array();
		$SubjectArr['pager']['total']		= 	$PowerBB->subject->GetSubjectNumber($TotalArr);
		$SubjectArr['pager']['perpage'] 	= 	$PowerBB->_CONF['info_row']['subject_perpage'];
		$SubjectArr['pager']['count'] 		= 	$PowerBB->_GET['count'];
		$SubjectArr['pager']['location'] 	= 	'index.php?page=forum&amp;show=1&amp;id=' . $this->Section['id'];
		$SubjectArr['pager']['var'] 		= 	'count';

		$PowerBB->_CONF['template']['while']['subject_list'] = $PowerBB->subject->GetSubjectList($SubjectArr);


				//////////

		$StickSubjectArr = array();

		$StickSubjectArr['where'] 				= 	array();

		$StickSubjectArr['where'][0] 			= 	array();
		$StickSubjectArr['where'][0]['name'] 	= 	'section';
		$StickSubjectArr['where'][0]['oper'] 	= 	'=';
		$StickSubjectArr['where'][0]['value'] 	= 	$this->Section['id'];

		$StickSubjectArr['where'][1] 			= 	array();
		$StickSubjectArr['where'][1]['con']		=	'AND';
		$StickSubjectArr['where'][1]['name'] 	= 	'stick';
		$StickSubjectArr['where'][1]['oper'] 	= 	'=';
		$StickSubjectArr['where'][1]['value'] 	= 	'1';

		$StickSubjectArr['where'][2] 			= 	array();
		$StickSubjectArr['where'][2]['con']		=	'AND';
		$StickSubjectArr['where'][2]['name'] 	= 	'delete_topic';
		$StickSubjectArr['where'][2]['oper'] 	= 	'<>';
		$StickSubjectArr['where'][2]['value'] 	= 	'1';

		$StickSubjectArr['order'] = array();
		$StickSubjectArr['order']['field'] 	= 	'write_time';
		$StickSubjectArr['order']['type'] 	= 	'DESC';

		$StickSubjectArr['proc'] 						= 	array();
		// Ok Mr.XSS go to hell !
		$StickSubjectArr['proc']['*'] 					= 	array('method'=>'clean','param'=>'html');
		$StickSubjectArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
		$StickSubjectArr['proc']['write_time'] 			= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);

		$PowerBB->_CONF['template']['while']['stick_subject_list'] = $PowerBB->subject->GetSubjectList($StickSubjectArr);

		if (sizeof($PowerBB->_CONF['template']['while']['stick_subject_list']) <= 0)
		{
			$PowerBB->template->assign('NO_STICK_SUBJECTS',true);
		}
		else
		{
			$PowerBB->template->assign('NO_STICK_SUBJECTS',false);
		}

		//////////

		// Get the list of subjects that need review

		if ($PowerBB->functions->ModeratorCheck($this->Section['id']))
		{
			$ReviewSubjectArr = array();

			$ReviewSubjectArr['where'] 				= 	array();

			$ReviewSubjectArr['where'][0] 			= 	array();
			$ReviewSubjectArr['where'][0]['name'] 	= 	'section';
			$ReviewSubjectArr['where'][0]['oper'] 	= 	'=';
			$ReviewSubjectArr['where'][0]['value'] 	= 	$this->Section['id'];

			$ReviewSubjectArr['where'][1] 			= 	array();
			$ReviewSubjectArr['where'][1]['con']	=	'AND';
			$ReviewSubjectArr['where'][1]['name'] 	= 	'review_subject';
			$ReviewSubjectArr['where'][1]['oper'] 	= 	'=';
			$ReviewSubjectArr['where'][1]['value'] 	= 	'1';

			$ReviewSubjectArr['where'][2] 			= 	array();
			$ReviewSubjectArr['where'][2]['con']	=	'AND';
			$ReviewSubjectArr['where'][2]['name'] 	= 	'delete_topic';
			$ReviewSubjectArr['where'][2]['oper'] 	= 	'<>';
			$ReviewSubjectArr['where'][2]['value'] 	= 	'1';

			$ReviewSubjectArr['order'] 				= 	array();
			$ReviewSubjectArr['order']['field'] 	= 	'write_time';
			$ReviewSubjectArr['order']['type'] 		= 	'DESC';

			$ReviewSubjectArr['proc'] 						= 	array();
			// Ok Mr.XSS go to hell !
			$ReviewSubjectArr['proc']['*'] 					= 	array('method'=>'clean','param'=>'html');
			$ReviewSubjectArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
			$ReviewSubjectArr['proc']['write_time'] 		= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);

			$PowerBB->_CONF['template']['while']['review_subject_list'] = $PowerBB->subject->GetSubjectList($ReviewSubjectArr);

			if (sizeof($PowerBB->_CONF['template']['while']['review_subject_list']) <= 0)
			{
				$PowerBB->template->assign('NO_REVIEW_SUBJECTS',true);
			}
			else
			{
				$PowerBB->template->assign('NO_REVIEW_SUBJECTS',false);
			}
		}
		else
		{
			$PowerBB->template->assign('NO_REVIEW_SUBJECTS',true);
		}

		//////////

		if ($PowerBB->subject->GetSubjectNumber($TotalArr) > $PowerBB->_CONF['info_row']['subject_perpage'])
		{
		$PowerBB->template->assign('pager',$PowerBB->pager->show());
		}

		$PowerBB->template->assign('section_id',$this->Section['id']);

	}

	  	/**
	 * order subject in forum
	 */
	function _Startorder()
	{
		global $PowerBB;

		/**
		 * Ok , are you ready to get subjects list ? :)
		 */
		$TotalArr 				= 	array();
		$TotalArr['get_from'] 	= 	'db';
		$TotalArr['where'] 		= 	array('section',$this->Section['id']);

		$SubjectArr = array();

		$SubjectArr['where'] 				= 	array();

		$SubjectArr['where'][0] 			= 	array();
		$SubjectArr['where'][0]['name'] 	= 	'section';
		$SubjectArr['where'][0]['oper'] 	= 	'=';
		$SubjectArr['where'][0]['value'] 	= 	$this->Section['id'];

		$SubjectArr['where'][1] 			= 	array();
		$SubjectArr['where'][1]['con']		=	'AND';
		$SubjectArr['where'][1]['name'] 	= 	'stick';
		$SubjectArr['where'][1]['oper'] 	= 	'<>';
		$SubjectArr['where'][1]['value'] 	= 	'1';

		$SubjectArr['where'][2] 			= 	array();
		$SubjectArr['where'][2]['con']		=	'AND';
		$SubjectArr['where'][2]['name'] 	= 	'delete_topic';
		$SubjectArr['where'][2]['oper'] 	= 	'<>';
		$SubjectArr['where'][2]['value'] 	= 	'1';

		$SubjectArr['where'][3] 			= 	array();
		$SubjectArr['where'][3]['con']		=	'AND';
		$SubjectArr['where'][3]['name'] 	= 	'review_subject';
		$SubjectArr['where'][3]['oper'] 	= 	'<>';
		$SubjectArr['where'][3]['value'] 	= 	'1';

		if ($this->Section['hide_subject']
			and !$PowerBB->_CONF['group_info']['admincp_allow'])
		{
			$SubjectArr['where'][4] 			= 	array();
			$SubjectArr['where'][4]['con'] 		= 	'AND';
			$SubjectArr['where'][4]['name'] 	= 	'writer';
			$SubjectArr['where'][4]['oper'] 	= 	'=';
			$SubjectArr['where'][4]['value'] 	= 	$PowerBB->_CONF['member_row']['username'];
		}

		$SubjectArr['order'] = array();

		if ($this->Section['subject_order'] == 2)
		{
			$SubjectArr['order']['field'] 	= 	'id';
			$SubjectArr['order']['type'] 	= 	$PowerBB->_GET['sort'];
		}
		elseif ($this->Section['subject_order'] == 3)
		{
			$SubjectArr['order']['field'] 	= 	'id';
			$SubjectArr['order']['type'] 	= 	'ASC';
		}
		else
		{
			$SubjectArr['order']['field'] 	= 	'write_time';
			$SubjectArr['order']['type'] 	= 	$PowerBB->_GET['sort'];
		}

		$PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
		$PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');

		$SubjectArr['proc'] 						= 	array();
		// Ok Mr.XSS go to hell !
		$SubjectArr['proc']['*'] 					= 	array('method'=>'clean','param'=>'html');
		$SubjectArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
		$SubjectArr['proc']['write_time'] 			= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);



		// Pager setup
		$SubjectArr['pager'] 				= 	array();
		$SubjectArr['pager']['total']		= 	$PowerBB->subject->GetSubjectNumber($TotalArr);
		$SubjectArr['pager']['perpage'] 	= 	$PowerBB->_CONF['info_row']['subject_perpage'];
		$SubjectArr['pager']['count'] 		= 	$PowerBB->_GET['count'];
		$SubjectArr['pager']['location'] 	= 	'index.php?page=forum&amp;show=1&amp;id=' . $this->Section['id'];
		$SubjectArr['pager']['var'] 		= 	'count';

		$PowerBB->_CONF['template']['while']['subject_list'] = $PowerBB->subject->GetSubjectList($SubjectArr);

				//////////

		$StickSubjectArr = array();

		$StickSubjectArr['where'] 				= 	array();

		$StickSubjectArr['where'][0] 			= 	array();
		$StickSubjectArr['where'][0]['name'] 	= 	'section';
		$StickSubjectArr['where'][0]['oper'] 	= 	'=';
		$StickSubjectArr['where'][0]['value'] 	= 	$this->Section['id'];

		$StickSubjectArr['where'][1] 			= 	array();
		$StickSubjectArr['where'][1]['con']		=	'AND';
		$StickSubjectArr['where'][1]['name'] 	= 	'stick';
		$StickSubjectArr['where'][1]['oper'] 	= 	'=';
		$StickSubjectArr['where'][1]['value'] 	= 	'1';

		$StickSubjectArr['where'][2] 			= 	array();
		$StickSubjectArr['where'][2]['con']		=	'AND';
		$StickSubjectArr['where'][2]['name'] 	= 	'delete_topic';
		$StickSubjectArr['where'][2]['oper'] 	= 	'<>';
		$StickSubjectArr['where'][2]['value'] 	= 	'1';

		$StickSubjectArr['order'] = array();
		$StickSubjectArr['order']['field'] 	= 	'write_time';
		$StickSubjectArr['order']['type'] 	= 	'DESC';

		$StickSubjectArr['proc'] 						= 	array();
		// Ok Mr.XSS go to hell !
		$StickSubjectArr['proc']['*'] 					= 	array('method'=>'clean','param'=>'html');
		$StickSubjectArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
		$StickSubjectArr['proc']['write_time'] 			= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);

		$PowerBB->_CONF['template']['while']['stick_subject_list'] = $PowerBB->subject->GetSubjectList($StickSubjectArr);

		if (sizeof($PowerBB->_CONF['template']['while']['stick_subject_list']) <= 0)
		{
			$PowerBB->template->assign('NO_STICK_SUBJECTS',true);
		}
		else
		{
			$PowerBB->template->assign('NO_STICK_SUBJECTS',false);
		}

		//////////

		// Get the list of subjects that need review

		if ($PowerBB->functions->ModeratorCheck($this->Section['id']))
		{
			$ReviewSubjectArr = array();

			$ReviewSubjectArr['where'] 				= 	array();

			$ReviewSubjectArr['where'][0] 			= 	array();
			$ReviewSubjectArr['where'][0]['name'] 	= 	'section';
			$ReviewSubjectArr['where'][0]['oper'] 	= 	'=';
			$ReviewSubjectArr['where'][0]['value'] 	= 	$this->Section['id'];

			$ReviewSubjectArr['where'][1] 			= 	array();
			$ReviewSubjectArr['where'][1]['con']	=	'AND';
			$ReviewSubjectArr['where'][1]['name'] 	= 	'review_subject';
			$ReviewSubjectArr['where'][1]['oper'] 	= 	'=';
			$ReviewSubjectArr['where'][1]['value'] 	= 	'1';

			$ReviewSubjectArr['where'][2] 			= 	array();
			$ReviewSubjectArr['where'][2]['con']	=	'AND';
			$ReviewSubjectArr['where'][2]['name'] 	= 	'delete_topic';
			$ReviewSubjectArr['where'][2]['oper'] 	= 	'<>';
			$ReviewSubjectArr['where'][2]['value'] 	= 	'1';

			$ReviewSubjectArr['order'] 				= 	array();
			$ReviewSubjectArr['order']['field'] 	= 	'write_time';
			$ReviewSubjectArr['order']['type'] 		= 	'DESC';

			$ReviewSubjectArr['proc'] 						= 	array();
			// Ok Mr.XSS go to hell !
			$ReviewSubjectArr['proc']['*'] 					= 	array('method'=>'clean','param'=>'html');
			$ReviewSubjectArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
			$ReviewSubjectArr['proc']['write_time'] 		= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);

			$PowerBB->_CONF['template']['while']['review_subject_list'] = $PowerBB->subject->GetSubjectList($ReviewSubjectArr);

			if (sizeof($PowerBB->_CONF['template']['while']['review_subject_list']) <= 0)
			{
				$PowerBB->template->assign('NO_REVIEW_SUBJECTS',true);
			}
			else
			{
				$PowerBB->template->assign('NO_REVIEW_SUBJECTS',false);
			}
		}
		else
		{
			$PowerBB->template->assign('NO_REVIEW_SUBJECTS',true);
		}

		//////////

		if ($PowerBB->subject->GetSubjectNumber($TotalArr) > $PowerBB->_CONF['info_row']['subject_perpage'])
		{
		$PowerBB->template->assign('pager',$PowerBB->pager->show());
		}

		$PowerBB->template->assign('section_id',$this->Section['id']);

	}

	function _GetSubjectList()
	{
		global $PowerBB;

		/** Show the subject order by (oldr - new )**/
		if($PowerBB->_GET['order'])
		{
			$this->_Startorder();
		}
		/** Show the subject order by (reply_number - visitor - rating)**/
        elseif($PowerBB->_GET['orderby'])
        {
         $this->_StartorderBy();
        }
        else
        {



		/**
		 * Ok , are you ready to get subjects list ? :)
		 */
		$TotalArr 				= 	array();
		$TotalArr['get_from'] 	= 	'db';
		$TotalArr['where'] 		= 	array('section',$this->Section['id']);

		$SubjectArr = array();

		$SubjectArr['where'] 				= 	array();

		$SubjectArr['where'][0] 			= 	array();
		$SubjectArr['where'][0]['name'] 	= 	'section';
		$SubjectArr['where'][0]['oper'] 	= 	'=';
		$SubjectArr['where'][0]['value'] 	= 	$this->Section['id'];

		$SubjectArr['where'][1] 			= 	array();
		$SubjectArr['where'][1]['con']		=	'AND';
		$SubjectArr['where'][1]['name'] 	= 	'stick';
		$SubjectArr['where'][1]['oper'] 	= 	'<>';
		$SubjectArr['where'][1]['value'] 	= 	'1';

		$SubjectArr['where'][2] 			= 	array();
		$SubjectArr['where'][2]['con']		=	'AND';
		$SubjectArr['where'][2]['name'] 	= 	'review_subject';
		$SubjectArr['where'][2]['oper'] 	= 	'<>';
		$SubjectArr['where'][2]['value'] 	= 	'1';
        if (!$PowerBB->functions->ModeratorCheck($this->Section['id']))
   		{
		$SubjectArr['where'][3] 			= 	array();
		$SubjectArr['where'][3]['con']		=	'AND';
		$SubjectArr['where'][3]['name'] 	= 	'delete_topic';
		$SubjectArr['where'][3]['oper'] 	= 	'<>';
		$SubjectArr['where'][3]['value'] 	= 	'1';
        }

		if ($this->Section['hide_subject']
			and !$PowerBB->_CONF['group_info']['admincp_allow'])
		{
			$SubjectArr['where'][3] 			= 	array();
			$SubjectArr['where'][3]['con'] 		= 	'AND';
			$SubjectArr['where'][3]['name'] 	= 	'writer';
			$SubjectArr['where'][3]['oper'] 	= 	'=';
			$SubjectArr['where'][3]['value'] 	= 	$PowerBB->_CONF['member_row']['username'];
		}

		$SubjectArr['order'] = array();

		if ($this->Section['subject_order'] == 2)
		{
			$SubjectArr['order']['field'] 	= 	'id';
			$SubjectArr['order']['type'] 	= 	'DESC';
		}
		elseif ($this->Section['subject_order'] == 3)
		{
			$SubjectArr['order']['field'] 	= 	'id';
			$SubjectArr['order']['type'] 	= 	'ASC';
		}
		else
		{
			$SubjectArr['order']['field'] 	= 	'write_time';
			$SubjectArr['order']['type'] 	= 	'DESC';
		}

		$PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
		$PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');

		$SubjectArr['proc'] 						= 	array();
		// Ok Mr.XSS go to hell !
		$SubjectArr['proc']['*'] 					= 	array('method'=>'clean','param'=>'html');
		$SubjectArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
		$SubjectArr['proc']['write_time'] 			= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);



		// Pager setup
		$SubjectArr['pager'] 				= 	array();
		$SubjectArr['pager']['total']		= 	$PowerBB->subject->GetSubjectNumber($TotalArr);
		$SubjectArr['pager']['perpage'] 	= 	$PowerBB->_CONF['info_row']['subject_perpage'];
		$SubjectArr['pager']['count'] 		= 	$PowerBB->_GET['count'];
		$SubjectArr['pager']['location'] 	= 	'index.php?page=forum&amp;show=1&amp;id=' . $this->Section['id'];
		$SubjectArr['pager']['var'] 		= 	'count';

		$PowerBB->_CONF['template']['while']['subject_list'] = $PowerBB->subject->GetSubjectList($SubjectArr);

			$ReplyArr 						= 	array();
			$ReplyArr['where']				=	array('section',$this->Section['id']);

			$PowerBB->_CONF['template']['while']['ReplyList'] = $PowerBB->reply->GetReplyList($ReplyArr);


      /* Show part of the topic for a pause on the link
			$sectionid = $this->Section['id'];
			$SubjectTextArr = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['subject'] . " WHERE section = '$sectionid' ");

       while ($getstyleText = $PowerBB->DB->sql_fetch_array($SubjectTextArr))
       {

        $PowerBB->template->assign('subject_text',$getstyleText['text']);

       }

       */

		//////////

		$StickSubjectArr = array();

		$StickSubjectArr['where'] 				= 	array();

		$StickSubjectArr['where'][0] 			= 	array();
		$StickSubjectArr['where'][0]['name'] 	= 	'section';
		$StickSubjectArr['where'][0]['oper'] 	= 	'=';
		$StickSubjectArr['where'][0]['value'] 	= 	$this->Section['id'];

		$StickSubjectArr['where'][1] 			= 	array();
		$StickSubjectArr['where'][1]['con']		=	'AND';
		$StickSubjectArr['where'][1]['name'] 	= 	'stick';
		$StickSubjectArr['where'][1]['oper'] 	= 	'=';
		$StickSubjectArr['where'][1]['value'] 	= 	'1';

		$StickSubjectArr['where'][2] 			= 	array();
		$StickSubjectArr['where'][2]['con']		=	'AND';
		$StickSubjectArr['where'][2]['name'] 	= 	'review_subject';
		$StickSubjectArr['where'][2]['oper'] 	= 	'<>';
		$StickSubjectArr['where'][2]['value'] 	= 	'1';
        if (!$PowerBB->functions->ModeratorCheck($this->Section['id']))
   		{
		$StickSubjectArr['where'][3] 			= 	array();
		$StickSubjectArr['where'][3]['con']		=	'AND';
		$StickSubjectArr['where'][3]['name'] 	= 	'delete_topic';
		$StickSubjectArr['where'][3]['oper'] 	= 	'<>';
		$StickSubjectArr['where'][3]['value'] 	= 	'1';
		}

		if ($this->Section['hide_subject']
		and !$PowerBB->_CONF['group_info']['admincp_allow'])
		{
		$StickSubjectArr['where'][3] 			= 	array();
		$StickSubjectArr['where'][3]['con'] 		= 	'AND';
		$StickSubjectArr['where'][3]['name'] 	= 	'writer';
		$StickSubjectArr['where'][3]['oper'] 	= 	'=';
		$StickSubjectArr['where'][3]['value'] 	= 	$PowerBB->_CONF['member_row']['username'];
		}

		$StickSubjectArr['order'] = array();
		$StickSubjectArr['order']['field'] 	= 	'write_time';
		$StickSubjectArr['order']['type'] 	= 	'DESC';

		$StickSubjectArr['proc'] 						= 	array();
		// Ok Mr.XSS go to hell !
		$StickSubjectArr['proc']['*'] 					= 	array('method'=>'clean','param'=>'html');
		$StickSubjectArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
		$StickSubjectArr['proc']['write_time'] 			= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);

		$PowerBB->_CONF['template']['while']['stick_subject_list'] = $PowerBB->subject->GetSubjectList($StickSubjectArr);

		if (sizeof($PowerBB->_CONF['template']['while']['stick_subject_list']) <= 0)
		{
			$PowerBB->template->assign('NO_STICK_SUBJECTS',true);
		}
		else
		{
			$PowerBB->template->assign('NO_STICK_SUBJECTS',false);
		}

		//////////

		// Get the list of subjects that need review

		if ($PowerBB->functions->ModeratorCheck($this->Section['id']))
		{
			$ReviewSubjectArr = array();

			$ReviewSubjectArr['where'] 				= 	array();

			$ReviewSubjectArr['where'][0] 			= 	array();
			$ReviewSubjectArr['where'][0]['name'] 	= 	'section';
			$ReviewSubjectArr['where'][0]['oper'] 	= 	'=';
			$ReviewSubjectArr['where'][0]['value'] 	= 	$this->Section['id'];

			$ReviewSubjectArr['where'][1] 			= 	array();
			$ReviewSubjectArr['where'][1]['con']	=	'AND';
			$ReviewSubjectArr['where'][1]['name'] 	= 	'review_subject';
			$ReviewSubjectArr['where'][1]['oper'] 	= 	'=';
			$ReviewSubjectArr['where'][1]['value'] 	= 	'1';

			$ReviewSubjectArr['where'][2] 			= 	array();
			$ReviewSubjectArr['where'][2]['con']	=	'AND';
			$ReviewSubjectArr['where'][2]['name'] 	= 	'delete_topic';
			$ReviewSubjectArr['where'][2]['oper'] 	= 	'<>';
			$ReviewSubjectArr['where'][2]['value'] 	= 	'1';

				if ($this->Section['hide_subject']
				and !$PowerBB->_CONF['group_info']['admincp_allow'])
			{
				$ReviewSubjectArr['where'][3] 			= 	array();
				$ReviewSubjectArr['where'][3]['con'] 		= 	'AND';
				$ReviewSubjectArr['where'][3]['name'] 	= 	'writer';
				$ReviewSubjectArr['where'][3]['oper'] 	= 	'=';
				$ReviewSubjectArr['where'][3]['value'] 	= 	$PowerBB->_CONF['member_row']['username'];
			}

			$ReviewSubjectArr['order'] 				= 	array();
			$ReviewSubjectArr['order']['field'] 	= 	'write_time';
			$ReviewSubjectArr['order']['type'] 		= 	'DESC';

			$ReviewSubjectArr['proc'] 						= 	array();
			// Ok Mr.XSS go to hell !
			$ReviewSubjectArr['proc']['*'] 					= 	array('method'=>'clean','param'=>'html');
			$ReviewSubjectArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
			$ReviewSubjectArr['proc']['write_time'] 		= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);

			$PowerBB->_CONF['template']['while']['review_subject_list'] = $PowerBB->subject->GetSubjectList($ReviewSubjectArr);

			if (sizeof($PowerBB->_CONF['template']['while']['review_subject_list']) <= 0)
			{
				$PowerBB->template->assign('NO_REVIEW_SUBJECTS',true);
			}
			else
			{
				$PowerBB->template->assign('NO_REVIEW_SUBJECTS',false);
			}
		}
		else
		{
			$PowerBB->template->assign('NO_REVIEW_SUBJECTS',true);
		}

		//////////

		if ($PowerBB->subject->GetSubjectNumber($TotalArr) > $PowerBB->_CONF['info_row']['subject_perpage'])
		{
		$PowerBB->template->assign('pager',$PowerBB->pager->show());
		}

		$PowerBB->template->assign('section_id',$this->Section['id']);
		}
	}

    /**
	 * Get the results of search one section
	 */

	function _SearchSection()
	{
		global $PowerBB;

         if (!$PowerBB->_GET['keyword'])
	      {
            $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['please_enter_a_single_search']);
	      }

		//////////

		$keyword 	= 	(isset($PowerBB->_GET['keyword'])) ? $PowerBB->_GET['keyword'] : $PowerBB->_POST['keyword'];
		$section 	= 	(isset($PowerBB->_GET['section'])) ? $PowerBB->_GET['section'] : $PowerBB->_POST['section'];

          	$subject_nm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['subject'] . " WHERE text LIKE '%$keyword%' AND section = '$section'"));


            $sec = ' AND section =  ';

	          if ($subject_nm > '0')
	          {
		       $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Search_successful']);
		       $PowerBB->functions->redirect('index.php?page=forum&amp;option=1&amp;section=' . $section . '&amp;keyword=' . $keyword);
	           }
		      else
		       {
		       $stop = ($PowerBB->_CONF['info_row']['ajax_search'] and !$PowerBB->_POST['ajax']) ? false : true;
			   $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['no_search_results'],$stop);
		       }

    }
	function _StartSearch()
	{
		global $PowerBB;

		if (!$PowerBB->_CONF['group_info']['search_allow'])
		{
          if (!$PowerBB->_CONF['member_permission'])
              {
              $PowerBB->template->display('login');
              $PowerBB->functions->error_stop();
			}
	        else
	        {
	        $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['no_online']);
	        }
	     }

         if (!$PowerBB->_GET['keyword'])
	      {
            $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['please_enter_a_single_search']);
	      }


           $PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
           $PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');
		//////////

		$keyword 	= 	(isset($PowerBB->_GET['keyword'])) ? $PowerBB->_GET['keyword'] : $PowerBB->_POST['keyword'];
		$section 	= 	(isset($PowerBB->_GET['section'])) ? $PowerBB->_GET['section'] : $PowerBB->_POST['section'];

          	$subject_nm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['subject'] . " WHERE text LIKE '%$keyword%' AND section = '$section'"));

                $PowerBB->template->assign('nm',$subject_nm);

            $sec = ' AND section =  ';

            $SubjectSearchArr = array();

			$SubjectSearchArr['where'] 				= 	array();

			$SubjectSearchArr['where'][0] 			= 	array();
			$SubjectSearchArr['where'][0]['name'] 	= 	'text LIKE ';
			$SubjectSearchArr['where'][0]['oper']		=  "'".'%' .$keyword .'%'."'  $sec";
			$SubjectSearchArr['where'][0]['value']    =  $section;


			$SubjectSearchArr['proc'] 						= 	array();
			// Ok Mr.XSS go to hell !
			$SubjectSearchArr['proc']['*'] 					= 	array('method'=>'clean','param'=>'html');
			$SubjectSearchArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
			$SubjectSearchArr['proc']['write_time'] 			= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
            // Pager setup
			$SubjectSearchArr['pager'] 				= 	array();
			$SubjectSearchArr['pager']['total']		= 	$subject_nm;
			$SubjectSearchArr['pager']['perpage'] 	= 	$PowerBB->_CONF['info_row']['perpage'];
			$SubjectSearchArr['pager']['count'] 	= 	$PowerBB->_GET['count'];
			$SubjectSearchArr['pager']['location'] 	= 	'index.php?page=forum&amp;option=1&amp;section=' . $section . '&amp;keyword=' . $keyword;
			$SubjectSearchArr['pager']['var'] 		= 	'count';

			$PowerBB->_CONF['template']['while']['SubjectList'] = $PowerBB->subject->GetSubjectList($SubjectSearchArr);

       if (($PowerBB->_CONF['template']['while']['SubjectList'] or $PowerBB->_CONF['template']['while']['ReplyList']  or $PowerBB->_CONF['template']['while']['SubjectTitleList'] or $PowerBB->_CONF['template']['while']['MembersListSubject'] or $PowerBB->_CONF['template']['while']['MembersListReply']  and !$this->SectionGroup['view_section']) == false)
	   {
		   $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['No_search_results'],$stop);

       }



		$PowerBB->_CONF['template']['while']['SearchResult'] = $PowerBB->search->Search(array(	'keyword'	=>	$keyword,
															'section'	=>	$section));

       $ReplyArr['where'] = array($field,$PowerBB->_POST['keyword']);



		//////////

                	if ($subject_nm > $PowerBB->_CONF['info_row']['perpage'])
			        {
					$PowerBB->template->assign('pager',$PowerBB->pager->show());
			        }

		$PowerBB->template->assign('keyword',$keyword);
		$PowerBB->template->display('search_results_all');



	}


	function _CallTemplate()
	{
		global $PowerBB;

		$SecArr 			= 	array();
		$SecArr['where'] 	= 	array('id',$this->Section['id']);

		$Inf = $PowerBB->section->GetSectionInfo($SecArr);

        $PowerBB->template->assign('section_id',$this->Section['id']);

        //if subjects numprs in Section = 0 get the masseg
        $SecSubjectNumArr 			= 	array();
		$SecSubjectNumArr['where'] 	= 	array('id',$PowerBB->_GET['id']);

		$Section_rwo = $PowerBB->section->GetSectionInfo($SecSubjectNumArr);
		$PowerBB->template->assign('NO_SUBJECTS',$Section_rwo['subject_num']);

         ////

         // Moderator And admin Check for View the Icons Editing and Deletion
		$ModArr 			= 	array();
		$ModArr['where'] 	= 	array('section_id',$PowerBB->_GET['id']);

		$ModeratorInfo = $PowerBB->moderator->GetModeratorInfo($ModArr);

		if ($PowerBB->functions->ModeratorCheck($PowerBB->_GET['id']))
		{
			$PowerBB->template->assign('mod_toolbar',0);
			$PowerBB->template->assign('colspan',8);
		}
		else
		{
			$PowerBB->template->assign('mod_toolbar',1);
			$PowerBB->template->assign('colspan',7);
		}

        $SecSubject1 			= 	array();
		$SecSubject1['where'] 	= 	array('id',$Section_rwo['parent']);

		$Section_rwo1 = $PowerBB->section->GetSectionInfo($SecSubject1);

      $PowerBB->template->assign('SectionGroup',$this->SectionGroup);
      $PowerBB->template->assign('sec_address_id',$Section_rwo1['id']);
      $PowerBB->template->assign('section_parent',$Section_rwo1['parent']);
      $PowerBB->template->assign('sec_address_title',$Section_rwo1['title']);



		$PowerBB->template->display('forum');

	}


	    /**
	 * Get the Jump Sections List
	 */
	function _GetJumpSectionsList()
    {
		global $PowerBB;

		//////////

		$SecArr 						= 	array();
		$SecArr['get_from']				=	'db';

		$SecArr['proc'] 				= 	array();
		$SecArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');

		$SecArr['order']				=	array();
		$SecArr['order']['field']		=	'sort';
		$SecArr['order']['type']		=	'ASC';

		$SecArr['where']				=	array();
		$SecArr['where'][0]['name']		= 	'parent';
		$SecArr['where'][0]['oper']		= 	'=';
		$SecArr['where'][0]['value']	= 	'0';

		// Get main sections
		$catsy = $PowerBB->section->GetSectionsList($SecArr);

		// We will use forumsy_list to store list of forums which will view in main page
		$PowerBB->_CONF['template']['foreach']['forumsy_list'] = array();

		// Loop to read the information of main sections
		foreach ($catsy as $caty)
		{
			// Get the groups information to know view this section or not
			$groups = unserialize(base64_decode($caty['sectiongroup_cache']));

			if (is_array($groups[$PowerBB->_CONF['group_info']['id']]))
			{
				if ($groups[$PowerBB->_CONF['group_info']['id']]['view_section'])
				{
					$PowerBB->_CONF['template']['foreach']['forumsy_list'][$caty['id'] . '_m'] = $caty;
				}
			}

			unset($groups);

			if (!empty($caty['forums_cache']))
			{
				$forumsy = unserialize(base64_decode($caty['forums_cache']));

				foreach ($forumsy as $forumy)
				{
					if (is_array($forumy['groups'][$PowerBB->_CONF['group_info']['id']]))
					{
						if ($forumy['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
						{
							//////////

							// Get the first-level sub forums as a _link_ and store it in $forumy['sub']

							$forumy['is_sub'] 	= 	0;
							$forumy['sub']		=	'';

							if (!empty($forumy['forums_cache']))
							{
								$subsy = unserialize(base64_decode($forumy['forums_cache']));

								if (is_array($subsy))
								{
									foreach ($subsy as $suby)
									{
										if (is_array($suby['groups'][$PowerBB->_CONF['group_info']['id']]))
										{
											if ($suby['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
											{
												if (!$forumy['is_sub'])
												{
													$forumy['is_sub'] = 1;
												}

												$forumy['sub'] .= ('<option value="index.php?page=forum&amp;show=1&amp;id=' . $suby['id'] . '">---'  . $suby['title'] . '</option>');
											}
										}
									}
								}
							}


							$PowerBB->_CONF['template']['foreach']['forumsy_list'][$forumy['id'] . '_f'] = $forumy;
						}
					} // end if is_array
				} // end foreach ($forumsy)
			} // end !empty($forums_cache)
		} // end foreach ($catsy)

		//////////
   }
}

?>
