<?php

$CALL_SYSTEM = array();
$CALL_SYSTEM['SUBJECT']     = true;
$CALL_SYSTEM['SECTION'] 	= 	true;
$CALL_SYSTEM['REPLY'] 		= 	true;

(!defined('IN_PowerBB')) ? die() : '';

include('common.php');

define('CLASS_NAME','PowerBBLatestMOD');

class PowerBBLatestMOD
{
	function run()
	{
		global $PowerBB;

		$this->_GetJumpSectionsList();

		if ($PowerBB->_GET['today'])
		{
			$this->_TodayReply();
		}
		else
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$PowerBB->functions->GetFooter();
	}

	function _TodayReply()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();

		$day 	= 	date('j');
		$month 	= 	date('n');
		$year 	= 	date('Y');

		$from 	= 	mktime(0,0,0,$month,$day,$year);
		$to 	= 	mktime(23,59,59,$month,$day,$year);


        $subject_today_nm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['subject'] . " WHERE native_write_time BETWEEN " . $from . " AND " . $to . " AND delete_topic<>'1' AND review_subject<>'1' AND sec_subject<>1 "));
        $reply_today_nm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['reply'] . " WHERE write_time BETWEEN " . $from . " AND " . $to . " AND delete_topic<>'1' AND review_reply<>'1'"));

		$LastSubjectArr 							= 	array();

		// Order data
		$LastSubjectArr['order'] 				= 	array();
		$LastSubjectArr['order']['field'] 	= 	'write_time';
		$LastSubjectArr['order']['type'] 		= 	'DESC';
        $LastSubjectArr['limit'] 		= 	'20';

		// Ten rows only
        $LastSubjectArr['where'][1] 			= 	array();
		$LastSubjectArr['where'][1]['con']		=	'AND';
		$LastSubjectArr['where'][1]['name'] 	= 	'review_subject<>1 AND sec_subject<>1 AND delete_topic';
		$LastSubjectArr['where'][1]['oper'] 	= 	'<>';
		$LastSubjectArr['where'][1]['value'] 	= 	'1';

    	$PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
    	$PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');

		// Clean data
		$LastSubjectArr['proc'] 				= 	array();
		$LastSubjectArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');
		$LastSubjectArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
		$LastSubjectArr['proc']['write_time'] 			= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);


		$LastSubjectArr['pager'] 				= 	array();
		$LastSubjectArr['pager']['total']		= 	$reply_today_nm;
		$LastSubjectArr['pager']['perpage'] 	= 	$PowerBB->_CONF['info_row']['perpage'];
		$LastSubjectArr['pager']['count'] 		= 	$PowerBB->_GET['count'];
		$LastSubjectArr['pager']['location'] 	= 	'index.php?page=latest_reply&amp;today=1';
		$LastSubjectArr['pager']['var'] 		= 	'count';

         $PowerBB->_CONF['template']['while']['LastSubject'] = $PowerBB->subject->GetSubjectList($LastSubjectArr);

        $PowerBB->template->assign('reply_today_nm',$reply_today_nm);

       if ($reply_today_nm  > $PowerBB->_CONF['info_row']['perpage'])
		{
		 $PowerBB->template->assign('pagerLastSubject',$PowerBB->pager->show());
		}

		$PowerBB->template->display('today_reply');

	}

	    /**
	 * Get the Jump Sections List
	 */
	function _GetJumpSectionsList()
    {
		global $PowerBB;

		//////////

		$SecArr 						= 	array();
		$SecArr['get_from']				=	'db';

		$SecArr['proc'] 				= 	array();
		$SecArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');

		$SecArr['order']				=	array();
		$SecArr['order']['field']		=	'sort';
		$SecArr['order']['type']		=	'ASC';

		$SecArr['where']				=	array();
		$SecArr['where'][0]['name']		= 	'parent';
		$SecArr['where'][0]['oper']		= 	'=';
		$SecArr['where'][0]['value']	= 	'0';

		// Get main sections
		$catsy = $PowerBB->section->GetSectionsList($SecArr);

		// We will use forumsy_list to store list of forums which will view in main page
		$PowerBB->_CONF['template']['foreach']['forumsy_list'] = array();

		// Loop to read the information of main sections
		foreach ($catsy as $caty)
		{
			// Get the groups information to know view this section or not
			$groups = unserialize(base64_decode($caty['sectiongroup_cache']));

			if (is_array($groups[$PowerBB->_CONF['group_info']['id']]))
			{
				if ($groups[$PowerBB->_CONF['group_info']['id']]['view_section'])
				{
					$PowerBB->_CONF['template']['foreach']['forumsy_list'][$caty['id'] . '_m'] = $caty;
				}
			}

			unset($groups);

			if (!empty($caty['forums_cache']))
			{
				$forumsy = unserialize(base64_decode($caty['forums_cache']));

				foreach ($forumsy as $forumy)
				{
					if (is_array($forumy['groups'][$PowerBB->_CONF['group_info']['id']]))
					{
						if ($forumy['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
						{
							//////////

							// Get the first-level sub forums as a _link_ and store it in $forumy['sub']

							$forumy['is_sub'] 	= 	0;
							$forumy['sub']		=	'';

							if (!empty($forumy['forums_cache']))
							{
								$subsy = unserialize(base64_decode($forumy['forums_cache']));

								if (is_array($subsy))
								{
									foreach ($subsy as $suby)
									{
										if (is_array($suby['groups'][$PowerBB->_CONF['group_info']['id']]))
										{
											if ($suby['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
											{
												if (!$forumy['is_sub'])
												{
													$forumy['is_sub'] = 1;
												}

												$forumy['sub'] .= ('<option value="index.php?page=forum&amp;show=1&amp;id=' . $suby['id'] . '">---'  . $suby['title'] . '</option>');
											}
										}
									}
								}
							}


							$PowerBB->_CONF['template']['foreach']['forumsy_list'][$forumy['id'] . '_f'] = $forumy;
						}
					} // end if is_array
				} // end foreach ($forumsy)
			} // end !empty($forums_cache)
		} // end foreach ($catsy)

		//////////
   }
}

?>
