<?php

(!defined('IN_PowerBB')) ? die() : '';

define('STOP_STYLE',true);
define('LOGIN',true);

include('common.php');

define('CLASS_NAME','PowerBBLoginMOD');

class PowerBBLoginMOD
{
	function run()
	{
		global $PowerBB;

		/** Normal login **/
		if ($PowerBB->_GET['login'])
		{
			$this->_StartLogin();
		}
		/** **/

		/** Login after register **/
		elseif ($PowerBB->_GET['register_login'])
		{
			$this->_StartLogin(true);
		}
		/** **/
		else
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

	}

	/**
	 * Check if the username , password is true , then give the permisson .
	 * otherwise don't give the permisson
	 *
	 * @param :
	 *			register_login	->
	 *								true : to use this function to login after register
	 *								false : to use this function to normal login
	 */
	function _StartLogin($register_login=false)
	{
		global $PowerBB;

		if (!$register_login)
		{
			if (empty($PowerBB->_POST['username'])
             or empty($PowerBB->_POST['password']))
             {
          $PowerBB->functions->ShowHeader();
          $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Message_Login_incorrect'],true);
          }
			$username = $PowerBB->functions->CleanVariable($PowerBB->_POST['username'],'trim');
			$password = $PowerBB->functions->CleanVariable(md5($PowerBB->_POST['password']),'trim');
		}
		else
		{
             if (empty($PowerBB->_GET['username'])
             or empty($PowerBB->_GET['password']))
                {
                $PowerBB->functions->ShowHeader();
                $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Message_Login_incorrect'],true);
                }
			$username = $PowerBB->functions->CleanVariable($PowerBB->_GET['username'],'trim');
            $password = $PowerBB->functions->CleanVariable($PowerBB->_GET['password'],'trim');
		}

		$expire = ($PowerBB->_POST['temporary'] == 'on') ? 0 : time() + 31536000;

		$IsMember = $PowerBB->member->LoginMember(array(	'username'	=>	$username,
															'password'	=>	$password,
															'expire'	=>	$expire));


		if ($IsMember != false)
		{
			//////////

			$username = $PowerBB->functions->CleanVariable($username,'html');

			$PowerBB->template->assign('username',$username);

			$PowerBB->template->display('login_msg');

			//////////

			if ($IsMember['style'] != $IsMember['style_id_cache'])
			{
				$style_cache = $PowerBB->style->CreateStyleCache(array('where'=>array('id',$IsMember['style'])));

				$UpdateArr						=	array();
				$UpdateArr['field']				=	array();

				$UpdateArr['field']['style_cache'] 		= 	$style_cache;
				$UpdateArr['field']['style_id_cache']	=	$IsMember['style'];
				$UpdateArr['where']						=	array('id',$IsMember['id']);

				$update_cache = $PowerBB->member->UpdateMember($UpdateArr);
			}

			//////////

			$DelArr 						= 	array();
			$DelArr['where'] 				= 	array();
			$DelArr['where'][0] 			= 	array();
			$DelArr['where'][0]['name'] 	= 	'user_ip';
			$DelArr['where'][0]['oper'] 	= 	'=';
			$DelArr['where'][0]['value'] 	= 	$PowerBB->_CONF['ip'];

			$PowerBB->online->DeleteOnline($DelArr);

			//////////

			$url = parse_url($PowerBB->_SERVER['HTTP_REFERER']);
      		$url = $url['query'];
      		$url = explode('&',$url);
      		$url = $url[0];

     		$Y_url = explode('/',$PowerBB->_SERVER['HTTP_REFERER']);
      		$X_url = explode('/',$PowerBB->_SERVER['HTTP_HOST']);

      		//////////

      		if (!$register_login)
      		{
      			if ($url != 'page=logout'
      				or empty($url)
      				or $url != 'page=login')
           		{
       				$PowerBB->functions->redirect($PowerBB->_SERVER['HTTP_REFERER']);
      			}

      			elseif ($Y_url[2] != $X_url[0]
      					or $url == 'page=logout'
      					or $url == 'page=login')
           		{
       				$PowerBB->functions->redirect('index.php');
      			}
      		}
      		else
      		{
      			 // Can't find last visit cookie , so register it
				if (!$PowerBB->functions->IsCookie('PowerBB_lastvisit'))
				{
					$CookieArr 					= 	array();
					$CookieArr['last_visit'] 	= 	(empty($PowerBB->_CONF['member_row']['lastvisit'])) ? $PowerBB->_CONF['now'] : $PowerBB->_CONF['member_row']['lastvisit'];
					$CookieArr['date'] 			= 	$PowerBB->_CONF['now'];
					$CookieArr['id'] 			= 	$PowerBB->_CONF['member_row']['id'];

					$PowerBB->member->LastVisitCookie($CookieArr);
				}
      			$PowerBB->functions->redirect('index.php');
      		}
		}
		else
		{
			$PowerBB->functions->ShowHeader();
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Message_Login_incorrect'],true);
		}
	}
}

?>
