<?php

// ##############################################################################||
// #
// #   PowerBB Version 2.0.0
// #   http://www.PBBoard.com
// #   Copyright (c) 2009 by Abu.Rakan
// #
// #   filename : print.module.php
// #   print Subject
// #
// ##############################################################################||

(!defined('IN_PowerBB')) ? die() : '';

$CALL_SYSTEM				=	array();
$CALL_SYSTEM['SUBJECT'] 	= 	true;
$CALL_SYSTEM['SECTION'] 	= 	true;
$CALL_SYSTEM['REPLY'] 		= 	true;
$CALL_SYSTEM['ICONS'] 		= 	true;
$CALL_SYSTEM['MODERATORS'] 	= 	true;
$CALL_SYSTEM['POLL'] 		= 	true;

define('JAVASCRIPT_PowerCode',true);

include('common.php');

define('CLASS_NAME','PowerBBPrintMOD');

class PowerBBPrintMOD
{
	var $Info;
	var $SectionInfo;
	var $SectionGroup;
	var $RInfo;
	var $x = 0;
	var $reply_number = 0;

	/**
	 * The main function , will require from kernel file "index.php"
	 */
	function run()
	{
		global $PowerBB;

		// Show the topic
		if ($PowerBB->_GET['show'])
		{
			$this->_ShowTopic();
		}
		else
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}
      $PowerBB->template->display('print_footer');
	}

	function _ShowTopic()
	{
		global $PowerBB;

		// Get subject information
		$this->__GetSubject();

		// Get subject's section information
		$this->__GetSection();

		$this->__ModeratorCheck();

		// Get visitor/member group info
		$this->__GetGroup();

		// Check about everything
		$this->__CheckSystem();

		// Get subject's writer information
		$this->__GetWriterInfo();


		$this->__CheckPoll();

		// Make subject text as a nice text
		$this->__SubjectTextFormat();

		// Show subject
		$this->__SubjectEnd();

		// Get the replies
		$this->__GetReply();
	}

	function __GetSubject()
	{
		global $PowerBB;

		//////////

		// Clean id from any string, that will protect us
		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		// If the id is empty, so stop the page
		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		//////////

		// Get the subject and the subject's writer information
		$this->Info = $PowerBB->subject->GetSubjectWriterInfo(array('id'	=>	$PowerBB->_GET['id']));

		// There is no subject, so show error message
		if (!$this->Info)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Requested_topic_does_not_exist']);
		}

		// The ID of subject
		$this->Info['subject_id'] = $PowerBB->_GET['id'];

		//////////

		// Kill XSS
		$PowerBB->functions->CleanVariable($this->Info,'html');
		// Kill SQL Injection
		$PowerBB->functions->CleanVariable($this->Info,'sql');

		//////////

		// Send subject id to template engine
		$PowerBB->template->assign('subject_id',$PowerBB->_GET['id']);
		$PowerBB->template->assign('section_id',$this->Info['section']);

		//////////

	}

	function __GetSection()
	{
		global $PowerBB;

		/** Get the section information **/
		$SecArr 			= 	array();
		$SecArr['where'] 	= 	array('id',$this->Info['section']);

		$this->SectionInfo = $PowerBB->section->GetSectionInfo($SecArr);

		// Kill XSS
		$PowerBB->functions->CleanVariable($this->SectionInfo,'html');
		// Kill SQL Injection
		$PowerBB->functions->CleanVariable($this->SectionInfo,'sql');
		/** **/

		$PowerBB->template->assign('section_info',$this->SectionInfo);
	}

	function __ModeratorCheck()
	{
		global $PowerBB;

		$Mod = $PowerBB->functions->ModeratorCheck($PowerBB->_GET['id']);

		$PowerBB->template->assign('Mod',$Mod);
	}

	function __GetGroup()
	{
		global $PowerBB;

		/** Get section's group information and make some checks **/
		$SecGroupArr 						= 	array();
		$SecGroupArr['where'] 				= 	array();
		$SecGroupArr['where'][0]			=	array();
		$SecGroupArr['where'][0]['name'] 	= 	'section_id';
		$SecGroupArr['where'][0]['value'] 	= 	$this->SectionInfo['id'];
		$SecGroupArr['where'][1]			=	array();
		$SecGroupArr['where'][1]['con']		=	'AND';
		$SecGroupArr['where'][1]['name']	=	'group_id';
		$SecGroupArr['where'][1]['value']	=	$PowerBB->_CONF['group_info']['id'];

		// Finally get the permissions of group
		$this->SectionGroup = $PowerBB->group->GetSectionGroupInfo($SecGroupArr);
	}

	function __CheckSystem()
	{
		global $PowerBB;

		// The visitor can't show this section , so stop the page
		if (!$this->SectionGroup['view_section'])
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Sorry_you_can_not_print_this_topic']);
		}
		/** **/

        // If the member isn't the writer , so register a new visit for the subject
		$SubjectArr = array();
		$SubjectArr['where'] = array('id',$PowerBB->_GET['id']);

		$SubjectInfov = $PowerBB->subject->GetSubjectInfo($SubjectArr);

		$SubjectInfov['visitor'] +=1;
        $visitor = $SubjectInfov['visitor'];

		$Subjectid = $PowerBB->_GET['id'];
			if  ($PowerBB->_CONF['member_row']['username'] == $SubjectInfov['writer'])
		   {
              // Does not do anything
		   }
          else
          {
		     $update_visitor = $PowerBB->DB->sql_query("UPDATE " . $PowerBB->table['subject'] . " SET visitor= '$visitor' WHERE id='$Subjectid'");

          }

		// We have password in the subject's section , so check the password
		if (!empty($this->SectionInfo['section_password'])
			and !$PowerBB->_CONF['rows']['group_info']['admincp_allow'])
		{
			// The visitor don't give me password , so require it
     		if (empty($PowerBB->_GET['password']))
        	{
      			$PowerBB->template->display('forum_password');
      			$PowerBB->functions->stop();
     		}
     		// The visitor give me password , so check
     		elseif (!empty($PowerBB->_GET['password']))
     		{
     			$PassArr = array();

     			// Section id
     			$PassArr['id'] 		= $this->SectionInfo['id'];

     			// The password to check
     			$PassArr['password'] 	= base64_decode($PowerBB->_GET['password']);

     			$IsTruePassword = $PowerBB->section->CheckPassword($PassArr);

     			// Stop ! it's don't true password
     			if (!$IsTruePassword)
     			{
     				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['PasswordIsnotTrue']);
     			}

     			$PowerBB->_CONF['template']['password'] = '&amp;password=' . $PowerBB->_GET['password'];
     		}
     	}
	}

	function __GetWriterInfo()
	{
		global $PowerBB;

		// Make register date in nice format to show it
		if (is_numeric($this->Info['register_date']))
		{
			$this->Info['register_date'] = $PowerBB->functions->date($this->Info['register_date']);
		}


		if (empty($this->Info['username_style_cache']))
		{
			$this->Info['display_username'] = $this->Info['username'];
		}
		else
		{
			$this->Info['display_username'] = $this->Info['username_style_cache'];

			$this->Info['display_username'] = $PowerBB->functions->CleanVariable($this->Info['display_username'],'unhtml');
		}
	}


	function __CheckPoll()
	{
		global $PowerBB;

		$PollArr 			= 	array();
		$PollArr['where'] 	= 	array('subject_id',$PowerBB->_GET['id']);

		$Poll = $PowerBB->poll->GetPollInfo($PollArr);

		// Aha, there is poll in this subject
		if ($Poll != false)
		{
			$PowerBB->template->foreach_array['answers'] = $Poll['answers'];

			unset($Poll['answers']);

			$PowerBB->template->assign('Poll',$Poll);
			$PowerBB->template->assign('SHOW_POLL',true);
		}
		else
		{
			$PowerBB->template->assign('SHOW_POLL',false);
		}
	}

	function __SubjectTextFormat()
	{
		global $PowerBB;


		// If the PowerCode is allow , so use it :)
		if ($this->SectionInfo['use_power_code_allow'])
		{
			$this->Info['text'] = $PowerBB->Powerparse->replace($this->Info['text']);
		}
		// The PowerCode isn't allow , don't use it :(
		else
		{
			$this->Info['text'] = nl2br($this->Info['text']);
		}

		// Convert smiles in subject to nice images :)
		$PowerBB->Powerparse->replace_smiles($this->Info['text']);
		 $PowerBB->Powerparse->replace_wordwrap($this->Info['text']);
	}

	function __SubjectEnd()
	{
		global $PowerBB;

		$topic_date = $PowerBB->functions->date($this->Info['native_write_time']);
		$topic_time = $PowerBB->functions->time($this->Info['native_write_time']);

		$this->Info['native_write_time'] = $topic_date;

		// Finally $this->Info to templates
		$PowerBB->template->assign('Info',$this->Info);

		// Show subject
		$PowerBB->template->display('print_subject');
	}

	function __GetReply()
	{
		global $PowerBB;

		// Show the replies
		$PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
		$PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');

		$ReplyNumArr 					= 	array();
		$ReplyNumArr['get_from'] 		= 	'db';

		$ReplyNumArr['where'] 		= 	array('subject_id',$this->Info['subject_id']);

		$ReplyNumArr['where'][1] 			= 	array();
		$ReplyNumArr['where'][1]['con']		=	'AND';
		$ReplyNumArr['where'][1]['name']	=	'delete_topic';
		$ReplyNumArr['where'][1]['oper']	=	'<>';
		$ReplyNumArr['where'][1]['value']	=	'1';

		$ReplyArr = array();

		$ReplyArr['proc'] 				= 	array();
		$ReplyArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');

		// Pager setup
		$ReplyArr['pager'] 				= 	array();
		$ReplyArr['pager']['total']		= 	$PowerBB->reply->GetReplyNumber($ReplyNumArr);
		$ReplyArr['pager']['perpage'] 	= 	$PowerBB->_CONF['info_row']['perpage'];
		$ReplyArr['pager']['count'] 	= 	$PowerBB->_GET['count'];
		$ReplyArr['pager']['location'] 	= 	'index.php?page=topic&amp;show=1&amp;id=' . $this->Info['subject_id'];
		$ReplyArr['pager']['var'] 		= 	'count';

		$ReplyArr['where']				=	array();
		$ReplyArr['where'][0] 			= 	array();
		$ReplyArr['where'][0]['name']	=	'delete_topic';
		$ReplyArr['where'][0]['oper']	=	'<>';
		$ReplyArr['where'][0]['value']	=	'1';

		$ReplyArr['subject_id'] 		= 	$this->Info['subject_id'];

		$this->RInfo = $PowerBB->reply->GetReplyWriterInfo($ReplyArr);

		// Kill XSS
		// TODO :: it's better to kill XSS inside the loop
		$PowerBB->functions->CleanVariable($this->RInfo,'html');

		$n = sizeof($this->RInfo);
		$this->x = 0;

		// Nice loop :D
		while ($n > $this->x)
		{
			// Get the replier info
			$this->___GetReplierInfo();

			// Make reply text as a nice format
			$this->___ReplyFormat();

			// The end of reply
			$this->___ReplyEnd();
		}
	}

	function ___GetReplierInfo()
	{
		global $PowerBB;

		// Make register date in nice format to show it
		if (is_numeric($this->RInfo[$this->x]['register_date']))
		{
			$this->RInfo[$this->x]['register_date'] = $PowerBB->functions->date($this->RInfo[$this->x]['register_date']);
		}


		if (empty($this->RInfo[$this->x]['username_style_cache']))
		{
			$this->RInfo[$this->x]['display_username'] = $this->RInfo[$this->x]['username'];
		}
		else
		{
			$this->RInfo[$this->x]['display_username'] = $this->RInfo[$this->x]['username_style_cache'];

			$this->RInfo[$this->x]['display_username'] = $PowerBB->functions->CleanVariable($this->RInfo[$this->x]['display_username'],'unhtml');
		}

		$this->RInfo[$this->x]['reply_number'] = $this->reply_number;

		$this->reply_number += 1;
	}

	function ___ReplyFormat()
	{
		global $PowerBB;

		// If the PowerCode is allow , use it
		if ($this->SectionInfo['use_power_code_allow'])
		{
			$this->RInfo[$this->x]['text'] = $PowerBB->Powerparse->replace($this->RInfo[$this->x]['text']);
		}
		// It's not allow , don't use it
		else
		{
			$this->RInfo[$this->x]['text'] = nl2br($this->RInfo[$this->x]['text']);
		}

		// Convert the smiles to image
		$PowerBB->Powerparse->replace_smiles($this->RInfo[$this->x]['text']);
		 $PowerBB->Powerparse->replace_wordwrap($this->RInfo[$this->x]['text']);

		// Member signture is not empty , show make it nice with PowerCode
		if (!empty($this->RInfo[$this->x]['user_sig']))
		{
			$this->RInfo[$this->x]['user_sig'] = $PowerBB->Powerparse->replace($this->RInfo[$this->x]['user_sig']);
			$PowerBB->Powerparse->replace_smiles($this->RInfo[$this->x]['user_sig']);
		}
	}

	function ___ReplyEnd()
	{
		global $PowerBB;

		$reply_date = $PowerBB->functions->date($this->RInfo[$this->x]['write_time']);
		$reply_time = $PowerBB->functions->time($this->RInfo[$this->x]['write_time']);

		$this->RInfo[$this->x]['write_time'] = $reply_date ;

		// We have attachment in this reply
		if ($this->RInfo[$this->x]['attach_reply'])
		{
			$AttachArr 							= 	array();
			$AttachArr['where']					= 	array();
			$AttachArr['where'][0] 				=	array();
			$AttachArr['where'][0]['name'] 		=	'subject_id';
			$AttachArr['where'][0]['oper'] 		=	'=';
			$AttachArr['where'][0]['value'] 	=	$this->RInfo[$this->x]['reply_id'];
			$AttachArr['where'][1] 				=	array();
			$AttachArr['where'][1]['con']		=	'AND';
			$AttachArr['where'][1]['name'] 		=	'reply';
			$AttachArr['where'][1]['oper'] 		=	'=';
			$AttachArr['where'][1]['value'] 	=	'1';

			// Get the attachment information
			$PowerBB->_CONF['template']['while']['AttachList'] = $PowerBB->attach->GetAttachList($AttachArr);

			if ($PowerBB->_CONF['template']['while']['AttachList'] != false)
			{
				$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['while']['AttachList'],'html');
			}

			$PowerBB->template->assign('AttachList',$PowerBB->_CONF['template']['while']['AttachList']);
		}

		// $RInfo to templates
		$PowerBB->template->assign('Info',$this->RInfo[$this->x]);
		$PowerBB->template->assign('section',$this->Info['section']);

       	$ReviewInfoArr = array();
		$ReviewInfoArr['where'] = array('id',$this->RInfo[$this->x]['reply_id']);

		$ReviewInfo = $PowerBB->reply->GetReplyInfo($ReviewInfoArr);
		$PowerBB->template->assign('ReviewInfo',$ReviewInfo);

		// $x = $x + 1
		$this->x += 1;

		// Show the reply :)
			if ($ReviewInfo['review_reply'] == 1)
			{
				// Does not show anything
			}
			else
			{
		// Show the reply :)
		$PowerBB->template->display('print_reply');

		}
	}



	function __PageEnd()
	{
		global $PowerBB;

		////////

		$Admin = false;

		if ($PowerBB->_CONF['member_permission'])
		{
			if ($PowerBB->_CONF['group_info']['admincp_allow']
				or $PowerBB->_CONF['group_info']['vice'])
			{
				$Admin = true;
			}
			else
			{
				if (isset($this->SectionInfo))
				{
					$AdminArr = array();
					$AdminArr['username'] = $PowerBB->_CONF['member_row']['username'];
					$AdminArr['section_id'] = $this->SectionInfo['id'];

					$Admin = $PowerBB->moderator->IsModerator($AdminArr);
				}
			}
		}

		////////

		$PowerBB->template->assign('pager',$PowerBB->pager->show());

     	$PowerBB->template->assign('id',$PowerBB->_GET['id']);

     	$PowerBB->template->assign('Admin',$Admin);

	}
}

?>
