<?php

(!defined('IN_PowerBB')) ? die() : '';

$CALL_SYSTEM				=	array();
$CALL_SYSTEM['TAG'] 		= 	true;
$CALL_SYSTEM['TAG_SUBJECT'] 		= 	true;
$CALL_SYSTEM['SUBJECT'] 	= 	true;
$CALL_SYSTEM['MODERATORS'] 	= 	true;

include('common.php');

define('CLASS_NAME','PowerBBTagsMOD');

class PowerBBTagsMOD
{

	function run()
	{
		global $PowerBB;

		// Show header with page title
		$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['Atags']);

		if ($PowerBB->_GET['show'])
		{
			$this->_Show();
		}
		if ($PowerBB->_GET['edit'])
		{
			$this->_edit();
		}
		if ($PowerBB->_GET['start'])
		{
			$this->_StartEdit();
		}

		$PowerBB->functions->GetFooter();
	}

	function _Show()
	{
		global $PowerBB;

		// Clean the id from any strings
		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
		$PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');


		$TagInfoArr 			= 	array();
		$TagInfoArr['where'] 	= 	array('tag_id',$PowerBB->_GET['id']);
		$TagInfo = $PowerBB->tag_subject->GetSubjectInfo($TagInfoArr);

		$TotalArr 			= 	array();
		$TotalArr['where'] 	= 	array('tag',$TagInfo['tag']);


		// Pager setup
		$TagArr 							= 	array();
		$TagArr['where'] 					= 	array();

		$TagArr['where'][0] 				= 	array();
		$TagArr['where'][0]['name'] 		= 	'tag';
		$TagArr['where'][0]['oper'] 		= 	'=';
		$TagArr['where'][0]['value'] 		= 	$TagInfo['tag'];

		$TagArr['proc'] 			= 	array();
		$TagArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');
		$TagArr['order']			=	array();
		$TagArr['order']['field']	=	'id';
		$TagArr['order']['type']	=	'DESC';

		$TagArr['pager'] 				= 	array();
		$TagArr['pager']['total']		= 	$PowerBB->tag_subject->GetSubjectNumber($TotalArr);
		$TagArr['pager']['perpage'] 	= 	$PowerBB->_CONF['info_row']['subject_perpage']; // TODO
		$TagArr['pager']['count'] 		= 	$PowerBB->_GET['count'];
		$TagArr['pager']['location'] 	= 	'index.php?page=tags&amp;show=1&amp;id=' . $PowerBB->_GET['id'];
		$TagArr['pager']['var'] 		= 	'count';

		$PowerBB->_CONF['template']['while']['Subject'] = $PowerBB->tag_subject->GetSubjectList($TagArr);

		if (!$PowerBB->_CONF['template']['while']['Subject'])
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['taag_requested_does_not_exist']);
		}

		$PowerBB->template->assign('tag',$TagInfo['tag']);
		if ($PowerBB->tag_subject->GetSubjectNumber($TotalArr) > $PowerBB->_CONF['info_row']['subject_perpage'])
		{
		$PowerBB->template->assign('pager',$PowerBB->pager->show());
        }
		$PowerBB->template->display('tags_show_subject');
	}

	function _edit()
	{
		global $PowerBB;

	   $PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

      	if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}


		$SubjectinfArr = array();
		$SubjectinfArr['where'] = array('id',$PowerBB->_GET['id']);

		$Subjectinfo = $PowerBB->subject->GetSubjectInfo($SubjectinfArr);

         $PowerBB->template->assign('SubjectTitle',$Subjectinfo['title']);
         $PowerBB->template->assign('Subjectinfo',$Subjectinfo);

		$SecArr 			= 	array();
		$SecArr['where'] 	= 	array('id',$Subjectinfo['section']);

		$SectionInfo = $PowerBB->section->GetSectionInfo($SecArr);
		$PowerBB->template->assign('SectionInfo',$SectionInfo);

		// Moderator And admin Check for View the Tags Editing
		$ModArr 			= 	array();
		$ModArr['where'] 	= 	array('section_id',$Subjectinfo['section']);

		$ModeratorInfo = $PowerBB->moderator->GetModeratorInfo($ModArr);

		if ($Subjectinfo['writer'] == $PowerBB->_CONF['member_row']['username']
		OR $PowerBB->_CONF['group_info']['admincp_allow']
		OR $PowerBB->_CONF['group_info']['vice']
		OR $PowerBB->functions->ModeratorCheck($Subjectinfo['section']))
		{



		$TagSubjectArr 							= 	array();
		$TagSubjectArr['proc'] 					= 	array();
		$TagSubjectArr['proc']['*'] 				= 	array('method'=>'clean','param'=>'html');

		$TagSubjectArr['where']					=	array();
		$TagSubjectArr['where'][0]				=	array();
		$TagSubjectArr['where'][0]['name']		=	'subject_id';
		$TagSubjectArr['where'][0]['oper']		=	'=';
		$TagSubjectArr['where'][0]['value']		=	$PowerBB->_GET['id'];

		$TagSubjectArr['order']					=	array();
		$TagSubjectArr['order']['field']		=	'id';
		$TagSubjectArr['order']['type']			=	'ASC';

		$PowerBB->_CONF['template']['while']['TagSubjectList'] = $PowerBB->tag->GetSubjectList($TagSubjectArr);
		$subject_id = $PowerBB->_GET['id'];
        $SubjectTagNm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['tag_subject'] . " WHERE subject_id='$subject_id'"));
		 $PowerBB->template->assign('SubjectTagNm',$SubjectTagNm);
         $PowerBB->template->display('tags_edit_subject');
	 }
   	else
     {
     $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);

      }


     }

 	function _StartEdit()
	 {
		global $PowerBB;

		if ($PowerBB->_POST['tags'])
    		{

    			 $Tags = $PowerBB->_POST['tags'];
		      foreach ($Tags as $Tags_x)
		      {

	      		if (empty($Tags_x))
				{
					$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['fill_in_tags']);
				}

		      }


		}

		if ($PowerBB->_POST['remove'])
    		{

    		 $DelTags = $PowerBB->_POST['del_tag'];


		      	if (empty($DelTags))
				{
					$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['fill_in_tags_remove']);
				}
		      foreach ($DelTags as $DelTags_x)
		      {


				  $DeleteSubjectArr				=	array();
		          $DeleteSubjectArr['where'] 	= 	array('id',intval($DelTags_x));
				  $delSubject = $PowerBB->tag_subject->DeleteSubject($DeleteSubjectArr);

		      }

		    $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['tags_delet_successfully']);
			$PowerBB->functions->redirect('index.php?page=tags&edit=1&id=' . $PowerBB->_POST['subject_id']);

		   }
		   else
		   {

		    		// Set tags for the subject
		   		$tags_size = sizeof($PowerBB->_POST['tags']);

		   		if ($tags_size > 0
		   			and strlen($PowerBB->_POST['tags'][0]) > 0)
		   		{
		   			foreach ($PowerBB->_POST['tags'] as $tag)
		   			{
		   				$CheckArr 			= 	array();
		   				$CheckArr['where'] 	= 	array('tag',$tag);

		   				$tag_id = 1;

		   				$Tag = $PowerBB->tag_subject->GetSubjectInfo($CheckArr);

		   				if (!$Tag)
		   				{
		   				$InsertArr 						= 	array();
		   				$InsertArr['field']				=	array();

		   				$InsertArr['field']['tag_id'] 			= 	$tag_id;
		   				$InsertArr['field']['subject_id'] 		=	$PowerBB->_POST['subject_id'];
		   				$InsertArr['field']['tag'] 				= 	$PowerBB->functions->CleanVariable($tag,'html');
		   				$InsertArr['field']['subject_title'] 	= 	$PowerBB->_POST['title'];

		   				// Note, this function is from tag system not subject system
		   				$insert = $PowerBB->tag_subject->InsertSubject($InsertArr);

		   					unset($InsertArr);
				        }
				     	else
				     	{
		   					$UpdateArr 			= 	array();
		   					$UpdateArr['field']	=	array();

		   					$UpdateArr['field']['tag'] 	= 	$PowerBB->functions->CleanVariable($tag,'html');
		   					$UpdateArr['where']				=	array('id',$Tag['id']);

		   					$update = $PowerBB->tag_subject->UpdateSubject($UpdateArr);

		   					$tag_id = $Tag['id'];
		   				}

		   			}
		   		}




   			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Updated_successfully']);
			$PowerBB->functions->redirect('index.php?page=topic&show=1&id=' . $PowerBB->_POST['subject_id']);
         }
    }

}

?>
