<?php

(!defined('IN_PowerBB')) ? die() : '';

$CALL_SYSTEM				=	array();
$CALL_SYSTEM['ICONS'] 		= 	true;
$CALL_SYSTEM['TOOLBOX'] 	= 	true;
$CALL_SYSTEM['REQUEST'] 	= 	true;
$CALL_SYSTEM['MASSEGE'] 	= 	true;
$CALL_SYSTEM['MESSAGE'] 	= 	true;
$CALL_SYSTEM['AVATAR'] 		= 	true;
$CALL_SYSTEM['SUBJECT'] 	= 	true;
$CALL_SYSTEM['SECTION'] 		= 	true;
$CALL_SYSTEM['EXTRAFIELD']   =   true;
$CALL_SYSTEM['REPUTATION'] 	= 	true;
$CALL_SYSTEM['REPLY'] 		= 	true;
$CALL_SYSTEM['ATTACH'] 			= 	true;
$CALL_SYSTEM['BOOKMARK'] 	= 	true;
$CALL_SYSTEM['EMAILED'] 		= 	true;
$CALL_SYSTEM['FRIENDS'] 		= 	true;

include('common.php');

define('CLASS_NAME','PowerBBUserCPMOD');

class PowerBBUserCPMOD
{
	function run()
	{
		global $PowerBB;

		if (!$PowerBB->_CONF['member_permission'])
		{
            $PowerBB->functions->ShowHeader();
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['This_region_to_members_only']);
		}

		if ($PowerBB->_GET['index'])
		{
			$this->_Index();
		}

		/** Control **/
		elseif ($PowerBB->_GET['control'])
		{
			/** Persenol Information control **/
			if ($PowerBB->_GET['info'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_InfoMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_InfoChange();
				}
			}
			/** **/

			/** Options control **/
			elseif ($PowerBB->_GET['setting'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_SettingMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_SettingChange();
				}
			}
			/** **/

			/** Signature control **/
			elseif ($PowerBB->_GET['sign'])
			{
				if (!$PowerBB->_CONF['group_info']['sig_allow'])
				{
		            $PowerBB->functions->ShowHeader();
					$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_can_not_use_this_feature']);
				}

				if ($PowerBB->_GET['main'])
				{
					$this->_SignMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_SignChange();
				}
				elseif ($PowerBB->_GET['subject'])
				{
					$this->_SignSubjectMain();
				}
				elseif ($PowerBB->_GET['subject_start'])
				{
					$this->_SignSubjectChange();
				}
				elseif ($PowerBB->_GET['reply'])
				{
					$this->_SignReplyMain();
				}
				elseif ($PowerBB->_GET['reply_start'])
				{
					$this->_SignReplyChange();
				}
			}
			/** **/

			/** Password control **/
			elseif ($PowerBB->_GET['password'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_PasswordMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_PasswordChange();
				}
			}
			/** **/

			/** Email control **/
			elseif ($PowerBB->_GET['email'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_EmailMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_EmailChange();
				}
			}
			/** **/

			/** Avatar control **/
			elseif ($PowerBB->_GET['avatar'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_AvatarMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_AvatarChange();
				}
			}
			/** **/
		}
		/** **/

		/** Options **/
		elseif ($PowerBB->_GET['options'])
		{
			if ($PowerBB->_GET['reply'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_ReplyListMain();
				}
			}
			elseif ($PowerBB->_GET['subject'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_SubjectListMain();
				}
			}
			elseif ($PowerBB->_GET['attach'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_attachListMain();
				}
				elseif($PowerBB->_GET['del'])
				{
			      $this->_DeleteAttachments();
				}
			}
			elseif ($PowerBB->_GET['emailed'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_EmailedListMain();
				}
			}
			elseif ($PowerBB->_GET['friends'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_FriendsMain();
				}
				elseif ($PowerBB->_GET['add'])
				{
					$this->_FriendsAdd();
				}
				elseif ($PowerBB->_GET['del'])
				{
					$this->_FriendsDel();
				}
				elseif ($PowerBB->_GET['approval'])
				{
					$this->_ApprovalFriendStart();
				}
			}
			elseif ($PowerBB->_GET['reputation'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_ReputationListMain();
				}
			}

		}



		$PowerBB->functions->GetFooter();
	}

	function _Index()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();
        // Get Member Subjects
		$SubjectArr 								= 	array();
		$SubjectArr['where'] 						= 	array();

		$SubjectArr['where'][0] 					= 	array();
		$SubjectArr['where'][0]['name'] 			= 	'writer';
		$SubjectArr['where'][0]['oper'] 			= 	'=';
		$SubjectArr['where'][0]['value'] 			= 	$PowerBB->_CONF['rows']['member_row']['username'];

		// Clean data
		$SubjectArr['proc'] 			        	= 	array();
		$SubjectArr['proc']['*'] 		        	= 	array('method'=>'clean','param'=>'html');
		$SubjectArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
		$SubjectArr['proc']['write_time'] 			= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);

		$SubjectArr['order']			            =	array();
		$SubjectArr['order']['field']	            =	'write_time';
		$SubjectArr['order']['type']	            =	'DESC';
		$SubjectArr['limit'] 		             	= 	'5';


         $PowerBB->_CONF['template']['while']['SubjectList'] = $PowerBB->subject->GetSubjectList($SubjectArr);

		$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['while']['ReplyList'],'html');


		if ($PowerBB->_CONF['template']['while']['SubjectList'] == false)
		{
			$PowerBB->template->assign('No_Subjects',true);
		}
		else
		{
			$PowerBB->template->assign('No_Subjects',false);
		}

        // Get Member Replys

     	$ReplyArr 								= 	array();
		$ReplyArr['where'] 						= 	array();
        $ReplyArr['select'] 	                = 	'DISTINCT subject_id,title,writer,icon';

		$ReplyArr['where'][0] 					= 	array();
		$ReplyArr['where'][0]['name'] 			= 	'writer';
		$ReplyArr['where'][0]['oper'] 			= 	'=';
		$ReplyArr['where'][0]['value'] 			= 	$PowerBB->_CONF['rows']['member_row']['username'];

		$ReplyArr['order'] 						=	 array();
		$ReplyArr['order']['field'] 			= 	'write_time';
		$ReplyArr['order']['type'] 				= 	'DESC';

		$ReplyArr['limit'] 						= 	'10';


		$ReplyArr['proc']['write_time'] 		= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);

		$PowerBB->_CONF['template']['while']['ReplyList'] = $PowerBB->reply->GetReplyList($ReplyArr);


		$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['while']['ReplyList'],'html');


		if ($PowerBB->_CONF['template']['while']['ReplyList'] == false)
		{
			$PowerBB->template->assign('No_posts',true);
		}
		else
		{
			$PowerBB->template->assign('No_posts',false);
		}

		/** Get the Reputation information **/
		$ReputArr 							= 	array();
		$ReputArr['where'] 					= 	array();

		$ReputArr['where'][0] 				= 	array();
		$ReputArr['where'][0]['name'] 		= 	'username';
		$ReputArr['where'][0]['oper'] 		= 	'=';
		$ReputArr['where'][0]['value'] 		= 	$PowerBB->_CONF['rows']['member_row']['username'];

		$ReputArr['order'] 					=	 array();
		$ReputArr['order']['field'] 			= 	'id';
		$ReputArr['order']['type'] 			= 	'DESC';

		$ReputArr['proc'] 						= 	array();
		$ReputArr['proc']['*'] 					= 	array('method'=>'clean','param'=>'html');
		$ReputArr['proc']['reputationdate'] 	= 	array('method'=>'date','store'=>'reputationdate','type'=>$PowerBB->_CONF['info_row']['timesystem']);


		$ReputArr['limit'] 					= 	$PowerBB->_CONF['info_row']['show_reputation_number'];


       $PowerBB->_CONF['template']['while']['MemberReputation'] = $PowerBB->reputation->GetReputationList($ReputArr);
       $this->ReputationInfo = $PowerBB->reputation->GetReputationInfo($ReputArr);

        // If Reputation  by reply Get subject_id for thes reply
		$ReplyArr = array();
		$ReplyArr['where'] = array('id',$this->ReputationInfo['reply_id']);

		$ReplyInfo = $PowerBB->reply->GetReplyInfo($ReplyArr);

		$PowerBB->template->assign('subject_id',$ReplyInfo['subject_id']);

		if ($PowerBB->_CONF['template']['while']['MemberReputation'] == false)
		{
			$PowerBB->template->assign('No_Reputation',true);
		}
		else
		{
			$PowerBB->template->assign('No_Reputation',false);
		}

         // reputation read
		 $UpdateArr 				= 	array();
		 $UpdateArr['field']		=	array();

		 $UpdateArr['field']['reputationread'] 		= 	'0';
	     $UpdateArr['where'] 						= 	array('username',$PowerBB->_CONF['rows']['member_row']['username']);

		 $update = $PowerBB->reputation->UpdateReputation($UpdateArr);

      	$PowerBB->template->display('usercp_index');
	}

	function _InfoMain()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();
				//getting extra fields
    $PowerBB->_CONF['template']['while']['extrafields']=$PowerBB->extrafield->getUserFields();

		$PowerBB->template->display('usercp_control_info');

	}

	function _InfoChange()
	 {
		global $PowerBB;
 		$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['execution_Process_Update']);

		//getting extra fields
    $extraFields=$PowerBB->extrafield->getEmptyLoginFields();
		//checking if the extra fields are required
	 foreach($extraFields AS $field)
	 {
		$FieldsArr = array();
		$FieldsArr['where'] = array('name',$field['name']);

		$FieldsInfo = $PowerBB->extrafield->GetFieldInfo($FieldsArr);

   		if ($FieldsInfo['required'] == 'yes'
   		and $PowerBB->_POST[ $field['name_tag'] ] == '')
   		{
	          $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_do_not_enter'].' <i><b>'.$field['name'].'</b></i>');
        }
     }



		$PowerBB->functions->AddressBar('<a href="index.php?page=usercp&index=1">' .$PowerBB->_CONF['template']['lang']['User_Control_Panel']. '</a> ' . $PowerBB->_CONF['info_row']['adress_bar_separate'] . $PowerBB->_CONF['template']['lang']['execution_Process_Update']);

        $PowerBB->_POST['away_msg'] = $PowerBB->Powerparse->censor_words($PowerBB->_POST['away_msg']);
        $PowerBB->_POST['website'] = $PowerBB->Powerparse->censor_words($PowerBB->_POST['website']);
        $PowerBB->_POST['country'] = $PowerBB->Powerparse->censor_words($PowerBB->_POST['country']);
        $PowerBB->_POST['info'] = $PowerBB->Powerparse->censor_words($PowerBB->_POST['info']);
        $PowerBB->_POST['year'] = $PowerBB->Powerparse->censor_words($PowerBB->_POST['year']);

		$StartArr 			= 	array();
		$StartArr['field'] 	= 	array();

		$StartArr['field']['user_country'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['country'],'html');
		$StartArr['field']['user_gender']   = 	$PowerBB->functions->CleanVariable($PowerBB->_POST['gender'],'html');
		$StartArr['field']['user_website'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['website'],'html');
		$StartArr['field']['user_info'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['info'],'html');
		$StartArr['field']['away'] 			= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['away'],'html');
		$StartArr['field']['away_msg'] 		= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['away_msg'],'html');
		$StartArr['field']['bday_day'] 		= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['day'],'html');
		$StartArr['field']['bday_month'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['month'],'html');
		$StartArr['field']['bday_year'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['year'],'html');
		//extra fields insertion
        foreach($extraFields AS $field){

        $PowerBB->_POST[ $field['name_tag'] ] = $PowerBB->Powerparse->censor_words($PowerBB->_POST[ $field['name_tag'] ]);
		$PowerBB->functions->CleanVariable($PowerBB->_POST[ $field['name_tag'] ],'sql');
		$StartArr['field'][ $field['name_tag'] ]     =   $PowerBB->Powerparse->censor_words($PowerBB->_POST[ $field['name_tag'] ]);
        }
		$StartArr['where']					=	array('id',$PowerBB->_CONF['member_row']['id']);

		$StartChange = $PowerBB->member->UpdateMember($StartArr);

		if ($StartChange)
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Updated_successfully']);
            $PowerBB->functions->redirect('index.php?page=usercp&amp;control=1&amp;info=1&amp;main=1');
		}
	}

	function _SettingMain()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();

       // Select Style

		$GetStyleArr 						= 	array();

		$GetStyleArr['order'] 				= 	array();
		$GetStyleArr['order']['field'] 		= 	'style_order';
		$GetStyleArr['order']['type'] 		= 	'ASC';

		$PowerBB->_CONF['template']['while']['StyleList'] = $PowerBB->style->GetStyleList($GetStyleArr);

		$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['while']['StyleList'],'html');

       // Select Language
		$GetLangArr 						= 	array();

		$GetLangArr['order'] 				= 	array();
		$GetLangArr['order']['field'] 		= 	'lang_order';
		$GetLangArr['order']['type'] 		= 	'ASC';

		$PowerBB->_CONF['template']['while']['LangList'] = $PowerBB->lang->GetLangList($GetLangArr);

		$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['while']['LangList'],'html');

       // info member
		$MemberArr 				= 	array();
		$MemberArr['where']		=	array('username',$PowerBB->_CONF['member_row']['username']);

		$member = $PowerBB->member->GetMemberInfo($MemberArr);
        $PowerBB->template->assign('member_lang',$member['lang']);
        $PowerBB->template->assign('member',$member);

		$PowerBB->template->display('usercp_control_setting');

	}

	function _SettingChange()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['execution_Process_Update']);

		$PowerBB->functions->AddressBar('<a href="index.php?page=usercp&index=1"> '. $PowerBB->_CONF['template']['lang']['User_Control_Panel'] .'</a>'. $PowerBB->_CONF['info_row']['adress_bar_separate'] . $PowerBB->_CONF['template']['lang']['execution_Process_Update']);

		$UpdateArr 					= 	array();
		$UpdateArr['field']			=	array();

		$UpdateArr['field']['style'] 		= 	$PowerBB->_POST['style'];
		$UpdateArr['field']['lang'] 		= 	$PowerBB->_POST['lang'];
		$UpdateArr['field']['hide_online'] 	= 	$PowerBB->_POST['hide_online'];
		$UpdateArr['field']['user_time'] 	= 	$PowerBB->_POST['user_time'];
		$UpdateArr['field']['send_allow'] 	= 	$PowerBB->_POST['send_allow'];
		$UpdateArr['field']['pm_emailed'] 	= 	$PowerBB->_POST['pm_emailed'];
		$UpdateArr['field']['pm_window'] 	= 	$PowerBB->_POST['pm_window'];
		$UpdateArr['field']['visitormessage'] 	= 	$PowerBB->_POST['visitormessage'];

		$UpdateArr['where']					=	array('id',$PowerBB->_CONF['member_row']['id']);

		$UpdateSetting = $PowerBB->member->UpdateMember($UpdateArr);

		if ($UpdateSetting)
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Updated_successfully']);
         $PowerBB->functions->redirect('index.php?page=usercp&amp;control=1&amp;setting=1&amp;main=1',2);
		}
	}

	function _SignMain()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();

		$PowerBB->functions->GetEditorTools();

		$PowerBB->_CONF['template']['Sign'] = $PowerBB->Powerparse->replace($PowerBB->_CONF['rows']['member_row']['user_sig']);
		$PowerBB->Powerparse->replace_smiles($PowerBB->_CONF['template']['Sign']);
		$PowerBB->_CONF['template']['Sign'] = str_replace('&amp;','&',$PowerBB->_CONF['template']['Sign']);

		$PowerBB->template->display('usercp_control_sign');

	}

	function _SignChange()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['execution_Process_Update']);

		$PowerBB->functions->AddressBar('<a href="index.php?page=usercp&index=1"> ' . $PowerBB->_CONF['template']['lang']['User_Control_Panel']. '</a>' .$PowerBB->_CONF['info_row']['adress_bar_separate'] . $PowerBB->_CONF['template']['lang']['execution_Process_Update']);

   		if (isset($PowerBB->_POST['text']{$PowerBB->_CONF['group_info']['sig_len']}))
   		{
              $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['sign_max']);
    	 }

		$PowerBB->_POST['text'] = $PowerBB->functions->CleanVariable($PowerBB->_POST['text'],'trim');
        $PowerBB->_POST['text'] = $PowerBB->Powerparse->censor_words($PowerBB->_POST['text']);
        $PowerBB->functions->CleanVariable($PowerBB->_POST['text'],'sql');
		$PowerBB->_POST['text'] = str_replace('target="_blank" ','',$PowerBB->_POST['text']);

		$SignArr 				= 	array();
		$SignArr['field']		=	array();

		$SignArr['field']['user_sig'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['text'],'html');
		$SignArr['where']				=	array('id',$PowerBB->_CONF['member_row']['id']);

		$UpdateSign = $PowerBB->member->UpdateMember($SignArr);

		if ($UpdateSign)
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Signature_has_been_updated_successfully']);
          $PowerBB->functions->redirect('index.php?page=usercp&amp;control=1&amp;sign=1&amp;main=1');
		}
	}

	function _SignSubjectMain()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();

		$PowerBB->functions->GetEditorTools();

		$PowerBB->_CONF['template']['Sign'] = $PowerBB->Powerparse->replace($PowerBB->_CONF['rows']['member_row']['subject_sig']);
		$PowerBB->Powerparse->replace_smiles($PowerBB->_CONF['template']['Sign']);
		$PowerBB->_CONF['template']['Sign'] = str_replace('&amp;','&',$PowerBB->_CONF['template']['Sign']);

		$PowerBB->template->display('usercp_control_signsubject');

	}

	function _SignSubjectChange()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['execution_Process_Update']);

		$PowerBB->functions->AddressBar('<a href="index.php?page=usercp&index=1">' .$PowerBB->_CONF['template']['lang']['User_Control_Panel']. '</a> ' . $PowerBB->_CONF['info_row']['adress_bar_separate'] . $PowerBB->_CONF['template']['lang']['execution_Process_Update']);

		$PowerBB->_POST['text'] = $PowerBB->functions->CleanVariable($PowerBB->_POST['text'],'trim');

		$SignArr = array();
		$SignArr['field'] = array();

		$SignArr['field']['subject_sig'] = $PowerBB->functions->CleanVariable($PowerBB->_POST['text'],'html');
		$SignArr['where'] = array('id',$PowerBB->_CONF['member_row']['id']);

		$UpdateSign = $PowerBB->member->UpdateMember($SignArr);

		if ($UpdateSign)
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Updated_the_default_signature_of_the_subjects_successfully']);
            $PowerBB->functions->redirect('index.php?page=usercp&control=1&subjects=1&main=1');
		}
	}

	function _SignReplyMain()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();

		$PowerBB->functions->GetEditorTools();

		$PowerBB->_CONF['template']['Sign'] = $PowerBB->Powerparse->replace($PowerBB->_CONF['rows']['member_row']['reply_sig']);
		$PowerBB->Powerparse->replace_smiles($PowerBB->_CONF['template']['Sign']);
		$PowerBB->_CONF['template']['Sign'] = str_replace('&amp;','&',$PowerBB->_CONF['template']['Sign']);

		$PowerBB->template->display('usercp_control_signreply');

	}

	function _SignReplyChange()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['execution_Process_Update']);

		$PowerBB->functions->AddressBar('<a href="index.php?page=usercp&index=1">' .$PowerBB->_CONF['template']['lang']['User_Control_Panel']. '</a> ' . $PowerBB->_CONF['info_row']['adress_bar_separate'] . $PowerBB->_CONF['template']['lang']['execution_Process_Update']);

		$PowerBB->_POST['text'] = $PowerBB->functions->CleanVariable($PowerBB->_POST['text'],'trim');

		$SignArr = array();
		$SignArr['field'] = array();

		$SignArr['field']['reply_sig'] = $PowerBB->functions->CleanVariable($PowerBB->_POST['text'],'html');;
		$SignArr['where'] = array('id',$PowerBB->_CONF['member_row']['id']);

		$UpdateSign = $PowerBB->member->UpdateMember($SignArr);

		if ($UpdateSign)
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Updated_the_default_signature_of_the_replys_successfully']);
           $PowerBB->functions->redirect('index.php?page=usercp&control=1&replays=1&main=1');
		}
	}

	function _PasswordMain()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();

		$PowerBB->template->display('usercp_control_password');

	}

	function _PasswordChange()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['Ongoing_process']);

		$PowerBB->functions->AddressBar('<a href="index.php?page=usercp&index=1">' .$PowerBB->_CONF['template']['lang']['User_Control_Panel']. '</a> ' . $PowerBB->_CONF['info_row']['adress_bar_separate'] . $PowerBB->_CONF['template']['lang']['Ongoing_process']);

		//////////

		// Check if the information aren't empty
		if (empty($PowerBB->_POST['new_password']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_fill_in_all_the_information']);
		}

		//////////

		// Clean the information from white spaces (only in the begin and in the end)
		$PowerBB->_POST['new_password'] = $PowerBB->functions->CleanVariable($PowerBB->_POST['new_password'],'trim');

		//////////


		if ($PowerBB->_CONF['info_row']['confirm_on_change_pass'])
		{

       		$new_password = $PowerBB->_POST['new_password'];


		$Adress = 	$PowerBB->functions->GetForumAdress();
		$Code	=	$PowerBB->functions->RandomCode();


			$Adress	= 	$PowerBB->functions->GetForumAdress();
			$Code	=	$PowerBB->functions->RandomCode();

		$ChangeAdress = $Adress . 'index.php?page=new_password&pass_change=1&id=' . $PowerBB->_CONF['member_row']['id'] .'&code=' . $Code;
		$CancelAdress = $Adress . 'index.php?page=cancel_requests&index=1&type=1&code=' . $Code;

			$ReqArr 					= 	array();
			$ReqArr['field']			=	array();

			$ReqArr['field']['random_url'] 		= 	$Code;
			$ReqArr['field']['username'] 		= 	$PowerBB->_CONF['rows']['member_rows']['username'];
			$ReqArr['field']['request_type'] 	= 	1;

			$InsertReq = $PowerBB->request->InsertRequest($ReqArr);

			if ($InsertReq)
			{
				$UpdateArr 				= 	array();
				$UpdateArr['field']		= 	array();

				$UpdateArr['field']['new_password'] 	= 	$new_password;
				$UpdateArr['where'] 					= 	array('id',$PowerBB->_CONF['member_row']['id']);

				$UpdateNewPassword = $PowerBB->member->UpdateMember($UpdateArr);

				if ($UpdateNewPassword)
				{

                    $MsgArr 			= 	array();
					$MsgArr['where'] 	= 	array('id','1');

					$MassegeInfo = $PowerBB->message->GetMessageInfo($MsgArr);

					$MsgArr = array();
					$MsgArr['text'] 		= 	$MassegeInfo['text'];
					$MsgArr['change_url'] 	= 	$ChangeAdress;
					$MsgArr['cancel_url'] 	= 	$CancelAdress;
					$MsgArr['username']		=	$PowerBB->_CONF['member_row']['username'];
					$MsgArr['title']		=	$PowerBB->_CONF['info_row']['title'];

					$MassegeInfo['text'] = $PowerBB->message->MessageProccess($MsgArr);

					if ($PowerBB->_CONF['info_row']['mailer']=='phpmail')
					{
					$Send = $PowerBB->functions->mail($PowerBB->_CONF['rows']['member_row']['email'],$MassegeInfo['title'],$MassegeInfo['text'],$PowerBB->_CONF['info_row']['send_email']);
		            }
					elseif ($PowerBB->_CONF['info_row']['mailer']=='smtp')
					{
					$to = $PowerBB->_CONF['rows']['member_row']['email'];
					$fromname = $PowerBB->_CONF['info_row']['title'];
					$message = $MassegeInfo['text'];
					$subject = $MassegeInfo['title'];
					$from = $PowerBB->_CONF['info_row']['send_email'];

						$mail             = new PHPMailer();
						$header  = "MIME-Version: 1.0\n";
						$header .= "Content-type: text/html; charset=utf-8\n";
						$header .= "From: <$from>\n";
						$header .= "Reply-To: $from\n";

					    // HTML body
					    $body  = "";
					    $body .= "<br>";
					    $body .= $message;

					    // Plain text body (for mail clients that cannot read HTML)
					    $text_body  = $PowerBB->_CONF['template']['lang']['hello_your']."   " . $getmember_row['username'] . ", \n\n";
					    $text_body .= "\n";
					    $text_body .= $fromname;

						$mail->IsSMTP();
						$mail->SMTPAuth   = ($PowerBB->_CONF['info_row']['smtp_username'] && $PowerBB->_CONF['info_row']['smtp_password'] ? true : false);
						$mail->SMTPSecure = $PowerBB->_CONF['info_row']['smtp_secure'];
						$mail->Host = $PowerBB->_CONF['info_row']['smtp_server'];  // specify main and backup server
						$mail->Mailer   = "smtp";
						$mail->Port = $PowerBB->_CONF['info_row']['smtp_port'];
		                $mail->CharSet = "UTF-8";

						$mail->Username = $PowerBB->_CONF['info_row']['smtp_username'];  // SMTP username
						$mail->Password = $PowerBB->_CONF['info_row']['smtp_password']; // SMTP password

						$mail->From = $from;
						$mail->FromName = $fromname;
						$mail->Subject = $subject;
						$mail->Body = $body;
						$mail->AltBody = $text_body;
						$mail->WordWrap   = 50; // set word wrap

						$mail->MsgHTML($body);

						$mail->AddReplyTo($to, $PowerBB->_CONF['info_row']['title']);

						$mail->AddAddress($to,$PowerBB->_CONF['info_row']['title']);

						$mail->IsHTML(true); // send as HTML

						if(!$mail->Send()) {
				          $PowerBB->functions->error("Mailer Error: " . $mail->ErrorInfo);
						}

						$Send = $mail->Send($to, $fromname, $message, $subject, $header);
					}

						$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Password_has_been_sent_to_E-mail']);
						$PowerBB->functions->redirect('index.php?page=usercp&index=1');

				}
			}
		}
		else
		{

		   // Convert password to md5
		  $PowerBB->_POST['new_password'] = md5($PowerBB->_POST['new_password']);

			$PassArr 				= 	array();
			$PassArr['field']		=	array();
			$PassArr['field']['password'] 			= 	$PowerBB->_POST['new_password'];
			$PassArr['where'] = array('id',$PowerBB->_CONF['member_row']['id']);

			$UpdatePassword = $PowerBB->member->UpdateMember($PassArr);

			if ($UpdatePassword)
			{
				$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Updated_successfully']);
               $PowerBB->functions->redirect('index.php?page=usercp&index=1');
			}
		}
	}


	function _EmailMain()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();

		$PowerBB->template->display('usercp_control_email');

	}

	function _EmailChange()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['Ongoing_process']);

		$PowerBB->functions->AddressBar('<a href="index.php?page=usercp&index=1">' .$PowerBB->_CONF['template']['lang']['User_Control_Panel']. '</a> ' . $PowerBB->_CONF['info_row']['adress_bar_separate'] . $PowerBB->_CONF['template']['lang']['Ongoing_process']);

		$EmailArr = array();
		$EmailArr['where']	=	array('email',$PowerBB->_POST['new_email']);

		$EmailExists = $PowerBB->member->IsMember($EmailArr);

		if (empty($PowerBB->_POST['new_email']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_fill_in_all_the_information']);
		}
		if (!$PowerBB->functions->CheckEmail($PowerBB->_POST['new_email']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_enter_your_correct_email']);
		}
		if ($EmailExists)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['E-mail_is_registered_please_type_the_other']);
		}

		$PowerBB->_POST['new_email'] = $PowerBB->functions->CleanVariable($PowerBB->_POST['new_email'],'trim');

		// We will send a confirm message, The confirm message will help user protect himself from crack
		if ($PowerBB->_CONF['info_row']['confirm_on_change_mail'])
		{
			$Adress	= 	$PowerBB->functions->GetForumAdress();
			$Code	=	$PowerBB->functions->RandomCode();

			$ChangeAdress = $Adress . 'index.php?page=new_email&index=1&code=' . $Code;
			$CancelAdress = $Adress . 'index.php?page=cancel_requests&index=1&type=2&code=' . $Code;

			$ReqArr 			= 	array();
			$ReqArr['field'] 	= 	array();

			$ReqArr['field']['random_url'] 		= 	$Code;
			$ReqArr['field']['username'] 		= 	$PowerBB->_CONF['member_rows']['username'];
			$ReqArr['field']['request_type'] 	= 	2;

			$InsertReq = $PowerBB->request->InsertRequest($ReqArr);

			if ($InsertReq)
			{
				$UpdateArr 				= 	array();
				$UpdateArr['field']		=	array();
				$UpdateArr['field']['new_email'] 			= 	$PowerBB->_POST['new_email'];
				$UpdateArr['where'] = array('id',$PowerBB->_CONF['member_row']['id']);

				$UpdateNewEmail = $PowerBB->member->UpdateMember($UpdateArr);

				if ($UpdateNewEmail)
				{
                    $MsgArr 			= 	array();
					$MsgArr['where'] 	= 	array('id','2');

					$MassegeInfo = $PowerBB->message->GetMessageInfo($MsgArr);

					$MsgArr = array();
					$MsgArr['text'] 		= 	$MassegeInfo['text'];
					$MsgArr['change_url'] 	= 	$ChangeAdress;
					$MsgArr['cancel_url'] 	= 	$CancelAdress;
					$MsgArr['username']		=	$PowerBB->_CONF['member_row']['username'];
					$MsgArr['title']		=	$PowerBB->_CONF['info_row']['title'];

					$MassegeInfo['text'] = $PowerBB->message->MessageProccess($MsgArr);

					if ($PowerBB->_CONF['info_row']['mailer']=='phpmail')
					{
					$Send = $PowerBB->functions->mail($PowerBB->_CONF['rows']['member_row']['email'],$MassegeInfo['title'],$MassegeInfo['text'],$PowerBB->_CONF['info_row']['send_email']);
		            }
					elseif ($PowerBB->_CONF['info_row']['mailer']=='smtp')
					{
					$to = $PowerBB->_CONF['rows']['member_row']['email'];
					$fromname = $PowerBB->_CONF['info_row']['title'];
					$message = $MassegeInfo['text'];
					$subject = $MassegeInfo['title'];
					$from = $PowerBB->_CONF['info_row']['send_email'];

						$mail             = new PHPMailer();
						$header  = "MIME-Version: 1.0\n";
						$header .= "Content-type: text/html; charset=utf-8\n";
						$header .= "From: <$from>\n";
						$header .= "Reply-To: $from\n";

					    // HTML body
					    $body  = "";
					    $body .= "<br>";
					    $body .= $message;

					    // Plain text body (for mail clients that cannot read HTML)
					    $text_body  = $PowerBB->_CONF['template']['lang']['hello_your']."   " . $getmember_row['username'] . ", \n\n";
					    $text_body .= "\n";
					    $text_body .= $fromname;

						$mail->IsSMTP();
						$mail->SMTPAuth   = ($PowerBB->_CONF['info_row']['smtp_username'] && $PowerBB->_CONF['info_row']['smtp_password'] ? true : false);
						$mail->SMTPSecure = $PowerBB->_CONF['info_row']['smtp_secure'];
						$mail->Host = $PowerBB->_CONF['info_row']['smtp_server'];  // specify main and backup server
						$mail->Mailer   = "smtp";
						$mail->Port = $PowerBB->_CONF['info_row']['smtp_port'];
		                $mail->CharSet = "UTF-8";

						$mail->Username = $PowerBB->_CONF['info_row']['smtp_username'];  // SMTP username
						$mail->Password = $PowerBB->_CONF['info_row']['smtp_password']; // SMTP password

						$mail->From = $from;
						$mail->FromName = $fromname;
						$mail->Subject = $subject;
						$mail->Body = $body;
						$mail->AltBody = $text_body;
						$mail->WordWrap   = 50; // set word wrap

						$mail->MsgHTML($body);

						$mail->AddReplyTo($to, $PowerBB->_CONF['info_row']['title']);

						$mail->AddAddress($to,$PowerBB->_CONF['info_row']['title']);

						$mail->IsHTML(true); // send as HTML

						if(!$mail->Send()) {
				          $PowerBB->functions->error("Mailer Error: " . $mail->ErrorInfo);
						}

						$Send = $mail->Send($to, $fromname, $message, $subject, $header);
					}

						$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['has_been_sent_to_your_email']);
                       $PowerBB->functions->redirect('index.php?page=usercp&index=1');

				}
			}
		}
		// Confirm message is off, so change email direct
		else
		{
			$EmailArr 			= 	array();
			$EmailArr['field']	=	array();

			$EmailArr['field']['email'] 	= 	$PowerBB->_POST['new_email'];
			$EmailArr['where'] 				= 	array('id',$PowerBB->_CONF['member_row']['id']);

			$UpdateEmail= $PowerBB->member->UpdateMember($EmailArr);

			if ($UpdateEmail)
			{
				$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['email_was_changed_successfully']);
                $PowerBB->functions->redirect('index.php?page=usercp&amp;control=1&amp;email=1&amp;main=1');
			}
		}
	}

	function _AvatarMain()
	{
		global $PowerBB;

		// This line will include jQuery (Javascript library)
		$PowerBB->template->assign('JQUERY',true);

		$PowerBB->functions->ShowHeader();

		// Stop this feature if it's not allowed
		if (!$PowerBB->_CONF['info_row']['allow_avatar'])
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_can_not_use_this_feature']);
		}

		$PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
		$PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');

		$AvaArr 					= 	array();
		$AvaArr['proc'] 			= 	array();
		$AvaArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');
		$AvaArr['order']			=	array();
		$AvaArr['order']['field']	=	'id';
		$AvaArr['order']['type']	=	'DESC';

		// Pager setup
		$AvaArr['pager'] 				= 	array();
		$AvaArr['pager']['total']		= 	$PowerBB->avatar->GetAvatarNumber(null);
		$AvaArr['pager']['perpage'] 	= 	$PowerBB->_CONF['info_row']['avatar_perpage'];
		$AvaArr['pager']['count'] 		= 	$PowerBB->_GET['count'];
		$AvaArr['pager']['location'] 	= 	'index.php?page=usercp&amp;control=1&amp;avatar=1&amp;main=1';
		$AvaArr['pager']['var'] 		= 	'count';

		$PowerBB->_CONF['template']['while']['AvatarList'] = $PowerBB->avatar->GetAvatarList($AvaArr);
     	if ($PowerBB->avatar->GetAvatarNumber(null) > $PowerBB->_CONF['info_row']['avatar_perpage'])
		{
		$PowerBB->template->assign('pager',$PowerBB->pager->show());
		}
		$PowerBB->template->assign('count',$PowerBB->_GET['count']);

		$PowerBB->template->display('usercp_control_avatar');

	}

	function _AvatarChange()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['execution_Process_Update']);

		$PowerBB->functions->AddressBar('<a href="index.php?page=usercp&index=1">' .$PowerBB->_CONF['template']['lang']['User_Control_Panel']. '</a> ' . $PowerBB->_CONF['info_row']['adress_bar_separate'] . $PowerBB->_CONF['template']['lang']['execution_Process_Update']);

		$allowed_array = array('.jpg','.gif','.png');

		$UpdateArr 					= 	array();
		$UpdateArr['field']			=	array();

		$UpdateArr['where']					= 	array('id',$PowerBB->_CONF['member_row']['id']);
		$UpdateArr['field']['avater_path'] 	= 	'';

		if ($PowerBB->_POST['options'] == 'no')
		{

		$MemberArr 			= 	array();
		$MemberArr['where'] 	= 	array('username',$PowerBB->_CONF['rows']['member_row']['username']);

		$MemberInfo = $PowerBB->member->GetMemberInfo($MemberArr);

	      if (file_exists($MemberInfo['avater_path']))
	      {
		   $del = @unlink($MemberInfo['avater_path']);
          }

			$PowerBB->_CONF['param']['UpdateArr']['path'] = '';
		}
		elseif ($PowerBB->_POST['options'] == 'list')
		{
			if (empty($PowerBB->_POST['avatar_list']))
			{
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_select_the_desired_image']);
			}

			$UpdateArr['field']['avater_path'] = $PowerBB->_POST['avatar_list'];
		}
		elseif ($PowerBB->_POST['options'] == 'site')
		{
			if (empty($PowerBB->_POST['avatar'])
				or $PowerBB->_POST['avatar'] == 'http://')
			{
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_select_the_desired_image']);
			}
			elseif (!$PowerBB->functions->IsSite($PowerBB->_POST['avatar']))
			{
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['The_site_that_you_typed_is_incorrect']);
			}

			$extension = $PowerBB->functions->GetURLExtension($PowerBB->_POST['avatar']);

			if (!in_array($extension,$allowed_array))
			{
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Along_the_image_is_not_permitted']);
			}

			$size = @getimagesize($PowerBB->_POST['avatar']);

			if ($size[0] > $PowerBB->_CONF['info_row']['max_avatar_width'])
			{
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['width_the_image_is_not_acceptable']);
			}

			if ($size[1] > $PowerBB->_CONF['info_row']['max_avatar_height'])
			{
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['height_the_image_is_not_acceptable']);
			}

			$UpdateArr['field']['avater_path'] = $PowerBB->_POST['avatar'];
		}
		elseif ($PowerBB->_POST['options'] == 'upload')
		{
			$pic = $PowerBB->_FILES['upload']['tmp_name'];

			$size = @getimagesize($pic);

			if ($size[0] > $PowerBB->_CONF['info_row']['max_avatar_width'])
			{
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['width_the_image_is_not_acceptable']);
			}

			if ($size[1] > $PowerBB->_CONF['info_row']['max_avatar_height'])
			{
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['height_the_image_is_not_acceptable']);
			}


     		if (!empty($PowerBB->_FILES['upload']['name']))
     		{
     			//////////

              if ( stristr($PowerBB->_FILES['upload']['name'],'.php') )
             {
              $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Can_you_raise_file_extension']);
			}
			if ( stristr($PowerBB->_FILES['upload']['name'],'.php3') )
             {
              $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Can_you_raise_file_extension']);
			}
			if ( stristr($PowerBB->_FILES['upload']['name'],'.phtml') )
             {
              $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Can_you_raise_file_extension']);
			}
			if ( stristr($PowerBB->_FILES['upload']['name'],'.pl') )
             {
              $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Can_you_raise_file_extension']);
			}
			if ( stristr($PowerBB->_FILES['upload']['name'],'.cgi') )
             {
              $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Can_you_raise_file_extension']);
			}
			if ( stristr($PowerBB->_FILES['upload']['name'],'.asp') )
             {
             $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Can_you_raise_file_extension']);
			}
			if ( stristr($PowerBB->_FILES['upload']['name'],'.3gp') )
             {
              $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Can_you_raise_file_extension']);
			}

     			// Get the extension of the file
     			$ext = $PowerBB->functions->GetFileExtension($PowerBB->_FILES['upload']['name']);

     			// Bad try!
     			if ($ext == 'MULTIEXTENSION'
     				or !$ext)
     			{
     			}
     			else
     			{
	     			// Convert the extension to small case
    	 			$ext = strtolower($ext);

    	 			// The extension is not allowed
    	 			if (!array($ext,$allowed_array))
					{
						$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Along_the_image_is_not_permitted']);
					}
    	 			else
    	 			{
    	 				// Set the name of the file

    	 				$filename = $PowerBB->_FILES['upload']['name'];

    	 				// There is a file which has same name, so change the name of the new file
    	 				if (file_exists($PowerBB->_CONF['info_row']['download_path'] . '/avatar/' . $filename))
    	 				{
    	 					$filename = $PowerBB->_FILES['files']['upload'] . '-' . $PowerBB->functions->RandomCode();
    	 				}

    	 				//////////

    	 				// Copy the file to download dirctory
    	 				$copy = move_uploaded_file($PowerBB->_FILES['upload']['tmp_name'],$PowerBB->_CONF['info_row']['download_path'] . '/avatar/' . $filename);

    	 				// Success
    	 				if ($copy)
    	 				{
    	 					// Change avatar to the new one
    	 					$UpdateArr['field']['avater_path'] = $PowerBB->_CONF['info_row']['download_path'] . '/avatar/' . $filename;
    	 				}

    	 				//////////
    	 			}
    	 		}
    	 	}
    	}
		else
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Please_wait']);
             $PowerBB->functions->redirect('index.php?page=usercp&control=1&avatar=1&main=1',2);
			$PowerBB->functions->stop();
		}

		$UpdateAvatar = $PowerBB->member->UpdateMember($UpdateArr);

		if ($UpdateAvatar)
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Updated_successfully']);
           $PowerBB->functions->redirect('index.php?page=usercp&control=1&avatar=1&main=1',2);
		}
	}

	function _ReplyListMain()
	{
		//TODO later ...
	}

	function _SubjectListMain()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();

		$PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
		$PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');

      	// Get the Member Subjects num
      	$writer = $PowerBB->_CONF['rows']['member_row']['username'];
        $GetMemberSubjectNum = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['subject'] . " WHERE writer = '$writer'"));
       	$PowerBB->template->assign('member_subject_num',$GetMemberSubjectNum );

       // Get the Member Subjects information
		$SubjectArr 							= 	array();
		$SubjectArr['where'] 					= 	array();

		$SubjectArr['where'][0] 				= 	array();
		$SubjectArr['where'][0]['name'] 		= 	'writer';
		$SubjectArr['where'][0]['oper'] 		= 	'=';
		$SubjectArr['where'][0]['value'] 		= 	$PowerBB->_CONF['rows']['member_row']['username'];

	   // Pager setup
		$SubjectArr['pager'] 				= 	array();
		$SubjectArr['pager']['total']		= 	$GetMemberSubjectNum;
		$SubjectArr['pager']['perpage'] 	= 	$PowerBB->_CONF['info_row']['subject_perpage'];
		$SubjectArr['pager']['count'] 		= 	$PowerBB->_GET['count'];
		$SubjectArr['pager']['location'] 	= 	'index.php?page=usercp&options=1&subject=1&main=1';
		$SubjectArr['pager']['var'] 		= 	'count';

		$SubjectArr['order'] 					=	 array();
		$SubjectArr['order']['field'] 			= 	'id';
		$SubjectArr['order']['type'] 			= 	'DESC';

		$SubjectArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
		$SubjectArr['proc']['write_time'] 			= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);


		$PowerBB->_CONF['template']['while']['MemberSubjects'] = $PowerBB->subject->GetSubjectList($SubjectArr);
		$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['while']['MemberSubjects'],'html');

            if ($GetMemberSubjectNum > $PowerBB->_CONF['info_row']['subject_perpage'])
	        {
			$PowerBB->template->assign('pager',$PowerBB->pager->show());
	         }

		$PowerBB->template->display('usercp_options_subjects');

	}


	function _AttachListMain()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();

		$PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
		$PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');

      	// Get the Member attachments num
      	$u_id = $PowerBB->_CONF['member_row']['id'];
        $GetMemberAttachmentNum = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['attach'] . " WHERE u_id = '$u_id'"));
       	$PowerBB->template->assign('member_Attachment_num',$GetMemberAttachmentNum );

		// Get the attachment information

			$AttachArr 							= 	array();
			$AttachArr['where']					= 	array();

			$AttachArr['where'][0] 				=	array();
			$AttachArr['where'][0]['name'] 		=	'u_id';
			$AttachArr['where'][0]['oper'] 		=	'=';
			$AttachArr['where'][0]['value'] 	=	$PowerBB->_CONF['member_row']['id'];

		   // Pager setup
			$AttachArr['pager'] 				= 	array();
			$AttachArr['pager']['total']		= 	$GetMemberAttachmentNum;
			$AttachArr['pager']['perpage'] 	= 	$PowerBB->_CONF['info_row']['subject_perpage'];
			$AttachArr['pager']['count'] 		= 	$PowerBB->_GET['count'];
			$AttachArr['pager']['location'] 	= 	'index.php?page=usercp&options=1&attach=1&main=1';
			$AttachArr['pager']['var'] 		= 	'count';

			$AttachArr['order'] 					=	 array();
			$AttachArr['order']['field'] 			= 	'id';
			$AttachArr['order']['type'] 			= 	'DESC';


			$PowerBB->_CONF['template']['while']['MemberAttachList'] = $PowerBB->attach->GetAttachList($AttachArr);


				if ($PowerBB->_CONF['template']['while']['MemberAttachList'] == false)
				{
					$PowerBB->template->assign('member_attach_nm',true);
				}
				else
				{
					$PowerBB->template->assign('member_attach_nm',false);
				}


		$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['while']['MemberAttachList'],'html');

            if ($GetMemberAttachmentNum > $PowerBB->_CONF['info_row']['subject_perpage'])
	        {
			$PowerBB->template->assign('pager',$PowerBB->pager->show());
	         }

        $PowerBB->template->assign('table_subject',$PowerBB->table['subject']);
        $PowerBB->template->assign('table_reply',$PowerBB->table['reply']);
		$PowerBB->template->display('usercp_options_attach');

	}

	function _EmailedListMain()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();


		$PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
		$PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');

      		// Get the Emailed num
      	$user_id = $PowerBB->_CONF['member_row']['id'];
        $GetEmailedNum = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['emailed'] . " WHERE user_id = '$user_id'"));
       	$PowerBB->template->assign('emailed_num',$GetEmailedNum );
		// Get the Emailed information
			$EmailedArr 							= 	array();
			$EmailedArr['where']					= 	array();

			$EmailedArr['where'][0] 				=	array();
			$EmailedArr['where'][0]['name'] 		=	'user_id';
			$EmailedArr['where'][0]['oper'] 		=	'=';
			$EmailedArr['where'][0]['value'] 	=	$PowerBB->_CONF['member_row']['id'];

		   // Pager setup
			$EmailedArr['pager'] 				= 	array();
			$EmailedArr['pager']['total']		= 	$GetEmailedNum;
			$EmailedArr['pager']['perpage'] 	= 	$PowerBB->_CONF['info_row']['subject_perpage'];
			$EmailedArr['pager']['count'] 		= 	$PowerBB->_GET['count'];
			$EmailedArr['pager']['location'] 	= 	'index.php?page=usercp&options=1&emailed=1&main=1';
			$EmailedArr['pager']['var'] 		= 	'count';

			$EmailedArr['order'] 					=	 array();
			$EmailedArr['order']['field'] 			= 	'id';
			$EmailedArr['order']['type'] 			= 	'DESC';


			$PowerBB->_CONF['template']['while']['MemberEmailedList'] = $PowerBB->emailed->GetEmailedList($EmailedArr);

				if ($PowerBB->_CONF['template']['while']['MemberEmailedList'] == false)
				{
					$PowerBB->template->assign('show_emailed',true);
				}
				else
				{
					$PowerBB->template->assign('show_emailed',false);
				}


		$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['while']['MemberEmailedList'],'html');


            if ($GetEmailedNum > $PowerBB->_CONF['info_row']['subject_perpage'])
	        {
			$PowerBB->template->assign('pager',$PowerBB->pager->show());
	        }


		$PowerBB->template->display('usercp_options_emailed');

	}

		/**
	 * add Friends Start
	 */
	function _FriendsAdd()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();



       if (empty($PowerBB->_POST['username_friend']) && empty($PowerBB->_GET['username_friend']))
       {
          $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_fill_in_all_the_information']);
       }
       if (empty($PowerBB->_POST['username_friend']) && !empty($PowerBB->_GET['username_friend']))
       {
          $PowerBB->_POST['username_friend'] = $PowerBB->_GET['username_friend'];
       }

 		$PowerBB->functions->CleanVariable($PowerBB->_POST['username_friend'],'html');

		if (!$PowerBB->member->IsMember(array('where' => array('username',$PowerBB->_POST['username_friend']))))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Member_you_want_does_not_exist']);
		}

		$MemberArr 			= 	array();
		$MemberArr['where'] 	= 	array('username',$PowerBB->_POST['username_friend']);

		$MemberInfo = $PowerBB->member->GetMemberInfo($MemberArr);

		if ($PowerBB->_POST['username_friend'] == $PowerBB->_CONF['member_row']['username'])
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Can_not_be_friends_with_yourself']);
		}


		  $username_friendInfo = $PowerBB->_POST['username_friend'];
		  $username_member_row = $PowerBB->_CONF['member_row']['username'];

		  $sql_friendInfo1 = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['friends'] . " WHERE username = '$username_member_row' ");

	       while ($getSection_row1 = $PowerBB->DB->sql_fetch_array($sql_friendInfo1))
	      {
			if ($username_friendInfo == $getSection_row1['username_friend'])
			{
				$PowerBB->functions->error($PowerBB->_POST['username_friend'].$PowerBB->_CONF['template']['lang']['thess_friend_adding_befor']);
			}

          }
      /*
		  $sql_friendInfo2 = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['friends'] . " WHERE username = '$username_friendInfo' ");

	       while ($getSection_row2 = $PowerBB->DB->sql_fetch_array($sql_friendInfo2))
	      {
			if ($PowerBB->_POST['username_friend'] == $getSection_row2['username'])
			{
				$PowerBB->functions->error($PowerBB->_POST['username_friend'].$PowerBB->_CONF['template']['lang']['thess_friend_adding_befor']);
			}

          }

         */
			$FriendsArr 			= 	array();
			$FriendsArr['field']	=	array();

			$FriendsArr['field']['username']                = 	$PowerBB->_CONF['member_row']['username'];
			$FriendsArr['field']['username_friend'] 		= 	$PowerBB->_POST['username_friend'];
			$FriendsArr['field']['userid_friend'] 		    = 	$MemberInfo['id'];
			$FriendsArr['field']['approval'] 	    	    = 	'0';

			$insert = $PowerBB->friends->InsertFriends($FriendsArr);

			if ($insert)
			{
	          $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Friendship_request_has_been_sent_successfully']);
               $PowerBB->functions->redirect('index.php?page=usercp&amp;options=1&amp;friends=1&amp;main=1');
			}

	}

	function _FriendsMain()
	{
		global $PowerBB;
		$PowerBB->functions->ShowHeader();


        // show Friends List
		$FriendsArr 					= 	array();
		$FriendsArr['order']			=	array();
		$FriendsArr['order']['field']	=	'id';
		$FriendsArr['order']['type']	=	'DESC';
		$FriendsArr['proc'] 			= 	array();
		$FriendsArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');

		$FriendsArr['where'] 				= 	array();
		$FriendsArr['where'][0] 			= 	array();
		$FriendsArr['where'][0]['name'] 	=  'username';
		$FriendsArr['where'][0]['oper']		=  '=';
		$FriendsArr['where'][0]['value']    =  $PowerBB->_CONF['member_row']['username'];

		$PowerBB->_CONF['template']['while']['FriendsList'] = $PowerBB->friends->GetFriendsList($FriendsArr);

		if ($PowerBB->_CONF['template']['while']['FriendsList'] == false)
		{
			$PowerBB->template->assign('No_Friends',true);
		}
     	else
		{
			$PowerBB->template->assign('No_Friends',false);
		}
		// show approval Friends List
		$FriendsApprovalArrr 					= 	array();
		$FriendsApprovalArrr['order']			=	array();
		$FriendsApprovalArrr['order']['field']	=	'id';
		$FriendsApprovalArrr['order']['type']	=	'DESC';
		$FriendsApprovalArrr['proc'] 			= 	array();
		$FriendsApprovalArrr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');

		$FriendsApprovalArrr['where'] 				= 	array();
		$FriendsApprovalArrr['where'][0] 			= 	array();
		$FriendsApprovalArrr['where'][0]['name'] 	=  'username_friend';
		$FriendsApprovalArrr['where'][0]['oper']		=  '=';
		$FriendsApprovalArrr['where'][0]['value']    =  $PowerBB->_CONF['member_row']['username'];

		$FriendsApprovalArrr['where'][1] 			= 	array();
		$FriendsApprovalArrr['where'][1]['con']		=	'AND';
		$FriendsApprovalArrr['where'][1]['name'] 	= 	'approval';
		$FriendsApprovalArrr['where'][1]['oper'] 	= 	'=';
		$FriendsApprovalArrr['where'][1]['value'] 	= 	'0';

		$PowerBB->_CONF['template']['while']['FriendsApprovalList'] = $PowerBB->friends->GetFriendsList($FriendsApprovalArrr);

		if ($PowerBB->_CONF['template']['while']['FriendsApprovalList'] == false)
		{
			$PowerBB->template->assign('No_Approval_Friends',true);
		}
		else
		{
			$PowerBB->template->assign('No_Approval_Friends',false);
		}

		$PowerBB->template->display('friends_main');
	}


	function _ApprovalFriendStart()
	{
		global $PowerBB;
		$PowerBB->functions->ShowHeader();

			if (empty($PowerBB->_GET['id']))
			{
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Friendship_request_is_required_does_not_exist']);
			}

		$FriendsArr 			= 	array();
		$FriendsArr['field']	=	array();

		$FriendsArr['field']['approval'] 	    	    = 	'1';
		$FriendsArr['where'] 				            = 	array('id',$PowerBB->_GET['id']);

		$update = $PowerBB->friends->UpdateFriends($FriendsArr);

		if ($update)
		{

			$Memberfriend1Arr 			= 	array();
		    $Memberfriend1Arr['where'] 	= 	array('username',$PowerBB->_GET['username']);

		    $Memberfriend1Info = $PowerBB->member->GetMemberInfo($Memberfriend1Arr);

			$FriendsArr 			= 	array();
			$FriendsArr['field']	=	array();

			$FriendsArr['field']['username']                = 	$PowerBB->_CONF['member_row']['username'];
			$FriendsArr['field']['username_friend'] 		= 	$PowerBB->_GET['username'];
			$FriendsArr['field']['userid_friend'] 		    = 	$Memberfriend1Info['id'];
			$FriendsArr['field']['approval'] 	    	    = 	'1';

			$insert = $PowerBB->friends->InsertFriends($FriendsArr);

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Has_been_accepted_friendship_request_specific']);
			$PowerBB->functions->redirect('index.php?page=usercp&amp;options=1&amp;friends=1&amp;main=1');
		}
	}

	function _FriendsDel()
	{
		global $PowerBB;
		$PowerBB->functions->ShowHeader();

			if (empty($PowerBB->_GET['id']))
			{
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Friendship_request_is_required_does_not_exist']);
			}

		$MemberFriendArr 			= 	array();
		$MemberFriendArr['where'] 	= 	array('id',$PowerBB->_GET['id']);

		$MemberFriendInfo = $PowerBB->friends->GetFriendsInfo($MemberFriendArr);

		$username_friend = $MemberFriendInfo['username_friend'];
		$username = $MemberFriendInfo['username'];

		 $FriendInfo = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['friends'] . " WHERE username = '$username_friend' and username_friend = '$username' ");
         while ($FriendInfo_row = $PowerBB->DB->sql_fetch_array($FriendInfo))
         {
			$Del1Arr 			= 	array();
			$Del1Arr['where'] 	= 	array('id',$FriendInfo_row['id']);

			$del1 = $PowerBB->friends->DeleteFriends($Del1Arr);
         }

			$DelArr 			= 	array();
			$DelArr['where'] 	= 	array('id',$PowerBB->_GET['id']);

			$del = $PowerBB->friends->DeleteFriends($DelArr);

				$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['friends_delet_successfully']);
				$PowerBB->functions->redirect('index.php?page=usercp&amp;options=1&amp;friends=1&amp;main=1');

	}

   function _DeleteAttachments()
	{
		global $PowerBB;
		$PowerBB->functions->ShowHeader();


		if (empty($PowerBB->_POST['check']))
		{
			$PowerBB->functions->error_no_foot($PowerBB->_CONF['template']['lang']['You_do_not_select_any_attach']);
			$PowerBB->functions->GetFooter();

		}


       $Attach_D = $PowerBB->_POST['check'];


       foreach ($Attach_D as $DeleteAttach)
       {

			   $GetAttachArr 					= 	array();
			   $GetAttachArr['where'] 			= 	array('id',intval($DeleteAttach));
			   $Attachinfo = $PowerBB->attach->GetAttachInfo($GetAttachArr);

		      if (file_exists($Attachinfo['filepath']))
		      {
			   $del = unlink($Attachinfo['filepath']);
              }


				// Delete attachment from database
				$DelAttachArr 							= 	array();
				$DelAttachArr['name'] 	        		=  	'id';
		        $DelAttachArr['where'] 		    	= 	array('id',intval($DeleteAttach));

				$DeleteAttach = $PowerBB->attach->DeleteAttach($DelAttachArr);

       }


                $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['deleted_Attachments_successfully']);
				$PowerBB->functions->redirect('index.php?page=usercp&amp;options=1&amp;attach=1&amp;main=1');
	}

	function _ReputationListMain()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();

		$PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
		$PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');

      	// Get the Member Subjects num
      	$username = $PowerBB->_CONF['rows']['member_row']['username'];
        $GetMemberReputationNum = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['reputation'] . " WHERE username = '$username'"));
       	$PowerBB->template->assign('member_reputation_num',$GetMemberReputationNum );


		/** Get the Reputation information **/
		$ReputArr 							= 	array();
		$ReputArr['where'] 					= 	array();

		$ReputArr['where'][0] 				= 	array();
		$ReputArr['where'][0]['name'] 		= 	'username';
		$ReputArr['where'][0]['oper'] 		= 	'=';
		$ReputArr['where'][0]['value'] 		= 	$PowerBB->_CONF['rows']['member_row']['username'];

		$ReputArr['order'] 					=	 array();
		$ReputArr['order']['field'] 			= 	'id';
		$ReputArr['order']['type'] 			= 	'DESC';
	   // Pager setup
		$ReputArr['pager'] 				= 	array();
		$ReputArr['pager']['total']		= 	$GetMemberReputationNum;
		$ReputArr['pager']['perpage'] 	= 	$PowerBB->_CONF['info_row']['subject_perpage'];
		$ReputArr['pager']['count'] 		= 	$PowerBB->_GET['count'];
		$ReputArr['pager']['location'] 	= 	'index.php?page=usercp&amp;options=1&amp;reputation=1&amp;main=1';
		$ReputArr['pager']['var'] 		= 	'count';

		$ReputArr['proc'] 						= 	array();
		$ReputArr['proc']['*'] 					= 	array('method'=>'clean','param'=>'html');
		$ReputArr['proc']['reputationdate'] 	= 	array('method'=>'date','store'=>'reputationdate','type'=>$PowerBB->_CONF['info_row']['timesystem']);

       $PowerBB->_CONF['template']['while']['MemberReputation'] = $PowerBB->reputation->GetReputationList($ReputArr);
       $this->ReputationInfo = $PowerBB->reputation->GetReputationInfo($ReputArr);

            if ($GetMemberReputationNum > $PowerBB->_CONF['info_row']['subject_perpage'])
	        {
			  $PowerBB->template->assign('pager',$PowerBB->pager->show());
	         }

        // If Reputation  by reply Get subject_id for thes reply
		$ReplyArr = array();
		$ReplyArr['where'] = array('id',$this->ReputationInfo['reply_id']);

		$ReplyInfo = $PowerBB->reply->GetReplyInfo($ReplyArr);

		$PowerBB->template->assign('subject_id',$ReplyInfo['subject_id']);

		if ($PowerBB->_CONF['template']['while']['MemberReputation'] == false)
		{
			$PowerBB->template->assign('No_Reputation',true);
		}
		else
		{
			$PowerBB->template->assign('No_Reputation',false);
		}

         // Update reputation read
		 $UpdateArr 				= 	array();
		 $UpdateArr['field']		=	array();

		 $UpdateArr['field']['reputationread'] 		= 	'0';
	     $UpdateArr['where'] 						= 	array('username',$PowerBB->_CONF['rows']['member_row']['username']);

		 $update = $PowerBB->reputation->UpdateReputation($UpdateArr);
		$PowerBB->template->display('usercp_reputations');

	}

	    /**
	 * Get the Jump Sections List
	 */
	function _GetJumpSectionsList()
    {
		global $PowerBB;

		//////////

		$SecArr 						= 	array();
		$SecArr['get_from']				=	'db';

		$SecArr['proc'] 				= 	array();
		$SecArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');

		$SecArr['order']				=	array();
		$SecArr['order']['field']		=	'sort';
		$SecArr['order']['type']		=	'ASC';

		$SecArr['where']				=	array();
		$SecArr['where'][0]['name']		= 	'parent';
		$SecArr['where'][0]['oper']		= 	'=';
		$SecArr['where'][0]['value']	= 	'0';

		// Get main sections
		$catsy = $PowerBB->section->GetSectionsList($SecArr);

		// We will use forumsy_list to store list of forums which will view in main page
		$PowerBB->_CONF['template']['foreach']['forumsy_list'] = array();

		// Loop to read the information of main sections
		foreach ($catsy as $caty)
		{
			// Get the groups information to know view this section or not
			$groups = unserialize(base64_decode($caty['sectiongroup_cache']));

			if (is_array($groups[$PowerBB->_CONF['group_info']['id']]))
			{
				if ($groups[$PowerBB->_CONF['group_info']['id']]['view_section'])
				{
					$PowerBB->_CONF['template']['foreach']['forumsy_list'][$caty['id'] . '_m'] = $caty;
				}
			}

			unset($groups);

			if (!empty($caty['forums_cache']))
			{
				$forumsy = unserialize(base64_decode($caty['forums_cache']));

				foreach ($forumsy as $forumy)
				{
					if (is_array($forumy['groups'][$PowerBB->_CONF['group_info']['id']]))
					{
						if ($forumy['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
						{
							//////////

							// Get the first-level sub forums as a _link_ and store it in $forumy['sub']

							$forumy['is_sub'] 	= 	0;
							$forumy['sub']		=	'';

							if (!empty($forumy['forums_cache']))
							{
								$subsy = unserialize(base64_decode($forumy['forums_cache']));

								if (is_array($subsy))
								{
									foreach ($subsy as $suby)
									{
										if (is_array($suby['groups'][$PowerBB->_CONF['group_info']['id']]))
										{
											if ($suby['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
											{
												if (!$forumy['is_sub'])
												{
													$forumy['is_sub'] = 1;
												}

												$forumy['sub'] .= ('<option value="index.php?page=forum&amp;show=1&amp;id=' . $suby['id'] . '">---'  . $suby['title'] . '</option>');
											}
										}
									}
								}
							}


							$PowerBB->_CONF['template']['foreach']['forumsy_list'][$forumy['id'] . '_f'] = $forumy;
						}
					} // end if is_array
				} // end foreach ($forumsy)
			} // end !empty($forums_cache)
		} // end foreach ($catsy)

		//////////
   }
}

?>
