<?php
(!defined('IN_PowerBB')) ? die() : '';
include('common.php');
define('CLASS_NAME','PowerBBTopicArchiveMOD');
class PowerBBTopicArchiveMOD
{
	var $Info;
	var $SectionInfo;
	var $SectionGroup;
	var $RInfo;
	var $x = 0;
	var $reply_number = 0;

	/**
	 * The main function , will require from kernel file "index.php"
	 */
	function run()
	{
		global $PowerBB;


		// Show the topic
		if ($PowerBB->_GET['show'])
		{
			$this->_ShowTopic();
		}
		else
		{
			$PowerBB->functions->error('المسار المتبع غير صحيح !');
		}

		// Can live without footer :) ?
	}

	function _ShowTopic()
	{
		global $PowerBB;

		// Get subject information
		$this->__GetSubject();

		// Get subject's section information
		$this->__GetSection();

		// Get subject's writer information
		$this->__GetWriterInfo();


		// Make subject text as a nice text
		$this->__SubjectTextFormat();

		// Show subject
		$this->__SubjectEnd();

		// Get the replies
		$this->__GetReply();

		$this->__PageEnd();

	}

	function __GetSubject()
	{
		global $PowerBB;

		//////////

		// Clean id from any string, that will protect us
		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		// If the id is empty, so stop the page
		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error('المعذره المسار المتبع غير صحيح');
		}

		//////////

		// Get the subject and the subject's writer information
		$this->Info = $PowerBB->subject->GetSubjectWriterInfo(array('id'	=>	$PowerBB->_GET['id']));

		// There is no subject, so show error message
		if (!$this->Info)
		{
			$PowerBB->functions->error('المعذره، الموضوع المطلوب غير موجود');
		}

		// The ID of subject
		$this->Info['subject_id'] = $PowerBB->_GET['id'];

		//////////

		// hmmmmmmm , this subject deleted , so the members and visitor can't show it
		if ($this->Info['delete_topic']
			and !$PowerBB->_CONF['group_info']['admincp_allow'])
		{
			$PowerBB->functions->error('الموضوع المطلوب منقول إلى سلّة المحذوفات');
		}

		//////////

		// Kill XSS
		$PowerBB->functions->CleanVariable($this->Info,'html');
		// Kill SQL Injection
		$PowerBB->functions->CleanVariable($this->Info,'sql');

		//////////

		// Send subject id to template engine
		$PowerBB->template->assign('subject_id',$PowerBB->_GET['id']);
		$PowerBB->template->assign('section_id',$this->Info['section']);

		//////////

		// Where is the member now?
		if ($PowerBB->_CONF['member_permission'])
     	{
     		$UpdateOnline 			= 	array();
			$UpdateOnline['field']	=	array();

			$UpdateOnline['field']['user_location']		=	$PowerBB->_CONF['template']['lang']['Seen_the_topic_archive'] .' '. $this->Info['title'];
			$UpdateOnline['where']						=	array('username',$PowerBB->_CONF['member_row']['username']);

			$update = $PowerBB->online->UpdateOnline($UpdateOnline);
     	}

     	//////////
	}

	function __GetSection()
	{
		global $PowerBB;

		/** Get the section information **/
		$SecArr 			= 	array();
		$SecArr['where'] 	= 	array('id',$this->Info['section']);

		$this->SectionInfo = $PowerBB->section->GetSectionInfo($SecArr);

		// Kill XSS
		$PowerBB->functions->CleanVariable($this->SectionInfo,'html');
		// Kill SQL Injection
		$PowerBB->functions->CleanVariable($this->SectionInfo,'sql');
		/** **/

		$PowerBB->template->assign('section_info',$this->SectionInfo);
	}

	function __ModeratorCheck()
	{
		global $PowerBB;

		$Mod = $PowerBB->functions->ModeratorCheck($PowerBB->_GET['id']);

		$PowerBB->template->assign('Mod',$Mod);
	}


	function __CheckSystem()
	{
		global $PowerBB;


		// We have password in the subject's section , so check the password
		if (!empty($this->SectionInfo['section_password'])
			and !$PowerBB->_CONF['rows']['group_info']['admincp_allow'])
		{
			// The visitor don't give me password , so require it
     		if (empty($PowerBB->_GET['password']))
        	{
      			$PowerBB->template->display('forum_password');
      			$PowerBB->functions->stop();
     		}
     		// The visitor give me password , so check
     		elseif (!empty($PowerBB->_GET['password']))
     		{
     			$PassArr = array();

     			// Section id
     			$PassArr['id'] 		= $this->SectionInfo['id'];

     			// The password to check
     			$PassArr['password'] 	= base64_decode($PowerBB->_GET['password']);

     			$IsTruePassword = $PowerBB->section->CheckPassword($PassArr);

     			// Stop ! it's don't true password
     			if (!$IsTruePassword)
     			{
     				$PowerBB->functions->error('المعذره .. كلمة المرور غير صحيحه');
     			}

     			$PowerBB->_CONF['template']['password'] = '&amp;password=' . $PowerBB->_GET['password'];
     		}
     	}
	}

	function __GetWriterInfo()
	{
		global $PowerBB;

		// Make register date in nice format to show it
		if (is_numeric($this->Info['register_date']))
		{
			$this->Info['register_date'] = $PowerBB->functions->date($this->Info['register_date']);
		}

		// Make writer gender as readable text
		$this->Info['user_gender'] 	= 	str_replace('m','ذكر',$this->Info['user_gender']);
		$this->Info['user_gender'] 	= 	str_replace('f','انثى',$this->Info['user_gender']);

		// Is writer online ?
		$CheckOnline = ($this->Info['logged'] < $PowerBB->_CONF['timeout']) ? false : true;

		// If the member is online , so store that in status variable
		($CheckOnline) ? $PowerBB->template->assign('status',"<font class='online'>متصل</font>") : $PowerBB->template->assign('status',"<font class='offline'>غير متصل</font>");

		$PowerBB->Powerparse->replace_smiles($this->Info['away_msg']);

		if (empty($this->Info['username_style_cache']))
		{
			$this->Info['display_username'] = $this->Info['username'];
		}
		else
		{
			$this->Info['display_username'] = $this->Info['username_style_cache'];

			$this->Info['display_username'] = $PowerBB->functions->CleanVariable($this->Info['display_username'],'unhtml');
		}
	}


	function __SubjectTextFormat()
	{
		global $PowerBB;

		// If the PowerCode is allow , so use it :)
		if ($this->SectionInfo['use_power_code_allow'])
		{
			$this->Info['text'] = $PowerBB->Powerparse->replace($this->Info['text']);
		}
		// The PowerCode isn't allow , don't use it :(
		else
		{
			$this->Info['text'] = nl2br($this->Info['text']);
		}

		// Convert smiles in subject to nice images :)
		$PowerBB->Powerparse->replace_smiles($this->Info['text']);

				// feltr Subject Text
		$this->Info['text'] = str_ireplace('{39}',"'",$this->Info['text']);
        $this->Info['text'] = str_ireplace('cookie','**',$this->Info['text']);
        $censorwords = preg_split('#[ \r\n\t]+#', $PowerBB->_CONF['info_row']['censorwords'], -1, PREG_SPLIT_NO_EMPTY);
        $this->Info['text'] = str_ireplace($censorwords,'**', $this->Info['text']);


		$this->Info['text'] = str_replace('&amp;','&',$this->Info['text']);
	}

   function __SubjectEnd()
	{
		global $PowerBB;

        // If the member isn't the writer , so register a new visit for the subject
		$SubjectArr = array();
		$SubjectArr['where'] = array('id',$PowerBB->_GET['id']);

		$SubjectInfov = $PowerBB->subject->GetSubjectInfo($SubjectArr);

		$SubjectInfov['visitor'] +=1;
        $visitor = $SubjectInfov['visitor'];

		$Subjectid = $PowerBB->_GET['id'];
			if  ($PowerBB->_CONF['member_row']['username'] == $SubjectInfov['writer'])
		   {
              // Does not do anything
		   }
          else
          {
		     $update_visitor = $PowerBB->DB->sql_query("UPDATE " . $PowerBB->table['subject'] . " SET visitor= '$visitor' WHERE id='$Subjectid'");

          }

         ////////


		$topic_date = $PowerBB->functions->date($this->Info['native_write_time']);
		$topic_time = $PowerBB->functions->time($this->Info['native_write_time']);

		$this->Info['native_write_time'] = $topic_date . ' ; ' . $topic_time;

		// Finally $this->Info to templates
		$PowerBB->template->assign('Info',$this->Info);

		// Show subject
		$PowerBB->template->display('archive_subject');
           // show Guest Reply
	       $subject_Info_id = $PowerBB->_GET['id'];
	       $ReplyGuestInfo = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['reply'] . " WHERE subject_id = '$subject_Info_id' AND delete_topic<>1 ORDER BY write_time ASC");
	       while ($ReplyGuestInforow = $PowerBB->DB->sql_fetch_array($ReplyGuestInfo))
		      {
		        if ($ReplyGuestInforow['writer'] == 'Guest')
				{

			       $Member_Info_writer = $ReplyGuestInforow['writer'];
			       $ReplyMemberInfo = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['member'] . " WHERE username = '$Member_Info_writer' ORDER BY id ASC");
			       while ($MemberInfo = $PowerBB->DB->sql_fetch_array($ReplyMemberInfo))
				      {
			            $PowerBB->template->assign('Info',$MemberInfo);


			          }


						// If the PowerCode is allow , so use it :)
						if ($this->SectionInfo['use_power_code_allow'])
						{
							$ReplyGuestInforow['text'] = $PowerBB->Powerparse->replace($ReplyGuestInforow['text']);
						}
						// The PowerCode isn't allow , don't use it :(
						else
						{
							$ReplyGuestInforow['text'] = nl2br($ReplyGuestInforow['text']);
						}

					 $PowerBB->Powerparse->replace_smiles($ReplyGuestInforow['text']);


			         // feltr guest Reply Text
			          $ReplyGuestInforow['text'] = str_ireplace('[guest_name]',' <br /> <br />[guest_name]',$ReplyGuestInforow['text']);
				      $ReplyGuestInforow['text'] = str_ireplace('{39}',"'",$ReplyGuestInforow['text']);
				      $ReplyGuestInforow['text'] = str_ireplace('cookie','**',$ReplyGuestInforow['text']);
				      $censorwords = preg_split('#[ \r\n\t]+#', $PowerBB->_CONF['info_row']['censorwords'], -1, PREG_SPLIT_NO_EMPTY);
				      $ReplyGuestInforow['text'] = str_ireplace($censorwords,'**', $ReplyGuestInforow['text']);

	                $Reply_time_date = $PowerBB->functions->date($ReplyGuestInforow['write_time']);
			        $Reply_time = $PowerBB->functions->time($ReplyGuestInforow['write_time']);
			        $PowerBB->template->assign('write_time',$Reply_time_date.' ; '.$Reply_time);
			        $PowerBB->template->assign('reply_guest',$ReplyGuestInforow);



                   $PowerBB->template->display('archive_reply_guest');

				}

		     }
             //////////////////////
	}

	function __GetReply()
	{
		global $PowerBB;

		// Show the replies
		$PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
		$PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');

		$ReplyNumArr 					= 	array();
		$ReplyNumArr['get_from'] 		= 	'db';

		$ReplyNumArr['where'] 		= 	array('subject_id',$this->Info['subject_id']);

		$ReplyArr['where']				=	array();
		$ReplyArr['where'][0] 			= 	array();
		$ReplyArr['where'][0]['name']	=	'delete_topic';
		$ReplyArr['where'][0]['oper']	=	'<>';
		$ReplyArr['where'][0]['value']	=	'1';

		$ReplyArr['where'][1] 			= 	array();
		$ReplyArr['where'][1]['con'] 	= 	'AND';
		$ReplyArr['where'][1]['name']	=	'writer';
		$ReplyArr['where'][1]['oper']	=	'<>';
		$ReplyArr['where'][1]['value']	=	'Guest';

		$ReplyArr = array();

		$ReplyArr['proc'] 				= 	array();
		$ReplyArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');


		$ReplyArr['subject_id'] 		= 	$this->Info['subject_id'];

		$this->RInfo = $PowerBB->reply->GetReplyWriterInfo($ReplyArr);
		if (!$this->RInfo)
		{
		$this->RInfo = $PowerBB->reply->GetReplyGuestInfo($ReplyArr);
		}
		// Kill XSS
		// TODO :: it's better to kill XSS inside the loop
		$PowerBB->functions->CleanVariable($this->RInfo,'html');

		$n = sizeof($this->RInfo);
		$this->x = 0;

		// Nice loop :D
		while ($n > $this->x)
		{
			// Get the replier info
			$this->___GetReplierInfo();

			// Make reply text as a nice format
			$this->___ReplyFormat();

			// The end of reply
			$this->___ReplyEnd();
		}
	}

	function ___GetReplierInfo()
	{
		global $PowerBB;


		if (empty($this->RInfo[$this->x]['username_style_cache']))
		{
			$this->RInfo[$this->x]['display_username'] = $this->RInfo[$this->x]['username'];
		}
		else
		{
			$this->RInfo[$this->x]['display_username'] = $this->RInfo[$this->x]['username_style_cache'];

			$this->RInfo[$this->x]['display_username'] = $PowerBB->functions->CleanVariable($this->RInfo[$this->x]['display_username'],'unhtml');
		}

		$this->RInfo[$this->x]['reply_number'] = $this->reply_number;

		$this->reply_number += 1;
	}

	function ___ReplyFormat()
	{
		global $PowerBB;

		// If the PowerCode is allow , use it
		if ($this->SectionInfo['use_power_code_allow'])
		{
			$this->RInfo[$this->x]['text'] = $PowerBB->Powerparse->replace($this->RInfo[$this->x]['text']);
		}
		// It's not allow , don't use it
		else
		{
			$this->RInfo[$this->x]['text'] = nl2br($this->RInfo[$this->x]['text']);
		}

		// Convert the smiles to image
		$PowerBB->Powerparse->replace_smiles($this->RInfo[$this->x]['text']);

				// feltr Reply Text
        $this->RInfo[$this->x]['text'] = str_ireplace('{39}',"'",$this->RInfo[$this->x]['text']);

        $this->RInfo[$this->x]['text'] = str_ireplace('Cookie','**', $this->RInfo[$this->x]['text']);
        $censorwords = preg_split('#[ \r\n\t]+#', $PowerBB->_CONF['info_row']['censorwords'], -1, PREG_SPLIT_NO_EMPTY);
        $this->RInfo[$this->x]['text'] = str_ireplace($censorwords,'**', $this->RInfo[$this->x]['text']);

        $this->RInfo[$this->x]['text'] = str_replace('&amp;','&',$this->RInfo[$this->x]['text']);


	}

	function ___ReplyEnd()
	{
		global $PowerBB;

		$reply_date = $PowerBB->functions->date($this->RInfo[$this->x]['write_time']);
		$reply_time = $PowerBB->functions->time($this->RInfo[$this->x]['write_time']);

		$this->RInfo[$this->x]['write_time'] = $reply_date . ' ; ' . $reply_time;


		// $RInfo to templates
		$PowerBB->template->assign('Info',$this->RInfo[$this->x]);
		$PowerBB->template->assign('section',$this->Info['section']);


		// Show the reply :)
		       	$ReviewInfoArr = array();
		$ReviewInfoArr['where'] = array('id',$this->RInfo[$this->x]['reply_id']);

		$ReviewInfo = $PowerBB->reply->GetReplyInfo($ReviewInfoArr);
		$PowerBB->template->assign('ReviewInfo',$ReviewInfo);

		// $x = $x + 1
		$this->x += 1;

		// Show the reply :)
			if ($ReviewInfo['review_reply'] == 1)
			{
				// Does not show anything
			}
			else
			{
		// Show the reply :)
		$PowerBB->template->display('archive_reply');

		}
	}



	function __PageEnd()
	{
		global $PowerBB;

		////////

		$Admin = false;

		if ($PowerBB->_CONF['member_permission'])
		{
			if ($PowerBB->_CONF['group_info']['admincp_allow']
				or $PowerBB->_CONF['group_info']['vice'])
			{
				$Admin = true;
			}
			else
			{
				if (isset($this->SectionInfo))
				{
					$AdminArr = array();
					$AdminArr['username'] = $PowerBB->_CONF['member_row']['username'];
					$AdminArr['section_id'] = $this->SectionInfo['id'];

				}
			}
		}

		////////


     	$PowerBB->template->assign('id',$PowerBB->_GET['id']);

     	$PowerBB->template->assign('Admin',$Admin);

     	$PowerBB->template->display('archive_footer');


	}
}

?>
