<?php
/*======================================================================*\
|| #################################################################### ||
|| # psiStats 2010 for vBulletin 4.0.x by Psionic Vision
|| #################################################################### ||
|| # Copyright 2009 Anton Kanevsky (ankan925@gmail.com) aka Psionic Vision. All Rights Reserved.
|| # This file may redistributed under GPL license for non-commercial purposes only.
|| #################################################################### ||
\*======================================================================*/

######################################################################################
error_reporting(E_ALL & ~E_NOTICE);

######################################################################################
$phrasegroups = array('psistats');
$specialtemplates = array();

######################################################################################
require_once('./global.php');

######################################################################################
if (!can_administer('canadminsettings'))
{
	print_cp_no_permission();
}

print_cp_header($vbphrase['psistats_refmanagement']);

######################################################################################
######################################################################################
######################################################################################

if ($_POST['do'] == 'update')
{
	$vbulletin->input->clean_gpc('p', 'blocksites', TYPE_ARRAY);
	
	if (is_array($vbulletin->GPC['blocksites']))
	{
		foreach ($vbulletin->GPC['blocksites'] as $referrer => $banned)
		{
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "psistats_data
				SET cmisc = " . intval($banned) . "
				WHERE cdata = '" . $db->escape_string($referrer) . "'
				AND ctype = 'referrer'
			");
		}
	}
}

######################################################################################
######################################################################################
######################################################################################

$getsites = $db->query_read("
	SELECT cdata as referrer, count, cmisc as banned
	FROM " . TABLE_PREFIX ."psistats_data
	WHERE ctype = 'referrer'
	ORDER BY banned, referrer
");

######################################################################################
######################################################################################
######################################################################################

print_form_header('psistats_admin', 'update');
print_table_header($vbphrase['psistats_refmanagement']);

if ($db->num_rows($getsites))
{
	print_label_row($vbphrase['psistats_refmanagement_desc']);
	
	while ($site = $db->fetch_array($getsites))
	{
		print_yes_no_row($site['referrer'], 'blocksites[' . $site['referrer'] . ']', $site['banned']);
	}
	
	print_submit_row();
}
else
{
	print_label_row($vbphrase['psistats_refmanagement_dbempty']);
	print_table_footer();
}

######################################################################################
######################################################################################
######################################################################################

print_cp_footer();

/*======================================================================*\
|| #################################################################### ||
|| # psiStats 2010 for vBulletin 4.0.x by Psionic Vision
|| #################################################################### ||
\*======================================================================*/
?>