<?php
/*======================================================================*\
|| #################################################################### ||
|| # psiStats 2010 for vBulletin 4.0.x by Psionic Vision
|| #################################################################### ||
|| # Copyright 2010 Anton Kanevsky (ankan925@gmail.com) aka Psionic Vision. All Rights Reserved.
|| # This file may redistributed under GPL license for non-commercial purposes only.
|| #################################################################### ||
\*======================================================================*/

######################################################################################
error_reporting(E_ALL & ~E_NOTICE);
if (!is_object($vbulletin->db))
{
	exit;
}

######################################################################################
require(DIR . '/includes/psistats/database_country.php');
require(DIR . '/includes/psistats/database_agent.php');

######################################################################################
######################################################################################
######################################################################################

$vbulletin->db->lock_tables(array('psistats_cache' => 'WRITE', 'psistats_data' => 'WRITE'));

######################################################################################

$existingcache = $updatecache = array();

$getcache = $vbulletin->db->query_read("
	SELECT COUNT(`cdata`) as count, `ctype`, `cdata` 
	FROM `" . TABLE_PREFIX . "psistats_cache` 
	GROUP BY `ctype`, `cdata`
");
$getexisting = $vbulletin->db->query_read("
	SELECT `cdata`, `count`, `ctype`, `cmisc` 
	FROM `" . TABLE_PREFIX . "psistats_data`
");

######################################################################################
######################################################################################
######################################################################################

if ($vbulletin->db->num_rows($getexisting))
{
	while ($item = $vbulletin->db->fetch_array($getexisting))
	{
		$existingcache["$item[ctype]_||_$item[cdata]"] = array('count' => $item['count'], 'cmisc' => $item['cmisc']);
	}
}

// memory saving
$vbulletin->db->free_result($getexisting);

######################################################################################
######################################################################################
######################################################################################

if ($vbulletin->db->num_rows($getcache))
{
	while ($item = $vbulletin->db->fetch_array($getcache))
	{
		switch ($item['ctype'])
		{
			###################################################################################################################
			case 'country':
				if (!preg_match('#^\d+\.\d+\.\d+\.\d+$#', $item['cdata']))
				{
					break;
				}
				
				$split_ip = explode(".", $item['cdata']);
				
				$include_file = DIR . '/includes/psistats/database_ip/' . $split_ip[0] . '.php';
				if (!file_exists($include_file))
				{
					continue;
				}
				else
				{
					include($include_file);
				}				
				
				$code = ($split_ip[0] * 16777216) + ($split_ip[1] * 65536) + ($split_ip[2] * 256) + ($split_ip[3]);
				$coucode = false;
						
				foreach($ranges as $key => $value)
				{
					if ($key <= $code)
					{
						if($value[0] >= $code)
						{
							$coucode = $value[1];
							break;
						}
					}
				}
				
				unset($ranges); // memory saving
				
				if (isset($database_country["$coucode"]))
				{
					if (isset($updatecache["country_||_$coucode"]))
					{
						$item['count'] += $updatecache["country_||_$coucode"][1];
					}
				
					$updatecache["country_||_$coucode"] = array($existingcache["country_||_$coucode"]['count'], $item['count'], $existingcache["country_||_$coucode"]['cmisc']);
				}
				break;
			###################################################################################################################
			case 'useragent':
				$browser 	= array('name' => 'Unknown', 'version' => '', 'os' => 'Unknown', 'bstring' => '');
				$useragent 	= strtolower($item['cdata']);
				
				// <><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>

				foreach ($bots as $ident => $output)
				{
					if (strpos($useragent, $ident) !== false)
					{					
						$browser['name'] = "Bot ($output)";
						break;
					}
				}
				
				// <><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
				
				if ($browser['name'] == 'Unknown')
				{
					foreach ($browsers as $browsername => $data)
					{
						list ($regex, $precheck, $skipversion, $strip) = $data;

						if (!$precheck OR strpos($useragent, $precheck) !== false)
						{
							if (preg_match($regex, $useragent, $matches))
							{
								$browser['name'] = $browsername;
									
								if (!$skipversion)
								{
									$browser['version'] = $matches[1];
									
									if ($strip)
									{
										for ($i = 0; $i < strlen($strip); $i++)
										{
											$browser['version'] = str_replace($strip{$i}, '', $browser['version']);
										}
									}
									
									if (strlen($browser['version']) > 3)
									{
										$browser['version'] = substr($browser['version'], 0, 3);
									}
								}
									
								break;
							}
						}
					}
				}

				// <><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
				
				foreach ($oses as $os => $identificator)
				{
					if (is_array($identificator))
					{
						foreach ($identificator as $ident)
						{
							if (preg_match("#$ident#i", $useragent))
							{
								$browser['os'] = $os;
								break;
							}
						}
					}
					else
					{
						if (preg_match("#$identificator#i", $useragent))
						{
							$browser['os'] = $os;
							break;
						}
					}
				}
				
				// <><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
				
				$browser['bstring'] = $browser['name'] . "," . $browser['version'];
				
				if (isset($updatecache["browser_||_$browser[bstring]"]))
				{
					$item['count'] += $updatecache["browser_||_$browser[bstring]"][1];
				}
				
				if (isset($updatecache["os_||_$browser[os]"]))
				{
					$item['count'] = $updatecache["os_||_$browser[os]"][1];
				}
				
				$updatecache["browser_||_$browser[bstring]"] = array($existingcache["browser_||_$browser[bstring]"]['count'], $item['count'], $existingcache["browser_||_$browser[bstring]"]['cmisc']);
				$updatecache["os_||_$browser[os]"] = array($existingcache["os_||_$browser[os]"]['count'], $item['count'], $existingcache["os_||_$browser[os]"]['cmisc']);
				
				break;
			###################################################################################################################
			case 'referrer':
				$bannedurl = false;

				if ($vbulletin->options['psistats_refcensure'])
				{
					foreach (explode(',', strtolower($vbulletin->options['psistats_refcensure'])) as $word)
					{
						if (strpos($item['cdata'], trim($word)) !== false)
						{
							$bannedurl = true;
						}
					}
				}
				
				if (!$bannedurl)
				{
					if (isset($updatecache["referrer_||_$item[cdata]"]))
					{
						$item['count'] += $updatecache["referrer_||_$item[cdata]"][1];
					}
				
					$updatecache["referrer_||_$item[cdata]"] = array($existingcache["referrer_||_$item[cdata]"]['count'], $item['count'], $existingcache["referrer_||_$item[cdata]"]['cmisc']);
				}
				
				break;
			###################################################################################################################
			case 'screendepth':
				switch ($item['cdata'])
				{
					case 4:
						$colors = '16';
						$depth_handled = true;
						break;
					case 8:
						$colors = '256';
						$depth_handled = true;
						break;
					case 16:
						$colors = 'True Color';
						$depth_handled = true;
						break;
					case 24:
					case 32:
						$colors = 'High Color';
						$depth_handled = true;
						break;
					default:
						$depth_handled = false;
						break;
				}

				if ($depth_handled)
				{
					$depthstring = $item['cdata'] . "," . $colors;
					
					if (isset($updatecache["screendepth_||_$depthstring"]))
					{
						$item['count'] += $updatecache["screendepth_||_$depthstring"][1];
					}
					
					$updatecache["screendepth_||_$depthstring"] = array($existingcache["screendepth_||_$depthstring"]['count'], $item['count'], $existingcache["screendepth_||_$depthstring"]['cmisc']);
				}
				
				break;
			###################################################################################################################
			case 'screenresolution':
				if (isset($updatecache["screenresolution_||_$item[cdata]"]))
				{
					$item['count'] += $updatecache["screenresolution_||_$item[cdata]"][1];
				}
			
				$updatecache["screenresolution_||_$item[cdata]"] = array($existingcache["screenresolution_||_$item[cdata]"]['count'], $item['count'], $existingcache["screenresolution_||_$item[cdata]"]['cmisc']);
				break;
			###################################################################################################################
		}
	}
}

// memory saving
$vbulletin->db->free_result($getcache);

######################################################################################
######################################################################################
######################################################################################

if (sizeof($updatecache) > 0)
{
	$deletions = $insertions = array();
	
	foreach ($updatecache as $ident => $data)
	{
		$ident = explode('_||_', $ident);
		
		$deletions[] = "(`cdata` = '$ident[1]' AND `count` = '$data[0]' AND `ctype` = '$ident[0]' AND `cmisc` = '$data[2]')";
		$insertions[] = "('$ident[1]', '" . ($data[0] + $data[1]) . "', '$ident[0]', '$data[2]')";
	}

	$deletions = implode(' OR ', $deletions);
	$insertions = implode(',', $insertions);
	
	$vbulletin->db->unlock_tables();
	
	$vbulletin->db->query_write("
		DELETE FROM `" . TABLE_PREFIX ."psistats_data`
		WHERE $deletions
	");	
	
	$vbulletin->db->query_write("
		INSERT INTO `" . TABLE_PREFIX ."psistats_data`
		(`cdata`, `count`, `ctype`, `cmisc`) VALUES
		$insertions
	");
	
	$vbulletin->db->query_write("TRUNCATE TABLE `" . TABLE_PREFIX ."psistats_cache`");
}
else
{
	$vbulletin->db->unlock_tables();
}

######################################################################################
######################################################################################
######################################################################################

log_cron_action('psiStats Updated', $nextitem);

/*======================================================================*\
|| #################################################################### ||
|| # psiStats 2010 for vBulletin 4.0.x by Psionic Vision
|| #################################################################### ||
\*======================================================================*/
?>