<?php
// #############################################################################
// psiStats 2010 for vBulletin 4.0.x
// Created by Anton Kanevsky (ankan925@gmail.com) - aka Psionic Vision
// Country Database - Last Updated: 2010/09/18
// Distributed under GPL license for non-commercial use.
// #############################################################################

/***********************************************************************************************************************************************
* @key		string	Bot Identificator
* @value	string	Output on Match
**/
$bots = array(
	'yahoo! slurp' 			=> 'Yahoo! Slurp',
	'msnbot'				=> 'MSN',
	'googlebot'				=> 'Google',
	'mediapartners-google' 	=> 'Google Adsense',
	'ask jeeves'			=> 'Ask Jeeves',
	'scooter'				=> 'Alta Vista',
	'bot'					=> 'Unknown',
	'crawl'					=> 'Unknown',
);

/***********************************************************************************************************************************************
* @key	string	Output on Match
* @item	mixed	Regular Expression
* @item	mixed	Pre-check for a certain string before doing regex (must be lowecase only)
* @item	mixed	Do not fetch version
* @item	mixed	Symbols to strip from version string
**/
$browsers = array(
	'Opera'				=> array('/Opera[\/ ]([0-9]+[u]?[\d+]?)/i',		false,			false,		false	),
	'Internet Explorer'	=> array('/MSIE ([0-9\.]+[b]?)/i',				false,			false,		false	),
	'Netscape'			=> array('/Netscape[0-9]?\/([0-9\.]+)/i',		false,			false, 		false	),
	'Konqueror'			=> array('/Konqueror\/([0-9\.]+)/i',			false,			false,		false	),
	'OmniWeb'			=> array('/OmniWeb\/([v]?[0-9\.]+)/i',			false,			false,		'v'		),
	'iCab'				=> array('/iCab[\/ ]([0-9\.]+)/i',				false,			false,		false	),
	'Firefox'			=> array('/Firefox\/([0-9\.]+)/i',				'gecko',		false,		false	),
	'Google Chrome'		=> array('/Chrome\/([0-9\.]+)/i',				'applewebkit',	false,		false	),
	'Safari'			=> array('/Safari\/([0-9]+)/i',					'applewebkit',	true,		false	),
	'Galeon'			=> array('/Galeon\/([0-9\.]+)/i',				false,			false,		false	),
	'Camino'			=> array('/Camino\/([0-9\.]+)/i',				false,			false,		false	),
);

/***********************************************************************************************************************************************
* @key		string	Output on Match
* @value	string	Operating System Identificator (lowercase only)
**/
$oses = array(
	'Windows XP'			=>	array('winnt5.1', 'windows nt 5.1'),
	'Windows 98'			=>	array('win98', 'windows 98'),
	'Windows 2000'			=>	array('winnt5.0', 'windows nt 5.0'),
	'Windows 2003 Server'	=>	'windows nt 5.2',
	'Windows Vista'			=>	'windows nt 6.0',
	'Windows 7'				=>	'windows nt 6.1',
	'Windows NT'			=>	array('winnt4.0', 'windows nt 4.0'),
	'Windows CE'			=>	'windows ce',
	'Windows ME'			=>	array('windows 9x 4.90', 'windows me'),
	'Mac OS X'				=>	'mac os x',
	'Macintosh'				=>	array('powerpc', 'macintosh'),
	'Linux'					=>	'linux',
	'Free BSD'				=>	'freebsd',
	'Net BSD'				=>	'netbsd',
	'Open BSD'				=>	'openbsd',
	'Sun OS'				=>	'sunos',
	'Symbian'				=>	'symbian',
);

// #############################################################################
// psiStats 2010 for vBulletin 4.0.x
// Created by Anton Kanevsky (ankan925@gmail.com) - aka Psionic Vision
// #############################################################################
?>