<?php
/*======================================================================*\
|| #################################################################### ||
|| # psiStats 2010 for vBulletin 4.0.x by Psionic Vision
|| #################################################################### ||
|| # Copyright 2010 Anton Kanevsky (ankan925@gmail.com) aka Psionic Vision. All Rights Reserved.
|| # This file may redistributed under GPL license for non-commercial purposes only.
|| #################################################################### ||
\*======================================================================*/

######################################################################################
error_reporting(E_ALL & ~E_NOTICE);

######################################################################################
define('THIS_SCRIPT', 'psistats');

######################################################################################
######################################################################################
######################################################################################

/**
* fetch_percent_color
*
* Takes in this row's amount and total amount, and creates global $color, $percent and $real_percent variables.
*/
function fetch_percent_color($this_count, $total_count)
{
	global $color, $percent, $real_percent;

	if ($total_count > 0)
	{
		$color = rand(1,6);
		$real_percent	= round($this_count / $total_count * 100, 2);
		$percent = ($real_percent >= 70 ? 70 + ($real_percent - 70) / 4 : $real_percent);
		if ($percent < 0.12)
		{
			$percent = 0.12; // make sure that the bar is always visible (this is not the value that is displayed, this is only the bar width value)
		}
	}
	else
	{
		$color = rand(1,6);
		$real_percent = 0;
		$percent = 0;
	}
}

/**
* fetch_sum
*
* Takes in a mysql resources and returns total count from all rows.
*/
function fetch_sum(&$mysql_resource)
{
	global $vbulletin;
	
	$total = 0;
	while ($item = $vbulletin->db->fetch_array($mysql_resource))													
	{
		$total += $item['count'];																		
	}
	
	$vbulletin->db->data_seek($mysql_resource, 0);																	
	return $total;																						
}

######################################################################################
######################################################################################
######################################################################################
			
$phrasegroups = array('psistats'); 																		
$globaltemplates = array('psistats_footer'); 
$specialtemplates = array('userstats');
$actiontemplates = array(
	'home' => array(
		'PSISTATS_HOME'
	),
	'styles' => array(
		'PSISTATS_STYLES',
		'psistats_stylebit'
	),
	'toptf' => array(
		'PSISTATS_TOPTF',
		'psistats_topthreadbit',
		'psistats_topforumbit'
	),
	'display' => array(
		'PSISTATS_DISPLAY',
		'psistats_resolutionbit',
		'psistats_depthbit'
	),
	'regions' => array(
		'PSISTATS_REGIONS',
		'psistats_regionbit',
		'psistats_countrybit'
	),
	'os' => array(
		'PSISTATS_OS',
		'psistats_browserbit',
		'psistats_osbit'
	),
	'refsites' => array(
		'PSISTATS_REFSITES',
		'psistats_refsitebit',
	),
	'referrers' => array(
		'PSISTATS_REFERRERS',
		'psistats_referrerbit',
		'psistats_referreduserbit',
	),
	'demographics' => array(
		'PSISTATS_DEMOGRAPHICS',
		'psistats_demographics_groupbit',
	),
);

######################################################################################
$default_do = false;
if (!isset($_REQUEST['do']) OR !in_array($_REQUEST['do'], array_keys($actiontemplates)))
{
	$_REQUEST['do'] = 'home';
	$default_do = true;
}

######################################################################################
require_once('./global.php');
######################################################################################

if (trim($vbulletin->options['psistats_ugslimit']))
{
	if (preg_match('/^([0-9]{1,2}[\s]*[,]{0,1}[\s]*)*$/', $vbulletin->options['psistats_ugslimit']))
	{
		eval('$canview = is_member_of($vbulletin->userinfo, ' . $vbulletin->options['psistats_ugslimit'] . ');');
		if (!$canview)
		{
			print_no_permission();
		}
	}
}

######################################################################################
######################################################################################
######################################################################################
$show_modules = array();
foreach (array_keys($psistats_options) as $module)
{
	$show_modules["$module"] = ($vbulletin->options['psistats_modules'] & $psistats_options["$module"] ? 1 : 0);
}
if ($default_do && !$show_modules['stats_general'])
{
	foreach (array_keys($psistats_options) as $module)
	{
		if (($module != 'general') && $show_modules["$module"])
		{
			$_REQUEST['do'] = substr($module, strpos($module, '_') + 1);
			break;
		}
	}
}

######################################################################################
######################################################################################
######################################################################################

if ($_REQUEST['do'] == 'home')
{
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	if (!$show_modules['stats_general']) { print_no_permission(); }
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	
	$c = array(
		'creation_date'			=> 0,											// board creation date
		'creation_fdate'		=> 0,											// board creation date (formatted)
		'creation_dayspassed'	=> 0, 											// days passed since board creation
		'posts_per_day'			=> 0,											// posts per day (average)
		'lastuserid'			=> $vbulletin->userstats['newuserid'],			// last registered user
		'lastusername'			=> $vbulletin->userstats['newusername'],			// last registered user
		'maxrefs'				=> 0,											// maximum referrals
		'maxrefs_userid'		=> 0,											// 	-> userid
		'maxrefs_username'		=> '',											//	-> username
		'users'					=> $vbulletin->userstats['numbermembers'],		// total users
		'staff'					=> 0,											// total staff
		'administrators'		=> 0,											//	-> admins
		'smoderators'			=> 0,											//	-> smods
		'moderators'			=> 0,											//	-> mods
		'registered_today'		=> 0,											// users registered during last 24 hours
		'active_users'			=> 0,											// active users
		'nonactive_users'		=> 0,											// nonactive users
		'activity'				=> 0,											// activity %
		'online'				=> 0,											// online total
		'online_users'			=> 0,											// online members
		'online_guests'			=> 0,											// online guests
		'threads'				=> 0,											// total threads
		'threads_today'			=> 0,											// total threads (24 hrs)
		'posts'					=> 0,											// total posts
		'posts_today'			=> 0,											// total posts (24 hrs)
		'pmtotal'				=> 0,											// total private messages
		'ousercache'			=> array(),										// cache (users online)
	);
	$c_formatted = array(
		'creation_dayspassed',
		'maxrefs',
		'users',
		'staff',
		'administrators',
		'smoderators',
		'moderators',
		'registered_today',
		'active_users',
		'nonactive_users',
		'online',
		'online_users',
		'online_guests',
		'threads',
		'threads_today',
		'posts',
		'posts_today',
		'pmtotal',
	);

	############################################################################################################################	
	if ($vbulletin->options['activememberoptions'] & 2)
	{
		if ($vbulletin->options['activememberdays'])
		{
			$c['active_users'] = $vbulletin->userstats['activemembers'];
			$c['nonactive_users'] = $vbulletin->userstats['numbermembers'] - $vbulletin->userstats['activemembers'];
			$c['activity'] = round($vbulletin->userstats['activemembers'] / $vbulletin->userstats['numbermembers'] * 100, 2);
		}
		else
		{
			$c['active_users'] = $vbulletin->userstats['numbermembers'];
			$c['anonactive_users'] = 0;
			$c['activity'] = 100;
		}
		
		$show['activity_stats'] = true;
	}
	else
	{
		$show['activity_stats'] = false;
	}
	
	############################################################################################################################	
	$getusers = $db->query_read("
		SELECT
			user.username, (user.options & " . $vbulletin->bf_misc_useroptions['invisible'] . ") AS invisible,
			session.userid, session.inforum, session.lastactivity
		FROM " . TABLE_PREFIX . "session AS session
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = session.userid)
		WHERE session.lastactivity > " . (TIMENOW - $vbulletin->options['cookietimeout']) . "
	");
	
	while ($loggedin = $db->fetch_array($getusers))
	{
		if (!$loggedin['userid'])
		{
			$c['online_guests']++;
		}
		else if (!isset($c['ousercache']["$loggedin[userid]"]))
		{
			$c['ousercache']["$loggedin[userid]"] = true;
			
			if (!$loggedin['invisible'] OR $loggedin['userid'] == $vbulletin->userinfo['userid'] OR ($vbulletin->userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canseehidden']))
			{
				$c['online_users']++;
			}
		}
	}

	if ($vbulletin->userinfo['userid'])
	{
		$c['online_users'] = ($c['online_users'] == 0 ? 1 : $c['online_users']);
	}
	else
	{
		$c['online_guests'] = ($c['online_guests'] == 0	? 1 : $c['online_guests']);
	}

	$c['online'] = $c['online_users'] + $c['online_guests'];
	
	############################################################################################################################
	$c['registered_today'] = $db->query_first("
		SELECT COUNT(userid) as X
		FROM " . TABLE_PREFIX . "user
		WHERE joindate > " . (TIMENOW - 86400) . "
	");
	$c['registered_today'] = $c['registered_today']['X'];
	
	############################################################################################################################
	$c['pmtotal'] = $db->query_first("
		SELECT SUM(pmtotal) as X
		FROM " . TABLE_PREFIX . "user
	");
	$c['pmtotal'] = $c['pmtotal']['X'];
	
	############################################################################################################################
	$threads = $db->query_first("
		SELECT COUNT(threadid) as X
		FROM " . TABLE_PREFIX . "thread
		WHERE visible = 1
	");
	
	$c['threads'] = $threads['X'];
	$c['threads_today'] = 0;
	
	if ($c['threads'])
	{
		$threads = $db->query_first("
			SELECT COUNT(threadid) as X
			FROM " . TABLE_PREFIX . "thread
			WHERE visible = 1
			AND dateline > " . (TIMENOW - 86400) . "
		");
		
		$c['threads_today'] = $threads['X'];
	}
	
	$db->free_result($threads);
	
	############################################################################################################################
	$posts = $db->query_first("
		SELECT COUNT(postid) as X
		FROM " . TABLE_PREFIX . "post
		WHERE visible = 1
	");
	
	$c['posts'] = $posts['X'];
	$c['posts_today'] = 0;
	
	if ($c['posts'])
	{
		$posts = $db->query_first("
			SELECT COUNT(postid) as X
			FROM " . TABLE_PREFIX . "post
			WHERE visible = 1
			AND dateline > " . (TIMENOW - 86400) . "
		");
		
		$c['posts_today'] = $posts['X'];
	}
	
	$db->free_result($posts);
	
	############################################################################################################################
	$getref = $db->query_first("
		SELECT referrerid, COUNT(referrerid) as referredcount
		FROM " . TABLE_PREFIX . "user
		WHERE referrerid > 0
		GROUP BY referrerid
		ORDER BY referredcount DESC LIMIT 1
	");
	
	if ($getref)
	{
		$getinfo = $db->query_first("
			SELECT username
			FROM " . TABLE_PREFIX . "user
			WHERE userid = " . $getref['referrerid'] . "
			LIMIT 1
		");
		
		if ($getinfo)
		{
			$c['maxrefs'] 			= $getref['referredcount'];
			$c['maxrefs_userid'] 	= $getref['referrerid'];
			$c['maxrefs_username'] 	= $getinfo['username'];
		}
	}
	
	############################################################################################################################
	if ($vbulletin->options['psistats_creationdate'] AND preg_match('#^\d{1,2}/\d{1,2}/\d{4}$#', $vbulletin->options['psistats_creationdate']))
	{
		$getcreationdate = explode('/', $vbulletin->options['psistats_creationdate']);
		$getcurrentdate = getdate(TIMENOW);

		if ($getcreationdate[0] > 0 AND $getcreationdate[0] <= 12 AND $getcreationdate[1] > 0 AND $getcreationdate[1] <= 31 AND $getcreationdate[2] > 1990 AND $getcreationdate[2] <= $getcurrentdate['year'])
		{
			require_once(DIR . '/includes/functions_misc.php');		
			$c['creation_date'] = vbmktime(0, 0, 0, $getcreationdate[0], $getcreationdate[1], $getcreationdate[2]);
		}
	}
	
	if (!$c['creation_date'])
	{
		$getcreationdate = $db->query_first("
			SELECT joindate
			FROM " . TABLE_PREFIX . "user
			ORDER BY joindate ASC LIMIT 1
		");
		
		$c['creation_date'] = $getcreationdate['joindate'];
	}
	
	$c['creation_fdate'] 		= vbdate($vbulletin->options['dateformat'], $c['creation_date']);
	$c['creation_dayspassed'] 	= ceil((TIMENOW - $c['creation_date']) / 86400);
	$c['posts_per_day'] 		= round($c['posts'] / $c['creation_dayspassed'], 2);
	
	############################################################################################################################
	$adminugs = array();
	$smodugs = array();
	$invert_conditions = array();
	function invert_cond($cond)
	{
		$search = array('IN ', 'OR ', 'usergroupid', 'membergroupids');
		$replace = array('NOT IN ', 'AND NOT ', 'user.usergroupid', 'user.membergroupids');
		return str_replace($search, $replace, $cond);
	}
	
	foreach ($vbulletin->usergroupcache as $usergroupid => $usergroup)
	{
		if ($usergroup['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel'])
		{
			$adminugs[] = $usergroupid;
		}
		else if ($usergroup['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator'])
		{
			$smodugs[] = $usergroupid;
		}
	}
	
	if (sizeof($adminugs))
	{
		$adminugs_cond = array();
		foreach ($adminugs as $ugid)
		{
			$adminugs_cond[] = "FIND_IN_SET($ugid, membergroupids)";
		}
		
		$admin_sql_cond = (
			"usergroupid IN (" . implode(',', $adminugs) . ")
			OR " . implode(' OR ', $adminugs_cond)
		);
		$invert_conditions[] = invert_cond($admin_sql_cond);
		$getadmins = $db->query_first("
			SELECT COUNT(userid) as X
			FROM " . TABLE_PREFIX . "user
			WHERE $admin_sql_cond
		");
		
		$c['administrators'] = $getadmins['X'];
	}
	
	if (sizeof($smodugs))
	{
		$smodugs_cond = array();
		foreach ($smodugs as $ugid)
		{
			$smodugs_cond[] = "FIND_IN_SET($ugid, membergroupids)";
		}
		
		$smod_sql_cond = (
			"usergroupid IN (" . implode(',', $smodugs) . ")
			OR " . implode(' OR ', $smodugs_cond)
		);
		$invert_conditions[] = invert_cond($smod_sql_cond);
		$getsmods = $db->query_first("
			SELECT COUNT(userid) as X
			FROM " . TABLE_PREFIX . "user
			WHERE $smod_sql_cond
		");
		
		$c['smoderators'] = $getsmods['X'];
	}
	
	$getmods = $db->query_read("
		SELECT DISTINCT moderator.userid
		FROM " . TABLE_PREFIX . "moderator as moderator
		LEFT JOIN " . TABLE_PREFIX . "user as user ON (user.userid = moderator.userid)
		WHERE moderator.forumid <> -1
		" . (!empty($invert_conditions) ? "AND (" . implode(") AND (", $invert_conditions) . ")" : "") . "
		
	");
	
	$c['moderators'] = $db->num_rows($getmods);
	
	$c['staff'] = $c['administrators'] + $c['smoderators'] + $c['moderators'];

	// format values
	foreach ($c as $key => $value)
	{
		if (in_array($key, $c_formatted))
		{
			$c["$key"] = vb_number_format($value);
		} 
	}
	
	// shell vars
	$shell_vars = array('c');
}

######################################################################################
######################################################################################
######################################################################################

if ($_REQUEST['do'] == 'styles')
{
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	if (!$show_modules['stats_styles']) { print_no_permission(); }
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

	$total_count = 0;
	$style_cache = array();
	
	// fetch styles
	$get_styles = $db->query_read("
		SELECT styleid, title
		FROM " . TABLE_PREFIX . "style
		WHERE userselect = 1
	");
	
	while ($this_style = $db->fetch_array($get_styles))
	{
		$style_cache["$style[styleid]"] = $this_style;
		$style_cache["$style[styleid]"]['count'] = 0;
	}
	
	// fetch users
	$getusers = $db->query_read("
		SELECT IF(styleid > 0, styleid, " . $vbulletin->options['styleid'] . ") as styleid
		FROM " . TABLE_PREFIX . "user
	");
	
	$stylebit = '';
	if ($total_count = $db->num_rows($getusers))
	{
		while ($user = $db->fetch_array($getusers))
		{
			if (isset($style_cache["$user[styleid]"]))
			{
				$style_cache["$user[styleid]"]['count']++;
			}
			else
			{
				$total_count--;
			}
		}
		
		foreach($style_cache as $styleid => $this_style)
		{
			fetch_percent_color($this_style['count'], $total_count);			
			$templater = vB_Template::create('psistats_stylebit');
				$templater->register('this_style', $this_style);
				$templater->register('color', $color);
				$templater->register('percent', $percent);
				$templater->register('real_percent', $real_percent);
			$stylebit .= $templater->render();
		}
	}
	
	// shell vars
	$shell_vars = array('stylebit');
}

######################################################################################
######################################################################################
######################################################################################

if ($_REQUEST['do'] == 'toptf')
{
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	if (!$show_modules['stats_toptf']) { print_no_permission(); }
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

	// top forums by threadreplycount
	$getforums = $db->query_read("
		SELECT forumid, title, threadcount, replycount
		FROM " . TABLE_PREFIX . "forum
		" . (!$vbulletin->options['psistats_toptf_show_uncounts'] ? "WHERE options & " . $vbulletin->bf_misc['forumoptions']['countposts'] : "") . "
		ORDER BY threadcount + replycount DESC
	");
	
	$topforumbit = '';
	if ($db->num_rows($getforums))
	{
		$i = 0;
		
		while ($forum = $db->fetch_array($getforums))
		{
			if (!$vbulletin->options['showprivateforums'] AND !($vbulletin->userinfo['forumpermissions']["$forum[forumid]"] & $vbulletin->bf_ugp_forumpermissions['canview']))
			{
				$limitfids .= ", $forum[forumid]";
				continue;
			}
	
			if ($forum['threadcount'] > 0 OR $forum['replycount'] > 0)
			{
				if (++$i <= $vbulletin->options['psistats_toptflimit'])
				{
					$forum['acount'] = $forum['threadcount'] + $forum['replycount'];
					$templater = vB_Template::create('psistats_topforumbit');
						$templater->register('forum', $forum);
					$topforumbit .= $templater->render();
				}
			}
		}
	}

	// top threads by views
	$getthreads = $db->query_read("
		SELECT thread.threadid, thread.title, thread.views
		FROM " . TABLE_PREFIX . "thread as thread
		" . (!$vbulletin->options['psistats_toptf_show_uncounts'] ? "LEFT JOIN " . TABLE_PREFIX . "forum as forum USING (forumid)" : "") . "
		WHERE thread.visible = 1
		" . (!$vbulletin->options['psistats_toptf_show_uncounts'] ? "AND forum.options & " . $vbulletin->bf_misc['forumoptions']['countposts'] : "") . "
		AND thread.forumid NOT IN (0$limitfids)
		ORDER BY thread.views DESC
		LIMIT " . $vbulletin->options['psistats_toptflimit'] . "
	");
	
	$vtopthreadbit = '';
	if ($db->num_rows($getthreads))
	{
		while ($thread = $db->fetch_array($getthreads))
		{
			$templater = vB_Template::create('psistats_topthreadbit');
				$templater->register('thread', $thread);
			$vtopthreadbit .= $templater->render();
		}
	}
	
	// top threads by replies
	$getthreads = $db->query_read("
		SELECT threadid, title, replycount
		FROM " . TABLE_PREFIX . "thread
		WHERE visible = 1
		AND replycount > 0
		AND forumid NOT IN (0$limitfids)
		ORDER BY replycount DESC
		LIMIT " . $vbulletin->options['psistats_toptflimit'] . "
	");
	
	$rtopthreadbit = '';
	if ($db->num_rows($getthreads))
	{
		while ($thread = $db->fetch_array($getthreads))
		{
			$templater = vB_Template::create('psistats_topthreadbit');
				$templater->register('thread', $thread);
			$rtopthreadbit .= $templater->render();
		}
	}
	
	// shell vars
	$shell_vars = array(
		'vtopthreadbit',
		'rtopthreadbit',
		'topforumbit',
	);
}

######################################################################################
######################################################################################
######################################################################################

if ($_REQUEST['do'] == 'display')
{
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	if (!$show_modules['stats_display']) { print_no_permission(); }
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

	// fetch resolutions
	$getresolutions = $db->query_read("
		SELECT cdata as resolution, count
		FROM " . TABLE_PREFIX . "psistats_data
		WHERE ctype = 'screenresolution'
		ORDER BY " . ($vbulletin->options['psistats_sortnum'] ? "count DESC" : "resolution ASC") . "
	");
	
	$resolutionbit = '';
	if ($db->num_rows($getresolutions))
	{
		$total_count = fetch_sum($getresolutions);
		while ($resolution = $db->fetch_array($getresolutions))
		{
			fetch_percent_color($resolution['count'], $total_count);
			$templater = vB_Template::create('psistats_resolutionbit');
				$templater->register('resolution', $resolution);
				$templater->register('color', $color);
				$templater->register('percent', $percent);
				$templater->register('real_percent', $real_percent);
			$resolutionbit .= $templater->render();
		}
	}
	
	// fetch depths
	$getdepths = $db->query_read("
		SELECT cdata as depth, count
		FROM " . TABLE_PREFIX . "psistats_data
		WHERE ctype = 'screendepth'
		ORDER BY " . ($vbulletin->options['psistats_sortnum'] ? "count DESC" : "depth ASC") . "
	");
	
	$depthbit = '';
	if ($db->num_rows($getdepths))
	{
		$total_count = fetch_sum($getdepths);
		while ($depth = $db->fetch_array($getdepths))
		{
			$depth['depth']		= explode(',', $depth['depth']);
			$depth['bits']		= trim($depth['depth'][0]);
			$depth['colors']	= trim($depth['depth'][1]);
			
			fetch_percent_color($depth['count'], $total_count);
			$templater = vB_Template::create('psistats_depthbit');
				$templater->register('depth', $depth);
				$templater->register('color', $color);
				$templater->register('percent', $percent);
				$templater->register('real_percent', $real_percent);
			$depthbit .= $templater->render();
		}
	}
	
	// shell vars
	$shell_vars = array(
		'resolutionbit',
		'depthbit'
	);
}

######################################################################################
######################################################################################
######################################################################################

if ($_REQUEST['do'] == 'regions')
{
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	if (!$show_modules['stats_regions']) { print_no_permission(); }
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

	$regioncache = array();

	// require back-end files
	require_once(DIR . '/includes/psistats/database_country.php');

	// fetch countries
	$getcountries = $db->query_read("
		SELECT cdata as code, count 
		FROM " . TABLE_PREFIX . "psistats_data
		WHERE ctype = 'country'
		ORDER BY " . ($vbulletin->options['psistats_sortnum'] ? "count DESC" : "code ASC") . "
	");
	
	$countrybit = $regionbit = '';
	if ($db->num_rows($getcountries))
	{
		$total_count = fetch_sum($getcountries);
		while ($country = $db->fetch_array($getcountries))
		{
			$country['name'] 		= $database_country["$country[code]"][0];
			$country['region'] 		= $database_country["$country[code]"][1];
			$country['capital'] 	= $database_country["$country[code]"][2];
			$country['currency'] 	= $database_country["$country[code]"][3];
			$country['ciacode'] 	= $database_country["$country[code]"][4];
			$country['code'] 		= strtolower($country['code']);
			$country['flagfile']	= (!file_exists(DIR . '/includes/psistats/database_flag/' . $country['code'] . '.gif')) ? 'noflag' : $country['code'];
			
			$regioncache["$country[region]"] = (isset($regioncache["$country[region]"]) ? $regioncache["$country[region]"] + $country['count'] : $country['count']);
			
			fetch_percent_color($country['count'], $total_count);
			$templater = vB_Template::create('psistats_countrybit');
				$templater->register('country', $country);
				$templater->register('color', $color);
				$templater->register('percent', $percent);
				$templater->register('real_percent', $real_percent);
			$countrybit .= $templater->render();
		}
		
		// fetch continents based on countries
		foreach ($regioncache as $region => $count)
		{
			fetch_percent_color($count, $total_count);
			$templater = vB_Template::create('psistats_regionbit');
				$templater->register('region', $region);
				$templater->register('color', $color);
				$templater->register('percent', $percent);
				$templater->register('real_percent', $real_percent);				
				$templater->register('count', $count);
			$regionbit .= $templater->render();
		}
	}
	
	// shell vars
	$shell_vars = array(
		'regionbit',
		'countrybit'
	);
}

######################################################################################
######################################################################################
######################################################################################

if ($_REQUEST['do'] == 'os')
{
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	if (!$show_modules['stats_os']) { print_no_permission(); }
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

	// fetch browsers
	$getbrowsers = $db->query_read("
		SELECT cdata as browserstring, count 
		FROM " . TABLE_PREFIX . "psistats_data
		WHERE ctype = 'browser'
		ORDER BY " . ($vbulletin->options['psistats_sortnum'] ? "count DESC" : "browserstring ASC") . "
	");
	
	$browserbit = '';
	if ($db->num_rows($getbrowsers))
	{
		$total_count = fetch_sum($getbrowsers);
		while ($browser = $db->fetch_array($getbrowsers))
		{
			$browser['browserstring'] = explode(',', $browser['browserstring']);
			$browser['browser'] = $browser['browserstring'][0];
			$browser['version'] = $browser['browserstring'][1];			
			
			$browserimage = strtolower(str_replace(' ', '', $browser['browser']));
		
			if (!file_exists(DIR . '/includes/psistats/database_agent/' . $browserimage . '.gif'))
			{
				switch ($browser['browser'])
				{
					case 'Mozilla':
					case 'Firefox':
						$browserimage = 'mozilla';
						break;
					default:
						$browserimage = 'nobrowser';
						if (strpos($browser['browser'], 'Bot') !== false)
						{
							$browserimage = 'crawler';
						}
						break;
				}
			}

			fetch_percent_color($browser['count'], $total_count);
			$templater = vB_Template::create('psistats_browserbit');
				$templater->register('browserimage', $browserimage);
				$templater->register('browser', $browser);
				$templater->register('color', $color);
				$templater->register('percent', $percent);
				$templater->register('real_percent', $real_percent);
			$browserbit .= $templater->render();
		}
	}
	
	// fetch oses
	$getoses = $db->query_read("
		SELECT cdata as os, count
		FROM " . TABLE_PREFIX . "psistats_data
		WHERE ctype = 'os'
		ORDER BY " . ($vbulletin->options['psistats_sortnum'] ? "count DESC" : "os ASC") . "
	");
	
	$osbit = '';
	if ($db->num_rows($getoses))
	{
		$total_count = fetch_sum($getoses);
		while ($os = $db->fetch_array($getoses))
		{			
			switch ($os['os'])
			{
				case 'Windows 98':
				case 'Windows ME':
				case 'Windows NT':
				case 'Windows 2000':
					$osimage = 'windows';
					break;
				case 'Windows XP':
				case 'Windows Vista':
				case 'Windows 2003 Server':
					$osimage = 'windowsxp';
					break;
				case 'Windows CE':
					$osimage = 'windowsce';
					break;
				default:
					$osimage = strtolower(str_replace(' ', '', $os['os']));					
					if (!file_exists(DIR . '/includes/psistats/database_os/' . $osimage . '.gif'))
					{
						$osimage = 'noos';
					}
					break;
			}
			
			fetch_percent_color($os['count'], $total_count);
			$templater = vB_Template::create('psistats_osbit');
				$templater->register('osimage', $osimage);
				$templater->register('os', $os);
				$templater->register('color', $color);
				$templater->register('percent', $percent);
				$templater->register('real_percent', $real_percent);
			$osbit .= $templater->render();
		}
	}
	
	// shell vars
	$shell_vars = array(
		'browserbit',
		'osbit'
	);
}

######################################################################################
######################################################################################
######################################################################################

if ($_REQUEST['do'] == 'refsites')
{
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	if (!$show_modules['stats_refsites']) { print_no_permission(); }
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

	// fetch referring sites
	$getsites = $db->query_read("
		SELECT cdata as referrer, count
		FROM " . TABLE_PREFIX . "psistats_data
		WHERE ctype = 'referrer'
		AND cmisc = 0
		ORDER BY count DESC
		LIMIT " . $vbulletin->options['psistats_refsitelimit'] . "
	");
	
	$output = '';
	$refsitebit = '';
	$rows = $db->num_rows($getsites);
	
	$vbulletin->input->clean_gpc('r', 'output', TYPE_STR);
	$vbulletin->GPC['output'] = strtoupper($vbulletin->GPC['output']);
	
	switch ($vbulletin->GPC['output'])
	{
		case 'JS':
		{
			$output = 	"function referrer(referrer, count)\r\n" . 
						"{\r\n" . 
						"\tthis.referrer = referrer;\r\n" . 
						"\tthis.count = count;\r\n" . 
						"}\r\n";
						
			$output .= "var referrers = new Array(" . $rows . ");\r\n";
		}
		break;
		case 'XML':
		{
			// set variables
			$expires = TIMENOW + 300;
			$lastmodified = TIMENOW;
			
			// set XML type and nocache headers
			$headers = array(
				'Cache-control: max-age=' . $expires,
				'Expires: ' . gmdate('D, d M Y H:i:s', $expires) . ' GMT',
				'Last-Modified: ' . gmdate('D, d M Y H:i:s', $lastmodified) . ' GMT',
				'ETag: "' . md5($lastmodified) . '"',
				'Content-Type: text/xml' . ($stylevar['charset'] != '' ? '; charset=' .  $stylevar['charset'] : ''),
			);
			
			// print out the page header
			$output = '<?xml version="1.0" encoding="' . $stylevar['charset'] . '"?>' . "\r\n";
			require_once(DIR . '/includes/class_xml.php');
			$xml = new vB_XML_Builder($vbulletin);
			$xml->add_group('source');
			$xml->add_tag('url', $vbulletin->options['bburl']);
		}
		break;
		default:
	}
	
	if ($rows > 0)
	{
		$total_count = fetch_sum($getsites);
		while ($site = $db->fetch_array($getsites))
		{
			switch ($vbulletin->GPC['output'])
			{
				case 'JS':
				{
					$site['referrer'] = addslashes_js($site['referrer']);
					$site['count'] = addslashes_js($site['count']);
					$output .= "\treferrers[] = new referrer('$site[referrer]', $site[count]);\r\n";
				}
				break;
				case 'XML':
				{
					$xml->add_group('referrer');
						$xml->add_tag('referrer', $site['referrer']);
						$xml->add_tag('count', $site['count']);
					$xml->close_group('referrer');
				}
				break;
				default:
				{
					fetch_percent_color($site['count'], $total_count);	
					$templater = vB_Template::create('psistats_refsitebit');
						$templater->register('site', $site);
						$templater->register('color', $color);
						$templater->register('percent', $percent);
						$templater->register('real_percent', $real_percent);
					$refsitebit .= $templater->render();
				}
			}
		}
	}
	
	switch ($vbulletin->GPC['output'])
	{
		case 'JS':
		{
			exit($output);
		}
		break;
		case 'XML':
		{
			$xml->close_group('source');
			$output .= $xml->output();
			unset($xml);
			exit($output);
		}
		break;
		default:
	}
	
	// shell vars
	$shell_vars = array(
		'refsitebit'
	);
}

######################################################################################
######################################################################################
######################################################################################

if ($_REQUEST['do'] == 'referrers')
{
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	if (!$show_modules['stats_referrers']) { print_no_permission(); }
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

	// fetch referred users
	$get_referred_users = $db->query_read("
		SELECT userid, username, referrerid
		FROM " . TABLE_PREFIX . "user
		WHERE referrerid > 0
	");
	
	$referrers = array();
	$total_referred_users = $db->num_rows($get_referred_users);
	if ($total_referred_users > 0)
	{
		// construct an array of which referrerid's referred which users
		while ($userinfo = $db->fetch_array($get_referred_users))
		{
			if (!isset($referrers[$userinfo['referrerid']])) { $referrers[$userinfo['referrerid']] = array(); }
			$referrers[$userinfo['referrerid']][$userinfo['username']] = $userinfo;
		}

		// fetch information about referrers
		$get_referrers = $db->query_read("
			SELECT userid, username, customtitle, usertitle, usergroupid, displaygroupid, referrerid
			FROM " . TABLE_PREFIX . "user
			WHERE userid IN (" . implode(',', array_keys($referrers)) . ")
		");
		
		$referrer_cache = array();
		if ($db->num_rows($get_referrers))
		{
			// construct an array of information about referrers grouped by referred user count
			while ($userinfo = $db->fetch_array($get_referrers))
			{
				$referred_users = sizeof($referrers[$userinfo['userid']]);
				if (!isset($referrer_cache[$referred_users])) { $referrer_cache[$referred_users] = array(); }
				$referrer_cache[$referred_users]["$userinfo[username]"] = array(
					'userid'		=> $userinfo['userid'],
					'username'		=> $userinfo['username'],
					'musername'		=> fetch_musername($userinfo),
					'usertitle'		=> ($userinfo['customtitle'] == 2 ? htmlspecialchars_uni($userinfo['usertitle']) : $userinfo['usertitle']),
				);
			}
			
			// sort referrers by referred user count
			krsort($referrer_cache);
			
			// construct referrerbit
			$referrerbit = '';
			foreach ($referrer_cache as $referred_users => $referrer_list)
			{
				foreach ($referrer_list as $username => $referrerdata)
				{
					fetch_percent_color($referred_users, $total_referred_users);	
					
					// make a referrerid variable for easier template access
					$referrerid =& $referrerdata['userid'];
					
					// sort refusers of this referrer by username			
					ksort($referrers[$referrerdata['userid']]);
					
					// construct referred user bit
					$referreduserbit = '';
					foreach ($referrers[$referrerdata['userid']] as $referreduser)
					{
						$templater = vB_Template::create('psistats_referreduserbit');
							$templater->register('referreduser', $referreduser);
							$templater->register('referreduserbit', $referreduserbit);
						$referreduserbit .= $templater->render();
					}
					
					// build referrerbit
					$templater = vB_Template::create('psistats_referrerbit');
						$templater->register('referrerid', $referrerid);
						$templater->register('referrerdata', $referrerdata);
						$templater->register('referreduserbit', $referreduserbit);
						$templater->register('referred_users', $referred_users);
						$templater->register('color', $color);
						$templater->register('percent', $percent);
						$templater->register('real_percent', $real_percent);
					$referrerbit .= $templater->render();
				}
			}
		}
	}
	
	// shell vars
	$shell_vars = array(
		'total_referred_users',
		'referrerbit'
	);
}

######################################################################################
######################################################################################
######################################################################################

if ($_REQUEST['do'] == 'demographics')
{
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	if (!$show_modules['stats_demographics']) { print_no_permission(); }
	// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	
	// fetch total users
	$total_users = 0;
	
	// define groups
	$groups = array(
		1 => array(-1,20,0,''),
		2 => array(20,29,0,''),
		3 => array(30,39,0,''),
		4 => array(40,49,0,''),
		5 => array(50,59,0,''),
		6 => array(60,69,0,''),
		7 => array(70,-1,0,'')
	);
	
	// process groups
	$age_groupbit = '';
	foreach ($groups as $groupid => $groupinfo)
	{
		// fetch set data
		if ($groupinfo[0] == -1)
		{
			$count = $db->query_first("
				SELECT COUNT(*) as X
				FROM " . TABLE_PREFIX . "user 
				WHERE YEAR(birthday_search) <> '0000'
				AND CAST(birthday_search AS DATE) > DATE_SUB(CURDATE(), INTERVAL " . $groupinfo[1] . " YEAR)
			");
			$groups[$groupid][3] = construct_phrase($vbphrase['psistats_demographics_under_x'], $groupinfo[1]);
		}
		else if ($groupinfo[1] == -1)
		{
			$count = $db->query_first("
				SELECT COUNT(*) as X
				FROM " . TABLE_PREFIX . "user
				WHERE YEAR(birthday_search) <> '0000'
				AND CAST(birthday_search AS DATE) < DATE_SUB(CURDATE(), INTERVAL " . $groupinfo[0] . " YEAR)
			");
			$groups[$groupid][3] = construct_phrase($vbphrase['psistats_demographics_over_x'], $groupinfo[0]);
		}
		else
		{
			$count = $db->query_first("
				SELECT COUNT(*) as X
				FROM " . TABLE_PREFIX . "user
				WHERE CAST(birthday_search AS DATE) BETWEEN
					DATE_SUB(CURDATE(), INTERVAL " . $groupinfo[1] . " YEAR) AND 
					DATE_SUB(CURDATE(), INTERVAL " . $groupinfo[0] . " YEAR)
			");
			$groups[$groupid][3] = construct_phrase($vbphrase['psistats_demographics_x_dash_y'], $groupinfo[0], $groupinfo[1]);
		}
		
		$total_users += $groups[$groupid][2] = $count['X'];
	}
	
	foreach ($groups as $groupid => $groupinfo)
	{
		$grouptitle = $groupinfo[3];
		$user_count = $groups[$groupid][2];
		fetch_percent_color($user_count, $total_users);
		
		// build groupbit
		$templater = vB_Template::create('psistats_demographics_groupbit');
			$templater->register('grouptitle', $grouptitle);
			$templater->register('color', $color);
			$templater->register('percent', $percent);
			$templater->register('real_percent', $real_percent);
			$templater->register('user_count', $user_count);
		$age_groupbit .= $templater->render();
	}
	
	// gender demographics
	$show['gender_demographics'] = false;
	if ($vbulletin->options['psistats_demographics_gender_field'])
	{
		$show['gender_demographics'] = true;
		
		// initialize variables
		$gender_field = explode('.', $vbulletin->options['psistats_demographics_gender_field']);
		$male_response =& $vbulletin->options['psistats_demographics_gender_male'];
		$female_response =& $vbulletin->options['psistats_demographics_gender_female'];
		
		// fetch total users
		$total_users = $vbulletin->userstats['numbermembers'];
		
		// construct groups
		$groups = array();
		
		$count = $db->query_first("
			SELECT COUNT(*) as X
			FROM " . TABLE_PREFIX . $gender_field[0] . "
			WHERE " . $gender_field[1] . " = '" . $db->escape_string($male_response) . "'
		");
		$groups['male'] = $count['X'];
		
		$count = $db->query_first("
			SELECT COUNT(*) as X
			FROM " . TABLE_PREFIX . $gender_field[0] . "
			WHERE " . $gender_field[1] . " = '" . $db->escape_string($female_response) . "'
		");
		$groups['female'] = $count['X'];
		
		$groups['undisclosed'] = $total_users - ($groups['male'] + $groups['female']);
		
		// process gender data
		$gender_groupbit = '';
		foreach ($groups as $groupid => $user_count)
		{
			$grouptitle = $vbphrase['psistats_demographics_gender_' . $groupid];
			fetch_percent_color($user_count, $total_users);
			
			// build groupbit
			$templater = vB_Template::create('psistats_demographics_groupbit');
				$templater->register('grouptitle', $grouptitle);
				$templater->register('color', $color);
				$templater->register('percent', $percent);
				$templater->register('real_percent', $real_percent);
				$templater->register('user_count', $user_count);
			$gender_groupbit .= $templater->render();
		}
	}
	
	// shell vars
	$shell_vars = array(
		'age_groupbit',
		'gender_groupbit'
	);
}

######################################################################################
######################################################################################
######################################################################################

$version = $db->query_first("SELECT version FROM " . TABLE_PREFIX . "product WHERE productid = 'psistats' LIMIT 1");
$version = $version['version'];

$navbits = construct_navbits(array(
	'psistats.php'	=>	$vbphrase['psistats_psistats'],
	''				=>	$vbphrase['psistats_' . $_REQUEST['do']]
));
$navbar = render_navbar_template($navbits);
$templater = vB_Template::create('psistats_footer');
	$templater->register('show_modules', $show_modules);
	$templater->register('version', $version);
$psistats_footer = $templater->render();
$templater = vB_Template::create('PSISTATS_' . strtoupper($_REQUEST['do']));
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('psistats_footer', $psistats_footer);
	foreach ($shell_vars as $var_name)
	{
		$templater->register($var_name, $$var_name);
	}
print_output($templater->render());

/*======================================================================*\
|| #################################################################### ||
|| # psiStats 2010 for vBulletin 4.0.x by Psionic Vision
|| #################################################################### ||
\*======================================================================*/
?>