
# Table: 'arrowchat'
CREATE TABLE IF NOT EXISTS `arrowchat` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `from` varchar(255) character set utf8 NOT NULL,
  `to` varchar(255) character set utf8 NOT NULL,
  `message` text character set utf8 NOT NULL,
  `sent` int(10) unsigned NOT NULL,
  `read` int(10) unsigned NOT NULL,
  `user_read` tinyint(1) NOT NULL default '0',
  `direction` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  INDEX (`to`),
  INDEX (`read`),
  INDEX (`user_read`)
);


# Table: 'arrowchat_admin'
CREATE TABLE IF NOT EXISTS `arrowchat_admin` (
  `id` int(3) NOT NULL auto_increment,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  PRIMARY KEY  (`id`)
);


# Table: 'arrowchat_applications'
CREATE TABLE IF NOT EXISTS `arrowchat_applications` (
  `id` int(3) NOT NULL auto_increment,
  `name` varchar(255) character set utf8 collate utf8_bin NOT NULL,
  `folder` varchar(255) character set utf8 collate utf8_bin NOT NULL,
  `icon` varchar(255) character set utf8 collate utf8_bin NOT NULL,
  `width` int(4) NOT NULL,
  `height` int(4) NOT NULL,
  `link` varchar(255) default NULL,
  `update_link` varchar(255) default NULL,
  `version` varchar(20) default NULL,
  `active` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`id`)
);


# Table: 'arrowchat_banlist'
CREATE TABLE IF NOT EXISTS `arrowchat_banlist` (
  `ban_id` int(10) NOT NULL auto_increment,
  `ban_userid` int(15) default NULL,
  `ban_ip` varchar(255) default NULL,
  PRIMARY KEY  (`ban_id`)
);


# Table: 'arrowchat_config'
CREATE TABLE IF NOT EXISTS `arrowchat_config` (
  `config_name` varchar(255) character set utf8 collate utf8_bin NOT NULL,
  `config_value` varchar(255) character set utf8 collate utf8_bin NOT NULL,
  `is_dynamic` tinyint(1) unsigned NOT NULL default '0',
  UNIQUE KEY `config_name` (`config_name`)
);


# Table: 'arrowchat_notifications'
CREATE TABLE IF NOT EXISTS `arrowchat_notifications` (
  `id` int(25) NOT NULL auto_increment,
  `to_id` int(25) NOT NULL,
  `author_id` int(25) NOT NULL,
  `author_name` varchar(255) NOT NULL,
  `type` int(3) NOT NULL,
  `alert_read` int(1) NOT NULL default '0',
  `user_read` int(1) NOT NULL default '0',
  `alert_time` int(15) NOT NULL,
  PRIMARY KEY  (`id`),
  INDEX (`to_id`)
);


# Table: 'arrowchat_notifications_markup'
CREATE TABLE IF NOT EXISTS `arrowchat_notifications_markup` (
  `id` int(10) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  `type` int(3) NOT NULL,
  `markup` text NOT NULL,
  PRIMARY KEY  (`id`)
);


# Table: 'arrowchat_smilies'
CREATE TABLE IF NOT EXISTS `arrowchat_smilies` (
  `id` int(3) NOT NULL auto_increment,
  `name` varchar(20) NOT NULL,
  `code` varchar(10) NOT NULL,
  PRIMARY KEY  (`id`)
);


# Table: 'arrowchat_status'
CREATE TABLE IF NOT EXISTS `arrowchat_status` (
  `userid` int(10) unsigned NOT NULL,
  `message` text character set utf8,
  `status` varchar(10) character set utf8 default NULL,
  `theme` int(3) default NULL,
  `popout` int(11) default NULL,
  `typing` text,
  `hide_bar` tinyint(1) default NULL,
  `play_sound` tinyint(1) default NULL,
  `window_open` tinyint(1) default NULL,
  `only_names` tinyint(1) default NULL,
  `unfocus_chat` text,
  `focus_chat` varchar(20) default NULL,
  `last_message` text,
  `session_time` int(20) NOT NULL,
  `hash_id` varchar(20) NOT NULL,
  PRIMARY KEY  (`userid`),
  INDEX (`hash_id`)
);


# Table: 'arrowchat_themes'
CREATE TABLE IF NOT EXISTS `arrowchat_themes` (
  `id` int(3) NOT NULL auto_increment,
  `folder` varchar(25) NOT NULL,
  `name` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `default` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`)
);


# Table: 'arrowchat_trayicons'
CREATE TABLE IF NOT EXISTS `arrowchat_trayicons` (
  `id` int(3) NOT NULL auto_increment,
  `name` varchar(100) character set utf8 collate utf8_bin NOT NULL,
  `icon` varchar(255) NOT NULL,
  `location` varchar(255) NOT NULL,
  `target` varchar(25) default NULL,
  `width` int(4) default NULL,
  `height` int(4) default NULL,
  `tray_width` int(3) default NULL,
  `tray_name` varchar(100) character set utf8 collate utf8_bin default NULL,
  `tray_location` int(3) NOT NULL,
  `active` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`id`)
);