<?php

	// This sometimes happens
	if (!isset($GLOBALS['vbulletin']->db)) exit();

	// Let's define a set of flags
	define (VBGHSFS_NO_TEST, -1);
	define (VBGHSFS_PASS, 0);
	define (VBGHSFS_FAIL, 1);
	define (VBGHSFS_HIT_BUT_PASS, 2);
	define (VBGHSFS_REMOTE_ERROR, 3);
	define (VBGHSFS_BLOCKED, 1);
	define (VBGHSFS_ALLOWED, 0);

	// And few variables
	global $vbghsfs_userHash, $vbghsfs_CacheHit;

	/**
	* Function called on 'register_addmember_complete' hook
	*/
	function VBGHSFS_UpdateLog() {

		global $vbulletin, $vbghsfs_userHash;

		$sql = 'UPDATE '.TABLE_PREFIX.'glowhostspamomatic_log SET `user_id` = "'.$vbulletin->userinfo['userid'].'" WHERE `user_hash` = "'.$vbghsfs_userHash.'"; ';
		$logresult = $vbulletin->db->query($sql);
	}

	/**
	* Function called on 'register_addmember_process' hook
	*/
	function VBGHSFS_Process() {

		global $vbulletin, $userdata;

		$ip = $vbulletin->session->vars['host'];
		$username = $vbulletin->userinfo['username'];
		$email = $vbulletin->GPC['email'];
		if (($email == '') && (isset($userdata))) { // hook for new FB Connect procedures
			$username = $userdata->fetch_field('username');
			$email = $userdata->fetch_field('email');
		}

		if (($username != '') && ($username != 'Unregistered')) { //disable check if not set
			$result = VBGHSFS_checkForSpam($username, 'username');
			if ($result !== VBGHSFS_NO_TEST) {
				VBGHSFS_Action('username', $username, $username, $email, $ip, $result);
			}
		}

		if ($email != '') { //disable check if not set
			$result = VBGHSFS_checkForSpam($email, 'email');
			if ($result !== VBGHSFS_NO_TEST) {
				VBGHSFS_Action ('email', $email, $username, $email, $ip, $result);
			}
		}

		$result = VBGHSFS_checkForSpam($ip, 'ip');
		if ($result !== VBGHSFS_NO_TEST) {
			VBGHSFS_Action('ip', $ip, $username, $email, $ip, $result);
		}

		VBGHSFS_Log($field, $data.'Passed StopForumSpam checks. Sent to vBulletin Registration System.', $username, $email, $ip, VBGHSFS_ALLOWED);
	}

	/**
	* Function to check for SPAM
	* @param string $data Query param content
	* @param string $field Query param name
	* @return SPAM flag
	*/
	function VBGHSFS_checkForSpam($data, $field) {

		global $vbulletin;

		if ($vbulletin->options['glowhostspamomatic_testfield_'. $field]) {
			switch (VBGHSFS_CacheHit($data, $field)) {
				case 1: // Found in cache - SPAM
					$is_spam = VBGHSFS_FAIL;
					break;

				case 2: // Found in cache - OK
					$is_spam = VBGHSFS_PASS;
					break;

				case 0:  // Not found in cache - test
					switch ($field) {
						case 'username':
							$is_spam = VBGHSFS_getXML('http://www.stopforumspam.com/api?username='.urlencode($data).'&f=serial', $field);
							break;

						case 'email':
							$is_spam = VBGHSFS_getXML('http://www.stopforumspam.com/api?email='.urlencode($data).'&f=serial', $field);
							break;

						case 'ip':
							$is_spam = VBGHSFS_getXML('http://www.stopforumspam.com/api?ip='.urlencode($data).'&f=serial', $field);
							break;
					}


	  				break;
	  		}

	  		if ($is_spam !== VBGHSFS_REMOTE_ERROR) VBGHSFS_updateCache($data, $is_spam, $field);

	  } else return VBGHSFS_NO_TEST; // no test performed

 		return $is_spam;
	}

	/**
	* Function to check if spam flag cached and remove old records
	* @param string $data Query param content
	* @param string $field Query param name
	* @return true
	*/
	function VBGHSFS_CacheHit($data, $field) {

		global $vbulletin, $vbghsfs_Purged, $vbghsfs_CacheHit;

		$vbghsfs_CacheHit = false;

		if (!$vbghsfs_Purged) { //must remove old records
			$sql = 'DELETE FROM '.TABLE_PREFIX.'glowhostspamomatic_remotecache WHERE `date` < DATE_SUB(NOW(), INTERVAL '.(int)$vbulletin->options['glowhostspamomatic_remote_cache'].' DAY); ';
			$vbulletin->db->query($sql);
			$vbghsfsPurged = true;
		}

		$sql = 'SELECT is_spambot FROM '.TABLE_PREFIX.'glowhostspamomatic_remotecache WHERE `field`="'.$field.'" AND `data`="'.addslashes($data).'" LIMIT 1';
		$result = $vbulletin->db->query($sql);

		$line = $vbulletin->db->fetch_array($result);
  		if (!empty($line)) {
  			$vbghsfs_CacheHit = true;

  			if ($line['is_spambot'] > 0) return VBGHSFS_FAIL;
  			if ($line['is_spambot'] == 0) return VBGHSFS_HIT_BUT_PASS;
  		}

		return VBGHSFS_PASS; //no hit. Must check
	}

	/**
	* Function to connect to stopforumspam.com
	* @param string $url URL to connect to
	* @return query result
	*/
	function VBGHSFS_getXML($url, $field = '') {
		global $vbulletin;

		$curl_installed = (function_exists('curl_init'));
		$curl_failed = false;

	    if (($vbulletin->options['glowhostspamomatic_curluse']) && ($curl_installed)) {

	        $cURL = curl_init();
	        curl_setopt($cURL, CURLOPT_URL, $url);
	        curl_setopt($cURL, CURLOPT_RETURNTRANSFER, 1);
	        curl_setopt($cURL, CURLOPT_TIMEOUT, '15');

	        if (($vbulletin->options['glowhostspamomatic_curlip']) && ($vbulletin->options['glowhostspamomatic_curlport'])) {
	            curl_setopt($cURL, CURLOPT_PROXY, "{$vbulletin->options['glowhostspamomatic_curlip']}:{$vbulletin->options['glowhostspamomatic_curlport']}");
	        }

	        $pageContent = curl_exec($cURL);

			if (curl_errno($cURL)) { // cURL failed
    			if (!($pageContent = @file_get_contents($url))) return VBGHSFS_REMOTE_ERROR;
	        }

	        curl_close($cURL);

	    } else if (!($pageContent = @file_get_contents($url))) return VBGHSFS_REMOTE_ERROR;

	    $pageContent = unserialize($pageContent);
	    if ($pageContent[$field]['appears']) {

			$sql = 'SELECT DATEDIFF(NOW(), "'.$pageContent[$field]['lastseen'].'") AS DAYS';
    		$result = $vbulletin->db->query($sql);
    		$line = $vbulletin->db->fetch_array($result);
    		$days = $line['DAYS'];
    		$result = ($days > $vbulletin->options['glowhostspamomatic_expire_day'])?VBGHSFS_PASS:VBGHSFS_FAIL; //user appears in SFS DB. but the entry is too old

	    } else $result = VBGHSFS_PASS;

		/*
		$parser = xml_parser_create('UTF-8');
		xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
		xml_parse_into_struct($parser, $pageContent, $vals, $index);
		xml_parser_free($parser);

	    $appears = ($vals[$index['APPEARS'][0]]['value']);

	    if (!$appears) return VBGHSFS_REMOTE_ERROR;

	    if ($appears == 'yes') {

    		$lastseen = $vals[$index['LASTSEEN'][0]]['value'];
    		$sql = 'SELECT DATEDIFF(NOW(), "'.$lastseen.'") AS DAYS';
    		$result = $vbulletin->db->query($sql);
    		$line = $vbulletin->db->fetch_array($result);
    		$days = $line['DAYS'];
    		$result = ($days > $vbulletin->options['glowhostspamomatic_expire_day'])?VBGHSFS_PASS:VBGHSFS_FAIL; //user appears in SFS DB. but the entry is too old

	    } else $result = VBGHSFS_PASS;
	    */

	    return $result;
	}

	/**
	* Function to save result in cache
	* @param string $data Query param content
	* @param string $is_spambot Is SPAM flag
	* @param string $field Query param name
	*/
	function VBGHSFS_updateCache($data, $is_spambot, $field) {

		global $vbulletin, $vbghsfs_CacheHit;

		if (!$vbghsfs_CacheHit) {
			$sql = 'INSERT HIGH_PRIORITY IGNORE INTO '.TABLE_PREFIX.'glowhostspamomatic_remotecache(`date`, `data`, `is_spambot`, `field`) VALUES (now(), "'.addslashes($data).'", "'.$is_spambot.'", "'.$field.'"); ';
			$vbulletin->db->query($sql);
		}
	}

	/**
	* Function to add log into cache
	* @param string $field Query param name
	* @param string $data Query param content
	* @param string $username User login
	* @param string $email User e-mail
	* @param string $ip User IP
	* @param string $is_blocked Is blocked flag
	*/
	function VBGHSFS_Log($field, $data, $username, $email, $ip, $is_blocked, $predefined_message = '') {

		global $vbulletin, $vbghsfs_userHash;

		if (($username == 'Unregistered') || ($username == '')) $username = 'No Username Submitted';

		$prefix = 'Spam-O-Matic Tagged '.$field.' - ';
		if ($field == '') $prefix = '';
		$message = $prefix.$data;
		$vbghsfs_userHash = md5(date('l jS \of F Y h:i:s A').$username);
		if ($predefined_message != '') $message = $predefined_message;
		$sql = 'INSERT INTO '.TABLE_PREFIX.'glowhostspamomatic_log(`date`, `ip`, `email`, `username`, `message`, `is_blocked`, `user_hash`) VALUES (now(), "'.addslashes($ip).'", "'.addslashes($email).'", "'.addslashes($username).'", "'.addslashes($message).'", "'.$is_blocked.'", "'.$vbghsfs_userHash.'"); ';
		$vbulletin->db->query($sql);
	}

	/**
	* Function to perform required actions based on setting and SPAM check
	* @param string $field Query param name
	* @param string $data Query param content
	* @param string $username User login
	* @param string $email User e-mail
	* @param string $ip User IP
	* @param string $resultcode SPAM check result code
	*/
	function VBGHSFS_Action($field, $data, $username, $email, $ip, $resultcode) {

		global $vbulletin;

		settype($resultcode, 'int');

		if ($resultcode == VBGHSFS_REMOTE_ERROR) { //SPAM check failed
			if ($vbulletin->options['glowhostspamomatic_result'] == 0) { // Log result, but allow registration
				VBGHSFS_Log($field, $data.' REMOTE_ERROR: Allowed by policy', $username, $email, $ip, VBGHSFS_ALLOWED);
			} else {
				if ($vbulletin->options['glowhostspamomatic_result_timeout'] == 1) { // Connection result timeout
					VBGHSFS_Log($field, $data . " REMOTE_ERROR: Unverfied and rejected by policy ", $username, $email, $ip, VBGHSFS_BLOCKED);
					standard_error(fetch_error('vbstopformspam_reject_connectionerror', $query));
				} else {
					VBGHSFS_Log($field, $data . " REMOTE_ERROR: Unverfied but allowed by policy", $username, $email, $ip, VBGHSFS_ALLOWED);
				}
			}
		} elseif ($resultcode == VBGHSFS_FAIL) { // SPAM detected
			if ($vbulletin->options['glowhostspamomatic_result'] == 0) { // Allow
				VBGHSFS_Log($field, $data.' - Spammer Found but allowed.', $username, $email, $ip, VBGHSFS_ALLOWED);
			} else { // Reject
				VBGHSFS_Log($field, $data.' - Spammer Found and rejected.', $username, $email, $ip, VBGHSFS_BLOCKED);
				standard_error(fetch_error('glowhostspamomatic_reject', $query));
			}
		}
	}

	/**
	* Function to show current SFS DB user status and a form to ban or remove user with additional options. Another part used here to redirect to
	* ban or remove dialog saving additional params in session var to be done on other hooks
	*/
	function VBGHSFS_UserEditCode() {

		global $vbulletin, $user, $vbphrase;

		if (isset($_REQUEST['ghsfs_action'])) { //save sesion params for other hooks

			session_start();

			$_SESSION['ghsfs_user_edit'] = array(
				'action' => $_REQUEST['ghsfs_action'],
				'username' => $user['username'],
				'email' => $user['email'],
				'ip' => $user['ipaddress'],
				'id' => $user['userid']
			);
			if (isset($_REQUEST['ghsfs_remove_posts'])) $_SESSION['ghsfs_user_edit']['remove_posts'] = true;
			else $_SESSION['ghsfs_user_edit']['remove_posts'] = false;
			if (isset($_REQUEST['ghsfs_report_spam'])) $_SESSION['ghsfs_user_edit']['report_spam'] = true;
			else $_SESSION['ghsfs_user_edit']['report_spam'] = false;

			session_commit();

			//action based redirect
			if ($_REQUEST['ghsfs_action'] == 0) {
				$print_code = '<script>
									pick_a_window("../modcp/banning.php?do=banuser&u='.$user['userid'].'");
								</script>';
			} else {
				$print_code = '<script>
									pick_a_window("user.php?do=remove&u='.$user['userid'].'");
								</script>';
			}
			print_label_row($print_code);

			return true;
		}



		if ((!is_member_of($user['usergroupid'], 6)) && ($vbulletin->GPC['userid'] > 1)) { //no report option for Administrators

			print_table_break('', $INNERTABLEWIDTH);
			print_table_header('GlowHost - Spam-O-Matic');
			if ($vbulletin->options["glowhostspamomatic_apikey"]) {
				//let's create HTML output here. We need to show SFS user status if known and a new form to submit user to SFS DB
				$print_code = '<script>
					function $(id) {
						return document.getElementById(id);
					}

					function ghsfs_submit_form() {
						var add_params = "";
						if ($("ghsfs_action0").checked) add_params = "&ghsfs_action=0";
						else add_params = "&ghsfs_action=1";
						if ($("ghsfs_remove_posts").checked) add_params = add_params + "&ghsfs_remove_posts=1";
						if ($("ghsfs_report_spam").checked) add_params = add_params + "&ghsfs_report_spam=1";

						//alert(add_params);

						pick_a_window("user.php?do=edit&u='.$user['userid'].'" + add_params);
					}
				</script>';
				$sql = 'SELECT is_blocked FROM '.TABLE_PREFIX.'glowhostspamomatic_log WHERE user_id='.$user['userid'];
				$result = $vbulletin->db->query($sql);
				$line = $vbulletin->db->fetch_array($result);
  				if (!empty($line)) {
  					$print_code .= 'StopForumSpam.com status: <b>'.(($line['is_blocked'] == 0)?'OK':'SPAM').'</b><br><br>';
  				}
				$print_code .= 'You can ban or remove the user along with removing all the posts and submitting profile details to StopForumSpam.com:<br>';
				$print_code .= '<input type="radio" name="ghsfs_action" id="ghsfs_action0" value="0" checked> Ban user<br>';
				$print_code .= '<input type="radio" name="ghsfs_action" id="ghsfs_action1" value="1"> Remove user<br>';
				$print_code .= '<input type="checkbox" name="ghsfs_remove_posts" id="ghsfs_remove_posts" value="1"> Remove All Posts<br>';
				$print_code .= '<input type="checkbox" name="ghsfs_report_spam" id="ghsfs_report_spam" value="1"> Submit to StopForumSpam.com<br>';
				$print_code .= '<input onclick="ghsfs_submit_form()" type="button" class="button" value="'.$vbphrase['submit'].'"/>';

				print_label_row($print_code);
			} else {
				print_label_row('You need an API key from www.stopforumspam.com before you can submit to the database' ,'');
			}
		}
	}

	/**
	* Function to be called on ban and remove user operations and to perform additional actions on user profile based on session vars
	*/
	function VBGHSFS_UserEditComplete() {
		session_start();

		//print_r($_SESSION);

		if (isset($_SESSION['ghsfs_user_edit'])) {
			if ($_SESSION['ghsfs_user_edit']['remove_posts']) { //this is definitely ALPHA code. HOOK: userdata_delete

				$sql = 'DELETE FROM '.TABLE_PREFIX.'post WHERE userid='.$_SESSION['ghsfs_user_edit']['id'].'); ';
				$vbulletin->db->query($sql);

				$sql = 'DELETE FROM '.TABLE_PREFIX.'thread WHERE postuserid='.$_SESSION['ghsfs_user_edit']['id'].'); ';
				$vbulletin->db->query($sql);
			}

			if ($_SESSION['ghsfs_user_edit']['report_spam']) { //HOOK: userdata_postsave

				$url = 'http://www.stopforumspam.com/add.php?username='.$_SESSION['ghsfs_user_edit']['username'].'&email='.$_SESSION['ghsfs_user_edit']['email'].'&ip_addr='.$_SESSION['ghsfs_user_edit']['ip'].'&api_key='.$vbulletin->options["glowhostspamomatic_apikey"];


				if (function_exists('curl_init')) {

					$cURL = curl_init();
					curl_setopt($cURL, CURLOPT_URL, $url);
					curl_setopt($cURL, CURLOPT_TIMEOUT, '15');

					if (($vbulletin->options['glowhostspamomatic_curlip']) && ($vbulletin->options['glowhostspamomatic_curlport'])) {
						curl_setopt($cURL, CURLOPT_PROXY, "{$vbulletin->options['glowhostspamomatic_curlip']}:{$vbulletin->options['glowhostspamomatic_curlport']}");
					}

				   curl_exec($cURL);

					if (curl_errno($cURL)) { // cURL failed
    					@file_get_contents($url);
					}

					curl_close($cURL);

				} else @file_get_contents($url);
				

				//log write this user as spambot
				VBGHSFS_Log('ip', $_SESSION['ghsfs_user_edit']['ip'], $_SESSION['ghsfs_user_edit']['username'], $_SESSION['ghsfs_user_edit']['email'], $_SESSION['ghsfs_user_edit']['ip'], 1, 'User data submitted to StopForumSpam.com database');

			}


		}

		unset($_SESSION['ghsfs_user_edit']);


		session_commit();
	}

	/**
	* Function to submit user details to SFS DB if admin decided so while banning users from Moderation Tools
	* @param string $request Request string
	* @param string $host Hostname
	* @param string $path Path
	* @param string $port Post, default 80
	* @return Result array
	*/
	function VBGHSFS_UserModeratorBan() {
		global $vbulletin, $userid;

		if (isset($_POST['do'])) if ($_POST['do'] == 'dodeletespam')  {
			if (($vbulletin->options['glowhostspamomatic_do_submit_moderation'] == '1') && ($vbulletin->options["glowhostspamomatic_apikey"] != '')) {

				$sql = 'SELECT username, email, ipaddress FROM `'.TABLE_PREFIX.'user` WHERE userid='.$userid;
				$result = $vbulletin->db->query($sql);

				$line = $vbulletin->db->fetch_array($result);
  				if (!empty($line)) {

  					$url = 'http://www.stopforumspam.com/add.php?username='.$line['username'].'&email='.$line['email'].'&ip_addr='.$line['ipaddress'].'&api_key='.$vbulletin->options["glowhostspamomatic_apikey"];

					if (function_exists('curl_init')) {

						$cURL = curl_init();
						curl_setopt($cURL, CURLOPT_URL, $url);
						curl_setopt($cURL, CURLOPT_TIMEOUT, '15');

						if (($vbulletin->options['glowhostspamomatic_curlip']) && ($vbulletin->options['glowhostspamomatic_curlport'])) {
						    curl_setopt($cURL, CURLOPT_PROXY, "{$vbulletin->options['glowhostspamomatic_curlip']}:{$vbulletin->options['glowhostspamomatic_curlport']}");
						}

					   curl_exec($cURL);

						if (curl_errno($cURL)) { // cURL failed
    						@file_get_contents($url);
						}

						curl_close($cURL);

					} else @file_get_contents($url);

					//log write this user as spambot
					VBGHSFS_Log('ip', $line['ipaddress'], $line['username'], $line['email'], $line['ipaddress'], 1, 'User data submitted to StopForumSpam.com database');
  				}
			}

			if (($vbulletin->options['glowhostspamomatic_akismet_enabled'] == 1) && ($vbulletin->options['glowhostspamomatic_akismet_do_submit_moderation'] == '1') && ($vbulletin->options["glowhostspamomatic_akismet_key"] != '')) {

				$sql = 'SELECT username, email, ipaddress FROM `'.TABLE_PREFIX.'user` WHERE userid='.$userid;
				$result = $vbulletin->db->query($sql);

				$line = $vbulletin->db->fetch_array($result);
  				if (!empty($line)) {

  					$key = $vbulletin->options['glowhostspamomatic_akismet_key'];
					$vbghsfs_host = $key.'.rest.akismet.com';

					$comment['user_ip'] = $line['ipaddress'];
					$comment['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
					$comment['referrer'] = $_SERVER['HTTP_REFERER'];
					$comment['blog'] = $vbulletin->options['bburl'];
					$comment['comment_author'] = $line['username'];
					$comment['comment_content'] = '';


					$query_string = '';
					foreach ($comment as $key => $data) $query_string .= $key.'='.urlencode(stripslashes($data)).'&';
					$response = VBGHSFS_AkismetRemoteCall($query_string, $host, '/1.1/submit-spam', 80);

					VBGHSFS_Log('ip', $line['ipaddress'], $line['username'], $line['email'], $line['ipaddress'], 0, 'User data submitted to Akismet database');

  				}
			}
		}
	}

	/**
	* Function to make AKISMET service call
	* @param string $request Request string
	* @param string $host Hostname
	* @param string $path Path
	* @param string $port Post, default 80
	* @return Result array
	*/
	function VBGHSFS_AkismetRemoteCall($request, $host, $path, $port = 80) {
		$http_request  = "POST $path HTTP/1.0\r\n";
		$http_request .= "Host: $host\r\n";
		$http_request .= "Content-Type: application/x-www-form-urlencoded;\r\n";
		$http_request .= "Content-Length: " . strlen($request) . "\r\n";
		$http_request .= "User-Agent: GHSFS/1.0 | Akismet/1.14\r\n";
		$http_request .= "\r\n";
		$http_request .= $request;

		$response = '';
		$fs = @fsockopen($host, $port, $errno, $errstr, 3);
		if ($fs !== false) {
			fwrite($fs, $http_request);
			while (!feof($fs)) $response .= fgets($fs, 1160);
			fclose($fs);
			$response = explode("\r\n\r\n", $response, 2);
		}
		return $response;
	}

	/**
	* Function to verify AKISMET key
	* @param string $key AKISMET key to verify
	* @return Bool result
	*/
	function VBGHSFS_AkismetVerifyKey($key) {
		$blog = urlencode('http://www.worldwidecreations.com/php_perl_help');
		$response = VBGHSFS_AkismetRemoteCall("key=$key&blog=$blog", 'rest.akismet.com', '/1.1/verify-key', 80);
		if ($response[1] == 'valid') return true;
		else return false;
	}

	/**
	* Function to check post/thread text aggainst AKISMET service
	* @param string $comment Post/Thread data
	* @param string $host Hostname
	* @return Bool result
	*/
	function VBGHSFS_AkismetCheckComment($comment, $host) {
		$query_string = '';
		foreach ($comment as $key => $data) $query_string .= $key.'='.urlencode(stripslashes($data)).'&';
		$response = VBGHSFS_AkismetRemoteCall($query_string, $host, '/1.1/comment-check', 80);
		if ($response[1] == 'true') { //the post is spam
			VBGHSFS_Log('ip', $comment['user_ip'], $comment['comment_author'], '', $comment['user_ip'], 1, '<a href="/modcp/moderate.php?do=posts">Found in Akismet Database. Held for moderation: '.substr(strip_tags($comment['comment_content']), 0, 50).'</a>');
			return true;
		} else { //the post is ok

			return false;
		}
	}
?>