<?php
/*======================================================================*\
|| #################################################################### ||
|| # vS-Invites System for vBulletin 4.0.x by Anton Kanevsky
|| # License #YW8-PDD7SYVPPS1HXKFH
|| #################################################################### ||
|| # Copyright 2006-2009 Anton Kanevsky (ankan925@gmail.com) aka @kan. All Rights Reserved.
|| # This file may not be redistributed.
|| #################################################################### ||
\*======================================================================*/

##########################################################################################
// set php environment
error_reporting(E_ALL & ~E_NOTICE);
																										
##########################################################################################
// pre-cache templates and data
$specialtemplates = array();
//$phrasegroups = array_merge($phrasegroups, array('user', 'cpuser', 'psionic_invites', 'cprofilefield'));

##########################################################################################
// require back-end
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions.php');
require_once(DIR . '/includes/adminfunctions_profilefield.php');
require_once(DIR . '/includes/adminfunctions_user.php');

##########################################################################################
// verify permissions
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

##########################################################################################
// log admin action
log_admin_action();

##########################################################################################
// start main script
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'invites';
}

if ($_REQUEST['do'] == 'unoptout')
{
	$vbulletin->input->clean_gpc('r', 'email', TYPE_STR);
	
	$db->query_write("
		DELETE FROM `" . TABLE_PREFIX . "noinvite`
		WHERE `email` = '" . $db->escape_string($vbulletin->GPC['email']) . "'
		LIMIT 1
	");
	
	$_REQUEST['do'] = 'noinvite';
}

if ($_REQUEST['do'] == 'noinvite')
{
	print_cp_header($vbphrase['invites_manage_optout']);
	
	$getoptouts = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "noinvite
		ORDER BY `email`
	");
	
	if ($db->num_rows($getoptouts))
	{
		print_form_header('', '');
		print_table_header($vbphrase['invites_manage_optout'], 2);
		
		while ($getoptout = $db->fetch_array($getoptouts))
		{
			print_cells_row(array($getoptout['email'], '<a href="invites.php?do=unoptout&amp;email=' . $getoptout['email'] . '">[' . $vbphrase['invites_optout_remove'] . ']</a>'));
		}
		
		print_table_footer();
	}
	else
	{
		print ($vbphrase['invites_optout_emptydb']);
	}
}

if ($_REQUEST['do'] == 'doinvites')
{
	print_cp_header($vbphrase['invites_allocate_invites']);
	
	$vbulletin->input->clean_array_gpc('p', array(
		'user'              => TYPE_ARRAY,
		'profile'           => TYPE_ARRAY,	
		'invites'			=> TYPE_UINT,
		'notify'			=> TYPE_BOOL,
	));
	
	if ($vbulletin->GPC['invites'])
	{
		$condition = fetch_user_search_sql($vbulletin->GPC['user'], $vbulletin->GPC['profile'], 'user');
		if (!$condition)
		{
			$condition = ' 1=1 ';
		}
		
		$getusers = $db->query_read("
			SELECT user.userid, user.username, user.email, user.options, user.languageid
			FROM " . TABLE_PREFIX . "user as user
			LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (userfield.userid = user.userid)
			LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = user.userid)
			WHERE $condition
		");
		
		if (($amount = $db->num_rows($getusers)) > 0)
		{
			$users = array();
			while($user = $db->fetch_array($getusers))
			{
				$users[$user['userid']] = $user;
			}
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "user
				SET
					invites = invites + {$vbulletin->GPC['invites']}
				WHERE
					userid IN (" . implode(',', array_keys($users)) . ")
			");
			
			print (construct_phrase($vbphrase['invites_allocated_to_x_y_to_each'], $amount, $vbulletin->GPC['invites']));			
			print ('<br />');
			print ('<br />');
			
			if ($vbulletin->GPC['notify'])
			{
				foreach ($users as $userid => $user)
				{
					print (construct_phrase($vbphrase['invites_sending_notification_to_x_y'], $user['username'], $user['email']));
					print (' ');
						
					if ($user['options'] & $vbulletin->bf_misc['useroptions']['adminemail'])
					{
						$email =& $user['email'];
						$username =& $user['username'];
						$bburl =& $vbulletin->options['bburl'];
						$bbtitle =& $vbulletin->options['bbtitle'];
						$invites =& $vbulletin->GPC['invites'];
							
						eval(fetch_email_phrases('invites_allocate_letter', $user['languageid']));
						vbmail($email, $subject, $message, true);
							
						print ($vbphrase['invites_ok']);
					}
					else
					{
						print ($vbphrase['invites_user_noadminemail']);
					}

					print ('<br />');
				}
			}
		}
		else
		{
			print($vbphrase['invites_nomatches']);
			print('<br />');
			print('<br />');
		}
	}
	else
	{
		print($vbphrase['invites_whyburden']);
	}
}

if ($_REQUEST['do'] == 'invites')
{
	print_cp_header($vbphrase['invites_allocate_invites']);

?>
<script type="text/javascript">
<!--
function check_all_usergroups(formobj, toggle_status)
{
	for (var i = 0; i < formobj.elements.length; i++)
	{
		var elm = formobj.elements[i];
		if (elm.type == "checkbox" && elm.name == 'user[usergroupid][]')
		{
			elm.checked = toggle_status;
		}
	}
}
// -->
</script>
<?php

	print_form_header('invites', 'doinvites');
	print_table_header($vbphrase['invites_allocate_invites']);
	print_input_row($vbphrase['invites_allocate_how_many'], 'invites');
	print_yes_no_row($vbphrase['invites_allocate_send_notificatin'], 'notify', 1);

	print_table_break();
	print_table_header($vbphrase['search_criteria']);

	$userarray = array('usergroupid' => 0, 'membergroupids' => '');
	$iusergroupcache = array();
	foreach ($vbulletin->usergroupcache as $usergroupid => $usergroup)
	{
		if (isset($vbulletin->bf_ugp['invites_permissions']) AND $usergroup['invites_permissions'] & $vbulletin->bf_ugp['invites_permissions']['can_invite'])
		{
			$userarray['membergroupids'] .= "$usergroup[usergroupid],";
			$iusergroupcache["$usergroup[usergroupid]"] = $usergroup['title'];
		}
	}
	unset($usergroup);
	$vbulletin->db->free_result($usergroups);
	
	if (sizeof($iusergroupcache))
	{
		print_checkbox_row($vbphrase['all_usergroups'], 'usergroup_all', 0, -1, $vbphrase['all_usergroups'], 'check_all_usergroups(this.form, this.checked);');
		print_membergroup_row($vbphrase['primary_usergroup'], 'user[usergroupid]', 2, $userarray);
	}
		
	print_input_row($vbphrase['email'], 'user[email]');
	print_input_row($vbphrase['parent_email_address'], 'user[parentemail]');
	print_yes_no_other_row($vbphrase['coppa_user'], 'user[coppauser]', $vbphrase['either'], -1);
	print_input_row($vbphrase['user_title'], 'user[usertitle]');
	print_input_row($vbphrase['join_date_is_after'] . '<dfn>(yyyy-mm-dd)</dfn>', 'user[joindateafter]');
	print_input_row($vbphrase['join_date_is_before'] . '<dfn>(yyyy-mm-dd)</dfn>', 'user[joindatebefore]');
	print_input_row($vbphrase['last_activity_is_after'] . '<dfn>(yyyy-mm-dd hh:mm:ss)</dfn>', 'user[lastactivityafter]');
	print_input_row($vbphrase['last_activity_is_before'] . '<dfn>(yyyy-mm-dd hh:mm:ss)</dfn>', 'user[lastactivitybefore]');
	print_input_row($vbphrase['last_post_is_after'] . '<dfn>(yyyy-mm-dd hh:mm:ss)</dfn>', 'user[lastpostafter]');
	print_input_row($vbphrase['last_post_is_before'] . '<dfn>(yyyy-mm-dd hh:mm:ss)</dfn>', 'user[lastpostbefore]');
	print_input_row($vbphrase['birthday_is_after'] . '<dfn>(yyyy-mm-dd)</dfn>', 'user[birthdayafter]');
	print_input_row($vbphrase['birthday_is_before'] . '<dfn>(yyyy-mm-dd)</dfn>', 'user[birthdaybefore]');
	print_input_row($vbphrase['posts_are_greater_than'], 'user[postslower]', '', 1, 7);
	print_input_row($vbphrase['posts_are_less_than'], 'user[postsupper]', '', 1, 7);
	print_input_row($vbphrase['reputation_is_greater_than'], 'user[reputationlower]', '', 1, 7);
	print_input_row($vbphrase['reputation_is_less_than'], 'user[reputationupper]', '', 1, 7);
	print_description_row('<div align="' . $stylevar['right'] .'"><input type="submit" class="button" value=" ' . $vbphrase['submit'] . ' " tabindex="1" /></div>');
	
	print_table_header($vbphrase['user_profile_fields']);
	$profilefields = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "profilefield");
	while ($profilefield = $vbulletin->db->fetch_array($profilefields))
	{
		$profilefield['def'] = 0;
		print_profilefield_row('profile', $profilefield);
	}

	print_table_break();
	print_submit_row($vbphrase['go']);	
}

print_cp_footer();

/*======================================================================*\
|| #################################################################### ||
|| # vS-Invites System for vBulletin 4.0.x by Anton Kanevsky
|| # Downloaded: 21:35, Sat Mar 6th 2010
|| #################################################################### ||
\*======================================================================*/
?>