<?php
/*======================================================================*\
|| #################################################################### ||
|| # vS-Invites System for vBulletin 3.5.x - 3.8.x by Anton Kanevsky
|| #################################################################### ||
|| # Copyright 2006-2009 Anton Kanevsky (ankan925@gmail.com) aka @kan. All Rights Reserved.
|| # This file may not be redistributed.
|| #################################################################### ||
\*======================================================================*/

##########################################################################################
// set php environment
error_reporting(E_ALL & ~E_NOTICE);
if (!is_object($vbulletin->db))
{
	exit;
}

if ($vbulletin->options['invites_enabled'])
{
	##########################################################################################
	// ensure sanity
	$vbulletin->options['invites_expiry_days'] = (intval($vbulletin->options['invites_expiry_days']) > 0 ? intval($vbulletin->options['invites_expiry_days']) : 0);
	$vbulletin->options['invites_cron_notifyperiod'] = (intval($vbulletin->options['invites_cron_notifyperiod']) > 0 ? intval($vbulletin->options['invites_cron_notifyperiod']) : 1);

	##########################################################################################
	// define important constants
	define('ONE_DAY', 86400);
	define('EXPIRY_PERIOD', $vbulletin->options['invites_expiry_days'] * ONE_DAY);
	
	##########################################################################################
	// lock tables
	$vbulletin->db->lock_tables(array('invites' => 'WRITE', 'user' => 'WRITE'));
	
	##########################################################################################
	// start getpending
	$getpending = $vbulletin->db->query_write("
		SELECT *
		FROM " . TABLE_PREFIX . "invites
		WHERE status = 0
	");

	##########################################################################################
	// start dopending
	if ($vbulletin->db->num_rows($getpending))
	{		
		$caseelsesql = '';
		$invusercredit = array();
		
		while ($invite = $vbulletin->db->fetch_array($getpending))
		{
			if (EXPIRY_PERIOD AND $invite['issue_date'] + EXPIRY_PERIOD < TIMENOW)
			{
				$caseelsesql .= " WHEN invitehash = '" . $vbulletin->db->escape_string($invite['invitehash']) . "' THEN 2";				
				$invusercredit[$invite['issuer_id']] = (isset($invusercredit[$invite['issuer_id']]) ? $invusercredit[$invite['issuer_id']] + 1 : 1);
			
				if ($vbulletin->options['invites_cron_notify'])
				{
					vbmail($invite['email'], $GLOBALS['vbphrase']['invites_subject_expired'], construct_phrase($GLOBALS['vbphrase']['invites_letter_expired'], $vbulletin->options['bbtitle'], $vbulletin->options['bburl']), true);
				}
			}
			else
			{
				if ($vbulletin->options['invites_cron_notify'])
				{
					$dayssince = floor((TIMENOW - $invite['issue_date']) / ONE_DAY);					
					if ($dayssince >= $vbulletin->options['invites_cron_notifyperiod'] AND ($dayssince % $vbulletin->options['invites_cron_notifyperiod'] == 0))
					{
						if (EXPIRY_PERIOD)
						{
							vbmail($invite['email'], $GLOBALS['vbphrase']['invites_subject_reminder'], construct_phrase($GLOBALS['vbphrase']['invites_letter_reminder'], 
								$vbulletin->options['bbtitle'], 
								$vbulletin->options['bburl'], 
								$invite['invitehash'], 
								$invite['email'], 
								floor((($invite['issue_date'] + EXPIRY_PERIOD) - TIMENOW) / ONE_DAY)
							), true);
						}
						else
						{
							vbmail($invite['email'], $GLOBALS['vbphrase']['invites_subject_reminder'], construct_phrase($GLOBALS['vbphrase']['invites_letter_reminder_noexpiry'], 
								$vbulletin->options['bbtitle'], 
								$vbulletin->options['bburl'], 
								$invite['invitehash'],
								$invite['email']
							), true);
						}
					}
				}
			}
		}	
	
		if (strlen($caseelsesql) > 0)
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "invites
				SET status = 
				CASE
					$caseelsesql
					ELSE status
				END
			");
		
			if ($vbulletin->options['invites_reg_only_by_invite'])
			{
				$caseelsesql = '';
				foreach ($invusercredit as $userid => $credit)
				{
					$caseelsesql .= " WHEN userid = '" . $userid . "' THEN invites + $credit";
				}
				
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "user
					SET invites = 
					CASE
						$caseelsesql
						ELSE invites
					END
				");
			}
		}
	}
	
	// unlock tables
	$vbulletin->db->unlock_tables();
}
	
##########################################################################################
// start log cron action
log_cron_action('Expired Invitations', $nextitem);

/*======================================================================*\
|| #################################################################### ||
|| # vS-Invites System for vBulletin 3.5.x - 3.8.x by Anton Kanevsky
|| #################################################################### ||
\*======================================================================*/
?>