<?php
/*======================================================================*\
|| #################################################################### ||
|| # vS-Invites System for vBulletin 3.5.x - 3.8.x by Anton Kanevsky
|| #################################################################### ||
|| # Copyright 2006-2009 Anton Kanevsky (ankan925@gmail.com) aka @kan. All Rights Reserved.
|| # This file may not be redistributed.
|| #################################################################### ||
\*======================================================================*/

##########################################################################################
// set php environment
error_reporting(E_ALL & ~E_NOTICE);

##########################################################################################
// define important constants
define('THIS_SCRIPT', 'invites');

##########################################################################################
// get special phrase groups
$phrasegroups = array('user', 'messaging', 'psionic_invites');				
				
// get special data templates from the datastore
$specialtemplates = array();
				
// pre-cache templates used by all actions	
$globaltemplates = array(
	'USERCP_SHELL',
	'newpost_errormessage',
	'newpost_preview',
	'USERCP_INVITES',
	'usercp_nav_folderbit',
	'usercp_invites_bit',
	'usercp_invites_alinebit',
	'usercp_invites_imagereg_35', // required in 3.5.x -- custom template
	'imagereg', // required in 3.6.x -- integrated template
	'humanverify', // require in newer versions -- integrated template
);
				
// pre-cache templates used by specific actions
$actiontemplates = array();
				
##########################################################################################
// require back-end
require_once('./global.php');
require_once(DIR . '/includes/functions_user.php');
require_once(DIR . '/includes/functions_newpost.php');

##########################################################################################
// fetch product version
$productversion = $db->query_first("SELECT version FROM " . TABLE_PREFIX . "product WHERE productid = 'psionic_invites' LIMIT 1");
$productversion = $productversion['version'];
$productyear = vbdate('Y', TIMENOW, false, false);

##########################################################################################
// fetch vbulletin version for misc purposes
require_once(DIR . '/includes/adminfunctions_template.php');
if (is_newer_version('3.5.0', $vbulletin->options['templateversion']))
{
	exit('vBulletin 3.5.0 or above is required to run vS-Invites System ' . $productversion . '!');
}
else
{
	$rgimv = substr($vbulletin->options['templateversion'], 0, 3);
	switch ($rgimv)
	{
		case '3.5':
			$vbulletin->options['invites_image_verification'] = ($vbulletin->options['gdversion'] ? true : false);
		break;
		case '3.6':
			$vbulletin->options['invites_image_verification'] = ($vbulletin->options['regimagetype'] ? true : false);
		break;
		default: // 3.7.x - 3.8.x
			$vbulletin->options['invites_image_verification'] = ($vbulletin->options['hv_type'] ? true : false);
		break;
	}
}

##########################################################################################
// start reject
$vbulletin->input->clean_gpc('r', 'optout', TYPE_STR);
if (is_valid_email($vbulletin->GPC['optout']))
{
	$db->query_write("
		REPLACE INTO `" . TABLE_PREFIX . "noinvite` (`email`) VALUES ('" . $db->escape_string($vbulletin->GPC['optout']) . "')
	");
	
	// credit the invite back to issuer...
	$inviteinfo = $db->query_first("
		SELECT * FROM " . TABLE_PREFIX . "invites
		WHERE email = '" . $db->escape_string($vbulletin->GPC['optout']) . "'
		AND status = 0
		LIMIT 1
	");
	
	if ($inviteinfo)
	{
		if ($vbulletin->options['invites_reg_only_by_invite'])
		{
			// credit routine
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "user
				SET invites = invites + 1
				WHERE userid = " . $inviteinfo['issuer_id'] . "
			");
		}
		
		// delete routine
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "invites
			SET status = 3
			WHERE invitehash = '" . $inviteinfo['invitehash'] . "'
			LIMIT 1
		");
	}
	
	eval(standard_error(fetch_error('invites_e_optout_success', $vbulletin->GPC['optout'], $vbulletin->options['contactuslink'])));
}

if (isset($_REQUEST['reject']))
{
	// retrieve invite information
	$inviteinfo = $db->query_first("
		SELECT * FROM " . TABLE_PREFIX . "invites
		WHERE invitehash = '" . $db->escape_string($_REQUEST['reject']) . "'
		AND status = 0
		LIMIT 1
	");
	
	if (!$inviteinfo)
	{
		eval(standard_error(fetch_error('invites_e_invalid_invite')));
	}
	else
	{
		if ($vbulletin->options['invites_reg_only_by_invite'])
		{
			// credit routine
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "user
				SET invites = invites + 1
				WHERE userid = " . $inviteinfo['issuer_id'] . "
			");
		}
	
		// delete routine
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "invites
			SET status = 3
			WHERE invitehash = '" . $inviteinfo['invitehash'] . "'
			LIMIT 1
		");
		
		// fetch redirect
		$vbulletin->options['useheaderredirect'] = 0;
		$vbulletin->url = 'index.php?' . $vbulletin->session->vars['sessionurl'];
		eval(standard_error(fetch_error('invites_e_invite_rejected')));
	}
}

##########################################################################################
// verify permissions
if (!$canmanageinvites)
{
	print_no_permission();
}

##########################################################################################
// initialize important variables
$errors = array(); // caches errors
$targets = array(); // caches regular contacts
$grabtargets = array(); // caches grabbed contacts
$target_amount = 0; // number of people to whom an invite was sent

$vbphrase['invites_status_pending_clean'] = htmlspecialchars_uni(strip_tags(str_replace('...', '', $vbphrase['invites_status_pending'])));
$vbphrase['invites_status_expired_clean'] = htmlspecialchars_uni(strip_tags($vbphrase['invites_status_expired']));
$vbphrase['invites_status_rejected_clean'] = htmlspecialchars_uni(strip_tags($vbphrase['invites_status_rejected']));

##########################################################################################
// start do invites
if (!$vbulletin->options['invites_reg_only_by_invite'] OR $vbulletin->userinfo['invites'] > 0)
{
	if (isset($_POST['submit']))
	{
		$vbulletin->input->clean_gpc('p', 'note', TYPE_NOHTML);
		$vbulletin->input->clean_gpc('p', 'subject', TYPE_NOHTML);
	
		if ($vbulletin->options['invites_image_verification'])
		{
			switch($rgimv)
			{
				case '3.5':
				case '3.6':
				{
					// sanitize input
					$vbulletin->input->clean_array_gpc('p', array(
						'imagestamp'	=> TYPE_STR,
						'imagehash'		=> TYPE_STR,
					));
					
					// fetch functions
					if ($rgimv == '3.6')
					{
						require_once(DIR . '/includes/functions_regimage.php');
					}
					else
					{
						function verify_regimage_hash($imagehash, $imagestamp)
						{
							global $vbulletin;

							$imagestamp = str_replace(' ', '', $imagestamp);

							$vbulletin->db->query_write("
								DELETE FROM " . TABLE_PREFIX . "regimage
								WHERE regimagehash = '" . $vbulletin->db->escape_string($imagehash) . "'
									AND imagestamp = '" . $vbulletin->db->escape_string($imagestamp) . "'
							");

							return ($vbulletin->db->affected_rows());
						}
					}
					
					// verify submission
					if (!verify_regimage_hash($vbulletin->GPC['imagehash'], $vbulletin->GPC['imagestamp']))
					{
						$errors[] = fetch_error('register_imagecheck');
						$db->query_write("
							DELETE FROM " . TABLE_PREFIX . "regimage
							WHERE regimagehash = '" . $vbulletin->db->escape_string($vbulletin->GPC['imagehash']) . "'
						");
					}
				}
				break;
				default:
				{
					$vbulletin->input->clean_gpc('p', 'humanverify', TYPE_ARRAY);
					require_once(DIR . '/includes/class_humanverify.php');
					$verify =& vB_HumanVerify::fetch_library($vbulletin);
					if (!$verify->verify_token($vbulletin->GPC['humanverify']))
					{
						$errors[] = fetch_error($verify->fetch_error());
					}
				}
				break;
			}
		}
	
		##########################################################################################
		// start main routine
		if ($vbulletin->options['invites_single_aline'])
		{
			$vbulletin->input->clean_gpc('p', 'aline', TYPE_NOHTML);
		
			// eliminate possible construction errors
			$vbulletin->GPC['aline'] = str_replace(',', ';', $vbulletin->GPC['aline']); // some people are that stupid :(
			$vbulletin->GPC['aline'] = preg_replace(
				array(
					'#(\r|\n|\r\n)#D',		// remove newlines
					'#(\s)#D',				// remove whitespace
					'#(:)+#D',				// correct inner dividers (::)
					'#(;)+#D',				// correct outer dividers (;)
					'#(;){1}$#D',			// remove ending semicolon
					'#^(;){1}#D'			// remove starting semicolon
				), 
				array(
					';',					// remove newlines
					'',						// remove whitespace
					'::',					// correct inner dividers (::)
					';',					// correct inner dividers (;)
					'',						// remove ending semicolon
					''						// remove starting semicolon
				), 
				$vbulletin->GPC['aline']
			);
			
			// build the targets
			if ($vbulletin->GPC['aline'])
			{			
				$gettargets = explode(";", $vbulletin->GPC['aline']);

				foreach ($gettargets as $target)
				{
					$targets[$target_amount] 				= explode("::", $target);
					$targets[$target_amount]['name'] 		= trim($targets[$target_amount][0]);
					$targets[$target_amount]['email'] 		= trim($targets[$target_amount][1]);
					
					if ($targets[$target_amount]['name'] == '' OR !is_valid_email($targets[$target_amount]['email']) OR sizeof($targets[$target_amount]) != 4)
					{
						$errors[] = $vbphrase['invites_e_malformed_aline'];
						break;
					}
					
					$target_amount++;
				}
			}
			
			if ($target_amount == 0)
			{
				$errors[] = $vbphrase['invites_e_malformed_aline'];
			}
		}
		else
		{
			$vbulletin->input->clean_array_gpc('p', array(
				'names'	=>	TYPE_ARRAY,
				'emails'=>	TYPE_ARRAY,
			));

			// get target addresses
			foreach ($vbulletin->GPC['names'] as $key => $name)
			{
				if (trim($name) != '' AND is_valid_email($vbulletin->GPC['emails'][$key]))
				{
					$targets["$key"]['name'] 	= trim($vbulletin->GPC['names'][$key]);
					$targets["$key"]['email'] 	= trim($vbulletin->GPC['emails'][$key]);
					
					$target_amount++;
				}
			}
			
			// check for errors
			if ($target_amount == 0)
			{
				$errors[] = $vbphrase['invites_e_no_targets_specified'];
			}
		}
		
		if ($vbulletin->options['invites_reg_only_by_invite'] AND $target_amount > $vbulletin->userinfo['invites'])
		{
			$errors[] = construct_phrase($vbphrase['invites_e_not_enough_invites'], $target_amount, $vbulletin->userinfo['invites']);
		}
		
		##########################################################################################
		// start mail
		if (sizeof($errors) == 0)
		{
			// subject - same for each message
			if ($vbulletin->options['invites_allow_custom_subject'] AND $vbulletin->GPC['subject'])
			{
				$subject = $vbulletin->GPC['subject'];
			}
			else
			{
				$subject = construct_phrase($vbphrase['invites_subject'], $vbulletin->options['bbtitle']);
			}
		
			$show['sentbit'] = false;
			$show['notsentbit'] = false;
			$sentbit = $notsentbit = '';
		
			// body - constructed separately for each message
			foreach ($targets as $target)
			{
				// verification
				if ($sql_verify = $db->query_first("SELECT username, userid FROM " . TABLE_PREFIX . "user WHERE email = '" . $db->escape_string($target['email']) . "' LIMIT 1"))
				{
					$target_amount--;
					$notsentbit .= "<li>" . construct_phrase($vbphrase['invites_m_sent_to_x_y'], htmlspecialchars_uni($sql_verify['username']), htmlspecialchars_uni($target['email'])) . "</li>";
					$show['notsentbit'] = true;
					continue;
				}
				else if ($sql_verify = $db->query_first("SELECT name, email FROM " . TABLE_PREFIX . "invites WHERE email = '" . $db->escape_string($target['email']) . "' LIMIT 1"))
				{
					$target_amount--;
					$notsentbit .= "<li>" . construct_phrase($vbphrase['invites_m_sent_to_x_y'], htmlspecialchars_uni($sql_verify['name']), htmlspecialchars_uni($sql_verify['email'])) . "</li>";
					$show['notsentbit'] = true;
					continue;
				}
				else if ($sql_verify = $db->query_first("SELECT email FROM " . TABLE_PREFIX . "noinvite WHERE email = '" . $db->escape_string($target['email']) . "' LIMIT 1"))
				{
					$target_amount--;
					$notsentbit .= "<li>" . construct_phrase($vbphrase['invites_m_sent_to_x_y'], htmlspecialchars_uni($vbphrase['n_a']), htmlspecialchars_uni($sql_verify['email'])) . "</li>";
					$show['notsentbit'] = true;
					continue;
				}
				else
				{			
					// subtract one invite for each person
					if ($vbulletin->options['invites_reg_only_by_invite'])
					{
						$vbulletin->userinfo['invites']--;
					}
					
					//  generate invitehash
					$invitehash = substr(md5(rand()), 0, 20);
					
					// create invite entry in the database
					$db->query_write("
						INSERT INTO " . TABLE_PREFIX . "invites (invitehash, issuer_id, issue_date, status, name, email)
						VALUES ('$invitehash', '" . $vbulletin->userinfo['userid'] . "', '" . TIMENOW . "', '0', '" . $db->escape_string($target['name']) . "', '" . $db->escape_string($target['email']) . "')
					");
					
					// build message body
					$message = construct_phrase($vbphrase['invites_letter'], 
						$target['name'], 
						$vbulletin->userinfo['username'],
						$vbulletin->options['bbtitle'], 
						($vbulletin->GPC['note'] ? construct_phrase($vbphrase['invites_letter_note'], $vbulletin->userinfo['username'], $vbulletin->GPC['note']) : ''), 
						$vbulletin->options['bburl'], 
						$invitehash,
						$vbulletin->userinfo['userid'],
						$target['email']
					);
								
					// send out the actual e-mail
					vbmail($target['email'], $subject, $message, true, ($vbulletin->options['invites_invitation_email'] ? $vbulletin->options['invites_invitation_email'] : $vbulletin->options['webmasteremail']), '', $vbulletin->userinfo['username']);
					
					// add item to array for output (to whom the message was sent)
					$sentbit .= "<li>" . construct_phrase($vbphrase['invites_m_sent_to_x_y'], htmlspecialchars_uni($target['name']), htmlspecialchars_uni($target['email'])) . "</li>";
					$show['sentbit'] = true;
				}
			}
			
			if ($vbulletin->options['invites_reg_only_by_invite'])
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "user
					SET invites = '" . $vbulletin->userinfo['invites'] . "'
					WHERE userid = '" . $vbulletin->userinfo['userid'] . "'
					LIMIT 1
				");
			}

			$sentmessage = construct_phrase($vbphrase['invites_m_sent_successfully'], $target_amount);
			$show['errors'] = false;
		}
		else
		{
			$errors = construct_errors($errors);
			$show['errors'] = true;
		}
	}
	
	##########################################################################################
	// construct address fields for template
	if (!$vbulletin->options['invites_single_aline'])
	{	
		for ($i = 1; $i <= $vbulletin->options['invites_multiple_field_amount']; $i++)
		{
			$i_name = (isset($vbulletin->GPC['names']) ? htmlspecialchars_uni($vbulletin->GPC['names'][$i - 1]) : '');
			$i_email = (isset($vbulletin->GPC['emails']) ? htmlspecialchars_uni($vbulletin->GPC['emails'][$i - 1]) : '');
		
			eval('$alinebit .= "' . fetch_template('usercp_invites_alinebit') . '";');
			
			if ($vbulletin->options['invites_reg_only_by_invite'] AND $i == $vbulletin->userinfo['invites'])
			{
				break;
			}
		}
	}
}

##########################################################################################
// start template configuration
if ($vbulletin->options['invites_reg_only_by_invite'])
{
	$show['invites_form'] = ($vbulletin->userinfo['invites'] > 0 ? true : false);
	$show['invites_left'] = true;
}
else
{
	$show['invites_form'] = true;
	$show['invites_left'] = false;
}

##########################################################################################
// start image verification
$show['imagecheck'] = false;
if ($vbulletin->options['invites_image_verification'])
{
	$show['imagecheck'] = true;
	switch($rgimv)
	{
		case '3.5':
		case '3.6':		
		{
			if ($rgimv == '3.6')
			{
				require_once(DIR . '/includes/functions_regimage.php');
				$template_name = 'imagereg';
			}
			else
			{
				function fetch_regimage_string($length)
				{
					$somechars = '234689ABCEFGHJMNPQRSTWY';
					$morechars = '234689ABCEFGHJKMNPQRSTWXYZabcdefghjkmnpstwxyz';

					for ($x = 1; $x <= $length; $x++)
					{
						$chars = ($x <= 2 OR $x == $length) ? $morechars : $somechars;
						$number = rand(1, strlen($chars));
						$word .= substr($chars, $number - 1, 1);
				 	}

				 	return $word;
				}
				
				function fetch_regimage_hash()
				{
					global $vbulletin;

					$string = fetch_regimage_string(6);
					$regimagehash = md5(uniqid(rand(), 1));
					// Gen hash and insert into database;
					/*insert query*/
					$vbulletin->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "regimage
							(regimagehash, imagestamp, dateline)
						VALUES
							('" . $vbulletin->db->escape_string($regimagehash) . "', '" . $vbulletin->db->escape_string($string) . "', " . TIMENOW . ")"
					);

					return $regimagehash;
				}
				
				$template_name = 'usercp_invites_imagereg_35';
			}
			
			$imagehash = fetch_regimage_hash();
			eval('$imagereg = "' . fetch_template($template_name) . '";');
		}
		break;
		default:
		{
			require_once(DIR . '/includes/class_humanverify.php');
			$verify =& vB_HumanVerify::fetch_library($vbulletin);
			$imagereg = $verify->output_token();
		}
		break;
	}
}

##########################################################################################
// start history
$getinvites = $db->query_read("
	SELECT invites.*, receiver.username as receiver_username
	FROM " . TABLE_PREFIX . "invites as invites
	LEFT JOIN " . TABLE_PREFIX . "user as receiver ON (invites.receiver_id = receiver.userid)
	WHERE invites.issuer_id = '" . $vbulletin->userinfo['userid'] . "'
	ORDER BY invites.issue_date DESC
");

$invitecache = array();
while ($invite = $db->fetch_array($getinvites))
{
	$invitecache[$invite['invitehash']] = $invite;
}

if ($_REQUEST['do'] == 'purgeinvites')
{	
	$invitehashes = '';
	$givecredit = 0;
		
	$purge = $vbulletin->input->clean_gpc('p', 'purge', TYPE_ARRAY_STR);
	$dowhat = $vbulletin->input->clean_gpc('p', 'dowhat', TYPE_NOCLEAN);
		
	foreach ($invitecache as $invitehash => $invite)
	{
		$selected = false;
		$creditable = false;
		
		switch ($dowhat)
		{
			case 'selected':
			{
				if (in_array($invitehash, $purge))
				{
					switch ($invite['status'])
					{
						case 0:
						{
							if ($vbulletin->options['invites_allow_cancel_pending'])
							{
								$selected = true;
								$creditable = true;
							}
						}
						break;
						case 1:
						{
							if (!$invite['receiver_username'])
							{
								$selected = true;
								$creditable = true;
							}
						}
						break;
						default:
						{
							$selected = true;
						}
					}
				}
			}
			break;
			case 'pending':
			{
				if ($invite['status'] == 0 AND $vbulletin->options['invites_allow_cancel_pending'])
				{
					$selected = true;
					$creditable = true;
				}
			}
			break;
			case 'expired':
			{
				if ($invite['status'] == 2)
				{
					$selected = true;
				}
			}
			break;
			case 'rejected':
			{
				if ($invite['status'] == 3)
				{
					$selected = true;
				}
			}
			break;
			case 'deleted':
			{
				if ($invite['status'] == 1 AND !$invite['receiver_username'])
				{
					$selected = true;
					$creditable = true;
				}
			}
			break;
		}
		
		if ($selected)
		{
			$invitehashes .= (!empty($invitehashes) ? ', ' : '') . "'" . $db->escape_string($invitehash) . "'";
			unset($invitecache["$invitehash"]);
			
			if ($creditable AND $vbulletin->options['invites_reg_only_by_invite'])
			{
				$givecredit++;
			}
		}
	}
				
	if (!empty($invitehashes))
	{
		$vbulletin->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "invites
			WHERE issuer_id = '" . $vbulletin->userinfo['userid'] . "'
			AND invitehash IN ($invitehashes)
		");
		
		if ($givecredit)
		{
			$vbulletin->userinfo['invites'] += $givecredit;
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "user
				SET invites = invites + $givecredit
				WHERE userid = " . $vbulletin->userinfo['userid'] . "
				LIMIT 1
			");
		}
	}
}

##########################################################################################
// construct history...
$show['invites_history'] = false;
if (sizeof($invitecache))
{
	foreach ($invitecache as $invite)
	{
		$invite['issue_date'] 	= vbdate($vbulletin->options['dateformat'], $invite['issue_date'], true);
		$invite['receive_date'] = ($invite['receive_date'] ? vbdate($vbulletin->options['dateformat'], $invite['receive_date'], true) : '');
		$invite['name'] = htmlspecialchars_uni($invite['name']);
		$invite['email'] = htmlspecialchars_uni($invite['email']);
		
		switch ($invite['status'])
		{
			case 0:
				$invite['statustext'] =& $vbphrase['invites_status_pending'];
				break;
			case 1:
				$invite['statustext'] =& $vbphrase['invites_status_accepted'];
				break;
			case 2:
				$invite['statustext'] =& $vbphrase['invites_status_expired'];
				break;
			case 3:
				$invite['statustext'] =& $vbphrase['invites_status_rejected'];
				break;
		}
			
		eval('$invites_bit .= "' . fetch_template('usercp_invites_bit') . '";');
	}
	
	$show['invites_history'] = true;
}

##########################################################################################
// start output
construct_usercp_nav('usercp_invites');										
				
// build navbar
$navbits = array(
	'usercp.php?' . $vbulletin->session->vars['sessionurl'] => $vbphrase['user_control_panel'],
	'invites.php?' . $vbulletin->session->vars['sessionurl'] => $vbphrase['invites']
);
$navbits = construct_navbits($navbits);
eval('$navbar = "' . fetch_template('navbar') . '";');

// print page		
eval('$HTML = "' . fetch_template('USERCP_INVITES') . '";');
eval('print_output("' . fetch_template('USERCP_SHELL') . '");');

/*======================================================================*\
|| #################################################################### ||
|| # vS-Invites System for vBulletin 3.5.x - 3.8.x by Anton Kanevsky
|| #################################################################### ||
\*======================================================================*/
?>