<?php
/*======================================================================*\
|| #################################################################### ||
|| # vS-Invites System for vBulletin 3.5.x - 3.8.x by Anton Kanevsky
|| #################################################################### ||
|| # Copyright 2006-2009 Anton Kanevsky (ankan925@gmail.com) aka @kan. All Rights Reserved.
|| # This file may not be redistributed.
|| #################################################################### ||
\*======================================================================*/

##########################################################################################
// set php environment
error_reporting(E_ALL & ~E_NOTICE);
if (!is_object($vbulletin->db))
{
	exit;
}

if ($vbulletin->options['invites_enabled'] AND $vbulletin->options['invites_reg_only_by_invite'] AND $vbulletin->options['invites_cron'])
{
	##########################################################################################
	// define important constants
	define('ONE_DAY', 86400);
	define('DAYS_IN_A_WEEK', 7);
	define('ONE_WEEK', ONE_DAY * DAYS_IN_A_WEEK);
	
	##########################################################################################
	// start getusers
	$getusers = $vbulletin->db->query_read("
		SELECT userid, reputation, invites, lastpost, email, options, languageid
		FROM " . TABLE_PREFIX . "user
		WHERE posts >= '" . intval($vbulletin->options['invites_min_posts']) . "'
		AND reputation >= '" . intval($vbulletin->options['invites_min_reputation']) . "'
	");
	
	##########################################################################################
	// start dousers	
	if ($vbulletin->db->num_rows($getusers) > 0)
	{
		while ($userinfo = $vbulletin->db->fetch_array($getusers))
		{
			// if days since last post is less than or equal to 7, get number of posts made during last week
			if (ceil((TIMENOW - $userinfo['lastpost']) / ONE_DAY) <= ONE_WEEK)
			{
				$getcount = $vbulletin->db->query_first("
					SELECT COUNT(*) as posts
					FROM " . TABLE_PREFIX . "post
					WHERE dateline >= " . (TIMENOW - ONE_WEEK) . "
					AND userid = $userinfo[userid]
				");

				if ($getcount['posts'])
				{
					// sanity check
					if ($vbulletin->options['invites_posts_for_one_invite'] < 1)
					{
						$vbulletin->options['invites_posts_for_one_invite'] = 1;
					}
					
					// give an invite for every $vbulletin->options['invites_posts_per_one_invite'] posts
					$invitescount_change = floor($getcount['posts'] / $vbulletin->options['invites_posts_for_one_invite']);
				
					// and finally, update the database
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "user
						SET invites = invites + " . $invitescount_change . "
						WHERE userid = $userinfo[userid]
						LIMIT 1
					");
					
					// send out notification
					if ($vbulletin->options['invites_cron_allocation_notification'] AND $userinfo['options'] & $vbulletin->bf_misc['useroptions']['adminemail'])
					{
						$email =& $userinfo['email'];
						$username =& $userinfo['username'];
						$bburl =& $vbulletin->options['bburl'];
						$bbtitle =& $vbulletin->options['bbtitle'];
						$invites =& $invitescount_change;
						
						eval(fetch_email_phrases('invites_allocate_letter', $userinfo['languageid']));
						vbmail($email, $subject, $message, true);
					}
				}
			}
			else
			{
				// and finally, update the database
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "user
					SET invites = invites - " . $vbulletin->options['invites_loss'] . "
					WHERE userid = $userinfo[userid]
					LIMIT 1
				");
			}
		}
	}
	
	##########################################################################################
	// start log cron action
	log_cron_action('Invite Counts Update', $nextitem);
}

/*======================================================================*\
|| #################################################################### ||
|| # vS-Invites System for vBulletin 3.5.x - 3.8.x by Anton Kanevsky
|| #################################################################### ||
\*======================================================================*/
?>