<?php
/*======================================================================*\
|| #################################################################### ||
|| # vS-Maintenance Suite for vBulletin 3.5.x - 3.8.x by Anton Kanevsky
|| #################################################################### ||
|| # Copyright 2006-2009 Anton Kanevsky (ankan925@gmail.com) aka @kan. All Rights Reserved.
|| # This file may not be redistributed.
|| #################################################################### ||
\*======================================================================*/

##############################################################################
error_reporting(E_All & ~E_NOTICE);

##############################################################################
define('CVS_REVISION', '$RCSfile: vs_maintenance.php,v $ - $Revision: 1.00.0.0 $');

##############################################################################
$phrasegroups = array('sql', 'vs_maintenance', 'cppermission', 'forum');
$specialtemplates = array();

##############################################################################
require_once('./global.php');

##############################################################################
##############################################################################
##############################################################################

// print cp header
print_cp_header($vbphrase['vs_cpnav']);

// verify permissions
if (!$vbulletin->debug)
{
	$userids = explode(',', str_replace(' ', '', $vbulletin->config['SpecialUsers']['canrunqueries']));
	if (!in_array($vbulletin->userinfo['userid'], $userids))
	{
		print_stop_message('no_permission_queries');
	}
}

// define default action
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'list';
}

// retrieve product list - used by products for group titles
$products = fetch_product_list();

// initialize queryoptions
$queryoptions = array(
	'-1'  => ''
);

// populate queryoptions
($hook = vBulletinHook::fetch_hook('vs_maintenance_queryoptions')) ? eval($hook) : false;

##############################################################################
if ($_POST['do'] == 'doquery')
{
	// retrieve gpc data
	$autoquery 			=& $vbulletin->input->clean_gpc('p', 'autoquery', TYPE_STR);
	$query 				= '';
	$rebuild			= false;
	
	// fetch gpc query
	($hook = vBulletinHook::fetch_hook('vs_maintenance_queryexec')) ? eval($hook) : false;
	
	// execute operations
	if ($query)
	{
		// log admin action
		log_admin_action("vs-maintenance-query = '" . htmlspecialchars_uni($query));
	
		// retrieve microtime functions
		require_once(DIR . '/includes/functions_misc.php');
	
		if (substr($query, -1) == ';')
		{
			$query = substr($query, 0, -1);
		}
		
		// execute query
		$db->hide_errors();
		
		$time_before = microtime();
		$db->query_write($query);
		$time_taken = fetch_microtime_difference($time_before);
		
		$db->show_errors();
		
		// print result form
		print_form_header('queries', 'doquery');
		print_table_header($vbphrase['vbulletin_message']);
		if ($errornum = $db->errno())
		{
			print_description_row(construct_phrase($vbphrase['an_error_occured_while_attempting_to_run_your_query'], $errornum, nl2br(htmlspecialchars_uni($db->error()))));
		}
		else
		{
			print_description_row(construct_phrase($vbphrase['affected_rows'], vb_number_format($db->affected_rows()), vb_number_format($time_taken, 4)));
		}
		print_table_footer();
		
		// rebuild data
		if ($rebuild)
		{
			require_once(DIR . '/includes/functions_databuild.php');
			build_forum_permissions();
		}

		// print restard form
		print_form_header('vs_maintenance', 'doquery');
		print_table_header($vbphrase['query']);
		print_description_row('<code>' . nl2br(htmlspecialchars_uni($query)) . '</code>');
		construct_hidden_code('autoquery', $autoquery);
		print_submit_row($vbphrase['restart']);
		print_table_footer();
	}
	else
	{
		// print result form
		print_form_header('', '');
		print_table_header($vbphrase['vbulletin_message']);
		print_description_row($vbphrase['vs_maintenance_invalid_query']);
		print_table_footer();
	}
}

// print control form
print_form_header('vs_maintenance', 'doquery');
print_table_header($vbphrase['execute_sql_query']);
print_select_row($vbphrase['auto_query'], 'autoquery', $queryoptions, -1);
print_submit_row($vbphrase['continue']);

// whatever else there is...
($hook = vBulletinHook::fetch_hook('vs_maintenance_complete')) ? eval($hook) : false;

// print cp footer
print_cp_footer();

/*======================================================================*\
|| #################################################################### ||
|| # vS-Maintenance Suite for vBulletin 3.5.x - 3.8.x by Anton Kanevsky
|| # Downloaded: 18:37, Sun Feb 28th 2010
|| #################################################################### ||
\*======================================================================*/
?>