<?php
/*=======================================================================================*\
|| ##################################################################################### ||
|| # vB Enterprise Translator (vBET) 2.4.2                                             # ||
|| # ----------------------------------------------------------------                  # ||
|| # Originally created by NLP-er (1.0.0)                                              # ||
|| # Copyright 2009 Michal Podbielski. All Rights Reserved.                            # ||
|| #                                                                                   # ||
|| # You may not redistribute this file or its derivatives without written permission. # ||
|| # http://www.vbenterprisetranslator.com/                                            # ||
|| ##################################################################################### ||
\*=======================================================================================*/
global $vbet_baseUri;
global $vbet_localCache;
global $maxUrlLength;
global $maxUrlSegments;
$vbet_localCache = array();
$maxUrlLength = 1900;
$maxUrlSegments = 128;
$vbet_baseUri = null;
require_once(DIR. '/includes/vbenterprisetranslator_url_functions.php');
function vbet_removeOldTranslations($dateline) {
global $vbulletin;
$removed = 0;
if ('normal' == $vbulletin->options['vbenterprisetranslator_cachettl_clearingstrategy']) {
$vbulletin->db->query_write('DELETE FROM ' . TABLE_PREFIX . 'vbenterprisetranslator_cache WHERE dateline<'.$dateline);
$removed += $vbulletin->db->affected_rows();
$vbulletin->db->query_write('DELETE FROM ' . TABLE_PREFIX . 'vbenterprisetranslator_cache_medium WHERE dateline<'.$dateline);
$removed += $vbulletin->db->affected_rows();
$vbulletin->db->query_write('DELETE FROM ' . TABLE_PREFIX . 'vbenterprisetranslator_cache_short WHERE dateline<'.$dateline);
$removed += $vbulletin->db->affected_rows();
} else if ('quicklocal' == $vbulletin->options['vbenterprisetranslator_cachettl_clearingstrategy']) {
$vbulletin->db->query_write('DELETE QUICK FROM ' . TABLE_PREFIX . 'vbenterprisetranslator_cache WHERE dateline<'.$dateline);
$removed += $vbulletin->db->affected_rows();
$vbulletin->db->query_write("OPTIMIZE LOCAL TABLE " . TABLE_PREFIX . "vbenterprisetranslator_cache");
$vbulletin->db->query_write('DELETE QUICK FROM ' . TABLE_PREFIX . 'vbenterprisetranslator_cache_medium WHERE dateline<'.$dateline);
$removed += $vbulletin->db->affected_rows();
$vbulletin->db->query_write('OPTIMIZE LOCAL TABLE ' . TABLE_PREFIX . 'vbenterprisetranslator_cache_medium');
$vbulletin->db->query_write('DELETE QUICK FROM ' . TABLE_PREFIX . 'vbenterprisetranslator_cache_short WHERE dateline<'.$dateline);
$removed += $vbulletin->db->affected_rows();
$vbulletin->db->query_write('OPTIMIZE LOCAL TABLE ' . TABLE_PREFIX . 'vbenterprisetranslator_cache_short');
} else if ('quick' == $vbulletin->options['vbenterprisetranslator_cachettl_clearingstrategy']) {
$vbulletin->db->query_write('DELETE QUICK FROM ' . TABLE_PREFIX . 'vbenterprisetranslator_cache WHERE dateline<'.$dateline);
$removed += $vbulletin->db->affected_rows();
$vbulletin->db->query_write('OPTIMIZE TABLE ' . TABLE_PREFIX . 'vbenterprisetranslator_cache');
$vbulletin->db->query_write('DELETE QUICK FROM ' . TABLE_PREFIX . 'vbenterprisetranslator_cache_medium WHERE dateline<'.$dateline);
$removed += $vbulletin->db->affected_rows();
$vbulletin->db->query_write('OPTIMIZE TABLE ' . TABLE_PREFIX . 'vbenterprisetranslator_cache_medium');
$vbulletin->db->query_write('DELETE QUICK FROM ' . TABLE_PREFIX . 'vbenterprisetranslator_cache_short WHERE dateline<'.$dateline);
$removed += $vbulletin->db->affected_rows();
$vbulletin->db->query_write('OPTIMIZE TABLE ' . TABLE_PREFIX . 'vbenterprisetranslator_cache_short');
} else if ('all' == $vbulletin->options['vbenterprisetranslator_cachettl_clearingstrategy']) {
$result = $vbulletin->db->query_first('SELECT MIN(dateline) as dateline FROM ' . TABLE_PREFIX . 'vbenterprisetranslator_cache_short');
if ($result['dateline'] < $dateline) {
$vbulletin->db->query_write('TRUNCATE ' . TABLE_PREFIX . 'vbenterprisetranslator_cache');
$vbulletin->db->query_write('TRUNCATE ' . TABLE_PREFIX . 'vbenterprisetranslator_cache_medium');
$vbulletin->db->query_write('TRUNCATE ' . TABLE_PREFIX . 'vbenterprisetranslator_cache_short');
$removed = 'ALL';
}
}
return $removed;
}
function vbet_encodeToSafeUTF8(&$string) {
if (! ereg("[\200-\237]", $string) and ! ereg("[\241-\377]", $string))
return $string;
$string = preg_replace("/([\340-\357])([\200-\277])([\200-\277])/e",
"'&#'.((ord('\\1')-224)*4096 + (ord('\\2')-128)*64 + (ord('\\3')-128)).';'",
$string);
$string = preg_replace("/([\300-\337])([\200-\277])/e",
"'&#'.((ord('\\1')-192)*64+(ord('\\2')-128)).';'",
$string);
return $string;
}
function vbet_getTranslationURL($from,$to) {
global $vbulletin;
if ($vbulletin->options['vbenterprisetranslator_googleapikey']) {
return 'http://ajax.googleapis.com/ajax/services/language/translate?v=1.0&format=html&langpair='.$from.'|'.$to.'&key='.$vbulletin->options['vbenterprisetranslator_googleapikey'].'&userip='.$_SERVER['REMOTE_ADDR'];
} else {
return 'http://ajax.googleapis.com/ajax/services/language/translate?v=1.0&format=html&langpair='.$from.'|'.$to.'&userip='.$_SERVER['REMOTE_ADDR'];
}
}
function vbet_useCache($language) {
global $vbulletin;
$key = 'vbenterprisetranslator_cache_'.$language;
return $vbulletin->options['vbenterprisetranslator_usecache'] &&
(
($vbulletin->bf_misc_vbenterprisetranslator_cache_options[$key]
&& ($vbulletin->options['vbenterprisetranslator_cache'] & $vbulletin->bf_misc_vbenterprisetranslator_cache_options[$key]))
||
($vbulletin->bf_misc_vbenterprisetranslator_cache_options_cd[$key]
&& ($vbulletin->options['vbenterprisetranslator_cache_cd'] & $vbulletin->bf_misc_vbenterprisetranslator_cache_options_cd[$key]))
||
($vbulletin->bf_misc_vbenterprisetranslator_cache_options_cd2[$key]
&& ($vbulletin->options['vbenterprisetranslator_cache_cd2'] & $vbulletin->bf_misc_vbenterprisetranslator_cache_options_cd2[$key]))
);
}
function vbet_replaceFirst($what, $toWhat, &$where) {
$position = strpos($where, $what);
if ($position === false) {
return $where;
}
return substr_replace($where, $toWhat, $position, strlen($what));
}
function vbet_translateTextToDivide(&$toTranslate, $language, $serie) {
global $vbulletin;
global $maxUrlLength;
$urlLength = strlen(vbet_getTranslationURL($vbulletin->options['vbenterprisetranslator_forumlanguage'], $language));
$toTranslateLength = strlen($toTranslate);
if (($toTranslateLength + $urlLength + 3) < $maxUrlLength) {
return vbet_translateEncodedText($toTranslate, $language, $serie);
} else {
$point = vbet_getDividePoint($toTranslate, '.', $urlLength);
if (!$point) {
$point = vbet_getDividePoint($toTranslate, '+', $urlLength);
}
if (!$point) {
$point = $maxUrlLength - 3 - $urlLength;
}
return vbet_translateEncodedText(substr($toTranslate, 0, $point), $language, $serie)
.vbet_translateTextToDivide(substr($toTranslate, $point), $language, $serie);
}
}
function vbet_getDividePoint(&$where, $dividor, $urlLength) {
global $maxUrlLength;
$skipper = 19;
$offset = $skipper + $urlLength;
$point = $maxUrlLength;
while (true) {
$point = strpos($where, $dividor, $maxUrlLength - $offset);
if (!$point) {
return 0;
}
if ($point + $urlLength + 3 <= $maxUrlLength) {
return $point;
}
$offset += $skipper;
if ($offset >= $maxUrlLength) {
return 0;
}
}
return 0;
}
function vbet_translatePage(&$output) {
global $vbulletin;
$language = $_REQUEST['language'];
if (vbet_isLangSupported($language) && ($language != $vbulletin->options['vbenterprisetranslator_forumlanguage'])) {
header ('Content-type: text/html; charset=utf-8');
set_time_limit(0);
preg_match_all('|<style[^>]*>(.*?)</style>|si',$output, $styles, PREG_SET_ORDER);
$size = sizeof($styles);
for($i = 0; $i < $size; $i++) {
$output = str_replace($styles[$i][0], "<styletag counter=\"$i\"/>",$output);
}
preg_match_all('|<script[^>]*>(.*?)</script>|si', $output, $scripts, PREG_SET_ORDER);
$size = sizeof($scripts);
for($i = 0; $i < $size; $i++) {
$output = str_replace($scripts[$i][0], "<scripttag counter=\"$i\"/>", $output);
}
preg_match_all('|<!--START vBET NOT TRANSLATED AREA-->(.*?)<!--END vBET NOT TRANSLATED AREA-->|si',$output, $notTranslated, PREG_SET_ORDER);
$size = sizeof($notTranslated);
for($i = 0; $i < $size; $i++) {
$output = str_replace($notTranslated[$i][0], "<nottranslatedtag counter=\"$i\"/>",$output);
}
global $stylevar;
$output = vbet_replaceFirst('lang="'.$stylevar['languagecode'].'"', 'lang="'.$language.'"', $output);
$output = str_replace("&nbsp;", "<&nbsp;>", $output);
$serie = microtime(true) * 10000;
$output = vbet_translateHTML($output, $language, $serie);
$output = str_replace("<&nbsp;>", "&nbsp;", $output);
$size = sizeof($notTranslated);
for($i = 0; $i < $size; $i++) {
$notTranslatedOne = vbet_getReEncoded($notTranslated[$i][1]);
$output = str_replace("<nottranslatedtag counter=\"$i\"/>", $notTranslatedOne, $output);
}
$size = sizeof($scripts);
for($i = 0; $i < $size; $i++) {
if ($vbulletin->options['vbenterprisetranslator_vbseo_message'] && strpos($scripts[$i][0], 'vbseo_jshtml[0]')) {
$scriptIndex = 0;
$position = 0;
$prevPosition = 0;
$scriptBuffer = '';
$script = $scripts[$i][0];
while (true) {
$position = strpos($script, 'vbseo_jshtml['.$scriptIndex.']', $prevPosition);
if (!$position) {
break;
}
$position = strpos($script, '<table', $position);
$end = strpos($script, '</table>', $position);
$toTranslate = substr($script, $position, $end + strlen('</table>') - $position);
$scriptBuffer .= substr($script, $prevPosition, $position).vbet_translateHTML($toTranslate, $language, $serie);
$scriptIndex++;
$prevPosition = $end + strlen('</table>');
}
$scripts[$i][0] = $scriptBuffer.substr($script, $prevPosition);
} else {
$scripts[$i][0] = vbet_getReEncoded($scripts[$i][0]);
}
$output = str_replace("<scripttag counter=\"$i\"/>", $scripts[$i][0], $output);
}
$size = sizeof($styles);
for($i = 0; $i < $size; $i++) {
$output = str_replace("<styletag counter=\"$i\"/>", $styles[$i][0], $output);
}
preg_match_all("|<meta[^>]+name=\"([^\"]*)\"[^>]+content=\"([^\"]*)\"[^>]+>|i",$output, $meta, PREG_PATTERN_ORDER);
$keywords = '';
$description = '';
$size = sizeof($meta[1]);
for ($i = 0;$i < $size; $i++) {
if (strtolower($meta[1][$i]) == "keywords") {
$keywords = $meta[2][$i];
}
if (strtolower($meta[1][$i]) == "description") {
$description = $meta[2][$i];
}
}
if ($stylevar['charset'] != 'utf-8') {
$output=str_replace("<meta name=\"description\" content=\"".$description."\" />", "<meta name=\"description\" content=\""
.vbet_translateText(vbet_encodeToSafeUTF8($description), $language, $serie)."\" />", $output);
$output=str_replace("<meta name=\"keywords\" content=\"".$keywords."\" />", "<meta name=\"keywords\" content=\""
.vbet_translateText(vbet_encodeToSafeUTF8($keywords), $language, $serie)."\" />", $output);
} else {
$output=str_replace("<meta name=\"description\" content=\"".$description."\" />", "<meta name=\"description\" content=\""
.vbet_translateText($description, $language, $serie)."\" />", $output);
$output=str_replace("<meta name=\"keywords\" content=\"".$keywords."\" />", "<meta name=\"keywords\" content=\""
.vbet_translateText($keywords, $language, $serie)."\" />", $output);
}
if ($vbulletin->options['vbenterprisetranslator_urltracking']) {
$output = preg_replace('|href\="([^"]*)|e',
"'href=\"'.vbet_createURLForAddressNoReplace('$language', '\\1')",
$output);
}
if ($vbulletin->options['vbenterprisetranslator_translationlinkstype']) {
$baseUri = vbet_getBaseURI();
$output = vbet_replaceFirst('<head>','<head><base href="'.$baseUri.'/" />',$output);
$output = vbet_replaceFirst('<!--[if IE]></base><![endif]-->','<!--[if IE]></base><![endif]--><base href="'.$baseUri.'/" />',$output);
}
if ($vbulletin->options['vbenterprisetranslator_google_maps']) {
$output = preg_replace('|http:\/\/maps\.google\.pl\/maps\?(.*?)hl=[^&]*|e',
"'http://maps.google.pl/maps?'.vbet_fixPregReplaceString('\\1').'hl=$language'",
$output);
}
}//end if language is set in get
}
function vbet_getReEncoded(&$text) {
global $stylevar;
return ($stylevar['charset'] != 'utf-8') ? iconv($stylevar['charset'], 'utf-8', $text) : $text;
}
function vbet_translateHTML(&$output, $language, $serie) {
global $vbulletin;
$outputResult = array();
$translationTexts = array();
$translationEncodedTexts = array();
$index = 0;
$outputResult[$index] = '';
global $maxUrlLength;
$forumLanguage = $vbulletin->options['vbenterprisetranslator_forumlanguage'];
$lengthOutput = strlen($output);
$openPosition = 0;
while (true) {
$closePosition = strpos($output, '>',$openPosition + 1);
if ($closePosition === false) {
$outputResult[$index] .=  vbet_getReEncoded(substr($output, $openPosition));
break;
}
$outputResult[$index] .=  vbet_getReEncoded(substr($output, $openPosition, $closePosition - $openPosition + 1));
$openPosition = strpos($output, '<',$closePosition + 1);
if ($openPosition === false) {
$outputResult[$index] .= substr($output, $closePosition + 1);
break;
}
while (true) {
$closePositionCheck = strpos($output, '>',$closePosition + 1);
if (!$closePositionCheck || ($closePositionCheck > $openPosition)) {
break;
}
$outputResult[$index] .=  vbet_getReEncoded(substr($output, $closePosition + 1, $closePositionCheck - $closePosition));
$closePosition = $closePositionCheck;
}
if ($openPosition - $closePosition > 1) {
$toTranslate = substr($output, $closePosition + 1, $openPosition - $closePosition - 1);
$trimmedToTranslate = trim($toTranslate);
if ($trimmedToTranslate == null || $trimmedToTranslate == '') {
$outputResult[$index] .= $toTranslate;
continue;
}
$toTranslateLength = strlen($toTranslate);
$rightTruncationLength = strlen(rtrim($toTranslate));
$leftSpaces = substr($toTranslate, 0, $toTranslateLength - strlen(ltrim($toTranslate)));
$rightSpaces = substr($toTranslate, $rightTruncationLength , $toTranslateLength - $rightTruncationLength );
$toTranslate = vbet_getReEncoded($trimmedToTranslate);
$translated = vbet_getFromCache($toTranslate, $language);
if ($translated !== null) {
$outputResult[$index] .= $leftSpaces.$translated.$rightSpaces;
} else {
$encoded = urlencode($toTranslate);
if (strlen($encoded) + strlen(vbet_getTranslationURL($forumLanguage,$language)) + 3 > $maxUrlLength) {
$outputResult[$index] .= $leftSpaces.vbet_translateTextToDivide($encoded, $language, $serie).$rightSpaces;
} else {
$outputResult[$index] .= $leftSpaces;
$translationTexts[$index] = $toTranslate;
$translationEncodedTexts[$index] = $encoded;
$index ++;
$outputResult[$index] = $rightSpaces;
}
}//end else for making translation
}//end if for content
}//end while for parsing
$translated = vbet_googleMultiTranslation($translationEncodedTexts, $forumLanguage, $language, $serie, 0);
$addToCache = array();
$addToCacheMedium = array();
$addToCacheShort = array();
$size = sizeof($outputResult);
$output = '';
for($i = 0; $i < $size; $i++) {
$output .= $outputResult[$i];
$output .= $translated[$i];
if (vbet_useCache($language)) {
$toTranslate = $translationTexts[$i];
$length = strlen($toTranslate);
$toCache = "('".$language."', '".addslashes($toTranslate)."', '".addslashes(trim($translated[$i]))."',".$serie.", " . TIMENOW . ")";
if ($length<=50) {
$addToCacheShort[] = $toCache ;
} else if ($length > 328) {
$addToCache[] = $toCache ;
} else {
$addToCacheMedium[] = $toCache ;
}
}
}
if (vbet_useCache($toLang) && sizeof($translated) == sizeof($translationEncodedTexts)) {
if ($addToCache) {
$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "vbenterprisetranslator_cache (tl, originaltext, translated, serie, dateline) VALUES "
. implode(',', $addToCache));
}
if ($addToCacheMedium) {
$vbulletin->db->query_write("INSERT IGNORE INTO " . TABLE_PREFIX . "vbenterprisetranslator_cache_medium (tl, originaltext, translated, serie, dateline) VALUES "
. implode(',', $addToCacheMedium));
}
if ($addToCacheShort) {
$vbulletin->db->query_write("INSERT IGNORE INTO " . TABLE_PREFIX . "vbenterprisetranslator_cache_short (tl, originaltext, translated, serie, dateline) VALUES "
. implode(',', $addToCacheShort));
}
}
return $output;
}
function vbet_fixPregReplaceString ($toFix) {
return str_replace('\"', '"', $toFix);
}
function vbet_getFromCache(&$toTranslate, $language) {
global $vbulletin;
$translations = null;
if (vbet_useCache($language)) {
$length = strlen($toTranslate);
if ($vbulletin->options['vbenterprisetranslator_byserie']) {
global $vbet_localCache;
$result = $vbet_localCache[$toTranslate];
if ($result != null) {
return $result;
}
if ($length<=50) {
$translations = $vbulletin->db->query_read("SELECT cache.originaltext as originaltext, cache.translated as translated FROM "
. TABLE_PREFIX . "vbenterprisetranslator_cache_short help, " . TABLE_PREFIX . "vbenterprisetranslator_cache_short cache WHERE help.originaltext='"
.addslashes($toTranslate)."' AND help.tl='"
.$language."' AND cache.serie=help.serie");
} else if ($length > 328) {
$translations = $vbulletin->db->query_read("SELECT cache.originaltext as originaltext, cache.translated as translated FROM "
. TABLE_PREFIX . "vbenterprisetranslator_cache help, " . TABLE_PREFIX . "vbenterprisetranslator_cache cache WHERE help.originaltext='"
.addslashes($toTranslate)."' AND help.tl='"
.$language."' AND cache.serie=help.serie");
} else {
$translations = $vbulletin->db->query_read("SELECT cache.originaltext as originaltext, cache.translated as translated FROM "
. TABLE_PREFIX . "vbenterprisetranslator_cache_medium help, " . TABLE_PREFIX . "vbenterprisetranslator_cache_medium cache WHERE help.originaltext='"
.addslashes($toTranslate)."' AND help.tl='"
.$language."' AND cache.serie=help.serie");
}
while ($row = $vbulletin->db->fetch_array($translations)) {
$vbet_localCache[$row['originaltext']] = $row['translated'];
}
$vbulletin->db->free_result($translations);
$result = $vbet_localCache[$toTranslate];
if ($result != null) {
return $result;
}
} else {
if ($length<=50) {
$translations = $vbulletin->db->query_read("SELECT translated FROM " . TABLE_PREFIX . "vbenterprisetranslator_cache_short WHERE originaltext='".addslashes($toTranslate)."' AND tl='".$language."'");
} else if ($length > 328) {
$translations = $vbulletin->db->query_read("SELECT translated FROM " . TABLE_PREFIX . "vbenterprisetranslator_cache WHERE originaltext='".addslashes($toTranslate)."' AND tl='".$language."' LIMIT 1");
} else {
$translations = $vbulletin->db->query_read("SELECT translated FROM " . TABLE_PREFIX . "vbenterprisetranslator_cache_medium WHERE originaltext='".addslashes($toTranslate)."' AND tl='".$language."'");
}
while ($row = $vbulletin->db->fetch_array($translations)) {
return $row['translated'];
}
}
}
return null;
}
function vbet_googleMultiTranslation(&$toTranslateTable, $from, $to, $serie, $start) {
global $maxUrlLength ;
global $maxUrlSegments;
$url = vbet_getTranslationURL($from,$to);
$length = strlen($url);
$translated = array();
$subTranslated = array();
$size = sizeof($toTranslateTable);
$added = 0;
for ($i = $start; $i < $size; $i++) {
$toTranslate = $toTranslateTable[$i];
$toTranslateLength = strlen($toTranslate);
if (($length + 3 + $toTranslateLength > $maxUrlLength) || ($added == $maxUrlSegments)) {
if ($i ==$start) {
$subTranslated = vbet_googleMultiTranslation($toTranslateTable, $from, $to, $serie, $i + 1);
$url .= "&q=".$toTranslate;
$added++;
break;
}
$subTranslated = vbet_googleMultiTranslation($toTranslateTable, $from, $to, $serie, $i);
break;
}
$url .= "&q=".$toTranslate;
$added++;
$length += 3 + $toTranslateLength;
}
vbet_googleTranslation($url, $translated);
return array_merge($translated, $subTranslated);
}
function vbet_translateText(&$toTranslate, $language, $serie) {
$trimmedToTranslate = trim($toTranslate);
if ($trimmedToTranslate == null || $trimmedToTranslate == '') {
return $toTranslate;
}
global $vbulletin;
$toTranslateLength = strlen($toTranslate);
$rightTruncationLength = strlen(rtrim($toTranslate));
$leftSpaces = substr($toTranslate, 0, $toTranslateLength - strlen(ltrim($toTranslate)));
$rightSpaces = substr($toTranslate, $rightTruncationLength , $toTranslateLength - $rightTruncationLength );
$toTranslate = vbet_getReEncoded($trimmedToTranslate);
return $leftSpaces.vbet_translateEncodedText(urlencode($toTranslate), $language, $serie).$rightSpaces ;
}
function vbet_googleTranslation(&$translationURL, &$tableForResults) {
$connection = @curl_init();
@curl_setopt($connection, CURLOPT_URL, $translationURL);
@curl_setopt($connection, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:1.4) Gecko/20030624 Netscape/7.1 (ax)");
@curl_setopt($connection, CURLOPT_FOLLOWLOCATION, 1);
@curl_setopt($connection, CURLOPT_RETURNTRANSFER, 1);
@curl_setopt($connection, CURLOPT_REFERER, vbet_getActualPathWithAll());
$result = @curl_exec ($connection);
curl_close ($connection);
preg_match_all('/{"translatedText":"(.*?)"}/', $result, $unwrappedResult, PREG_SET_ORDER);
$size = sizeof($unwrappedResult);
for($i = 0; $i < $size; $i++) {
$tableForResults[] = str_replace ('\u0026', '&' , $unwrappedResult[$i][1]);
}
}
function vbet_translateEncodedText(&$toTranslate, $language, $serie) {
global $vbulletin;
$translation = vbet_getFromCache($toTranslate, $language);
if ($translation) {
return $translation;
}
$forumLanguage = $vbulletin->options['vbenterprisetranslator_forumlanguage'];
$translationURL = vbet_getTranslationURL($forumLanguage,$language)."&q=".$toTranslate;
$translated = array();
vbet_googleTranslation($translationURL, $translated);
$translated = $translated[0];
if (vbet_useCache($language) && (strlen($translated) > 0)) {
$length = strlen($toTranslate);
if ($length<=50) {
$vbulletin->db->query_write("INSERT IGNORE INTO " . TABLE_PREFIX . "vbenterprisetranslator_cache_short SET tl='".$language."', originaltext='".addslashes($toTranslate)."', translated='".addslashes(trim($translated))."', serie=".$serie.", dateline=".TIMENOW);
} else if ($length > 328) {
$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "vbenterprisetranslator_cache SET tl='".$language."', originaltext='".addslashes($toTranslate)."', translated='".addslashes(trim($translated))."', serie=".$serie.", dateline=".TIMENOW);
} else {
$vbulletin->db->query_write("INSERT IGNORE INTO " . TABLE_PREFIX . "vbenterprisetranslator_cache_medium SET tl='".$language."', originaltext='".addslashes($toTranslate)."', translated='".addslashes(trim($translated))."', serie=".$serie.", dateline=".TIMENOW);
}
}
return $translated;
}
function vbet_addBase(&$base, &$url) {
if (strpos($url, 'http:')) {
return $url;
}
return $base.'/'.$url;
}
function vbet_getActualPathWithoutHost() {
if ($_SERVER['SCRIPT_URL']) {
return $_SERVER['SCRIPT_URL'];
}
if ($_SERVER['VBSEO_URI']) {
return vbet_createURLForAddress('', $_SERVER['VBSEO_URI']);
}
return vbet_createURLForAddress('', $_SERVER['REQUEST_URI']);
}
function vbet_getActualPathWithHost() {
if ($_SERVER['SCRIPT_URI']) {
return $_SERVER['SCRIPT_URI'];
}
return 'http://'.$_SERVER['HTTP_HOST'];
}
function vbet_getActualPathWithAll() {
$result = vbet_getActualPathWithHost();
if (!$_SERVER['VBSEO_URI'] && $_SERVER['QUERY_STRING']) {
$query = $_SERVER['QUERY_STRING'];
global $vbulletin;
if ($_REQUEST['language'] && $vbulletin->options['vbenterprisetranslator_translationlinkstype']) {
$query =& substr($query, 9 + strlen($_REQUEST['language']));
if (0 === strpos($query, '&')) {
$query =& substr($query, 1);
}
}
if ($query) {
$result .= '?'.$query;
}
}
return $result;
}
function vbet_getBaseURI() {
global $vbulletin, $vbet_baseUri;
if ($vbet_baseUri) {
return $vbet_baseUri;
}
$baseUri = vbet_getActualPathWithHost();
if (vbet_getActualPathWithoutHost() != '/') {
$baseUri = vbet_getActualPathWithHost();
$position = strpos($baseUri, vbet_getActualPathWithoutHost());
if ($position) {
$baseUri = substr($baseUri,0,$position);
}
}
if ($vbulletin->options['vbenterprisetranslator_forumdir']) {
$baseUri .= $vbulletin->options['vbenterprisetranslator_forumdir'];
}
$vbet_baseUri = $baseUri;
return $baseUri;
}
function vbet_isFromDomain(&$address) {
global $vbulletin;
return ($vbulletin->options['vbenterprisetranslator_forumdomain'] && strpos($address, $vbulletin->options['vbenterprisetranslator_forumdomain']))
|| (!$vbulletin->options['vbenterprisetranslator_forumdomain'] && (0 === strpos($address, vbet_getBaseURI())));
}
function vbet_createURLForAddressNoReplace($language, $address) {
global $vbulletin;
if (0 === strpos($address, 'javascript:')) {
return $address;
}
if (false !== strpos($address, 'css.php')) {
return $address;
}
if (0 === strpos($address, 'http:')) {
if (!vbet_isFromDomain($address)) {
return $address;
} else if ($vbulletin->options['vbenterprisetranslator_translationlinkstype']) {
global $vbet_languagesMatch;
if (preg_match('/\/('.$vbet_languagesMatch.')\//', $address)) {
return $address;
}
if (!$vbulletin->options['vbenterprisetranslator_forumdomain']) {
$baseUri = vbet_getBaseURI();
if ($address == $baseUri && '/' != $address[strlen($address) - 1]) {
$address .= '/';
}
return $baseUri.'/'.$language.substr($address, strlen($baseUri));
} else {
$index = strpos($address, $vbulletin->options['vbenterprisetranslator_forumdomain']) + strlen($vbulletin->options['vbenterprisetranslator_forumdomain']);
return substr($address, 0, $index).'/'.$language.substr($address, $index);
}
}
}
if ($vbulletin->options['vbenterprisetranslator_translationlinkstype']) {
return vbet_createURLForAddressNoReplaceSEO($language, $address) ;
}
$bookmark = strpos($address, '#');
if (false !== $bookmark) {
return vbet_createURLForAddressNoReplaceOld($language, substr($address, 0, $bookmark)).substr($address, $bookmark) ;
} else {
return vbet_createURLForAddressNoReplaceOld($language, $address) ;
}
}
function vbet_createURLForAddressNoReplaceSEO($language, $address) {
global $vbulletin;
if ($address[0] != '/') {
$address = '/'.$address;
}
if ($address == vbet_createURLForAddress('', vbet_getActualPathWithoutHost()) || $address == vbet_createURLForAddress('', $_SERVER['REQUEST_URI'])) {
return $address;
}
if ($vbulletin->options['vbenterprisetranslator_forumdir']) {
return vbet_createURLForAddressNoReplaceSEOSubdirectory($language, $address);
}
global $vbet_languagesMatch;
if (preg_match('/^\/('.$vbet_languagesMatch.')\//', $address)) {
return $address;
}
if (!$address) {
return '';
}
return vbet_createURLForAddressSEO($language, $address);
}
function vbet_createURLForAddressNoReplaceSEOSubdirectory($language, $address) {
global $vbulletin;
if ($address == $vbulletin->options['vbenterprisetranslator_forumdir'].vbet_createURLForAddress('', vbet_getActualPathWithoutHost()) || $address == $vbulletin->options['vbenterprisetranslator_forumdir'].vbet_createURLForAddress('', $_SERVER['REQUEST_URI'])) {
return $address;
}
global $vbet_languagesMatch;
if (preg_match('/^'.preg_quote($vbulletin->options['vbenterprisetranslator_forumdir'], '/').'\/('.$vbet_languagesMatch.')\//', $address)) {
return $address;
}
if ($address == $vbulletin->options['vbenterprisetranslator_forumdir'] || $address == $vbulletin->options['vbenterprisetranslator_forumdir'].'/') {
return '';
}
if (0 === strpos($address, $vbulletin->options['vbenterprisetranslator_forumdir'].'/')) {
$address = substr($address, strlen($vbulletin->options['vbenterprisetranslator_forumdir']));
}
return $vbulletin->options['vbenterprisetranslator_forumdir'].vbet_createURLForAddressSEO($language, $address);
}
function vbet_createURLForAddressNoReplaceOld($language, $address) {
global $vbulletin;
if (strstr($address,'language=')) {
return $address;
}
if (!$address) {
return '';
}
if ($address == vbet_getActualPathWithoutHost()) {
return $address;
}
return vbet_createURLForAddressOld($language, $address);
}
?>
