<? 

/** 
 * The AdminProcess class is meant to simplify the task of processing
 * admin submitted forms from the admin center, these deal with
 * member system adjustments. 
 */
include("../sources/session.php");

class AdminProcess
{
   /* Class constructor */
   function AdminProcess(){
      global $session;
	  global $HTTP_POST_VARS,$HTTP_GET_VARS,$HTTP_SERVER_VARS,$HTTP_SESSION_VARS,$HTTP_COOKIE_VARS;

      /* Make sure administrator is accessing page */
      if(!$session->isAdmin()){
         header("Location: ../index.php");
         return;
      }
      /* Admin submitted update user level form */
      if(isset($HTTP_POST_VARS['subupdlevel'])){
         $this->procUpdateLevel();
      }
      /* Admin submitted delete user form */
      else if(isset($HTTP_POST_VARS['subdeluser'])){
         $this->procDeleteUser();
      }
      /* Admin submitted delete inactive users form */
      else if(isset($HTTP_POST_VARS['subdelinact'])){
         $this->procDeleteInactive();
      }
      /* Admin submitted ban user form */
      else if(isset($HTTP_POST_VARS['subbanuser'])){
         $this->procBanUser();
      }
      /* Admin submitted delete banned user form */
      else if(isset($HTTP_POST_VARS['subdelbanned'])){
         $this->procDeleteBannedUser();
      }
	  /* Admin submitted Bann user from Song Upload form */
      else if(isset($HTTP_POST_VARS['subbansongupload'])){
         $this->procBanUserFromSongUpload();
      }	 
      /* Should not get here, redirect to home page */
      else{
         header("Location: admin.php");
      }
   }

   /**
    * procUpdateLevel - If the submitted username is correct,
    * their user level is updated according to the admin's
    * request.
    */
   function procUpdateLevel(){
      global $session, $database, $form;
	  global $HTTP_POST_VARS,$HTTP_GET_VARS,$HTTP_SERVER_VARS,$HTTP_SESSION_VARS,$HTTP_COOKIE_VARS;
      /* Username error checking */
      $subuser = $this->checkUsername("upduser");

      /* Errors exist, have user correct them */
      if($form->num_errors > 0){
         $HTTP_SESSION_VARS['value_array'] = $HTTP_POST_VARS;
         $HTTP_SESSION_VARS['error_array'] = $form->getErrorArray();
         header("Location: admin.php");
      }
      /* Update user level */
      else{
         $database->updateUserField($subuser, "userlevel", (int)$HTTP_POST_VARS['updlevel']);
         header("Location: admin.php");
      }
   }
   
   /**
    * procDeleteUser - If the submitted username is correct,
    * the user is deleted from the database.
    */
   function procDeleteUser(){
      global $session, $database, $form;
	  global $HTTP_POST_VARS,$HTTP_GET_VARS,$HTTP_SERVER_VARS,$HTTP_SESSION_VARS,$HTTP_COOKIE_VARS;
      /* Username error checking */
      $subuser = $this->checkUsername("deluser");
      
      /* Errors exist, have user correct them */
      if($form->num_errors > 0){
         $HTTP_SESSION_VARS['value_array'] = $HTTP_POST_VARS;
         $HTTP_SESSION_VARS['error_array'] = $form->getErrorArray();
         header("Location: admin.php");
      }
      /* Delete user from database */
      else{
         $q = "DELETE FROM ".TBL_USERS." WHERE username = '$subuser'";
         mysql_query($q);
         header("Location: admin.php");
      }
   }
   
   /**
    * procDeleteInactive - All inactive users are deleted from
    * the database, not including administrators. Inactivity
    * is defined by the number of days specified that have
    * gone by that the user has not logged in.
    */
   function procDeleteInactive(){
      global $session, $database;
	  global $HTTP_POST_VARS,$HTTP_GET_VARS,$HTTP_SERVER_VARS,$HTTP_SESSION_VARS,$HTTP_COOKIE_VARS;

      $inact_time = $session->time - $HTTP_POST_VARS['inactdays']*24*60*60;
      $q = "DELETE FROM ".TBL_USERS." WHERE timestamp < $inact_time "
          ."AND userlevel != ".ADMIN_LEVEL;
      mysql_query($q);
      header("Location: admin.php");
   }
   
   /**
    * procBanUser - If the submitted username is correct,
    * the user is banned from the member system, which entails
    * removing the username from the users table and adding
    * it to the banned users table.
    */
   function procBanUser(){
      global $session, $database, $form;
	  global $HTTP_POST_VARS,$HTTP_GET_VARS,$HTTP_SERVER_VARS,$HTTP_SESSION_VARS,$HTTP_COOKIE_VARS;

      /* Username error checking */
      $subuser = $this->checkUsername("banuser");
      
      /* Errors exist, have user correct them */
      if($form->num_errors > 0){
         $HTTP_SESSION_VARS['value_array'] = $HTTP_POST_VARS;
         $HTTP_SESSION_VARS['error_array'] = $form->getErrorArray();
         header("Location: admin.php");
      }
      /* Ban user from member system */
      else{
         $q = "DELETE FROM ".TBL_USERS." WHERE username = '$subuser'";
         mysql_query($q);

         $q = "INSERT INTO ".TBL_BANNED_USERS." VALUES ('$subuser', $session->time)";
         mysql_query($q);
         header("Location: admin.php");
      }
   }
   
   /**
    * procDeleteBannedUser - If the submitted username is correct,
    * the user is deleted from the banned users table, which
    * enables someone to register with that username again.
    */
   function procDeleteBannedUser(){
      global $session, $database, $form;
	  global $HTTP_POST_VARS,$HTTP_GET_VARS,$HTTP_SERVER_VARS,$HTTP_SESSION_VARS,$HTTP_COOKIE_VARS;

      /* Username error checking */
      $subuser = $this->checkUsername("delbanuser", true);
      
      /* Errors exist, have user correct them */
      if($form->num_errors > 0){
         $HTTP_SESSION_VARS['value_array'] = $HTTP_POST_VARS;
         $HTTP_SESSION_VARS['error_array'] = $form->getErrorArray();
         header("Location: admin.php");
      }
      /* Delete user from database */
      else{
         $q = "DELETE FROM ".TBL_BANNED_USERS." WHERE username = '$subuser'";
         mysql_query($q);
         header("Location: admin.php");
      }
   }



/**
    * procBanUserFromSongUpload - If the submitted username is correct,
    * the user Song Upload Status will change with '0' in users table
    */
   function procBanUserFromSongUpload(){
      global $session, $database, $form;
	  global $HTTP_POST_VARS,$HTTP_GET_VARS,$HTTP_SERVER_VARS,$HTTP_SESSION_VARS,$HTTP_COOKIE_VARS;
		
      /* Username error checking */
      $subuser = $this->checkUsername("bansongupload", true);
      
      /* Errors exist, have user correct them */
      if($form->num_errors > 0){
         $HTTP_SESSION_VARS['value_array'] = $HTTP_POST_VARS;
         $HTTP_SESSION_VARS['error_array'] = $form->getErrorArray();
         header("Location: admin.php");
      }
      /* Ban User From Song Upload from database */
      else{
		
         $q = "UPDATE ".TBL_USERS." SET song_upload_status = 0 WHERE username = '$subuser'";
		 mysql_query($q);
         header("Location: admin.php");
      }
   }



   
   /**

   
   /**
    * checkUsername - Helper function for the above processing,
    * it makes sure the submitted username is valid, if not,
    * it adds the appropritate error to the form.
    */
   function checkUsername($uname, $ban=false){
      global $database, $form;
	  global $HTTP_POST_VARS,$HTTP_GET_VARS,$HTTP_SERVER_VARS,$HTTP_SESSION_VARS,$HTTP_COOKIE_VARS;

      /* Username error checking */
      $subuser = $HTTP_POST_VARS[$uname];
      $field = $uname;  //Use field name for username
      if(!$subuser || strlen($subuser = trim($subuser)) == 0){
         $form->setError($field, "* Username not entered<br>");
      }
      else{
         /* Make sure username is in database */
         $subuser = stripslashes($subuser);
         if(strlen($subuser) < 3 || strlen($subuser) > 30 ||
            !eregi("^([0-9a-z])+$", $subuser) ||
            (!$ban && !$database->usernameTaken($subuser))){
            $form->setError($field, "* Username does not exist<br>");
         }
      }
      return $subuser;
   }
};

/* Initialize process */
$adminprocess = new AdminProcess;

?>
