<?php

/** 
 * This include displays a HTML list of all available avatars, allowing the user to select one. 
 */

/**
 * Recursive version of glob to suit versions from 4.0.6 to above.(glob is supported by 4.3.0 and higher versions of PHP). 
 *
 * @return array containing all pattern-matched files.
 *
 * @param string $sDir      Directory to start with.
 * @param string $sPattern  Pattern to glob for.
 * @param int $nFlags      Flags sent to glob.
 */
function rglob($sDir, $sPattern, $nFlags = NULL)
{
  $sDir = escapeshellcmd($sDir); 
  // Get the list of all matching files currently in the
  // directory.

  //$aFiles = glob("$sDir/$sPattern", $nFlags);
  $aFiles = nglob($sDir, $nFlags);

  // Then get a list of all directories in this directory, and
  // run ourselves on the resulting array.  This is the
  // recursion step, which will not execute if there are no
  // directories.

 foreach (nglob($sDir.'/', "GLOB_ONLYDIR") as $sSubDir)	//	foreach (glob("$sDir/*", "GLOB_ONLYDIR") as $sSubDir)
  {
//	if(is_dir($sSubDir) && $sSubDir != '.' && $sSubDir != '..')
	if(is_dir($sSubDir))
	  {
		$aSubFiles = rglob($sSubDir, $sPattern, $nFlags);
		$aFiles = array_merge($aFiles, $aSubFiles);
	  }

  }
/**/
  // The array we return contains the files we found, and the
  // files all of our children found.
/*******************************************************/ 
  for($vloop=0;$vloop<count($aFiles);$vloop++)
	{
		$vvfiles[] = $sDir.$aFiles[$vloop];
	}


	return $vvfiles;
/********************************************************/
 // return $aFiles;
}

/* Get Listing of avatars */
if (is_dir(AVATAR_DIR.AVATARS_DIR_STOCK))
    $files = rglob (AVATAR_DIR.AVATARS_DIR_STOCK, '*');
else
    $files = array();

#sorting won't solve your '.' and '..' problem.
#sort ($files, SORT_STRING);

/**
 * Display table of images
 */

 echo '<table>';
 # you can't start off with 0. that will add a extra one to the line.
 $x = 1;
 # looping files does not need a for loop. also for loops result in
 #  weird indexing and skipped indexes in some cases. use ofreach to
 #  cycle in cases like this.
 foreach ($files as $avatar) {
  # one means starting row.
  if ($x == 1) {
   echo '<tr>';
  }
  # strip out path.
  $avatar = substr($avatar, strlen(AVATARS_DIR));
  # show input and image.
  echo '<td>';
  echo '<input type="radio" name="avatar" value="'.$avatar.'" '.($form->value("avatar") == $avatar ? 'checked' : '').' onClick="document.getElementById(\'avatar_type_choose\').checked=1">';
  echo '<img src="../avatars/'.$avatar.'" width="30" height="30" alt="'.$avatar.'" align="middle">';
  echo '</td>';
  # last column, row end.
  if ($x == AVATARS_PER_ROW) {
   echo '</tr>';
   #restart loop, becomes 1 in next line on $x++ crank.
   $x = 0;
  }
  $x++;
 }
 # did you exit cleanly from the loop?
 #  $x = 0; is in the AVATARS_PER_ROW then $x++; is done.
 #  this results in a 1 result on clean looping.
 if ($x != 1) {
  # till we are at the last column keep going.
  while ($x != AVATARS_PER_ROW) {
   echo '<td></td>';
   $x++;
  }
  # we are clean now, end the row.
  echo '</tr>';
 }
 echo '</table>';


 function nglob($sDir,$nFlags="") {
  $handle = opendir($sDir);
  while (false !== ($file = readdir($handle))) {
   # on *nix the first files are '.' and '..' but you're on a windows server.
   #  windows does not put '.' and '..' first so you can NOT delete
   #  the first 2 indexes in a array and be ok.
   #  to do this the proper way you look for '.'  and '..' as a value.
   #  these will never be file names so a is_dir() check is trivial/pointless.
   if ($file != '.' && $file != '..') {
    $files[] = $file;
   }
  }
  closedir($handle);
  return $files;
 }

?>
