<? 
/** 
 * The Form class is meant to simplify the task of keeping
 * track of errors in user submitted forms and the form
 * field values that were entered correctly.
 * 
 */
 
class Form
{
   var $values = array();  //Holds submitted form field values
   var $errors = array();  //Holds submitted form error messages
   var $num_errors;   //The number of errors in submitted form

   /* Class constructor */
   function Form(){
	   global $HTTP_POST_VARS,$HTTP_GET_VARS,$HTTP_SERVER_VARS,$HTTP_SESSION_VARS,$HTTP_COOKIE_VARS;
      /**
       * Get form value and error arrays, used when there
       * is an error with a user-submitted form.
       */

	if(isset($HTTP_SESSION_VARS['value_array']) && isset($HTTP_SESSION_VARS['error_array'])){
         $this->values = $HTTP_SESSION_VARS['value_array'];
         $this->errors = $HTTP_SESSION_VARS['error_array'];
//echo("FORM 1 : ".$HTTP_SESSION_VARS['error_array']);
         $this->num_errors = count($this->errors);

         unset($HTTP_SESSION_VARS['value_array']);
         unset($HTTP_SESSION_VARS['error_array']);
      }
      else{
         $this->num_errors = 0;
      }
   }

   /**
    * setValue - Records the value typed into the given
    * form field by the user.
    */
   function setValue($field, $value){
      $this->values[$field] = $value;
   }

   /**
    * setError - Records new form error given the form
    * field name and the error message attached to it.
    */
   function setError($field, $errmsg){	 
//echo("FORM 2 : ".$errmsg);

     $this->errors[$field] = $errmsg;	 
     $this->num_errors = count($this->errors);
//echo("FORM 3 : ".$this->num_errors);
   }

   /**
    * value - Returns the value attached to the given
    * field, if none exists, the empty string is returned.
    */
   function value($field){
     if(array_keys($this->values,$field)){	// ENSYS
	   //if(array_key_exists($field,$this->values)){
         return htmlspecialchars(stripslashes($this->values[$field]));
      }else{
         return "";
      }
   }

   /**
    * error - Returns the error message attached to the
    * given field, if none exists, the empty string is returned.
    */
   function error($field){	
  
      if(array_keys($this->errors,$field)){	// ENSYS
	//	if(array_key_exists($field,$this->errors)){
         return "<font size=\"2\" color=\"#ff0000\">".$this->errors[$field]."</font>";
      }else{
         return "";
      }
	  /**/
   }

   /* getErrorArray - Returns the array of error messages */
   function getErrorArray(){
      return $this->errors;
   }
};
 
?>
