<?php
/*
Plugin Name: التقويم الهجري
Plugin URI: http://www.sewar.be/wordpress/plugins/hijri-date-ar/
Description: تمكنك من إستبدال التاريخ الميلادي بالتاريخ الهجري للتدوينات. بعد تفعيلها يجب عليك تعديل القوالب كما ذكر في <a href="http://www.sewar.be/wordpress/plugins/hijri-date-ar/">صفحة الإضافة</a>. تعريب <a href="http://www.sewar.be">سوار</a>.
Version: 1.87
Author: يونس يوسايد
Author URI: http://www.usayd.com
*/
/*
Please refer to the readme.txt for installation instructions. The hirji calculations have external permissions. Stable version from 0.15. 0.6+ comes with admin panel.
*/
/*  Copyright 2005  Usayd Younis  (email : plugins@usayd.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
function show_hijridate($hijri_time_format = false, $georgian_time_format = false, $seperator = false) {
echo unn_hijridate($hijri_time_format, $georgian_time_format, $seperator);
}
function unn_hijridate($hijri_time_format = false, $georgian_time_format = false, $seperator = false) {
$current_settings = get_option('unn_hijridate_options');
if ($hijri_time_format === false) $hijri_time_format = $current_settings['hijri_time_format'];
if ($georgian_time_format === false) $georgian_time_format = $current_settings['georgian_time_format'];
if ($seperator === false) $seperator = $current_settings['seperator'];
	if ($current_settings['hijriandgeorgian'] == 0){
		$timestamp = strtotime(get_post_time('Y-m-d H:i:s', true));

		$thisYear = strftime("%Y", $timestamp);
		$thisMonth = strftime("%m", $timestamp);
		if ($thisMonth < 10)
			$thisMonth = substr($thisMonth, 1, 1);
		$thisDay = trim(strftime("%e", $timestamp));

		$greg_part = strftime($georgian_time_format, $timestamp);

		$hijri_date = jd2hijri(greg2jd($thisDay, $thisMonth, $thisYear));
		$hijri_part = sprintf($hijri_time_format, $hijri_date[0],
		hijrimonth2name($hijri_date[1]), $hijri_date[2]);

		return $current_settings['start']. $greg_part .$seperator. $hijri_part .$current_settings['end'];

	} else if ($current_settings['hijriandgeorgian'] == 1) {

		//hijri_date
		$timestamp = strtotime(get_post_time('Y-m-d H:i:s', true));

		$thisYear = strftime("%Y", $timestamp);
		$thisMonth = strftime("%m", $timestamp);
		if ($thisMonth < 10)
			$thisMonth = substr($thisMonth, 1, 1);
		$thisDay = trim(strftime("%e", $timestamp));

		$hijri_date = jd2hijri(greg2jd($thisDay, $thisMonth, $thisYear));
		$hijri_part = sprintf("$hijri_time_format", $hijri_date[0],
		hijrimonth2name($hijri_date[1]), $hijri_date[2]);

		return $current_settings['start']. $hijri_part .$current_settings['end'];

	} else if ($current_settings['hijriandgeorgian'] == 2) {

		// georgian_date() {
		$timestamp = strtotime(get_post_time('Y-m-d H:i:s', true));

		$thisYear = strftime("%Y", $timestamp);
		$thisMonth = strftime("%m", $timestamp);
		if ($thisMonth < 10)
			$thisMonth = substr($thisMonth, 1, 1);
		$thisDay = trim(strftime("%e", $timestamp));

		$greg_part = strftime($georgian_time_format, $timestamp);

		$hijri_date = jd2hijri(greg2jd($thisDay, $thisMonth, $thisYear));
		$hijri_part = sprintf($hijri_time_format, $hijri_date[0],
		hijrimonth2name($hijri_date[1]), $hijri_date[2]);

		return $current_settings['start']. $greg_part .$current_settings['end'];
	}

}

function greg2jd($d, $m, $y) {
	$jd = (1461 * ($y + 4800 + ($m - 14) / 12)) / 4 +
	(367 * ($m - 2 - 12 * (($m - 14) / 12))) / 12 -
	(3 * (($y + 4900 + ($m - 14) / 12) / 100 )) / 4 +
	$d - 32075;

	return $jd;
}

function jd2hijri($jd) {
	$jd = $jd - 1948440 + 10632;
	$n = (int) (($jd - 1) / 10631);
	$jd = $jd - 10631 * $n + 354;
	$j = ((int) ((10985 - $jd) / 5316)) *
	((int) (50 * $jd / 17719)) +
	((int) ($jd / 5670)) *
	((int) (43 * $jd / 15238));
	$jd = $jd - ((int) ((30 - $j) / 15)) *
	((int) ((17719 * $j) / 50)) -
	((int) ($j / 16)) *
	((int) ((15238 * $j) / 43)) + 29;
	$m = (int) (24 * $jd / 709);
	$d = $jd - (int) (709 * $m / 24);
	$y = 30 * $n + $j - 30;

	return array($d, $m, $y);
}

function hijrimonth2name($m) {
	switch($m) {
		case 1:
			return 'محرم';
		case 2:
			return 'صفر';
		case 3:
			return 'ربيع الأول';
		case 4:
			return 'ربيع الثاني';
		case 5:
			return 'جمادى الأول';
		case 6:
			return 'جمادى الثاني';
		case 7:
			return 'رجب';
		case 8:
			return 'شعبان';
		case 9:
			return 'رمضان';
		case 10:
			return 'شوال';
		case 11:
			return 'ذو القعدة';
		case 12:
			return 'ذو الحجة';
	}
}


function bstOffset($currDate) {
	$thisYear = (date("Y"));
	$marStartDate = ($thisYear."-03-25");
	$octStartDate = ($thisYear."-10-25");
	$marEndDate = ($thisYear."-03-31");
	$octEndDate = ($thisYear."-10-31");


	while ($marStartDate <= $marEndDate) {
		$day = date("l", strtotime($marStartDate));
		if ($day == "Sunday")
			$bstStartDate = $marStartDate;
		$marStartDate++;
	}


	$bstStartDate = (date("U", strtotime($bstStartDate))+(60*60));


	while ($octStartDate <= $octEndDate) {
		$day = date("l", strtotime($octStartDate));
		if ($day == "Sunday")
			$bstEndDate = $octStartDate;
		$octStartDate++;
	}

	$bstEndDate = (date("U", strtotime($bstEndDate))+(60*60));

        if ($currDate < bstEndDate && $currDate > $bstStartDate)
		return 1;
	else
		return 0;
}
// begin options page (borrowed from footnotes plugin)
function unn_hijridate_options_page() {
	$current_settings = get_option('unn_hijridate_options');
	if ($_POST['action']){?>
		<div class="updated"><p><strong>تم حفظ الإعدادات.</strong></p></div>
 	<?php } ?>
    <div class="wrap" id="hijridate-options">
		<h2>إعدادات التقويم الهجري</h2>
		<p>يوجد بعض الإعدادات تستطيع تعديلها لعرض التاريخ بإستخدام <a href="http://www.sewar.be/wordpress/plugins/hijri-date-ar/">إضافة القويم الهجري</a>.</p>
		<p>بإمكانك إستخدام شفرات HTML للخيارات. صيغة التاريخ تستخدم <a href="http://de3.php.net/manual/en/function.strftime.php">strftime</a>.</p>

		<form method="post" action="<?php echo $_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING']; ?>">
			<fieldset>
				<legend>الإعدادات:</legend>
				<input type="hidden" name="action" value="save_options" />
				<table width="100%" cellspacing="2" cellpadding="5" class="editform">
				<tr>
					<th scope="row">عرض:</th>
					<td>
						<label for="hijriandgeorgian0"><input name="hijriandgeorgian" id="hijriandgeorgian0" type="radio" value="0" <?php if ($current_settings['hijriandgeorgian'] == 0) echo 'checked="checked"'; ?> />التاريخ الهجري و التاريخ الميلادي</label><br />
						<label for="hijriandgeorgian1"><input name="hijriandgeorgian" id="hijriandgeorgian1" type="radio" value="1" <?php if ($current_settings['hijriandgeorgian'] == 1) echo 'checked="checked"'; ?> />التاريخ الهجري فقط</label><br />
						<label for="hijriandgeorgian2"><input name="hijriandgeorgian" id="hijriandgeorgian2" type="radio" value="2" <?php if ($current_settings['hijriandgeorgian'] == 2) echo 'checked="checked"'; ?> />التاريخ الميلادي فقط</label><br />
					</td>
				</tr>
				<tr>
					<th width="33%" valign="top" scope="row"><label for="georgian_time_format">صيغة التاريخ الميلادي:</label></th><td><input type="text" name="georgian_time_format" id="georgian_time_format" value="<?php echo $current_settings['georgian_time_format']; ?>" /><br />القيمة الإفتراضية: %d %B %Y ميلادي</td>
				</tr>
				<tr>
					<th width="33%" valign="top" scope="row"><label for="hijri_time_format">صيغة التاريخ الهجري:</label></th><td><input type="text" name="hijri_time_format" id="hijri_time_format" value="<?php echo $current_settings['hijri_time_format']; ?>" /><br />القيمة الإفتراضية: %02d %s %d هجري</td>
				</tr>
				<tr>
					<th width="33%" valign="top" scope="row"><label for="start">قبل التاريخ:</label></th><td><input type="text" name="start" value="<?php echo $current_settings['start']; ?>" /></td>
				</tr>
				<tr>
					<th width="33%" valign="top" scope="row"><label for="seperator">فاصل بين التاريخ الهجري و الميلادي:</label></th><td><input type="text" id="seperator" name="seperator" value="<?php echo $current_settings['seperator']; ?>" /><br />القيمة الإفتراضية: | </td>
				</tr>
				<tr>
					<th width="33%" valign="top" scope="row"><label for="end">بعد التاريخ:</label></th><td><input type="text" name="end" value="<?php echo $current_settings['end']; ?>" /></td>
				</tr>
				</table>
			</fieldset>
			<fieldset class="options"><legend>مثال:</legend>
				<div align="center"><strong><?php echo unn_hijridate(); ?></strong></div>
				<br />
</fieldset>
			<div style="text-align: center; clear: both; color: darkgrey;"><small>إضافة التقويم الهجري من برمجة <a href="http://www.usayd.com/" style="color: #666; border: 0px;">يونس يوسايد</a> &copy;2006. هذا الإصدارة 1.87</small></div>
			<p class="submit">
				<input type="submit" name="Submit" value="حفظ الإعدادات &raquo;" />
			</p>
			<script type="text/javascript"><!--
document.getElementById('hijriandgeorgian1').onclick = document.getElementById('hijriandgeorgian2').onclick = function () { document.getElementById('seperator').disabled = true; };
document.getElementById('hijriandgeorgian0').onclick = function () { document.getElementById('seperator').disabled = false; };
--></script>
		</form>
	</div>
<?php
}

function unn_add_options() {
	// Add a new menu under Options:
	add_options_page('التقويم الهجري', 'التقويم الهجري', 8, __FILE__, 'unn_hijridate_options_page');
}

function unn_save_options() {
	global $hijridate_options;
	// create array
	if (isset($_POST['hijriandgeorgian'])) {
		$hijridate_options['hijriandgeorgian'] = (int) $_POST['hijriandgeorgian'];
		$hijridate_options['georgian_time_format'] = $_POST['georgian_time_format'];
		$hijridate_options['hijri_time_format'] = $_POST['hijri_time_format'];
		$hijridate_options['start'] = $_POST['start'];
		$hijridate_options['seperator'] = $_POST['seperator'];
		$hijridate_options['end'] = $_POST['end'];

		update_option('unn_hijridate_options', $hijridate_options);
	}
}

add_action('admin_menu', 'unn_add_options'); 		// Insert the Admin panel.

if (!get_option('unn_hijridate_options')){
	// create default options
	$hijridate_options = array();
	$hijridate_options['hijriandgeorgian'] = 0;
	$hijridate_options['georgian_time_format'] = '%d %B %Y ميلادي';
	$hijridate_options['hijri_time_format'] = '%02d %s %d هجري';
	$hijridate_options['start'] = '';
	$hijridate_options['seperator'] = ' | ';
	$hijridate_options['end'] = '';

	update_option('unn_hijridate_options', $hijridate_options);
}

if ($_POST['action'] == 'save_options'){
	unn_save_options();
}
?>