<?php get_header(); ?>

	<div id="content" class="widecolumn">

  <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
	
		<div class="navigation">
			<div class="alignleft"><?php previous_post_link('&laquo; %link') ?></div>
			<div class="alignright"><?php next_post_link('%link &raquo;') ?></div>
		</div>
	
		<div class="post" id="post-<?php the_ID(); ?>">
			<h2><a href="<?php echo get_permalink() ?>" rel="bookmark" title="رابط ثابت: <?php the_title(); ?>"><?php the_title(); ?></a></h2>
	
			<div class="entrytext">
				<?php the_content('<p class="serif">إقرأ بقية الموضوع &raquo;</p>'); ?>
	
				<?php link_pages('<p><strong>صفحات:</strong> ', '</p>', 'number'); ?>
	
				<p class="postmetadata alt">
					<small>
						هذا الموضوع كتب في <?php the_time(get_settings('date_format')) ?> 
						في الساعة <?php the_time() ?> ومصنف بهذه التصنيفات: <?php the_category(', ') ?>.
						يمكنك متابعة التعليقات على هذا الموضوع عن طريق ملف الخلاصات  <?php comments_rss_link('RSS 2.0'); ?>. 

						<?php if (('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
							// Both Comments and Pings are open ?>
							يمكنك أن <a href="#respond">تكتب تعليقاً</a>, أو <a href="<?php trackback_url(true); ?>" rel="trackback">تعقب</a> على الموضوع من موقعك.

						<?php } elseif (!('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
							// Only Pings are Open ?>
							لا يمكنك التعليق على الموضوع، لكن يمكنك كتابة <a href="<?php trackback_url(true); ?> " rel="trackback">تعقيب</a> من موقعك.

						<?php } elseif (('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
							// Comments are open, Pings are not ?>
							Yيمكنك كتابة تعليق، لكن لا يمكن التعقيب على الموضوع في المواقع الأخرى.

						<?php } elseif (!('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
							// Neither Comments, nor Pings are open ?>
							لا يمكن التعليق على الموضوع أو كتابة تعقيبات عليه في المواقع الأخرى.			

						<?php } edit_post_link('تحرير الموضوع.','',''); ?>

					</small>
				</p>
	
			</div>
		</div>

	<?php comments_template(); ?>
	
	<?php endwhile; else: ?>
	
		<p>عفواً، لا توجد مواضيع لعرضها.</p>
	
<?php endif; ?>
	
	</div>

<?php get_footer(); ?>