<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 2.0.1
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2009 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'blog_tag');
define('VBBLOG_PERMS', true);
define('VBBLOG_STYLE', true);
define('CSRF_PROTECTION', true);
define('VBBLOG_SCRIPT', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array(
	'vbblogglobal',
	'vbblogcat',
);

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array(
	'cloud' => array(
		'BLOG',
		'blog_css',
		'blog_usercss',
		'blog_sidebar_calendar',
		'blog_sidebar_calendar_day',
		'blog_sidebar_category_link',
		'blog_sidebar_comment_link',
		'blog_sidebar_custompage_link',
		'blog_sidebar_entry_link',
		'blog_sidebar_generic',
		'blog_sidebar_user',
		'blog_sidebar_user_block_archive',
		'blog_sidebar_user_block_category',
		'blog_sidebar_user_block_comments',
		'blog_sidebar_user_block_entries',
		'blog_sidebar_user_block_search',
		'blog_sidebar_user_block_tagcloud',
		'blog_sidebar_user_block_visitors',
		'blog_sidebar_user_block_custom',
		'blog_tag_cloud_box',
		'blog_tag_cloud_link',
		'blog_tag_cloud',
		'memberinfo_visitorbit',
		'tag_cloud_headinclude',
		'ad_blog_sidebar_start',
		'ad_blog_sidebar_middle',
		'ad_blog_sidebar_end',
	),
	'tagedit' => array(
		'BLOG',
		'blog_css',
		'blog_usercss',
		'blog_tag_cloud_link',
		'blog_tag_edit',
		'blog_tag_edit_form',
		'newpost_errormessage',
		'tag_managebit',
		'ad_blog_sidebar_start',
		'ad_blog_sidebar_middle',
		'ad_blog_sidebar_end',
		'blog_sidebar_entry_link',
		'blog_sidebar_user_block_archive',
		'blog_sidebar_user_block_category',
		'blog_sidebar_user_block_comments',
		'blog_sidebar_user_block_entries',
		'blog_sidebar_user_block_search',
		'blog_sidebar_user_block_tagcloud',
		'blog_sidebar_user_block_visitors',
		'blog_sidebar_user_block_custom',
	),
);

$actiontemplates['tagupdate'] =& $actiontemplates['tagedit'];

if (empty($_REQUEST['do']))
{
	if (empty($_REQUEST['tag']))
	{
		$_REQUEST['do'] = 'cloud';
	}
	else
	{
		$_REQUEST['do'] = 'tag';
	}
}

if ($_REQUEST['do'] == 'cloud')
{
	$specialtemplates[] = 'blogtagcloud';
}
else if ($_GET['do'] == 'tagedit' OR ($_POST['do'] == 'tagupdate' AND !$_POST['ajax']))
{
	$actiontemplates['tagedit'] = array_merge($actiontemplates['tagedit'], array(
		'blog_sidebar_calendar',
		'blog_sidebar_calendar_day',
		'blog_sidebar_category_link',
		'blog_sidebar_comment_link',
		'blog_sidebar_custompage_link',
		'blog_sidebar_user',
		'memberinfo_visitorbit',
	));
}

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/blog_init.php');
require_once(DIR . '/includes/blog_functions_tag.php');

if (!$vbulletin->options['vbblog_tagging'])
{
	print_no_permission();
}

($hook = vBulletinHook::fetch_hook('blog_tags_start')) ? eval($hook) : false;

if ($_REQUEST['do'] == 'tagedit' OR $_POST['do'] == 'tagupdate')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'blogid' => TYPE_UINT,
	));

	$bloginfo = verify_blog($blogid);

	$show['add_option'] = (
		(($vbulletin->userinfo['permissions']['vbblog_entry_permissions'] & $vbulletin->bf_ugp_vbblog_entry_permissions['blog_cantagown']) AND $bloginfo['userid'] == $vbulletin->userinfo['userid'])
		OR ($vbulletin->userinfo['permissions']['vbblog_entry_permissions'] & $vbulletin->bf_ugp_vbblog_entry_permissions['blog_cantagothers']
		OR can_moderate_blog('caneditentries'))
	);

	$show['manage_existing_option'] = (
		$show['add_option']
		OR (($vbulletin->userinfo['permissions']['vbblog_entry_permissions'] & $vbulletin->bf_ugp_vbblog_entry_permissions['blog_candeletetagown']) AND $bloginfo['userid'] == $vbulletin->userinfo['userid'])
		OR can_moderate_blog('caneditentries')
	);

	if (!$show['add_option'] AND !$show['manage_existing_option'])
	{
		print_no_permission();
	}
}

// #######################################################################
if ($_POST['do'] == 'tagupdate')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'tagskept'  => TYPE_ARRAY_UINT,
		'tagsshown' => TYPE_ARRAY_UINT,
		'taglist'   => TYPE_NOHTML,
		'userid'    => TYPE_UINT,
	));

	if ($vbulletin->GPC['ajax'])
	{
		$vbulletin->GPC['taglist'] = convert_urlencoded_unicode($vbulletin->GPC['taglist']);
	}

	if ($vbulletin->GPC['tagsshown'] AND $show['manage_existing_option'])
	{
		$tags_sql = $db->query_read("
			SELECT tag.*, tagentry.userid
			FROM " . TABLE_PREFIX . "blog_tagentry AS tagentry
			INNER JOIN " . TABLE_PREFIX . "blog_tag AS tag ON (tag.tagid = tagentry.tagid)
			WHERE tagentry.blogid = $bloginfo[blogid]
				AND tagentry.tagid IN (" . implode(',', $vbulletin->GPC['tagsshown']) . ")
		");

		$delete = array();
		while ($tag = $db->fetch_array($tags_sql))
		{
			if ($tag['userid'] == $vbulletin->userinfo['userid']
				OR (($vbulletin->userinfo['permissions']['vbblog_entry_permissions'] & $vbulletin->bf_ugp_vbblog_entry_permissions['blog_candeletetagown']) AND $bloginfo['userid'] == $vbulletin->userinfo['userid'])
				OR can_moderate_blog('caneditentries')
			)
			{
				if (!in_array($tag['tagid'], $vbulletin->GPC['tagskept']))
				{
					$delete[] = $tag['tagid'];
				}
			}
		}

		($hook = vBulletinHook::fetch_hook('blog_tag_domanage_delete')) ? eval($hook) : false;

		if ($delete)
		{
			$db->query_write("
				DELETE FROM " . TABLE_PREFIX . "blog_tagentry
				WHERE blogid = $bloginfo[blogid]
					AND tagid IN (" . implode(',', $delete) . ")
			");

			$bloginfo['taglist'] = build_entry_taglist($bloginfo['blogid']);

			// invalidate users tag cloud
			$dataman =& datamanager_init('Blog_User', $vbulletin, ERRTYPE_STANDARD);
			$info = array('bloguserid' => $bloginfo['userid']);
			$dataman->set_existing($info);
			$dataman->set('tagcloud', '');
			$dataman->save();
			unset($dataman);
		}
	}

	($hook = vBulletinHook::fetch_hook('blog_tag_domanage_postdelete')) ? eval($hook) : false;

	if ($vbulletin->GPC['taglist'] AND $show['add_option'])
	{
		if (!($errors = add_tags_to_entry($bloginfo, $vbulletin->GPC['taglist'], $bloginfo)) AND !$delete)
		{
			// invalidate users tag cloud
			$dataman =& datamanager_init('Blog_User', $vbulletin, ERRTYPE_STANDARD);
			$info = array('bloguserid' => $bloginfo['userid']);
			$dataman->set_existing($info);
			$dataman->set('tagcloud', '');
			$dataman->save();
			unset($dataman);
		}
	}
	else
	{
		$errors = array();
	}

	if ($vbulletin->GPC['ajax'])
	{
		$bloginfo = fetch_bloginfo($bloginfo['blogid'], false); // get updated tag list
		$tagcount = ($bloginfo['taglist'] ? count(explode(',', $bloginfo['taglist'])) : 0);

		require_once(DIR . '/includes/class_xml.php');

		$userinfo = array(
			'userid' => $vbulletin->GPC['userid']
		);
		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_group('tag');
			$xml->add_tag('taghtml', process_replacement_vars(fetch_entry_tagbits($bloginfo, $userinfo)));
			if ($errors)
			{
				$errorlist = '';
				foreach ($errors AS $error)
				{
					$errorlist .= "\n   * $error";
				}
				$xml->add_tag('warning', fetch_error('tag_add_failed_plain', $errorlist));
			}
		$xml->close_group();
		$xml->print_xml();
	}
	else
	{
		if ($errors)
		{
			$errorlist = '';
			foreach ($errors AS $key => $errormessage)
			{
				eval('$errorlist .= "' . fetch_template('newpost_errormessage') . '";');
			}

			$errorlist = fetch_error('entry_tag_add_failed_html', $errorlist, 'blog.php?' . $vbulletin->session->vars['sessionurl'] . "b=$bloginfo[blogid]#blogtaglist_$bloginfo[blogid]");

			$_REQUEST['do'] = 'tagedit';
			define('ADD_ERROR', true);
		}
		else
		{
			$vbulletin->url = 'blog.php?' . $vbulletin->session->vars['sessionurl'] . "b=$bloginfo[blogid]#blogtaglist_$bloginfo[blogid]";
			eval(print_standard_redirect(fetch_error('tags_edited_successfully'), false));
		}
	}
}

// #############################################################################
// tag popup

if ($_REQUEST['do'] == 'tagedit')
{
	$show['tagwidth'] = true;
	$show['tags'] = true;
	$show['errors'] = defined('ADD_ERROR');
	if (!$show['errors'])
	{
		$valid_tag_html = '';
	}

	$tag_manage_options = '';
	$have_removal_tags = false;
	$mytags = 0;

	$tags_sql = $db->query_read("
		SELECT tag.*, tagentry.userid, user.username
		FROM " . TABLE_PREFIX . "blog_tagentry AS tagentry
		INNER JOIN " . TABLE_PREFIX . "blog_tag AS tag ON (tag.tagid = tagentry.tagid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = tagentry.userid)
		WHERE tagentry.blogid = $bloginfo[blogid]
		ORDER BY tag.tagtext
	");
	$total_tags = $db->num_rows($tags_sql);

	if ($total_tags == 0 AND !$show['add_option'])
	{
		print_no_permission();
	}

	while ($tag = $db->fetch_array($tags_sql))
	{
		$tag['ismine'] = ($tag['userid'] == $vbulletin->userinfo['userid']);
		$show['tag_checkbox'] = ($tag['ismine']
			OR (($vbulletin->userinfo['permissions']['vbblog_entry_permissions'] & $vbulletin->bf_ugp_vbblog_entry_permissions['blog_candeletetagown']) AND $bloginfo['userid'] == $vbulletin->userinfo['userid'])
			OR can_moderate_blog('caneditentries')
		);

		if ($show['tag_checkbox'])
		{
			$have_removal_tags = true;
		}

		if ($tag['ismine'])
		{
			$mytags++;
		}

		// only moderators can see who added a tag
		if (!can_moderate_blog('caneditentries'))
		{
			$tag['username'] = '';
		}

		($hook = vBulletinHook::fetch_hook('blog_tag_managebit')) ? eval($hook) : false;

		eval('$tag_manage_options .= "' . fetch_template('tag_managebit') . '";');
	}

	// determine the number of tags this person can add
	$user_tags_remain = null;

	if ($vbulletin->options['vbblog_tagmax'])
	{
		// check global limit
		$tags_remain = max(0, $vbulletin->options['vbblog_tagmax'] - $total_tags);
		if ($tags_remain == 0 AND !$have_removal_tags)
		{
			// entry full and no tags can be removed - error
			standard_error(fetch_error('entry_has_max_allowed_tags'));
		}

		$user_tags_remain = $tags_remain;
	}

	if (!can_moderate_blog('caneditentries'))
	{
		$tags_remain = null;
		if ($vbulletin->options['vbblog_maxtagstarter'] AND $bloginfo['userid'] == $vbulletin->userinfo['userid'])
		{
			$tags_remain = max(0, $vbulletin->options['vbblog_maxtagstarter'] - $mytags);
		}
		else if ($vbulletin->options['vbblog_maxtaguser'])
		{
			$tags_remain = max(0, $vbulletin->options['vbblog_maxtaguser'] - $mytags);
		}

		if ($tags_remain !== null)
		{
			if ($user_tags_remain == null)
			{
				$user_tags_remain = $tags_remain;
			}
			else
			{
				$user_tags_remain = min($tags_remain, $user_tags_remain);
			}
		}
	}

	($hook = vBulletinHook::fetch_hook('blog_tag_manage_tagsremain')) ? eval($hook) : false;

	$show['tag_limit_phrase'] = ($user_tags_remain !== null);
	$tags_remain = vb_number_format($user_tags_remain);
	#$tag_delimiters = addslashes_js($vbulletin->options['tagdelimiter']);

	if ($vbulletin->GPC['ajax'])
	{
		$show['ajax'] = true;
		eval('$tagpopup = "' . fetch_template('blog_tag_edit_form') . '";');

		require_once(DIR . '/includes/class_xml.php');
		$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$xml->add_tag('tagpopup', process_replacement_vars($tagpopup));
		#$xml->add_tag('delimiters', $vbulletin->options['tagdelimiter']);
		$xml->print_xml();
	}
	else
	{
		eval('$html = "' . fetch_template('blog_tag_edit_form') . '";');
	}

	// navbar and output
	$navbits = array();

	$sidebar =& build_user_sidebar($bloginfo);

	// navbar and output
	$navbits['blog.php' . $vbulletin->session->vars['sessionurl_q']] = $vbphrase['blogs'];
	$navbits['blog.php?' . $vbulletin->session->vars['sessionurl'] . "u=$bloginfo[userid]"] = $bloginfo['blog_title'];
	$navbits['blog.php?' . $vbulletin->session->vars['sessionurl'] . "b=$bloginfo[blogid]"] = $bloginfo['title'];

	$navbits[''] = $vbphrase['tag_management'];

	$navbits = construct_navbits($navbits);

	eval('$content = "' . fetch_template('blog_tag_edit') . '";');
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('$headinclude .= "' . fetch_template('blog_css') . '";');
	eval('print_output("' . fetch_template('BLOG') . '");');
}

// #######################################################################
if ($_REQUEST['do'] == 'cloud')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'userid' => TYPE_UINT,
	));

	if ($vbulletin->GPC['userid'])
	{
		$userinfo = fetch_userinfo($vbulletin->GPC['userid']);

		if (!$userinfo['canviewmyblog'])
		{
			print_no_permission();
		}

		if ($vbulletin->userinfo['userid'] == $userinfo['userid'] AND !($vbulletin->userinfo['permissions']['vbblog_general_permissions'] & $vbulletin->bf_ugp_vbblog_general_permissions['blog_canviewown']))
		{
			print_no_permission();
		}

		if ($vbulletin->userinfo['userid'] != $userinfo['userid'] AND !($vbulletin->userinfo['permissions']['vbblog_general_permissions'] & $vbulletin->bf_ugp_vbblog_general_permissions['blog_canviewothers']))
		{
			// Can't view other's entries so off you go to your own blog.
			exec_header_redirect("blog.php?$session[sessionurl]u=" . $vbulletin->userinfo['userid']);
		}

		$show['usercloud'] = true;
		$tag_cloud = fetch_blog_tagcloud('usage', false, $userinfo['userid']);
	}
	else
	{
		$tag_cloud = fetch_blog_tagcloud('usage');
	}

	$navbits = construct_navbits(array(
		'blog.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['blogs'],
		'' => $vbphrase['tags'],
	));
	eval('$navbar = "' . fetch_template('navbar') . '";');

	($hook = vBulletinHook::fetch_hook('blog_tags_cloud_complete')) ? eval($hook) : false;

	if ($userinfo)
	{
		$sidebar =& build_user_sidebar($userinfo);
	}
	else
	{
		$sidebar =& build_overview_sidebar();
	}

	eval('$content = "' . fetch_template('blog_tag_cloud') . '";');
	eval('$headinclude .= "' . fetch_template('blog_css') . '";');
	eval('print_output("' . fetch_template('BLOG') . '");');
}

// #############################################################################
// tag search

if ($_POST['do'] == 'tagsearch')
{
	$vbulletin->input->clean_array_gpc('p', array('fragment' => TYPE_STR));

	$vbulletin->GPC['fragment'] = convert_urlencoded_unicode($vbulletin->GPC['fragment']);

	if ($vbulletin->GPC['fragment'] != '' AND strlen($vbulletin->GPC['fragment']) >= 3)
	{
		$fragment = htmlspecialchars_uni($vbulletin->GPC['fragment']);
	}
	else
	{
		$fragment = '';
	}

	require_once(DIR . '/includes/class_xml.php');
	$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
	$xml->add_group('tags');

	if ($fragment != '')
	{
		$tags = $db->query_read_slave("
			SELECT tagtext
			FROM " . TABLE_PREFIX . "blog_tag
			WHERE tagtext LIKE '" . $db->escape_string_like($fragment) . "%'
			ORDER BY tagtext
			LIMIT 15
		");
		while ($tag = $db->fetch_array($tags))
		{
			$xml->add_tag('tag', $tag['tagtext']);
		}
	}

	$xml->close_group();
	$xml->print_xml();
}

/*======================================================================*\
|| ####################################################################
|| # CVS: $RCSfile$ - $Revision: 26544 $
|| ####################################################################
\*======================================================================*/
?>