/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 2.0.1
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2009 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
* Class to handle thread rating
*
* @param	object	The form object containing the vote options
*/
function vB_AJAX_BlogLatest(varname)
{

	this.varname = varname;
	this.active = null;
	this.noresults = 0;
	this.which = null;

	this.containers = new Array('latestblogs', 'latestcomments');

	this.init = function()
	{
		if (AJAX_Compatible && (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax < 2))
		{
			for (var i = 0; i < this.containers.length; i++)
			{
				var images = fetch_object(this.containers[i]).getElementsByTagName('img');
				if (images.length)
				{
					for (var j = 0; j < images.length; j++)
					{
						img_alt_2_title(images[j]);
					}
				}
			}

			var bloglatest_link = fetch_object('vb_bloglatest_latest_link');
			var blograting_link = fetch_object('vb_bloglatest_rating_link');
			var blogblograting_link = fetch_object('vb_bloglatest_blograting_link');
			var bloglatest_more = fetch_object('vb_bloglatest_latest_findmore');
			var blograting_more = fetch_object('vb_bloglatest_rating_findmore');
			var blogblograting_more = fetch_object('vb_bloglatest_blograting_findmore');

			if (this.active == null)
			{
				// default value
				this.active = 'latest';
				if (blogblograting_link && blogblograting_link.style.display == 'none')
				{
					this.active = 'blograting';
				}
				else if (blograting_link && blograting_link.style.display == 'none')
				{
					this.active = 'rating';
				}
			}

			if (blogblograting_link)
			{
				blogblograting_link.varname = this.varname;
				blogblograting_link.which = 'blograting';
				YAHOO.util.Event.on("vb_bloglatest_blograting_link", "click", this.load_data);
				blogblograting_link.style.cursor = pointer_cursor;

				blogblograting_link.style.display = (this.active == 'blograting') ? 'none' : '';
				fetch_object('vb_bloglatest_blograting_findmore').style.display = (this.active == 'blograting' && this.noresults == 0) ? '' : 'none';
			}

			fetch_object('vb_bloglatest_blograting').style.display = (this.active != 'blograting') ? 'none' : '';

			if (blograting_link)
			{
				blograting_link.varname = this.varname;
				blograting_link.which = 'rating';
				YAHOO.util.Event.on("vb_bloglatest_rating_link", "click", this.load_data);
				blograting_link.style.cursor = pointer_cursor;

				blograting_link.style.display = (this.active == 'rating') ? 'none' : '';
				fetch_object('vb_bloglatest_rating_findmore').style.display = (this.active == 'rating' && this.noresults == 0) ? '' : 'none';
			}

			fetch_object('vb_bloglatest_rating').style.display = (this.active != 'rating') ? 'none' : '';

			if (bloglatest_link)
			{
				bloglatest_link.varname = this.varname;
				bloglatest_link.which = 'latest';
				YAHOO.util.Event.on("vb_bloglatest_latest_link", "click", this.load_data);
				bloglatest_link.style.cursor = pointer_cursor;

				bloglatest_link.style.display = (this.active == 'latest') ? 'none' : '';
				fetch_object('vb_bloglatest_latest_findmore').style.display = (this.active == 'latest') ? '' : 'none';
			}

			fetch_object('vb_bloglatest_latest').style.display = (this.active != 'latest') ? 'none' : '';
		}
	}

	/**
	* OnReadyStateChange callback. Uses a closure to keep state.
	* Remember to use me instead of this inside this function!
	*/
	this.handle_ajax_response = function(ajax)
	{
		if (ajax.responseXML)
		{
			fetch_object('progress_latest').style.display = 'none';

			// check for error first
			var error = ajax.responseXML.getElementsByTagName('error');
			if (error.length)
			{
				alert(error[0].firstChild.nodeValue);
			}
			else
			{
				var updateinfo = ajax.responseXML.getElementsByTagName('updated')[0];
				var data = updateinfo.getAttribute('data');
				this.noresults = updateinfo.getAttribute('noresults');
				this.active = updateinfo.getAttribute('which');

				if (data != '')
				{
					if (updateinfo.getAttribute('type') == 'blog')
					{
						fetch_object('latestblogs').innerHTML = data;
					}
					else
					{
						fetch_object('latestcomments').innerHTML = data;
					}
					this.init();
				}
			}

		}
	}

	this.load_data = function(e)
	{
		YAHOO.util.Event.stopEvent(e);
		fetch_object('progress_latest').style.display = '';

		YAHOO.util.Connect.asyncRequest("POST", "blog_ajax.php?do=loadupdated", {
		 	success: blogLatest.handle_ajax_response,
		  failure: vBulletin_AJAX_Error_Handler,
		  timeout: vB_Default_Timeout,
		  scope: blogLatest
		}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&do=loadupdated&type=blog&which=" + PHP.urlencode(this.which) + "&ajax=1");

		return false;
	};

	this.init();
};

/*======================================================================*\
|| ####################################################################
|| # CVS: $RCSfile$ - $Revision: 25612 $
|| ####################################################################
\*======================================================================*/