<?php
define('UNSHARP_MASK_AMOUNT', 50);
define('UNSHARP_MASK_RADIUS', 1);
define('UNSHARP_MASK_THRESHOLD', 0);

/**
 * Create avatar, base on profile photo
 *
 * @global vB_Registry $vbulletin
 * @param array $user_info
 * @return bool
 */
function create_avatar($user_info = null)
{
    global $vbulletin;
    if ($vbulletin->options['usefileavatar'])
    {
        $profile_pic_file = $vbulletin->options['profilepicurl']
            . '/profilepic'
            . $user_info['userid'] . '_' . $user_info['profilepicrevision'] . '.gif';
    }
    else
    {
        $profile_pic_file = '../image.php?'
            . $vbulletin->session->vars['sessionurl']
            . 'u=' . $user_info['userid']
            . '&amp;dateline=' . $user_info['profilepicdateline']
            . '&amp;type=profile';

        // TODO проверить
        // $avatarurl = 'image.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $user_info['userid'] . "&amp;dateline=$avatar[dateline]";
    }
    //загрузить файл в тмп дирректорию

    $img_file =  $vbulletin->options['tmppath'] . '/' . md5(microtime()) . 'tmp_avatar_img';
    $rh = fopen($profile_pic_file, 'rb');
    $wh = fopen($img_file, 'wb');
    if ($rh===false || $wh===false)
    {
        return false;
    }
    while (!feof($rh))
    {
        if (fwrite($wh, fread($rh, 1024)) === FALSE)
        {
            return false;
        }
    }
    fclose($rh);
    fclose($wh);


    // begin custom avatar code
    require_once(DIR . '/includes/class_upload.php');
    require_once(DIR . '/includes/class_image.php');

    $upload = new vB_Upload_Userpic($vbulletin);

    $upload->data =& datamanager_init('Userpic_Avatar', $vbulletin, ERRTYPE_STANDARD, 'userpic');
    $upload->image =& vB_Image::fetch_library($vbulletin);

    $upload->userinfo = $user_info;
    $upload->upload['filename'] = 'avatar' . $user_info['userid'] . '.gif';

    require_once DIR . '/includes/class_avatar_image_tools.php';
    $img_editor = new Avatar_Image_Tools();
    $img_editor->load_img_from_src_file($img_file);
  
    $img_editor->img_resize($user_info['permissions']['avatarmaxwidth'] ,
                                $user_info['permissions']['avatarmaxheight']);

    $img_editor->unshar_pmask(UNSHARP_MASK_AMOUNT, UNSHARP_MASK_RADIUS, UNSHARP_MASK_THRESHOLD);

    $img_editor->round_corner($vbulletin->options['pta_rounded_corners_radius_for_avatars']);

    $upload->imginfo[0] = $img_editor->get_width();
    $upload->imginfo[1] = $img_editor->get_height();
    
    $img_content = $img_editor->save();

    $upload->upload['filestuff'] = $img_content;
    $upload->save_upload();
    @unlink($img_file);
    return true;
}

?>
