<?php

/***************************************************************
@
@	Defult Setting
@
/**************************************************************/
require_once TEMPLATEPATH.'/control/firstrun.php';
/***************************************************************
@
@	Theme Control Panel
@
/**************************************************************/
require_once TEMPLATEPATH.'/control/cp-framework.php';
/**************************************************************
*          All theme Paths 
***************************************************************/
//theme Directory and URI
define('SalahElimam_DIR', get_template_directory());
define('SalahElimam_URI', get_template_directory_uri());
//SalahElimamizat Framework
define('SalahElimam_FW', SalahElimam_DIR . '/salahelimam');
define('SalahElimam_TM', SalahElimam_DIR . '/templates');

//assest
define('SalahElimam_JS', SalahElimam_URI . '/js');
define('SalahElimam_CSS', SalahElimam_URI . '/css');
define('SalahElimam_IMG', SalahElimam_URI . '/images');
define('SalahElimam_WIDGET', SalahElimam_FW . '/widgets');
require SalahElimam_WIDGET . '/ads100.php';
require SalahElimam_WIDGET . '/fb_likebox.php';
require SalahElimam_WIDGET . '/big_ad.php';
require SalahElimam_WIDGET . '/feeds.php';
/**************************************************************
 *          Menus
 ***************************************************************/
if ( function_exists( 'register_nav_menu' ) ) {
  register_nav_menus(
   array(
    'topnav'   => __('القائمة الرئيسية '),
   )
  );
  register_nav_menus(
   array(
    'mainnav'   => __('قائمة التصنيفات'),
   )
  );

}
/**************************************************************
*          Tumbnails
***************************************************************/

add_theme_support('post-thumbnails');

/***************************************************************
@
@	ShortCodes
@
/**************************************************************/
/*download*/
/*download*/
/*Notes*/
function note_shortcode( $atts, $content = null )
{
    extract( shortcode_atts( array(
      ), $atts ) );
 
      return '
 
      <div class="note"><p>' . $content . '</p></div>';

	  
 
}
add_shortcode('note', 'note_shortcode');
/*Notes*/
/*warning*/
function warning_shortcode( $atts, $content = null )
{
    extract( shortcode_atts( array(
      ), $atts ) );
 
      return '
 
      <div class="warning"><p>' . $content . '</p></div>';

	  
 
}
add_shortcode('warning', 'warning_shortcode');
/*warning*/
/*Info*/
function info_shortcode( $atts, $content = null )
{
    extract( shortcode_atts( array(
      ), $atts ) );
 
      return '
 
      <div class="info"><p>' . $content . '</p></div>';

	  
 
}
add_shortcode('info', 'info_shortcode');
/*Info*/
/*New*/
function new_shortcode( $atts, $content = null )
{
    extract( shortcode_atts( array(
      ), $atts ) );
 
      return '
 
      <div class="new"><p>' . $content . '</p></div>';

	  
 
}
add_shortcode('new', 'new_shortcode');
/*New*/
/*Download*/
function download_shortcode( $atts, $content = null )
{
    extract( shortcode_atts( array(
      ), $atts ) );
 
      return '
 
      <div class="download"><p>' . $content . '</p></div>';

	  
 
}
add_shortcode('download', 'download_shortcode');
/*Download*/
	/*Custom Link*/
function clink_shortcode( $atts, $content = null )
{
    extract( shortcode_atts( array(
      ), $atts ) );
 
      return '
 
      <div class="c-link">' . $content . '</div>';
	  
 
}
add_shortcode('clink', 'clink_shortcode');
	/*Custom Link*/


/**************************************************************
*          Auhtors List
***************************************************************/
function contributors() {
global $wpdb;

$authors = $wpdb->get_results("SELECT ID, user_nicename from $wpdb->users ORDER BY display_name");

foreach($authors as $author) {
echo "<li>";
echo "<a href=\"".get_bloginfo('url')."/?author=";
echo $author->ID;
echo "\">";
echo get_avatar($author->ID);
echo "</a>";
echo '<div>';
echo "<a href=\"".get_bloginfo('url')."/?author=";
echo $author->ID;
echo "\">";
the_author_meta('display_name', $author->ID);
echo "</a>";

echo "<a href=\"".get_bloginfo('url')."/?author=";
echo $author->ID;
echo "\">";
echo "<span>الملف الشخصي</span>";
echo "</a>";

echo "</div>";
echo "</li>";
}
}

/**************************************************************
*          Content & excerpt limit 
***************************************************************/

function excerpt($limit) {
$excerpt = explode(' ', get_the_excerpt(), $limit);
if (count($excerpt)>=$limit) {
array_pop($excerpt);
$excerpt = implode(" ",$excerpt).'...';
} else {
$excerpt = implode(" ",$excerpt);
}	
$excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
return $excerpt;
}

function content($limit) {
$content = explode(' ', get_the_content(), $limit);
if (count($content)>=$limit) {
array_pop($content);
$content = implode(" ",$content).'...';
} else {
$content = implode(" ",$content);
}	
$content = preg_replace('/\[.+\]/','', $content);
$content = apply_filters('the_content', $content); 
$content = str_replace(']]>', ']]&gt;', $content);
return $content;
}

//
function limit_content($content_length = 250, $allowtags = true, $allowedtags = '') {
global $post;
$content = $post->post_content;
$content = apply_filters('the_content', $content);
if (!$allowtags){
$allowedtags .= '<style>';
$content = strip_tags($content, $allowedtags);
}
$wordarray = explode(' ', $content, $content_length + 1);
if(count($wordarray) > $content_length) :
array_pop($wordarray);
array_push($wordarray, '...');
$content = implode(' ', $wordarray);
$content .= "</p>";
endif;

echo $content;
}

/***************************************************************
@
@	Max Excerpt & Short Title Fanctions
@
/**************************************************************/
function the_excerpt_max_charlength($charlength) {
   $excerpt = get_the_excerpt();
   $charlength++;
   if(strlen($excerpt)>$charlength) {
       $subex = substr($excerpt,0,$charlength-5);
       $exwords = explode(" ",$subex);
       $excut = -(strlen($exwords[count($exwords)-1]));
       if($excut<0) {
            echo substr($subex,0,$excut);
       } else {
       	    echo $subex;
       }
   } else {
	   echo $excerpt;
   }
}

function short_title($after = '', $length) {
	$mytitle = explode(' ', get_the_title(), $length);
	if (count($mytitle)>=$length) {
		array_pop($mytitle);
		$mytitle = implode(" ",$mytitle). $after;
	} else {
		$mytitle = implode(" ",$mytitle);
	}
	return $mytitle;
}

/**********************************************************************
* 			Comments Template
********************************************************************/
function SalahElimam_comment ($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>
   <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
     <div id="comment-<?php comment_ID(); ?>">
      <div class="comment-author vcard">
         <?php echo get_avatar($comment,$size='48',$default='<path_to_url>' ); ?>

         <?php printf(__('<cite class="fn">%s</cite> <span class="says">يقول : </span>'), get_comment_author_link()) ?>
         <div class="comment-meta commentmetadata"><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf(__('%1$s at %2$s'), get_comment_date(),  get_comment_time()) ?></a><?php edit_comment_link(__('(Edit)'),'  ','') ?></div>
      </div>
      <?php if ($comment->comment_approved == '0') : ?>
         <em><?php _e('تعليقك يحتاج إلى مراجعة المدير .') ?></em>
         <br />
      <?php endif; ?>

      <?php comment_text() ?>

      <div class="reply">
         <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
      </div>
     </div>
     
<?php
        }







/**********************************************************************
* 			Sidebars
********************************************************************/
if ( function_exists('register_sidebar') ) {

register_sidebar(array(
'name' => 'يمين',
'description' => 'القوائم والمربعات الجانبية علي اليمين',
'before_widget' => '<div class="rWidget">',
'after_widget' => '</div></div>',
'before_title' => '<h2>',
'after_title' => '</h2><div class="rightWidgetContent">'
));
register_sidebar(array(
'name' => 'يسار',
'description' => 'القوائم والمربعات الجانبية علي اليسار ',
'before_widget' => '<div class="lWidget"><div class="leftWidgetTop">',
'after_widget' => '</div><div class="leftWidgetBtm"></div></div>',
'before_title' => '<h2>',
'after_title' => '</h2></div><div class="leftWidgetContent">'
));
register_sidebar(array(
'name' => 'الفوتر',
'description' => 'القوائم والمربعات الجانبية بالفوتر',
'before_widget' => '<div class="MTWidget">',
'after_widget' => '</div>',
'before_title' => '<h2>',
'after_title' => '</h2>'
));
}



add_filter('the_content', 'shortcode_empty_paragraph_fix');
function shortcode_empty_paragraph_fix($content)
{   
$array = array (
'<p>[' => '[', 
']</p>' => ']', 
']<br />' => ']'
);

$content = strtr($content, $array);

return $content;
}

add_filter('widget_text', 'do_shortcode');


function add_my_stylesheet() {
echo '<link rel="stylesheet" type="text/css" href="' . get_bloginfo('stylesheet_directory') . '/css/login.css" />';
}
add_action('login_head', 'add_my_stylesheet');

function post_is_in_descendant_category( $cats, $_post )
{
foreach ( (array) $cats as $cat ) {
$descendants = get_term_children( (int) $cat, 'category');
array_push($descendants,$cat);
if ( $descendants && in_category( $descendants, $_post ) )
return true;
}
return false;
}

function load_cat_parent_template()
{
global $wp_query;

if (!$wp_query->is_category)
return true;

$cat = $wp_query->get_queried_object();

while ($cat && !is_wp_error($cat)) {
$template = TEMPLATEPATH . "/category-{$cat->cat_ID}.php";

if (file_exists($template)) {
load_template($template);
exit;
}

$cat = $cat->parent ? get_category($cat->parent) : false;
}
}
add_action('template_redirect', 'load_cat_parent_template');

if (!function_exists('is_category_or_sub')) {
function is_category_or_sub($cat_id = 0) {
foreach (get_the_category() as $cat) {
if ($cat_id == $cat->cat_ID || cat_is_ancestor_of($cat_id, $cat)) return true;
}
return false;
}
}


add_action( 'show_user_profile', 'my_show_extra_profile_fields' );
add_action( 'edit_user_profile', 'my_show_extra_profile_fields' );

function my_show_extra_profile_fields( $user ) { ?>

<h3>معلومات إضافية</h3>

<table class="form-table">

<tr>
<th><label for="twitter">Twitter</label></th>

<td>
<input type="text" name="twitter" id="twitter" value="<?php echo esc_attr( get_the_author_meta( 'twitter', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description">اكتب اسمك على تويتر.</span>
</td>
</tr>

<tr>
<th><label for="twitter">Facebook</label></th>

<td>
<input type="text" name="facebook" id="facebook" value="<?php echo esc_attr( get_the_author_meta( 'facebook', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description">ضع رابط صفحتك على فسيبوك.</span>
</td>
</tr>

<tr>
<th><label for="twitter">Linkedin</label></th>

<td>
<input type="text" name="linkedin" id="linkedin" value="<?php echo esc_attr( get_the_author_meta( 'linkedin', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description">ضع رابط صفحتك على لينكدان.</span>
</td>
</tr>

<tr>
<th><label for="twitter">Google Plus</label></th>

<td>
<input type="text" name="gplus" id="gplus" value="<?php echo esc_attr( get_the_author_meta( 'gplus', $user->ID ) ); ?>" class="regular-text" /><br />
<span class="description">ضع رابط صفحتك على جوجل بلس.</span>
</td>
</tr>

</table>
<?php }

add_action( 'personal_options_update', 'my_save_extra_profile_fields' );
add_action( 'edit_user_profile_update', 'my_save_extra_profile_fields' );

function my_save_extra_profile_fields( $user_id ) {

if ( !current_user_can( 'edit_user', $user_id ) )
return false;
update_usermeta( $user_id, 'twitter', $_POST['twitter'] );
update_usermeta( $user_id, 'facebook', $_POST['facebook'] );
update_usermeta( $user_id, 'linkedin', $_POST['linkedin'] );
update_usermeta( $user_id, 'gplus', $_POST['gplus'] );
}
add_action('init', 'my_rewrite');
function my_rewrite() {
global $wp_rewrite;
$wp_rewrite->add_permastruct('typename', 'typename/%year%/%postname%/', true, 1);
add_rewrite_rule('typename/([0-9]{4})/(.+)/?$', 'index.php?typename=$matches[2]', 'top');
$wp_rewrite->flush_rules(); // !!!
}

function wpfme_footer_admin () {
	echo 'القالب من تصميم وتطوير <a href="http://www.salahelimam.com" target="_blank">صلاح الإمام</a> بإستخدام <a href="http://wordpress.org" target="_blank">WordPress</a>.';
}
add_filter('admin_footer_text', 'wpfme_footer_admin');

add_theme_support( 'automatic-feed-links' );

?>