<?php

/**
 * yooplanet Tabbed Settings Page
 */

add_action( 'init', 'yooplanet_admin_init' );
add_action( 'admin_menu', 'yooplanet_settings_page_init' );

function yooplanet_admin_init() {
	$settings = get_option( "yooplanet_theme_settings" );
	if ( empty( $settings ) ) {
		$settings = array(
			'yooplanet_intro' => 'Some intro text for the home page',
			'yooplanet_intro2' => 'Some intro text for the home page',
			'yooplanet_intro3' => 'yooplanet_intro3yooplanet_intro3yooplanet_intro3',
			'yooplanet_tag_class' => false,
			'yooplanet_ga' => false
		);
		add_option( "yooplanet_theme_settings", $settings, '', 'yes' );
	}	
}

function yooplanet_settings_page_init() {
	$settings_page = add_menu_page(  ' yooplanet Settings',  ' yooplanet ', 'edit_theme_options', 'theme-settings', 'yooplanet_settings_page',get_bloginfo('template_url').'/yooplanet/main/icon.png' );
	add_action( "load-{$settings_page}", 'yooplanet_load_settings_page' );
}

function yooplanet_load_settings_page() {
	if ( $_POST["yooplanet-settings-submit"] == 'Y' ) {
		check_admin_referer( "yooplanet-settings-page" );
		yooplanet_save_theme_settings();
		$url_parameters = isset($_GET['tab'])? 'updated=true&tab='.$_GET['tab'] : 'updated=true';
		wp_redirect(admin_url('admin.php?page=theme-settings&'.$url_parameters));
		exit;
	}
}


/* //////////////////////////////////////*/
/* ///////// tabs //////////////////////*/
/* //////////////////////////////////////*/

function yooplanet_save_theme_settings() {
	global $pagenow;
	$settings = get_option( "yooplanet_theme_settings" );
	
	if ( $pagenow == 'admin.php' && $_GET['page'] == 'theme-settings' ){ 
		if ( isset ( $_GET['tab'] ) )
	        $tab = $_GET['tab']; 
	    else
	        $tab = 'homepage'; 

	    switch ( $tab ){ 
	        case 'general' :
				$settings['yooplanet_tag_class']	  = $_POST['yooplanet_tag_class'];
			break; 
	        case 'footer' : 
				$settings['yooplanet_ga']  = $_POST['yooplanet_ga'];
			break;
			case 'homepage' : 
				$settings['yooplanet_intro']	  = $_POST['yooplanet_intro'];
				$settings['yooplanet_intro2']	  = $_POST['yooplanet_intro2'];
				$settings['yooplanet_intro3']	  = $_POST['yooplanet_intro2'];
			break;
	    }
	}
	
	
	
	
		
	if( !current_user_can( 'unfiltered_html' ) ){
		if ( $settings['yooplanet_ga']  )
			$settings['yooplanet_ga'] = stripslashes( esc_textarea( wp_filter_post_kses( $settings['yooplanet_ga'] ) ) );
		if ( $settings['yooplanet_intro'] )
			$settings['yooplanet_intro'] = stripslashes( esc_textarea( wp_filter_post_kses( $settings['yooplanet_intro'] ) ) );
	}

	$updated = update_option( "yooplanet_theme_settings", $settings );
}

function yooplanet_admin_tabs( $current = 'homepage' ) { 
    $tabs = array( 'homepage' => 'Home', 'general' => 'General', 'footer' => 'Footer' ); 
    $links = array();
    echo '<div id="icon-themes" class="icon32"><br></div>';
    echo '<h2 class="nav-tab-wrapper">';
    foreach( $tabs as $tab => $name ){
        $class = ( $tab == $current ) ? ' nav-tab-active' : '';
        echo "<a class='nav-tab$class' href='?page=theme-settings&tab=$tab'>$name</a>";
        
    }
    echo '</h2>';
}

function yooplanet_settings_page() {
	global $pagenow;
	$settings = get_option( "yooplanet_theme_settings" );
	?>
	
	<div class="wrap">
		<h2><?php echo $theme_data['Name']; ?> Theme Settings</h2>
		
		<?php
			if ( 'true' == esc_attr( $_GET['updated'] ) ) echo '<div class="updated" ><p>Theme Settings updated.</p></div>';
			
			if ( isset ( $_GET['tab'] ) ) yooplanet_admin_tabs($_GET['tab']); else yooplanet_admin_tabs('homepage');
		?>

		<div id="poststuff">
			<form method="post" action="<?php admin_url( 'admin.php?page=theme-settings' ); ?>">
				<?php
				wp_nonce_field( "yooplanet-settings-page" ); 
				
				if ( $pagenow == 'admin.php' && $_GET['page'] == 'theme-settings' ){ 
				
					if ( isset ( $_GET['tab'] ) ) $tab = $_GET['tab']; 
					else $tab = 'homepage'; 
					
					echo '<table class="form-table">';
					switch ( $tab ){
						case 'general' :
							?>
							<tr>
								<th><label for="yooplanet_tag_class">Tags with CSS classes:</label></th>
								<td>
									<input id="yooplanet_tag_class" name="yooplanet_tag_class" type="checkbox" <?php if ( $settings["yooplanet_tag_class"] ) echo 'checked="checked"'; ?> value="true" /> 
									<span class="description">Output each post tag with a specific CSS class using its slug.</span>
								</td>
							</tr>
							<?php
						break; 
						case 'footer' : 
							?>
							<tr>
								<th><label for="yooplanet_ga">Insert tracking code:</label></th>
								<td>
									<textarea id="yooplanet_ga" name="yooplanet_ga" cols="60" rows="5"><?php echo esc_html( stripslashes( $settings["yooplanet_ga"] ) ); ?></textarea><br/>
									<span class="description">Enter your Google Analytics tracking code:</span>
								</td>
							</tr>
							<?php
						break;
						case 'homepage' : 
							?>
						<?php include('theme/home.php');?>
							<?php
						break;
					}
					echo '</table>';
				}
				?>
				<p class="submit" style="clear: both;">
					<input type="submit" name="Submit"  class="button-primary" value="Update Settings" />
					<input type="hidden" name="yooplanet-settings-submit" value="Y" />
				</p>
			</form>
			
			<p><?php echo $theme_data['Name'] ?> theme by <a href="http://ilovecolors.com.ar/">ilovecolors.com.ar</a> | <a href="http://twitter.com/eliorivero">Follow me on Twitter</a>! | Join <a href="http://on.fb.me/yooplanetfb">ilovecolors on Facebook</a>!</p>
		</div>

	</div>
<?php
}


?>