<?php
/* $Id: sql.php,v 1.94.2.6 2002/08/12 19:03:44 rabus Exp $ */


/**
 * Gets some core libraries
 */
require('./libraries/grab_globals.lib.php');
require('./libraries/common.lib.php');


/**
 * Defines the url to return to in case of error in a sql statement
 */
// Security checkings
if (!empty($goto)) {
    $is_gotofile     = ereg_replace('^([^?]+).*$', '\\1', $goto);
    if (!@file_exists('./' . $is_gotofile)) {
        unset($goto);
    } else {
        $is_gotofile = ($is_gotofile == $goto);
    }
} // end if (security checkings)

if (empty($goto)) {
    $goto         = (empty($table)) ? 'db_details.php' : 'tbl_properties.php';
    $is_gotofile  = TRUE;
} // end if
if (!isset($err_url)) {
    $err_url = $goto
             . '?lang=' . $lang
             . '&amp;server=' . $server
             . (isset($db) ? '&amp;db=' . urlencode($db) : '')
             . (($goto != 'db_details.php' && isset($table)) ? '&amp;table=' . urlencode($table) : '');
} // end if


/**
 * Check rights in case of DROP DATABASE
 *
 * This test may be bypassed if $is_js_confirmed = 1 (already checked with js)
 * but since a malicious user may pass this variable by url/form, we don't take
 * into account this case.
 */
if (!defined('PMA_CHK_DROP')
    && !$cfgAllowUserDropDatabase
    && eregi('DROP[[:space:]]+(IF EXISTS[[:space:]]+)?DATABASE[[:space:]]', $sql_query)) {
    // Checks if the user is a Superuser
    // TODO: set a global variable with this information
    // loic1: optimized query
    $result = @mysql_query('USE mysql');
    if (mysql_error()) {
        include('./header.inc.php');
        PMA_mysqlDie($strNoDropDatabases, '', '', $err_url);
    } // end if
} // end if


/**
 * Bookmark add
 */
if (isset($store_bkm)) {
    if (get_magic_quotes_gpc()) {
        $fields['label'] = stripslashes($fields['label']);
    }
    include('./libraries/bookmark.lib.php');
    PMA_addBookmarks($fields, $cfgBookmark);
    header('Location: ' . $cfgPmaAbsoluteUri . $goto);
} // end if


/**
 * Gets the true sql query
 */
// $sql_query has been urlencoded in the confirmation form for drop/delete
// queries or in the navigation bar for browsing among records
if (isset($btnDrop) || isset($navig)) {
    $sql_query = urldecode($sql_query);
}

// If the query is a Select, extract the db and table names and modify
// $db and $table, to have correct page headers, links and left frame.
// db and table name may be enclosed with backquotes, db is optionnal,
// query may contain aliases.
// (todo: check for embedded comments...)

$is_select = eregi('^SELECT[[:space:]]+', $sql_query);
if ($is_select) {
    eregi('^SELECT[[:space:]]+(.*)[[:space:]]+FROM[[:space:]]+(`[^`]+`|[A-Za-z0-9_$]+)([\.]*)(`[^`]*`|[A-Za-z0-9_$]*)', $sql_query, $tmp);

    if ($tmp[3] == '.') {
        $prev_db = $db;
        $db      = str_replace('`', '', $tmp[2]);
        $reload  = ($db == $prev_db) ? 0 : 1;
        $table   = str_replace('`', '', $tmp[4]);
    }
    else {
        $table   = str_replace('`', '', $tmp[2]);
    }
} // end if


/**
 * Sets or modifies the $goto variable if required
 */
if ($goto == 'sql.php') {
    $goto = 'sql.php'
          . '?lang=' . $lang
          . '&amp;server=' . $server
          . '&amp;db=' . urlencode($db)
          . '&amp;table=' . urlencode($table)
          . '&amp;pos=' . $pos
          . '&amp;sql_query=' . urlencode($sql_query);
} // end if


/**
 * Go back to further page if table should not be dropped
 */
if (isset($btnDrop) && $btnDrop == $strNo) {
    if (!empty($back)) {
        $goto = $back;
    }
    if ($is_gotofile) {
        if ($goto == 'db_details.php' && !empty($table)) {
            unset($table);
        }
        include('./' . ereg_replace('\.\.*', '.', $goto));
    } else {
        header('Location: ' . $cfgPmaAbsoluteUri . str_replace('&amp;', '&', $goto));
    }
    exit();
} // end if


/**
 * Displays the confirm page if required
 *
 * This part of the script is bypassed if $is_js_confirmed = 1 (already checked
 * with js) because possible security issue is not so important here: at most,
 * the confirm message isn't displayed.
 */
if (!$cfgConfirm
    || (isset($is_js_confirmed) && $is_js_confirmed)
    || isset($btnDrop)) {
    $do_confirm = FALSE;
} else {
    $do_confirm = (eregi('DROP[[:space:]]+(IF[[:space:]]+EXISTS[[:space:]]+)?(TABLE|DATABASE[[:space:]])|ALTER[[:space:]]+TABLE[[:space:]]+((`[^`]+`)|([A-Za-z0-9_$]+))[[:space:]]+DROP[[:space:]]|DELETE[[:space:]]+FROM[[:space:]]', $sql_query));
}

if ($do_confirm) {
    if (get_magic_quotes_gpc()) {
        $stripped_sql_query = stripslashes($sql_query);
    } else {
        $stripped_sql_query = $sql_query;
    }
    include('./header.inc.php');
    echo $strDoYouReally . '&nbsp;:<br />' . "\n";
    echo '<tt>' . htmlspecialchars($stripped_sql_query) . '</tt>&nbsp;?<br/>' . "\n";
    ?>
<form action="sql.php" method="post">
    <input type="hidden" name="lang" value="<?php echo $lang; ?>" />
    <input type="hidden" name="server" value="<?php echo $server; ?>" />
    <input type="hidden" name="db" value="<?php echo $db; ?>" />
    <input type="hidden" name="table" value="<?php echo isset($table) ? $table : ''; ?>" />
    <input type="hidden" name="sql_query" value="<?php echo urlencode($sql_query); ?>" />
    <input type="hidden" name="zero_rows" value="<?php echo isset($zero_rows) ? $zero_rows : ''; ?>" />
    <input type="hidden" name="goto" value="<?php echo $goto; ?>" />
    <input type="hidden" name="back" value="<?php echo isset($back) ? $back : ''; ?>" />
    <input type="hidden" name="reload" value="<?php echo isset($reload) ? $reload : 0; ?>" />
    <input type="hidden" name="show_query" value="<?php echo isset($show_query) ? $show_query : ''; ?>" />
    <input type="submit" name="btnDrop" value="<?php echo $strYes; ?>" />
    <input type="submit" name="btnDrop" value="<?php echo $strNo; ?>" />
</form>
    <?php
    echo "\n";
} // end if


/**
 * Executes the query and displays results
 */
else {
    if (!isset($sql_query)) {
        $sql_query = '';
    } else if (get_magic_quotes_gpc()) {
        $sql_query = stripslashes($sql_query);
    }
    // Defines some variables
    // loic1: A table have to be created -> left frame should be reloaded
    if ((!isset($reload) || $reload == 0)
        && eregi('^CREATE TABLE[[:space:]]+(.*)', $sql_query)) {
        $reload           = 1;
    }
    // Gets the number of rows per page
    if (!isset($session_max_rows)) {
        $session_max_rows = $cfgMaxRows;
    } else if ($session_max_rows != 'all') {
        $cfgMaxRows       = $session_max_rows;
    }
    // Defines the display mode (horizontal/vertical) and header "frequency"
    if (empty($disp_direction)) {
        $disp_direction   = $cfgDefaultDisplay;
    }
    if (empty($repeat_cells)) {
        $repeat_cells     = $cfgRepeatCells;
    }

    $is_explain = $is_count = $is_export = $is_delete = $is_insert = $is_affected = $is_show = $is_maint = $is_analyse = FALSE;
    if ($is_select) { // see line 76
        $is_count    = (eregi('^SELECT[[:space:]]+COUNT\((.*\.+)?.*\)', $sql_query));
        $is_export   = (eregi('[[:space:]]+INTO[[:space:]]+OUTFILE[[:space:]]+', $sql_query));
        $is_analyse  = (eregi('[[:space:]]+PROCEDURE[[:space:]]+ANALYSE\(', $sql_query));
    } else if (eregi('^EXPLAIN[[:space:]]+', $sql_query)) {
        $is_explain  = TRUE;
    } else if (eregi('^DELETE[[:space:]]+', $sql_query)) {
        $is_delete   = TRUE;
        $is_affected = TRUE;
    } else if (eregi('^(INSERT|LOAD[[:space:]]+DATA|REPLACE)[[:space:]]+', $sql_query)) {
        $is_insert   = TRUE;
        $is_affected = TRUE;
    } else if (eregi('^UPDATE[[:space:]]+', $sql_query)) {
        $is_affected = TRUE;
    } else if (eregi('^SHOW[[:space:]]+', $sql_query)) {
        $is_show     = TRUE;
    } else if (eregi('^(CHECK|ANALYZE|REPAIR|OPTIMIZE)[[:space:]]+TABLE[[:space:]]+', $sql_query)) {
        $is_maint    = TRUE;
    }

    // Statement with "PROC ANALYSE" -> display all rows
    if ($is_analyse) {
        $session_max_rows = 'all';
    }

    // Do append a "LIMIT" clause?
    if (isset($pos)
        && (!$cfgShowAll || $session_max_rows != 'all')
        && $is_select
        && !($is_count || $is_export)
        && eregi('[[:space:]]FROM[[:space:]]', $sql_query)
        && !eregi('[[:space:]]LIMIT[[:space:]0-9,]+$', $sql_query)) {

        $sql_limit_to_append = " LIMIT $pos, $cfgMaxRows";
        if (eregi('(.*)([[:space:]](PROCEDURE[[:space:]](.*)|FOR[[:space:]]+UPDATE|LOCK[[:space:]]+IN[[:space:]]+SHARE[[:space:]]+MODE))$', $sql_query, $regs)) {
            $full_sql_query  = $regs[1] . $sql_limit_to_append . $regs[2];
        } else {
            $full_sql_query  = $sql_query . $sql_limit_to_append;
        }
    } else {
        $full_sql_query      = $sql_query;
    } // end if...else


    mysql_select_db($db);

    // If the query is a DELETE query with no WHERE clause, get the number of
    // rows that will be deleted (mysql_affected_rows will always return 0 in
    // this case)
    if ($is_delete
        && eregi('^DELETE([[:space:]].+)?([[:space:]]FROM[[:space:]](.+))$', $sql_query, $parts)
        && !eregi('[[:space:]]WHERE[[:space:]]', $parts[3])) {
        $cnt_all_result = @mysql_query('SELECT COUNT(*) as count' .  $parts[2]);
        if ($cnt_all_result) {
            $num_rows   = mysql_result($cnt_all_result, 0, 'count');
            mysql_free_result($cnt_all_result);
        } else {
            $num_rows   = 0;
        }
    }

    // Executes the query
    $result   = @mysql_query($full_sql_query);

    // Displays an error message if required and stop parsing the script
    if (mysql_error()) {
        $error        = mysql_error();
        include('./header.inc.php');
        $full_err_url = (ereg('^(db_details|tbl_properties)', $err_url))
                      ? $err_url . '&amp;show_query=y&amp;sql_query=' . urlencode($sql_query)
                      : $err_url;
        PMA_mysqlDie($error, $full_sql_query, '', $full_err_url);
    }

    // tmpfile remove after convert encoding appended by Y.Kawada
    if (function_exists('PMA_kanji_file_conv')
        && (isset($textfile) && file_exists($textfile))) {
        unlink($textfile);
    }

    // Gets the number of rows affected/returned
    if (!$is_affected) {
        $num_rows = ($result) ? @mysql_num_rows($result) : 0;
    } else if (!isset($num_rows)) {
        $num_rows = @mysql_affected_rows();
    }

    // Counts the total number of rows for the same 'SELECT' query without the
    // 'LIMIT' clause that may have been programatically added
    if (empty($sql_limit_to_append)) {
        $unlim_num_rows         = $num_rows;
    }
    else if ($is_select) {
        // reads only the from-part of the query...
        $sp='[[:space:]]';
        $array = split(
            $sp . 'from' . $sp .'|' . $sp . 'FROM' .$sp .
            '|' . $sp .'order' . $sp . '|' . $sp . 'ORDER' . $sp .
            '|' . $sp .'having' . $sp . '|' . $sp . 'HAVING' . $sp .
            '|' . $sp .'limit' . $sp . '|' . $sp . 'LIMIT' . $sp .
            '|' . $sp .'group' . $sp . 'by'. $sp .
            '|' . $sp . 'GROUP' . $sp . 'BY' . $sp, $sql_query);
        if (!empty($array[1])) {
            // ... and makes a count(*) to count the entries
            $count_query        = 'SELECT COUNT(*) AS count FROM ' . $array[1];
            $cnt_all_result     = mysql_query($count_query);
            if ($cnt_all_result) {
                $unlim_num_rows = mysql_result($cnt_all_result, 0, 'count');
                mysql_free_result($cnt_all_result);
            }
        } else {
            $unlim_num_rows     = 0;
        }
    } // end rows total count

    // No rows returned -> move back to the calling page
    if ($num_rows < 1 || $is_affected) {
        if ($is_delete) {
            $message = $strDeletedRows . '&nbsp;' . $num_rows;
        } else if ($is_insert) {
            $message = $strInsertedRows . '&nbsp;' . $num_rows;
        } else if ($is_affected) {
            $message = $strAffectedRows . '&nbsp;' . $num_rows;
        } else if (!empty($zero_rows)) {
            $message = $zero_rows;
        } else {
            $message = $strEmptyResultSet;
        }

        if ($is_gotofile) {
            $goto = ereg_replace('\.\.*', '.', $goto);
            // Checks for a valid target script
            if (isset($table) && $table == '') {
                unset($table);
            }
            if (isset($db) && $db == '') {
                unset($db);
            }
            $is_db = $is_table = FALSE;
            if ($goto == 'tbl_properties.php') {
                if (!isset($table)) {
                    $goto     = 'db_details.php';
                } else {
                    $is_table = @mysql_query('SHOW TABLES LIKE \'' . PMA_sqlAddslashes($table, TRUE) . '\'');
                    if (!($is_table && @mysql_numrows($is_table))) {
                        $goto = 'db_details.php';
                        unset($table);
                    }
                } // end if... else...
            }
            if ($goto == 'db_details.php') {
                if (isset($table)) {
                    unset($table);
                }
                if (!isset($db)) {
                    $goto     = 'main.php';
                } else {
                    $is_db    = @mysql_select_db($db);
                    if (!$is_db) {
                        $goto = 'main.php';
                        unset($db);
                    }
                } // end if... else...
            }
            // Loads to target script
            if ($goto == 'db_details.php' || $goto == 'tbl_properties.php') {
                $js_to_run = 'functions.js';
            }
            if ($goto != 'main.php') {
                include('./header.inc.php');
            }
            include('./' . $goto);
        } // end if file_exist
        else {
            header('Location: ' . $cfgPmaAbsoluteUri . str_replace('&amp;', '&', $goto) . '&message=' . urlencode($message));
        } // end else
        exit();
    } // end no rows returned

    // At least one row is returned -> displays a table with results
    else {
        // Displays the headers
        if (isset($show_query)) {
            unset($show_query);
        }
        $js_to_run = 'functions.js';
        include('./header.inc.php');
        include('./libraries/bookmark.lib.php');

        // Gets the list of fields properties
        while ($field = mysql_fetch_field($result)) {
            $fields_meta[] = $field;
        }
        $fields_cnt        = count($fields_meta);

        // Displays the results in a table
        include('./libraries/display_tbl.lib.php');
        if (empty($disp_mode)) {
            // see the "PMA_setDisplayMode()" function in
            // libraries/display_tbl.lib.php
            $disp_mode = 'urdr11110';
        }
        PMA_displayTable($result, $disp_mode);
        mysql_free_result($result);

        // Displays "Insert a new row" link if required
        if ($disp_mode[6] == '1') {
            $lnk_goto  = 'sql.php'
                       . '?lang=' . $lang
                       . '&amp;server=' . $server
                       . '&amp;db=' . urlencode($db)
                       . '&amp;table=' . urlencode($table)
                       . '&amp;pos=' . $pos
                       . '&amp;session_max_rows=' . $session_max_rows
                       . '&amp;disp_direction=' . $disp_direction
                       . '&amp;repeat_cells=' . $repeat_cells
                       . '&amp;sql_query=' . urlencode($sql_query);
            $url_query = 'lang=' . $lang
                       . '&amp;server=' . $server
                       . '&amp;db=' . urlencode($db)
                       . '&amp;table=' . urlencode($table)
                       . '&amp;pos=' . $pos
                       . '&amp;session_max_rows=' . $session_max_rows
                       . '&amp;disp_direction=' . $disp_direction
                       . '&amp;repeat_cells=' . $repeat_cells
                       . '&amp;sql_query=' . urlencode($sql_query)
                       . '&amp;goto=' . urlencode($lnk_goto);

            echo "\n\n";
            echo '<!-- Insert a new row -->' . "\n";
            echo '<p>' . "\n";
            echo '    <a href="tbl_change.php?' . $url_query . '">' . $strInsertNewRow . '</a>' . "\n";
            echo '</p>' . "\n";
        } // end insert new row

        // Bookmark Support if required
        if ($disp_mode[7] == '1'
            && ($cfgBookmark['db'] && $cfgBookmark['table'] && empty($id_bookmark))
            && !empty($sql_query)) {
            echo "\n";

            $goto = 'sql.php'
                  . '?lang=' . $lang
                  . '&amp;server=' . $server
                  . '&amp;db=' . urlencode($db)
                  . '&amp;table=' . urlencode($table)
                  . '&amp;pos=' . $pos
                  . '&amp;session_max_rows=' . $session_max_rows
                  . '&amp;disp_direction=' . $disp_direction
                  . '&amp;repeat_cells=' . $repeat_cells
                  . '&amp;sql_query=' . urlencode($sql_query)
                  . '&amp;id_bookmark=1';
            ?>
<!-- Bookmark the query -->
<form action="sql.php" method="post" onsubmit="return emptyFormElements(this, 'fields[label]');">
            <?php
            echo "\n";
            if ($disp_mode[3] == '1') {
                echo '    <i>' . $strOr . '</i>' . "\n";
            }
            ?>
    <br /><br />
    <?php echo $strBookmarkLabel; ?>&nbsp;:
    <input type="hidden" name="server" value="<?php echo $server; ?>" />
    <input type="hidden" name="goto" value="<?php echo $goto; ?>" />
    <input type="hidden" name="fields[dbase]" value="<?php echo $db; ?>" />
    <input type="hidden" name="fields[user]" value="<?php echo $cfgBookmark['user']; ?>" />
    <input type="hidden" name="fields[query]" value="<?php echo urlencode($sql_query); ?>" />
    <input type="text" name="fields[label]" value="" />
    <input type="submit" name="store_bkm" value="<?php echo $strBookmarkThis; ?>" />
</form>
            <?php
        } // end bookmark support
    } // end rows returned

} // end executes the query
echo "\n\n";


/**
 * Displays the footer
 */
require('./footer.inc.php');
?>
