<?php
if (!class_exists('DBSEO')) { die('No direct loading allowed.'); }

// #############################################################################
// Blog class

/**
* Handles various functionality for Image
*/
class DBSEO_Script_Image
{
	/**
	 * Replace urls
	 *
	 * @param string $urlPrefix
	 * @param string $url
	 * @param string $urlAttributes
	 * @param string $urlSuffix
	 * @param string $inTag
	 * @param string $closeTag
	 * 
	 * @return string
	 */
	public static function replaceUrls(&$_preventProcessing, &$_seoParameters, &$urlPrefix, &$url, &$urlSuffix, &$inTag, &$_urlScript, &$_urlPlace, &$_urlParameters, &$_removeAllParameters, &$_cmsUrlAppend, &$nofollow, &$follow)
	{
		$newUrl = $_urlFormat = '';

		if (!DBSEO::$config['dbtech_dbseo_rewrite_avatar'])
		{
			// We're not rewriting this
			return $newUrl;
		}

		if ($_seoParameters['type'])
		{
			// We're not rewriting this
			return $newUrl;
		}

		if (!(isset($_seoParameters['u']) AND (!isset($_seoParameters['type']) OR $_seoParameters['type'] != 'profile')))
		{
			// We're not rewriting this
			return $newUrl;
		}

		if ($newUrl = DBSEO::createUrl('Avatar_Avatar', $_seoParameters))
		{
			$_urlScript = $newUrl;
			unset($_seoParameters['u']);
		}

		return $newUrl;
	}

	/**
	 * Create URL
	 *
	 * @param string $_seoParameters
	 * 
	 * @return string
	 */
	public static function createUrl($_seoParameters)
	{
		$newUrl = $_urlFormat = '';

		if (!DBSEO::$config['dbtech_dbseo_rewrite_avatar'])
		{
			// We're not rewriting this
			return $newUrl;
		}

		if ($_seoParameters['type'])
		{
			// We're not rewriting this
			return $newUrl;
		}

		if (!(isset($_seoParameters['u']) AND (!isset($_seoParameters['type']) OR $_seoParameters['type'] != 'profile')))
		{
			// We're not rewriting this
			return $newUrl;
		}

		return DBSEO::createUrl('Avatar_Avatar', $_seoParameters);
	}
}
?>