<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// DBSEO "CMSHome URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_CMSHome
{
	public static $format = 'CMS_CMSHome';
	public static $structure = 'content.php';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return (is_null($structure) ? self::$structure : $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Handle the replacements
		$newUrl = $rawFormat;
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_cms'] AND strpos($newUrl, '://') === false)
		{
			// Use a custom cms domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_cms'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}


// #############################################################################
// DBSEO "CMSSection URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_CMSSection
{
	public static $format = 'CMS_CMSSection';
	public static $structure = 'content.php?%s=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		if (!$urlInfo['section_id'] AND $urlInfo['section_title'])
		{
			// Lookup section title
			$urlInfo['section_id'] = DBSEO::reverseObject('cmsnode', $urlInfo['section_title']);
		}

		return sprintf((is_null($structure) ? self::$structure : $structure), DBSEO::$config['route_requestvar'], $urlInfo['section_id'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		$data['sectionid'] = intval($data['sectionid']);
		if ($data['sectionid'])
		{
			// Grab our section info
			$sectionInfo = DBSEO::getObjectInfo('cmscont', $data['sectionid']);
		}

		if (!$sectionInfo['idfield'])
		{
			// User didn't exist
			return '';
		}

		// Set SEO title
		$sectionInfo['seotitle'] = DBSEO::filterText($sectionInfo['title']);
		$sectionInfo['seotitle'] = $sectionInfo['seotitle'] ? $sectionInfo['seotitle'] : ($sectionInfo['url'] ? strtolower($sectionInfo['url']) : 'a');

		// Handle userid and username
		$replace['%section_id%'] 	= $sectionInfo['idfield'];
		$replace['%section_title%'] = $sectionInfo['seotitle'];

		if ($data['page'])
		{
			// We had a paged cms
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_cms'] AND strpos($newUrl, '://') === false)
		{
			// Use a custom cms domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_cms'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}


// #############################################################################
// DBSEO "CMSSection URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_CMSSection_List extends DBSEO_Rewrite_CMSSection
{
	public static $format = 'CMS_CMSSection_List';
	public static $structure = 'list.php?%s=section/%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "CMSSection URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_CMSSection_List_Page extends DBSEO_Rewrite_CMSSection_List
{
	public static $format = 'CMS_CMSSection_List_Page';
	public static $structure = 'list.php?%s=section/%d/%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "CMSCategory URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_CMSCategory
{
	public static $format = 'CMS_CMSCategory';
	public static $structure = 'list.php?%s=category/%d-%s';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), DBSEO::$config['route_requestvar'], $urlInfo['category_id'], $urlInfo['category_title'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		$data['categoryid'] = intval($data['categoryid']);
		if ($data['categoryid'])
		{
			// Grab our category info
			$categoryInfo = DBSEO::getObjectInfo('cms_cat', $data['categoryid']);
			$categoryInfo['category'] = DBSEO::filterText($categoryInfo['category']);
		}
		
		if (!$categoryInfo['categoryid'])
		{
			// User didn't exist
			return '';
		}

		// Handle userid and username
		$replace['%category_id%'] 	= $categoryInfo['categoryid'];
		$replace['%category_title%'] = $categoryInfo['category'];

		if ($data['page'])
		{
			// We had a paged cms
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_cms'] AND strpos($newUrl, '://') === false)
		{
			// Use a custom cms domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_cms'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "CMSCategory URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_CMSCategory_Page extends DBSEO_Rewrite_CMSCategory
{
	public static $format = 'CMS_CMSCategory_Page';
	public static $structure = 'list.php?%s=category/%d-%s/%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "CMSAuthor URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_CMSAuthor
{
	public static $format = 'CMS_CMSAuthor';
	public static $structure = 'list.php?%s=author/%d-%s';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), DBSEO::$config['route_requestvar'], $urlInfo['user_id'], $urlInfo['user_name'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		$data['userid'] = intval($data['userid'] ? $data['userid'] : $data['u']);
		if ($data['userid'])
		{
			// Grab our user info
			DBSEO::getUserInfo($data['userid']);
			$userInfo = DBSEO::$cache['userinfo'][$data['userid']];
		}
		
		if (!$userInfo['userid'])
		{
			// User didn't exist
			return '';
		}

		// Handle userid and username
		$replace['%user_id%'] 	= $userInfo['userid'];
		$replace['%user_name%'] = DBSEO::filterText($userInfo['username'], null, false, true, true);

		if ($data['page'])
		{
			// We had a paged cms
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_cms'] AND strpos($newUrl, '://') === false)
		{
			// Use a custom cms domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_cms'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "CMSAuthor URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_CMSAuthor_Page extends DBSEO_Rewrite_CMSAuthor
{
	public static $format = 'CMS_CMSAuthor_Page';
	public static $structure = 'list.php?%s=author/%d-%s/%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "CMSEntry URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_CMSEntry
{
	public static $format = 'CMS_CMSEntry';
	public static $structure = 'content.php?%s=%d-%s';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), DBSEO::$config['route_requestvar'], $urlInfo['entry_id'], $urlInfo['entry_title'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		//vbstop($data);

		// Init this
		$replace = array();

		$data['entryid'] = intval($data['entryid']);
		if ($data['entryid'])
		{
			// Grab our entry info
			$entryInfo = DBSEO::getObjectInfo('cmscont', $data['entryid']);
		}
		
		if (!$entryInfo['idfield'])
		{
			// User didn't exist
			return '';
		}

		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_rewrite_cms_smarttitle'])
		{
			// Content filter
			$entryInfo['seotitle'] = DBSEO::contentFilter($entryInfo['pagetext']);
		}
		/*DBTECH_PRO_END*/

		if (!$entryInfo['seotitle'])
		{
			// Normal filter
			$entryInfo['seotitle'] = DBSEO::filterText($entryInfo['title']);
		}

		// Set SEO title
		$entryInfo['seotitle'] = $entryInfo['seotitle'] ? $entryInfo['seotitle'] : ($entryInfo['url'] ? strtolower($entryInfo['url']) : 'a');

		// Handle userid and username
		$replace['%entry_id%'] 	= $entryInfo['idfield'];
		$replace['%entry_title%'] = $entryInfo['seotitle'];

		$data['sectionid'] = intval($entryInfo['parentnode']);
		if ($data['sectionid'])
		{
			// Grab our user info
			$sectionInfo = DBSEO::getObjectInfo('cmscont', $data['sectionid']);
		}
		
		if (!$sectionInfo['idfield'])
		{
			// User didn't exist
			return '';
		}

		// Set SEO title
		$sectionInfo['seotitle'] = DBSEO::filterText($sectionInfo['title']);
		$sectionInfo['seotitle'] = $sectionInfo['seotitle'] ? $sectionInfo['seotitle'] : ($sectionInfo['url'] ? strtolower($sectionInfo['url']) : 'a');

		// Handle userid and username
		$replace['%section_id%'] 	= $sectionInfo['idfield'];
		$replace['%section_title%'] = $sectionInfo['seotitle'];

		if ($data['page'])
		{
			// We had a paged cms
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_cms'] AND strpos($newUrl, '://') === false)
		{
			// Use a custom cms domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_cms'] . $newUrl;
		}
		/*DBTECH_PRO_END*/
		
		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "CMSEntry URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_CMSEntry_Page extends DBSEO_Rewrite_CMSEntry
{
	public static $format = 'CMS_CMSEntry_Page';
	public static $structure = 'content.php?%s=%d-%s/view/%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "CMSComments_Page URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_CMSComments_Page extends DBSEO_Rewrite_CMSEntry
{
	public static $format = 'CMS_CMSComments_Page';
	public static $structure = 'content.php?%s=%d-%s&page=%d#comments';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}