<?php
if (!class_exists('DBSEO')) { die('No direct loading allowed.'); }

// #############################################################################
// Blog class

/**
* Handles various functionality for Image
*/
class DBSEO_Script_List
{
	/**
	 * Replace urls
	 *
	 * @param string $urlPrefix
	 * @param string $url
	 * @param string $urlAttributes
	 * @param string $urlSuffix
	 * @param string $inTag
	 * @param string $closeTag
	 * 
	 * @return string
	 */
	public static function replaceUrls(&$_preventProcessing, &$_seoParameters, &$urlPrefix, &$url, &$urlSuffix, &$inTag, &$_urlScript, &$_urlPlace, &$_urlParameters, &$_removeAllParameters, &$_cmsUrlAppend, &$nofollow, &$follow)
	{
		$newUrl = $_urlFormat = '';

		if (!DBSEO::$config['dbtech_dbseo_rewrite_cms'])
		{
			// We're not rewriting this
			return $newUrl;
		}

		if ($newUrl = DBSEO::createCMSUrl($_seoParameters[DBSEO::$config['route_requestvar']] ? $_seoParameters[DBSEO::$config['route_requestvar']] : $_cmsUrlAppend, '', $_seoParameters))
		{
			$_urlScript = $newUrl;
			unset($_seoParameters[DBSEO::$config['route_requestvar']], $_seoParameters['page']);
		}

		return $newUrl;
	}

	/**
	 * Create URL
	 *
	 * @param string $_seoParameters
	 * 
	 * @return string
	 */
	public static function createUrl($_seoParameters)
	{
		$newUrl = $_urlFormat = '';

		if (!DBSEO::$config['dbtech_dbseo_rewrite_cms'])
		{
			// We're not rewriting this
			return $newUrl;
		}

		return DBSEO::createCMSUrl($_seoParameters[DBSEO::$config['route_requestvar']] ? $_seoParameters[DBSEO::$config['route_requestvar']] : $_cmsUrlAppend, '', $_seoParameters);
	}
}
?>