<?php
if (!class_exists('DBSEO')) { die('No direct loading allowed.'); }

// #############################################################################
// Blog class

/**
* Handles various functionality for Image
*/
class DBSEO_Script_Tags
{
	/**
	 * Replace urls
	 *
	 * @param string $urlPrefix
	 * @param string $url
	 * @param string $urlAttributes
	 * @param string $urlSuffix
	 * @param string $inTag
	 * @param string $closeTag
	 * 
	 * @return string
	 */
	public static function replaceUrls(&$_preventProcessing, &$_seoParameters, &$urlPrefix, &$url, &$urlSuffix, &$inTag, &$_urlScript, &$_urlPlace, &$_urlParameters, &$_removeAllParameters, &$_cmsUrlAppend, &$nofollow, &$follow)
	{
		$newUrl = $_urlFormat = '';

		if (!DBSEO::$config['dbtech_dbseo_rewrite_tags'])
		{
			// We're not rewriting this
			return $newUrl;
		}

		if ($_seoParameters['tag'])
		{
			// Single tag
			$_urlFormat = 'Tags_Tag_Single' . ($_seoParameters['page'] > 1 ? '_Page' : '');
		}
		else if (!count($_seoParameters))
		{
			// List of all tags
			$_urlFormat = 'Tags_TagList';
		}

		if ($_urlFormat AND $newUrl = DBSEO::createUrl($_urlFormat, $_seoParameters))
		{
			// And we're done here
			$_urlScript = $newUrl;
			unset($_seoParameters['tag'], $_seoParameters['page']);
		}

		return $newUrl;
	}

	/**
	 * Create URL
	 *
	 * @param string $_seoParameters
	 * 
	 * @return string
	 */
	public static function createUrl($_seoParameters)
	{
		$newUrl = $_urlFormat = '';

		if (!DBSEO::$config['dbtech_dbseo_rewrite_tags'])
		{
			// We're not rewriting this
			return $newUrl;
		}

		if ($_seoParameters['tag'])
		{
			// Single tag
			$_urlFormat = 'Tags_Tag_Single' . ($_seoParameters['page'] > 1 ? '_Page' : '');
		}
		else if (!count($_seoParameters))
		{
			// List of all tags
			$_urlFormat = 'Tags_TagList';
		}

		if (!$_urlFormat)
		{
			// We're not rewriting this
			return $newUrl;
		}

		return DBSEO::createUrl($_urlFormat, $_seoParameters);
	}
}
?>