<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// DBSEO DB class
class DBSEO_Database
{
	/**
	* The database object
	*
	* @private	$db
	*/
	private $db;
	
	/**
	* Array of configuration items
	*
	* @private	$this->config
	*/
	private $config;
	
	/**
	* The database link
	*
	* @private	MySQL_Result
	*/	
	private $link;
	
	/**
	* The query result we executed
	*
	* @private	MySQL_Result
	*/	
	private $result;
	
	/**
	* Whether we're debugging output
	*
	* @public	boolean
	*/
	public $debug = false;
	
	/**
	* Whether we're debugging output
	*
	* @public	boolean
	*/
	public $cache = array();
	
	/**
	* Whether we're logging debugging output
	*
	* @public	boolean
	*/
	public $debugLog = false;
	
	/**
	* The debug time flag
	*
	* @public	integer
	*/
	protected $debugTime = 0;


	/**
	* Does important checking before anything else should be going on
	*
	* @param	array		Configuration array
	*/
	function __construct(&$config)
	{
		// Set this
		$this->config =& $config;

		if ($this->config['DBSEO']['debug'])
		{
			// Store this for debug purposes
			$this->debugTime = time();			
			$this->debugLog = true;
		}

		if ($this->config['Database']['dbtype'] == 'mysqli' AND class_exists('mysqli'))
		{
			// Connect to MySQL
			$this->db = new mysqli($this->config['MasterServer']['servername'], $this->config['MasterServer']['username'], $this->config['MasterServer']['password'], $this->config['Database']['dbname'], $this->config['MasterServer']['port']);
			if ($this->db->connect_error)
			{
				die('Connect Error (' . $this->db->connect_errno . ') ' . $this->db->connect_error);
			}
		}
		else
		{
			if ($this->config['MasterServer']['usepconnect'])
			{
				$this->link = mysql_pconnect($this->config['MasterServer']['servername'] . ':' . $this->config['MasterServer']['port'], $this->config['MasterServer']['username'], $this->config['MasterServer']['password']);
			}
			else
			{
				$this->link = mysql_connect($this->config['MasterServer']['servername'] . ':' . $this->config['MasterServer']['port'], $this->config['MasterServer']['username'], $this->config['MasterServer']['password']);
			}

			if (!$this->link)
			{
				die('Connect Error: ' . mysql_error());
			}

			if (!mysql_select_db($this->config['Database']['dbname'], $this->link))
			{
				echo printf("DB Select Error: %s", mysql_error($this->link));
				die();
			}
		}

		// Close the DB connection
		register_shutdown_function(array($this, 'shutdown'));
	}

	/**
	* Closes the database link
	*/
	function shutdown()
	{
		if ($this->config['Database']['dbtype'] == 'mysqli' AND class_exists('mysqli'))
		{
			// We had a DB object
			@$this->db->close();
		}
		else
		{
			@mysql_close($this->link);
		}
	}

	public function fetchSettings($force = false)
	{
		if (isset($this->cache['settings']) AND !$force)
		{
			// We can return the settings from cache
			return $this->cache['settings'];
		}

		if (($config = DBSEO::$datastore->fetch('settings')) === false OR $force)
		{
			// The config we're gonna return
			$config = array();

			$query = "
				SELECT varname, value
				FROM " . $this->config['Database']['tableprefix'] . "setting 
			";

			if ($this->debugLog)
			{
				// Write to file and append if needed
				file_put_contents(DBSEO_CWD . '/dbtech/dbseo/debuglog/' . $this->debugTime . '.txt', "\n\n\nfetchSettings:\n" . $query, FILE_APPEND);
			}

			if ($this->config['Database']['dbtype'] == 'mysqli' AND class_exists('mysqli'))
			{
				if (!$result = $this->db->query($query))
				{
					// Error
					echo printf("Invalid query: %s", $this->db->error);
					die();
				}
				while ($array = $result->fetch_assoc())
				{
					// Store configuration
					$config[$array['varname']] = $array['value'];
				}
				$result->free();
			}
			else
			{
				if (!$result = mysql_query($query, $this->link))
				{	
					// Error
					echo printf("Invalid query: %s", mysql_error($this->link));
					die();
				}
				while ($array = mysql_fetch_assoc($result))
				{
					// Store configuration
					$config[$array['varname']] = $array['value'];
				}
				mysql_free_result($result);
			}

			// Build the cache
			DBSEO::$datastore->build('settings', $config);
		}

		// Now set the cache
		$this->cache['settings'] = $config;

		return $this->cache['settings'];
	}

	public function fetchProducts($force = false)
	{
		if (isset($this->cache['products']) AND !$force)
		{
			// We can return the products from cache
			return $this->cache['products'];
		}

		if (($config = DBSEO::$datastore->fetch('products')) === false OR $force)
		{
			// The config we're gonna return
			$config = array();

			$query = "
				SELECT productid, active
				FROM " . $this->config['Database']['tableprefix'] . "product 
			";

			if ($this->debugLog)
			{
				// Write to file and append if needed
				file_put_contents(DBSEO_CWD . '/dbtech/dbseo/debuglog/' . $this->debugTime . '.txt', "\n\n\nfetchProducts:\n" . $query, FILE_APPEND);
			}

			if ($this->config['Database']['dbtype'] == 'mysqli' AND class_exists('mysqli'))
			{
				if (!$result = $this->db->query($query))
				{
					// Error
					echo printf("Invalid query: %s", $this->db->error);
					die();
				}
				while ($array = $result->fetch_assoc())
				{
					// Store configuration
					$config[$array['productid']] = $array['active'];
				}
				$result->free();
			}
			else
			{
				if (!$result = mysql_query($query, $this->link))
				{	
					// Error
					echo printf("Invalid query: %s", mysql_error($this->link));
					die();
				}
				while ($array = mysql_fetch_assoc($result))
				{
					// Store configuration
					$config[$array['productid']] = $array['active'];
				}
				mysql_free_result($result);
			}

			// Build the cache
			DBSEO::$datastore->build('products', $config);
		}

		// Now set the cache
		$this->cache['products'] = $config;

		return $this->cache['products'];
	}

	public function fetchForumCache($force = false)
	{
		if (isset($this->cache['forumcache']) AND !$force)
		{
			// We can return the forumcache from cache
			return $this->cache['forumcache'];
		}

		if (($forumcache = DBSEO::$datastore->fetch('forumcache')) === false OR $force)
		{
			$query = "
				SELECT data
				FROM " . $this->config['Database']['tableprefix'] . "datastore
				WHERE title = 'forumcache'
			";

			if ($this->debugLog)
			{
				// Write to file and append if needed
				file_put_contents(DBSEO_CWD . '/dbtech/dbseo/debuglog/' . $this->debugTime . '.txt', "\n\n\nfetchForumCache:\n" . $query, FILE_APPEND);
			}

			if ($this->config['Database']['dbtype'] == 'mysqli' AND class_exists('mysqli'))
			{
				if (!$result = $this->db->query($query))
				{
					// Error
					echo printf("Invalid query: %s", $this->db->error);
					die();
				}
				while ($array = $result->fetch_assoc())
				{
					// Store configuration
					$forumcache = $array['data'];
				}
				$result->free();
			}
			else
			{
				if (!$result = mysql_query($query, $this->link))
				{	
					// Error
					echo printf("Invalid query: %s", mysql_error($this->link));
					die();
				}
				while ($array = mysql_fetch_assoc($result))
				{
					// Store configuration
					$forumcache = $array['data'];
				}
				mysql_free_result($result);
			}

			// Now set the cache
			$forumcache = @unserialize($forumcache);
			$forumcache = is_array($forumcache) ? $forumcache : array();

			foreach ($forumcache as $forumid => &$forum)
			{
				// Grab an array of parents in structured order
				$parentList = array_reverse(explode(',', $forum['parentlist']));

				// Init this
				$forum['seopath'] = array();

				foreach ($parentList as $forumId)
				{
					if (!isset($forumcache[$forumId]))
					{
						// Skip this
						continue;
					}

					// Cache the SEO Title for this forum
					$forumcache[$forumId]['seotitle'] = DBSEO::rewriteForumUrl($forumcache[$forumId], true);

					// Init the replacement array
					$replace = array(
						'%forum_id%' 	=> $forumId,
						'%forum_title%' => $forumcache[$forumId]['seotitle'],
					);

					// Add to the SEO Path
					$forum['seopath'][] = str_replace(array_keys($replace), $replace, DBSEO::$config['dbtech_dbseo_rewrite_rule_forumpath']);
				}

				// Store the path
				$forum['seopath'] = @implode('/', $forum['seopath']);			
			}

			// Build the cache
			DBSEO::$datastore->build('forumcache', $forumcache);
		}

		// Now set the cache
		$this->cache['forumcache'] = $forumcache;

		return $this->cache['forumcache'];
	}

	public function generalQuery($sql, $flatten = true, $force = false)
	{
		// Store a CRC32 hash of the SQL for use in the cache check
		$hashKey = crc32($sql);

		if (isset($this->cache[$hashKey]) AND !$force)
		{
			// Shorthand
			$data = $this->cache[$hashKey];

			if (count($data) == 1 AND $flatten)
			{
				// Flatten the array
				$data = $data[0];
			}

			// We can return the settings from cache
			return $data;
		}

		$data = array();

		$query = preg_replace('/\$(\w+)/', $this->config['Database']['tableprefix'] . '$1', $sql);

		if ($this->debugLog)
		{
			// Write to file and append if needed
			file_put_contents(DBSEO_CWD . '/dbtech/dbseo/debuglog/' . $this->debugTime . '.txt', "\n\n\ngeneralQuery:\n" . $query, FILE_APPEND);
		}

		if ($this->config['Database']['dbtype'] == 'mysqli' AND class_exists('mysqli'))
		{
			if (!$result = $this->db->query($query))
			{
				// Error
				echo printf("Invalid query: %s", $this->db->error);
				die();
			}
			while ($array = $result->fetch_assoc())
			{
				// Store configuration
				$data[] = $array;
			}
			$result->free();
		}
		else
		{
			if (!$result = mysql_query($query, $this->link))
			{	
				// Error
				echo printf("Invalid query: %s", mysql_error($this->link));
				die();
			}
			while ($array = mysql_fetch_assoc($result))
			{
				// Store configuration
				$data[] = $array;
			}
			mysql_free_result($result);
		}

		// Now set the cache
		$this->cache[$hashKey] = is_array($data) ? $data : array();

		if (count($data) == 1 AND $flatten)
		{
			// Flatten the array
			$data = $data[0];
		}

		return $data;
	}


	public function modifyQuery($sql)
	{
		$query = preg_replace('/\$(\w+)/', $this->config['Database']['tableprefix'] . '$1', $sql);

		if ($this->config['Database']['dbtype'] == 'mysqli' AND class_exists('mysqli'))
		{
			if (!$result = $this->db->query($query))
			{
				// Error
				echo printf("Invalid query: %s", $this->db->error);
				die();
			}
		}
		else
		{
			if (!$result = mysql_query($query, $this->link))
			{	
				// Error
				echo printf("Invalid query: %s", mysql_error($this->link));
				die();
			}
		}
	}

	public function escapeString($str)
	{
		if ($this->config['Database']['dbtype'] == 'mysqli' AND class_exists('mysqli'))
		{
			return $this->db->real_escape_string($str);
		}
		else
		{
			return mysql_real_escape_string($str);
		}
	}
}

// For vB3
function DBSEO_DB_Shutdown() { DBSEO::$db->shutdown(); }
?>