<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// DBSEO "Album URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_Album
{
	public static $format = 'Album_Album';
	public static $structure = 'album.php?albumid=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		if (empty($urlInfo['user_id']) AND isset($urlInfo['user_name']))
		{
			// Grab the user ID
			$urlInfo['user_id'] = DBSEO::reverseUsername($urlInfo['user_name']);
		}

		if (empty($urlInfo['album_id']) AND isset($urlInfo['album_title']))
		{
			// Grab the album ID
			$urlInfo['album_id'] = DBSEO::reverseObject('album', $urlInfo['album_title'], $urlInfo['user_id']);
		}

		// Return the constructed URL
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['album_id'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		if ($data['albumid'])
		{
			// Grab album info
			$albumInfo = DBSEO::getObjectInfo('album', $data['albumid']);
		}
		
		if (!$albumInfo['albumid'])
		{
			// Album didn't exist
			return '';
		}

		// Handle album id and album title
		$replace['%album_id%'] 		= $albumInfo['albumid'];
		$replace['%album_title%'] 	= DBSEO::filterText($albumInfo['title'], NULL, true, true);

		$data['userid'] = $albumInfo['userid'];
		if ($data['userid'])
		{
			// Grab our user info
			DBSEO::getUserInfo($data['userid']);
			$userInfo = DBSEO::$cache['userinfo'][$data['userid']];
		}
		
		if (!$userInfo['userid'])
		{
			// User didn't exist
			return '';
		}

		// Handle userid and username
		$replace['%user_id%'] 	= $userInfo['userid'];
		$replace['%user_name%'] = DBSEO::filterText($userInfo['username'], NULL, false, true, true);

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "Album URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_Album_Page extends DBSEO_Rewrite_Album
{
	public static $format = 'Album_Album_Page';
	public static $structure = 'album.php?albumid=%d&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}

// #############################################################################
// DBSEO "AlbumList URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_AlbumList
{
	public static $format = 'Album_AlbumList';
	public static $structure = 'album.php?u=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		if (empty($urlInfo['user_id']) AND isset($urlInfo['user_name']))
		{
			// Grab the user ID
			$urlInfo['user_id'] = DBSEO::reverseUsername($urlInfo['user_name']);
		}

		// Return the constructed URL
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['user_id'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		$data['userid'] = intval($data['userid'] ? $data['userid'] : $data['u']);
		if ($data['userid'])
		{
			// Grab our user info
			DBSEO::getUserInfo($data['userid']);
			$userInfo = DBSEO::$cache['userinfo'][$data['userid']];
		}
		
		if (!$userInfo['userid'])
		{
			// User didn't exist
			return '';
		}

		// Handle userid and username
		$replace['%user_id%'] 	= $userInfo['userid'];
		$replace['%user_name%'] = DBSEO::filterText($userInfo['username'], NULL, false, true, true);

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "AlbumList URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_AlbumList_Page extends DBSEO_Rewrite_AlbumList
{
	public static $format = 'Album_AlbumList_Page';
	public static $structure = 'album.php?u=%d&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "AlbumPicture URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_AlbumPicture
{
	public static $format = 'Album_AlbumPicture';
	public static $structure = 'album.php?albumid=%d&%s=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		if (empty($urlInfo['user_id']) AND isset($urlInfo['user_name']))
		{
			// Grab the user ID
			$urlInfo['user_id'] = DBSEO::reverseUsername($urlInfo['user_name']);
		}

		if (empty($urlInfo['album_id']) AND isset($urlInfo['album_title']))
		{
			// Grab the album ID
			$urlInfo['album_id'] = DBSEO::reverseObject('album', $urlInfo['album_title'], $urlInfo['user_id']);
		}

		// Return the constructed URL
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['album_id'], DBSEO::$config['_pictureid'], $urlInfo['picture_id'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		if ($data[DBSEO::$config['_pictureid']])
		{
			// Grab album picture info
			$albumPictureInfo = DBSEO::getObjectInfo(DBSEO::$config['_picturestorage'], $data[DBSEO::$config['_pictureid']]);
		}

		if (!$albumPictureInfo[DBSEO::$config['_pictureid']])
		{
			// Album picture didn't exist
			return '';
		}

		// Handle picture id and picture title
		$replace['%picture_id%'] 	= $albumPictureInfo[DBSEO::$config['_pictureid']];
		$replace['%picture_title%'] = DBSEO::filterText($albumPictureInfo['caption']);

		if ($data['thumb'])
		{
			// We're requesting a thumbnail
			$replace['%picture_id%'] .= 't';
		}

		$data['albumid'] = ($data['albumid'] ? $data['albumid'] : DBSEO::getContentId($albumPictureInfo));
		if ($data['albumid'])
		{
			// Grab album info
			$albumInfo = DBSEO::getObjectInfo('album', $data['albumid']);
		}
		
		if (!$albumInfo['albumid'])
		{
			// Album didn't exist
			return '';
		}

		// Store object ID
		DBSEO::$cache['_objectIds']['album'][] = $albumInfo['albumid'];

		// Handle album id and album title
		$replace['%album_id%'] 		= $albumInfo['albumid'];
		$replace['%album_title%'] 	= DBSEO::filterText($albumInfo['title'], NULL, true, true);

		$data['userid'] = $albumInfo['userid'];
		if ($data['userid'])
		{
			// Grab our user info
			DBSEO::getUserInfo($data['userid']);
			$userInfo = DBSEO::$cache['userinfo'][$data['userid']];
		}
		
		if (!$userInfo['userid'])
		{
			// User didn't exist
			return '';
		}

		// Handle userid and username
		$replace['%user_id%'] 	= $userInfo['userid'];
		$replace['%user_name%'] = DBSEO::filterText($userInfo['username'], NULL, false, true, true);

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "AlbumPicture URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_AlbumPicture_Page extends DBSEO_Rewrite_AlbumPicture
{
	public static $format = 'Album_AlbumPicture_Page';
	public static $structure = 'album.php?albumid=%d&%s=%d%page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "MemberAlbums URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_MemberAlbums
{
	public static $format = 'Album_MemberAlbums';
	public static $structure = 'album.php';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Return the constructed URL
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "MemberAlbums URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_MemberAlbums_Page extends DBSEO_Rewrite_MemberAlbums
{
	public static $format = 'Album_MemberAlbums_Page';
	public static $structure = 'album.php?do=latest%page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "AlbumPictureFile URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_AlbumPictureFile
{
	public static $format = 'Album_AlbumPictureFile';
	public static $structure = '%s.php?albumid=%d&%s=%d%s';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		if (empty($urlInfo['user_id']) AND isset($urlInfo['user_name']))
		{
			// Grab the user ID
			$urlInfo['user_id'] = DBSEO::reverseUsername($urlInfo['user_name']);
		}

		if (empty($urlInfo['album_id']) AND isset($urlInfo['album_title']))
		{
			// Grab the album ID
			$urlInfo['album_id'] = DBSEO::reverseObject('album', $urlInfo['album_title'], $urlInfo['user_id']);
		}

		// Check whether this is a thumbnail
		preg_match('#^(\d+)(d\d+)?(t)?#', $urlInfo['picture_id'], $match);

		// Return the constructed URL
		return sprintf((is_null($structure) ? self::$structure : $structure), DBSEO::$config['_picturescript'], $urlInfo['album_id'], DBSEO::$config['_pictureid'], $urlInfo['picture_id'], (isset($match[3]) ? '&thumb=1&dl=' . $match[2] : ''));
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		if ($data[DBSEO::$config['_pictureid']])
		{
			// Grab album picture info
			$albumPictureInfo = DBSEO::getObjectInfo(DBSEO::$config['_picturestorage'], $data[DBSEO::$config['_pictureid']]);
		}

		if (!$albumPictureInfo['idfield'])
		{
			// Album picture didn't exist
			return '';
		}

		// Handle picture id and picture title
		$replace['%picture_id%'] 	= $albumPictureInfo[DBSEO::$config['_pictureid']];
		$replace['%picture_title%'] = DBSEO::filterText($albumPictureInfo['caption']);
		
		if (!$albumPictureInfo['extension'])
		{
			// Ensure we have extension
			$albumPictureInfo['extension'] = pathinfo($albumPictureInfo['filename'], PATHINFO_EXTENSION);
		}

		// Handle extension
		$replace['%original_ext%'] = $albumPictureInfo['extension'];
		if ($data['thumb'])
		{
			// We're requesting a thumbnail
			$replace['%picture_id%'] .= 't';
		}

		$data['albumid'] = ($data['albumid'] ? $data['albumid'] : DBSEO::getContentId($albumPictureInfo));
		if ($data['albumid'])
		{
			// Grab album info
			$albumInfo = DBSEO::getObjectInfo('album', $data['albumid']);
		}
		
		if (!$albumInfo['albumid'])
		{
			// Album didn't exist
			return '';
		}

		// Handle album id and album title
		$replace['%album_id%'] 		= $albumInfo['albumid'];
		$replace['%album_title%'] 	= DBSEO::filterText($albumInfo['title'], NULL, true, true);

		$data['userid'] = $albumInfo['userid'];
		if ($data['userid'])
		{
			// Grab our user info
			DBSEO::getUserInfo($data['userid']);
			$userInfo = DBSEO::$cache['userinfo'][$data['userid']];
		}
		
		if (!$userInfo['userid'])
		{
			// User didn't exist
			return '';
		}

		// Handle userid and username
		$replace['%user_id%'] 	= $userInfo['userid'];
		$replace['%user_name%'] = DBSEO::filterText($userInfo['username'], NULL, false, true, true);

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}