<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBGallery by Scandal v1.0 for vBulletin 3.8.x                    # ||
|| # file: sc_gallery_admin.php v1.0                                  # ||
|| # ---------------------------------------------------------------- # ||
|| #                                                                  # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| # ---------------------------------------------------------------- # ||
|| # CVS: $RCSfile: admincp/sc_gallery_admin.php,v1.0                 # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'sc_gallery_admin.php');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('style');
$specialtemplates = array('products');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminsettings'))
{
	print_cp_no_permission();
}

// ######################## ADMINCP HEADER ################################
print_cp_header($vbphrase['sc_gallery_title']);

// ######################## FUNCTIONS #####################################
// Get Parent Options (for parent category select) - Max depth is 5
function fetch_gallery_parent_options_admin($thisitem = '', $parentid = -1, $depth = 1)
{
	global $db, $i_cache, $parentoptions;

	if (!is_array($i_cache))
	{
	// check to see if we have already got the results from the database
		$i_cache = array();
		$gcats = $db->query_read("
			SELECT sc_gallery.catid, sc_gallery.title, sc_gallery.parentid
			FROM " . TABLE_PREFIX . "sc_gallery AS sc_gallery
		");
		
		while ($gcat = $db->fetch_array($gcats))
		{
			$i_cache["$gcat[parentid]"]["$gcat[catid]"] = $gcat;
		}
		$db->free_result($gcats);
	}

	if (!is_array($parentoptions))
	{
		$parentoptions = array();
	}

	foreach($i_cache["$parentid"] AS $cat)
	{
		if ($cat['catid'] != $thisitem)
		{
		if ($depth < 5)
		{
			$parentoptions["$cat[catid]"] = str_repeat('--', $depth) . ' ' . $cat['title'];
			if (is_array($i_cache["$cat[catid]"]))
			{
				fetch_gallery_parent_options_admin($thisitem, $cat['catid'], $depth + 1);
			}
		}	
		}
	}
}

// Cache Categories
function cache_gallery_cats($gallery_catid = -1, $depth = 0)
{
	// returns an array of gallery categories with correct parenting and depth information

	global $db, $cat_cache, $count;
	static $g_cache, $i;
	
	if (!is_array($g_cache))
	{
	// check to see if we have already got the results from the database
		$g_cache = array();
		$gallery_cats = $db->query_read("
			SELECT sc_gallery.*, COUNT(album.catid) AS items
			FROM " . TABLE_PREFIX . "sc_gallery AS sc_gallery
			LEFT JOIN " . TABLE_PREFIX . "album AS album USING(catid)
			GROUP BY sc_gallery.catid
			ORDER BY sc_gallery.displayorder
		");	
		while ($gallery_cat = $db->fetch_array($gallery_cats))
		{
			$g_cache["$gallery_cat[parentid]"]["$gallery_cat[displayorder]"]["$gallery_cat[catid]"] = $gallery_cat;
		}
		$db->free_result($gallery_cats);
	}

	// database has already been queried
	if (is_array($g_cache["$gallery_catid"]))
	{
		foreach ($g_cache["$gallery_catid"] AS $holder)
		{
			foreach ($holder AS $gallery_cat)
			{
				$cat_cache["$gallery_cat[catid]"] = $gallery_cat;
				$cat_cache["$gallery_cat[catid]"]['depth'] = $depth;
				unset($g_cache["$gallery_catid"]);
				cache_gallery_cats($gallery_cat['catid'], $depth + 1);
			} 
		} 
	}
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'categories';
}

// ######################## CATEGORIES DISPLAY ORDER #######################
if ($_REQUEST['do'] == 'updateorder')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'order' => TYPE_NOCLEAN,
	));

	if (is_array($vbulletin->GPC['order']))
	{
		$categories = $db->query_read("
			SELECT sc_gallery.catid, sc_gallery.displayorder
			FROM " . TABLE_PREFIX . "sc_gallery AS sc_gallery
		");
		while ($category = $db->fetch_array($categories))
		{
			$gallery_cat_displayorder = intval($vbulletin->GPC['order']["$category[catid]"]);
			if ($category['gallery_cat_displayorder'] != $gallery_cat_displayorder)
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "sc_gallery
					SET displayorder = $gallery_cat_displayorder
					WHERE catid = $category[catid]
				");
			}
		}
	}

	define('CP_REDIRECT', "sc_gallery_admin.php?do=categories");
	print_stop_message('saved_display_order_successfully');
}

// ##################### INSERT CATEGORY TO DATABASE #########################
if ($_POST['do'] == 'insertcat')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'title' => TYPE_NOHTML,
		'description' => TYPE_NOHTML,
		'displayorder' => TYPE_INT,
		'parentid' => TYPE_INT,
		'iconpath' => TYPE_STR
	));

	$db->query_write("INSERT INTO " . TABLE_PREFIX . "sc_gallery (
		catid,title,description,displayorder,parentid,iconpath
	) VALUES (
		NULL, '" . addslashes($vbulletin->GPC['title']) . "','" . addslashes($vbulletin->GPC['description']) . "','". intval($vbulletin->GPC['displayorder']) ."', '". intval($vbulletin->GPC['parentid']) ."', '" . addslashes($vbulletin->GPC['iconpath']) . "'
	)");

	define('CP_REDIRECT', "sc_gallery_admin.php?do=categories");
	print_stop_message('saved_category_x_successfully', $vbulletin->GPC['title']);
}

// ##################### UPDATE CATEGORY TO DATABASE #########################
if ($_POST['do'] == 'updatecat')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'catid' => TYPE_INT,
		'title' => TYPE_NOHTML,
		'description' => TYPE_NOHTML,
		'displayorder' => TYPE_INT,
		'parentid' => TYPE_INT,
		'iconpath' => TYPE_STR
	));


    // if category contains albums, not allow to convert it to header (do parentid = -1)   
        $query = $vbulletin->db->query_read("
                  SELECT album.albumid as albumid
                  FROM " . TABLE_PREFIX . "album AS album
                  WHERE album.catid = ". $vbulletin->GPC['catid'] ."
                  ");
        $howmuch = $vbulletin->db->num_rows($query);
 
     if (($howmuch > 0) AND ($vbulletin->GPC['parentid'] == -1))
     {
      print_stop_message('cant_convert_to_header_cat', $howmuch);
     }
       
                
  		$db->query_write("
  			UPDATE " . TABLE_PREFIX . "sc_gallery SET
  			title = '" . addslashes($vbulletin->GPC['title']) . "',
  			description = '" . addslashes($vbulletin->GPC['description']) . "',
  			displayorder = ". $vbulletin->GPC['displayorder'] .",
  			iconpath = '" . addslashes($vbulletin->GPC['iconpath']) . "',
  			parentid = ". $vbulletin->GPC['parentid'] ."
  			WHERE catid = ". $vbulletin->GPC['catid'] ."
  		");
  		define('CP_REDIRECT', "sc_gallery_admin.php?do=categories");
  		print_stop_message('saved_category_x_successfully', $vbulletin->GPC['title']);

}

// ##################### DELETE CATEGORY FROM DATABASE #######################
if ($_POST['do'] == 'killcat')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'catid' => TYPE_INT,
		'destinationid' => TYPE_INT
	));


  // check if the destination category is a header and show error if yes
  	$query = $db->query_read("
			SELECT parentid
			FROM " . TABLE_PREFIX . "sc_gallery
			WHERE catid = ". $vbulletin->GPC['destinationid'] ."
		");
		while ($isheader = $db->fetch_array($query))
		{
      if ($isheader['parentid'] == -1)
      {
      print_stop_message('cant_move_to_header_cat');
      }
    }

  // send the subcategories to default header category id: 2
	$db->query_write("
			UPDATE " . TABLE_PREFIX . "sc_gallery
			SET parentid = 2
			WHERE parentid = ". $vbulletin->GPC['catid'] ."
		");

		$dest = $db->query_first("
			SELECT title
			FROM " . TABLE_PREFIX . "sc_gallery
			WHERE catid = ". $vbulletin->GPC['catid'] ."
		");
		
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "album
			SET catid = ". $vbulletin->GPC['destinationid'] ."
			WHERE catid = ". $vbulletin->GPC['catid'] ."
		");	
				
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "sc_gallery WHERE catid = ". $vbulletin->GPC['catid'] ."");

	define('CP_REDIRECT', "sc_gallery_admin.php?do=categories");
	print_stop_message('deleted_category_successfully');
}

// ##################### DO MASS MOVE ALBUMS #######################
if ($_POST['do'] == 'domass')
{

	$vbulletin->input->clean_array_gpc('p', array(
		'catid' => TYPE_INT,
		'destinationid' => TYPE_INT
	));

		$query = $db->query_read("
			SELECT parentid
			FROM " . TABLE_PREFIX . "sc_gallery
			WHERE catid = ". $vbulletin->GPC['destinationid'] ."
		");
		
		// check if the category is a header (can't contain Albums so NO mass move)
		while ($isheader = $db->fetch_array($query))
		{
      if ($isheader['parentid'] == -1)
      {
      print_stop_message('cant_move_to_header_cat');
      }
    }
		
		$dest = $db->query_first("
			SELECT title
			FROM " . TABLE_PREFIX . "sc_gallery
			WHERE catid = ". $vbulletin->GPC['catid'] ."
		");
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "album
			SET catid = ". $vbulletin->GPC['destinationid'] ."
			WHERE catid = ". $vbulletin->GPC['catid'] ."
		");

	define('CP_REDIRECT', "sc_gallery_admin.php?do=categories");
	print_stop_message('mass_move_done');
}

// ######################### ADD CATEGORY FORM ############################
if ($_REQUEST['do'] == 'addcat')
{
	print_form_header('sc_gallery_admin', 'insertcat');
	print_table_header($vbphrase["add_new_album_category"]);
	print_input_row($vbphrase['title'], 'title');
	print_input_row($vbphrase['description'],'description');
  print_input_row($vbphrase['sc_gallery_iconpath'],'iconpath');
  
	$parentoptions = array('-1' => $vbphrase["gallery_act_as_header"]);
	fetch_gallery_parent_options_admin($category['catid']);

	print_select_row($vbphrase['gallery_cat_parent'], 'parentid', $parentoptions,'-1');
	print_input_row($vbphrase['display_order'], 'displayorder',1);
	print_submit_row($vbphrase['save']);
}

// ######################### EDIT CATEGORY FORM ############################
if ($_REQUEST['do'] == 'editcat')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT
	));

	$category = $db->query_first("
		SELECT * FROM " . TABLE_PREFIX . "sc_gallery
		WHERE catid = ". $vbulletin->GPC['catid'] ."
	");

  if ($category['catid'] == 1)
  {
   print_table_start(); 
   print_table_header("Important Notice"); 
   echo "<tr><td class=\"alt1\" colspan=\"2\">" . $vbphrase['gallery_uncategorized_notice'] . "</td></tr>";
   print_table_footer(2, '', '', 0);
  } 

	print_form_header('sc_gallery_admin', 'updatecat');
	construct_hidden_code('catid', $category['catid']);
	print_table_header(construct_phrase($vbphrase['x_y_id_z'], $vbphrase['gallery_category'], $category['title'], $category['catid']));
	print_input_row($vbphrase['title'], 'title', $category['title'], 0);
	print_input_row($vbphrase['description'],'description',$category['description']);
  print_input_row($vbphrase['sc_gallery_iconpath'],'iconpath',$category['iconpath']);
  
	$parentoptions = array('-1' => $vbphrase['gallery_act_as_header']);
	fetch_gallery_parent_options_admin($category['catid']);

  if ($category['catid'] == 1)
  {
  construct_hidden_code('parentid', 2);
  }
  elseif ($category['catid'] == 2) 
  {
  construct_hidden_code('parentid', -1);
  }
  else
  {
	print_select_row($vbphrase["gallery_cat_parent"], 'parentid', $parentoptions, $category['parentid']);
	}
	print_input_row($vbphrase['display_order'], 'displayorder', $category['displayorder']);
	print_submit_row();
}


// ######################### REMOVE CATEGORY FORM ############################
if ($_REQUEST['do'] == 'removecat')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT
	));

	$categories = $db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "sc_gallery
		ORDER BY displayorder
	");
	
	if (($vbulletin->GPC['catid'] == 1) OR ($vbulletin->GPC['catid'] == 2))
	{
	  print_stop_message('cant_remove_default_category', $vbulletin->GPC['catid']);
	}
	else
	{
		$category = array();
		$destcats = array();
		while ($tmp = $db->fetch_array($categories))
		{
			if ($tmp['catid'] == $vbulletin->GPC['catid'])
			{
				$category = $tmp;
			}
			else
			{
				$destcats[$tmp['catid']] = $tmp['title'];
			}
		}
		unset($tmp);
		$db->free_result($categories);

		echo "<p>&nbsp;</p><p>&nbsp;</p>\n";

		print_form_header('sc_gallery_admin', 'killcat');
		construct_hidden_code('catid', $category['catid']);
		print_table_header(construct_phrase($vbphrase['delete']));
		
    // check if is a header cat	
		$query = $db->query_read("
			SELECT parentid
			FROM " . TABLE_PREFIX . "sc_gallery
			WHERE catid = ". $vbulletin->GPC['catid'] ."
		");
		while ($isheader = $db->fetch_array($query))
		{
      if ($isheader['parentid'] == -1)
      {
      print_description_row('<blockquote>' . construct_phrase($vbphrase["delete_gallery_header_category_called_x_question"], $category['title']) . '</blockquote>');
      }
      else
      {
      print_description_row('<blockquote>' . construct_phrase($vbphrase["delete_gallery_category_called_x_question"], $category['title'], construct_select_options($destcats)) . '</blockquote>');
      }  
    }
			
		print_submit_row($vbphrase['delete'], '', 2, $vbphrase['go_back']);
	}
}

// ######################### MASS MOVE ALBUMS FORM ########################
if ($_REQUEST['do'] == 'massmove')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT
	));

	$categories = $db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "sc_gallery
		ORDER BY displayorder
	");
	
		$category = array();
		$destcats = array();
		
                	
		while ($tmp = $db->fetch_array($categories))
		{

			if ($tmp['catid'] == $vbulletin->GPC['catid'])
			{
				$category = $tmp;
				
				// stop if the category is a header
				if ($category['parentid'] == -1)
				   {
           print_stop_message('cant_massmove_header_category', $category['title']);
           }
			}
			else
			{
				$destcats[$tmp['catid']] = $tmp['title'];
			}
		}
		unset($tmp);
		$db->free_result($categories);

		echo "<p>&nbsp;</p><p>&nbsp;</p>\n";

		print_form_header('sc_gallery_admin', 'domass');
		construct_hidden_code('catid', $category['catid']);
		print_table_header(construct_phrase($vbphrase['mass_move']));
		print_description_row('<blockquote>' . construct_phrase($vbphrase["mass_move_gallery_question"], $category['title'], construct_select_options($destcats)) . '</blockquote>');
		print_submit_row($vbphrase['mass_move'], '', 2, $vbphrase['go_back']);

}

// ######################### MANAGE CATEGORIES ############################
if ($_REQUEST['do'] == 'categories')
{

// ============================ 
 	cache_gallery_cats();
 	if (empty($cat_cache))
 	{
		print_stop_message("no_x_categories_found","$vbphrase[albums]", "sc_gallery_admin.php?$session[sessionurl]do=categories");
	}
	
 print_table_start();
 print_table_header("Notice"); 
 echo '<tr><td class="alt1" colspan="2">The albums counter per category on AdminCP contains all albums (public, private and empty). Gallery displays only non empty and non private Albums.</td></tr>';
 print_table_footer(2, '', '', 0);	
	
	print_form_header('sc_gallery_admin', 'updateorder');
	print_table_header($vbphrase['sc_gallery_catman'], 4);
	print_cells_row(array($vbphrase['title'], $vbphrase['albums'], $vbphrase['display_order'], $vbphrase['controls']), 1, '', -1);

	// display individual category
	foreach($cat_cache AS $key => $gallery_cat)
	{

		$cell = array();
		$cell[] = "<strong>" . construct_depth_mark($gallery_cat['depth'], '- - ', '  ') . "<a href=\"../gallerydisplay.php?$session[sessionurl]c=$gallery_cat[catid]\" target=\"blank\">$gallery_cat[title]</a></strong><div style=\"padding-left: 16px\">{$gallery_cat[description]}</div>";

      if ($gallery_cat['parentid'] != -1)
        {
        $cell[] = vb_number_format($gallery_cat['items']) . ' ' . "$vbphrase[albums]";
  			}
  			else
        {
        $cell[] = '';
        }
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$gallery_cat[catid]]\" value=\"$gallery_cat[displayorder]\" tabindex=\"1\" size=\"3\" />";
			$cell[] =
			  construct_link_code($vbphrase['edit'], "sc_gallery_admin.php?$session[sessionurl]do=editcat&amp;catid=$gallery_cat[catid]").
			  construct_link_code($vbphrase['mass_move'], "sc_gallery_admin.php?$session[sessionurl]do=massmove&amp;catid=$gallery_cat[catid]").
				construct_link_code($vbphrase['delete'], "sc_gallery_admin.php?$session[sessionurl]do=removecat&amp;catid=$gallery_cat[catid]");
				
		print_cells_row($cell, 0, '', -1);
	}
		print_submit_row($vbphrase['save_display_order'], NULL, 4);
		echo "<p align=\"center\">" . construct_link_code($vbphrase['add_new_album_category'], "sc_gallery_admin.php?$session[sessionurl]do=addcat")."</p>";
		
	print_table_footer();
}



// ######################### MANAGE ALBUMS ################################
if ($_REQUEST['do'] == 'list')
{ 
	$vbulletin->input->clean_array_gpc('r', array(
		'perpage' => TYPE_UINT,
		'page' => TYPE_UINT
	));

// Prepare pagenav
	if ($vbulletin->GPC['page'] < 1)
	{
		$vbulletin->GPC['page'] = 1;
	}

	if ($vbulletin->GPC['perpage'] < 1)
	{
		$vbulletin->GPC['perpage'] = 20;
	}

  $startat = ($vbulletin->GPC['page'] - 1) * $vbulletin->GPC['perpage'];
	$counter = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "album AS album
	");

  $totalitems = $counter['total'];
	$totalpages = ceil($totalitems / $vbulletin->GPC['perpage']);

	if ($vbulletin->GPC['page'] > $totalpages)
	{
		$vbulletin->GPC['page'] = $totalpages;
	}

	$showprev = false;
	$shownext = false;
	
  if ($vbulletin->GPC['page'] > 1)
	{
		$showprev = true;
	}
	if ($vbulletin->GPC['page'] < $totalpages)
	{
		$shownext = true;
	}
	
	$pageoptions = array();
	for ($i = 1; $i <= $totalpages; $i++)
	{
		$pageoptions["$i"] = "Page $i / $totalpages";
	}

// Main query for Albums
		$albums = $db->query_read("
		SELECT album.*,
		  picture.pictureid,
		  IF(picture.thumbnail_filesize > 0, 1, 0) AS hasthumbnail, picture.thumbnail_dateline,
			user.username AS username,
			sc_gallery.catid AS category_id,
			sc_gallery.title AS cattitle
		FROM " . TABLE_PREFIX . "album AS album
			LEFT JOIN " . TABLE_PREFIX . "picture AS picture ON (album.coverpictureid = picture.pictureid)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = album.userid)
			LEFT JOIN " . TABLE_PREFIX . "sc_gallery AS sc_gallery ON (sc_gallery.catid = album.catid)
			ORDER BY album.createdate DESC
			LIMIT $startat, " . $vbulletin->GPC['perpage'] ."
		");


	if ($db->num_rows($albums))
	{
    		if ($vbulletin->GPC['page'] != 1)
    		{
    			$prv = $vbulletin->GPC['page'] - 1;
    			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] .
    							"\" tabindex=\"1\" onclick=\"window.location='sc_gallery_admin.php?" . $vbulletin->session->vars['sessionurl'] .
    							"do=list&pp=" . $vbulletin->GPC['perpage'] .
    							"&page=1'\">";
    
    			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] .
    							"\" tabindex=\"1\" onclick=\"window.location='sc_gallery_admin.php?" . $vbulletin->session->vars['sessionurl'] .
    							"do=list&pp=" . $vbulletin->GPC['perpage'] .
    							"&page=1'\">";
    	
    		}
    
    		if ($vbulletin->GPC['page'] != $totalpages)
    		{
    			$nxt = $vbulletin->GPC['page'] + 1;
    			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] .
    						" &gt;\" tabindex=\"1\" onclick=\"window.location='sc_gallery_admin.php?" .
    						$vbulletin->session->vars['sessionurl'] .
    							"do=list&pp=" . $vbulletin->GPC['perpage'] .
    							"&page=1'\">";
    
    			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] .
    							"do=list&pp=" . $vbulletin->GPC['perpage'] .
    							"&page=1'\">";
    		}
    
      // extra code for pagenav
      construct_hidden_code('perpage', $vbulletin->GPC['perpage']);
    	print_form_header('sc_gallery_admin', 'list');
    	print_table_header('&nbsp;', 4);
    	echo '<tr>
    		<td class="thead">' .
    		'<input type="button"' . iif(!$showprev, ' disabled="disabled"') . ' class="button" value="&laquo; ' . $vbphrase['prev'] . '" tabindex="1" onclick="this.form.page.selectedIndex -= 1; this.form.submit()" />&nbsp;' .
    		'<select name="page" tabindex="1" onchange="this.form.submit()" class="bginput">' . construct_select_options($pageoptions, $vbulletin->GPC['page']) . '</select>&nbsp;' .
    		'<input type="button"' . iif(!$shownext, ' disabled="disabled"') . ' class="button" value="' . $vbphrase['next'] . ' &raquo;" tabindex="1" onclick="this.form.page.selectedIndex += 1; this.form.submit()" />
    		</td>
    		<td class="thead">' . $vbphrase['sc_gallery_results_per_page'] . ': ' . $vbulletin->GPC['perpage'] . '</td>
    		<td class="thead">' . $vbphrase['sc_gallery_total_entries'] . ': ' . vb_number_format($counter['total']) . '</td>
    	</tr>';
    	print_table_footer(7, "&nbsp;", 0, 4);

      print_table_start();
      print_table_header($vbphrase['sc_gallery_album_man'], 6);
      print_description_row($vbphrase['sc_gallery_album_man_desc'], 0, 6);
      print_table_break();
      
      print_cells_row(array('ID', 'Cover', 'Album', 'Description', 'Pictures', 'Category'), true, '', -1);

        	while ($album = $db->fetch_array($albums))
        	{ 
        	  $cell = array();
        		$album['createdate'] = vbdate($vbulletin->options['dateformat'], $album['createdate'], true);
        		$album['picturecount'] = vb_number_format($album['visible']);
        		
        		$cell[] = "<strong><font size=\"4\">$album[albumid]</font></strong>";
          		if ($album['hasthumbnail']) 
              {                          
                $cell[] = "<img src=\"../picture.php?pictureid=$album[pictureid]&albumid=$album[albumid]&thumb=1&amp;d=$album[thumbnail_dateline]\" />";
              }
          		else 
              {
          		  $cell[] = "<img src=\"../images/misc/albumcover.png\" />";
              }
          		
        		$cell[] = "<div align=\"left\"><strong>" . "<a href=\"../album.php?$session[sessionurl]albumid=$album[albumid]\" target=\"blank\"><font size=\"4\">$album[title]</font></a></strong>" . " (Created: $album[createdate])" . "<br />By $album[username]</div>";
            $cell[] = "$album[description]";
            $cell[] = "$album[picturecount]";
            
              if ($album['category_id'] == 1) 
              {
                $cell[] = "<a href=\"../gallerydisplay.php?$session[sessionurl]c=$album[category_id]\" target=\"blank\"><font color=\"red\" size=\"4\">$album[cattitle]</font></a></strong>";
              }
              else
              {   
                $cell[] = "<a href=\"../gallerydisplay.php?$session[sessionurl]c=$album[category_id]\" target=\"blank\"><font size=\"4\">$album[cattitle]</font></a></strong>";
              }  
            print_cells_row($cell, 0, '', -1);
            	
        	}
     print_table_footer(6, '', '', 0);

	
	}


     
}

// ######################### FOOTER #######################################
print_cp_footer();


?>
