<?php  
/*======================================================================*\
|| #################################################################### ||
|| # vBGallery by Scandal v1.0 for vBulletin 3.8.x                    # ||
|| # file: gallery.php v1.0                                           # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Scandal @ vBulletin.org                          # ||
|| #                                                                  # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'sc_gallery');
define('CSRF_PROTECTION', true);  

// #################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('album', 'user', );

// get special data templates from the datastore
$specialtemplates = array(); 

// pre-cache templates used by all actions
$globaltemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
	'GALLERYHOME',
	'galleryhome_category_level1',
	'galleryhome_category_level2',
	'galleryhome_category_level3',
	'galleryhome_category_level4',
	'galleryhome_category_level5',
	'galleryhome_loggedinuser',
	'galleryhome_activeusers',
  'gallery_navbar',
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'latestcomments' => array(
	'gallery_latestcomments',
	'gallerysearch_commentbit',
	),
	'latestpictures' => array(
	'gallery_latestpictures',
	'gallerysearch_picturebit',
	),
	'latestalbums' => array(
	'gallery_latestalbums',
	'gallerysearch_albumbit',
	),
	'mycomments' => array(
	'gallery_mycomments',
	'gallerysearch_commentbit',
	),    	
	'search' => array(
		'gallerysearch_page',
		'gallerysearch_input',
		'gallerysearch_albumbit',
		'gallerysearch_picturebit',
		'gallerysearch_commentbit',
    'gallerysearch_attachmentbit',
	),
	'attachments' => array(
		'GALLERYDISPLAY',
		'gallerysearch_attachmentbit',
	),  
	'pending' => array(
		'gallery_pending',
		'gallery_pending_albumbit',
	)	
);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_sc_gallery.php'); 
require_once('./includes/functions_album.php');
require_once('./includes/functions_user.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

cache_permissions($userinfo, false);

if (!($canviewalbums = $permissions['albumpermissions'] & $vbulletin->bf_ugp_albumpermissions['canviewalbum']))
{
	print_no_permission();
}

// Check ON/OFF field
if (!$vbulletin->options['sc_gallery_onoff'])
{ 
  $message = $vbulletin->options['sc_gallery_close_message'];
      if ($message)
      {
       standard_error($message);
      }
      else
      {
       $message = 'Gallery is closed. Please try again later.';
       standard_error($message);
      }      
}

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'home';
}

// ################# SET ALBUM PERMISSIONS ARRAY ##########################
$userinfo = cache_permissions($vbulletin->userinfo, false);
	
  $state=array('public');  
	if ($userinfo)
	{ // if is Super Moderator, Admin or Moderator, search returns and private-profile Albums/Pictures/Comments in them
		if ($userinfo['usergroupid']==5 OR $userinfo['usergroupid']==6 OR $userinfo['usergroupid']==7)
		{
			$state[]='private';
			$state[]='profile';
		}
	}
	
// ######################### GALLERYHOME #################################
if ($_REQUEST['do'] == 'home')
{ 
// ============================ 
  cache_gallery_cats();

  $depth = $vbulletin->options['sc_gallery_home_depth'];
    foreach ($cat_cache AS $row)
    {     
			// is this category a header category?
      if ($row['parentid'] == -1)
      {
       $categories_level2 = '';
       $show['subcat'] = false;

        	foreach ($cat_cache AS $subrow) 
          { 
            
            if ($subrow['parentid'] == $row['catid'])
            {     $categories_level3 = '';
                  $show['subcat'] = false;
                  $subcatchk = 0;

                  foreach ($cat_cache AS $sub2row)
                  {
                      if ($sub2row['parentid'] == $subrow['catid'])
                      {     
                        $categories_level4 = '';
                      
                        foreach ($cat_cache AS $sub3row)
                        {
                         if ($sub3row['parentid'] == $sub2row['catid'])
                         { 
                         
                            $categories_level5 = '';
                             foreach($cat_cache AS $sub4row)
                             {
                             if($sub4row['parentid'] == $sub3row['catid'])
                               {  
                                  $subrow['albums_num_sum'] += $sub4row['albums_num']; 
                                  if($vbulletin->options['sc_gallery_display_emptycat'] OR !$sub4row['albums_num'] == 0 OR !$subrow['albums_num_sum'] == 0)
                                  {                          
                                    count_num_ofpictures($sub4row);
                                    $subrow['pics_num_sum'] += $sub4row['pics_num'];
                                    construct_gallery_category_url($sub4row);
                                    
                                    if($depth >= 5)
                                     {
                                      eval('$categories_level5 .= "' . fetch_template('galleryhome_category_level5') . '";');
                                     }                               
                                  }
                               }
               
                             }

                            $subrow['albums_num_sum'] += $sub3row['albums_num'];
                            if($vbulletin->options['sc_gallery_display_emptycat'] OR !$sub3row['albums_num'] == 0 OR !$subrow['albums_num_sum'] == 0)
                            {              
                              construct_gallery_category_url($sub3row);
                              count_num_ofpictures($sub3row);
                              $subrow['pics_num_sum'] += $sub3row['pics_num'];
                             
                              if($depth >= 4)
                               {
                                eval('$categories_level4 .= "' . fetch_template('galleryhome_category_level4') . '";');  
                  						 }	
                            }
                         }
                        
                        }
                       
                       $subrow['albums_num_sum'] += $sub2row['albums_num'];
                       if($vbulletin->options['sc_gallery_display_emptycat'] OR !$sub2row['albums_num'] == 0 OR !$subrow['albums_num_sum'] == 0)
                       {
                         count_num_ofpictures($sub2row);
                         $subrow['pics_num_sum'] += $sub2row['pics_num'];                  
                          construct_gallery_category_url($sub2row);
                          if($depth >= 3)
                           {
                            eval('$categories_level3 .= "' . fetch_template('galleryhome_category_level3') . '";'); 
              							$show['subcat'] = true;
              							$subcatchk++;
              						 }	
                        }        
                      }
                                        
                  }
                 
                 $subrow['albums_num_sum'] += $subrow['albums_num'];
                if($vbulletin->options['sc_gallery_display_emptycat'] OR !$subrow['albums_num'] == 0 OR !$subrow['albums_num_sum'] == 0)
                { 
                  construct_gallery_category_url($subrow);
                  count_num_ofpictures($subrow);
                  $subrow['pics_num_sum'] += $subrow['pics_num'];
                  fetch_cat_last_pic($subrow);
                  
                 if($depth >= 2)
                 {
                  eval('$categories_level2 .= "' . fetch_template('galleryhome_category_level2') . '";');
    						 }
    						}	
            
            } 
           
           
          }
               
        construct_gallery_category_url($row);
       if($depth >= 1)
       {
        // complete category with subcategories
        eval('$galleries .= "' . fetch_template('galleryhome_category_level1') . '";');
					
          $show['galleries'] = true; 
       }  
        
      }
         
    }
  
// construct attachments gallery category
  if($vbulletin->options['sc_gallery_attach'] AND $vbulletin->options['sc_gallery_attachments_cat']) 
  {
    $isattach_gallery = true;
    //level2
    $subrow['catid'] = 0;
    $subrow['title'] =  $vbulletin->options['sc_gallery_attachments_cattitle'];                 
    $subrow['description'] = '';
    $subrow['url'] = 'gallery.php?' . $vbulletin->session->vars['sessionurl'] . 'do=attachments';
    $subrow['iconpath'] = $vbulletin->options['sc_gallery_attachments_statusicon'];
    
    // attach stats
    attachments_stats();
    fetch_attach_cat_last_pic($subrow);
    $subrow['pics_num_sum'] = $attach_stats['pics_num_attach'];   
    eval('$attach_category .= "' . fetch_template('galleryhome_category_level2') . '";');             
                
   // level1
    $row['catid'] = 0;
    $row['title'] = $vbphrase['sc_forum_attachments'];
    $row['description'] = '';
    $row['url'] = 'gallery.php?' . $vbulletin->session->vars['sessionurl'] . 'do=attachments'; 
    eval('$galleries .= "' . fetch_template('galleryhome_category_level1') . '";');              
   }  



///////////// What's going on 
  if ($vbulletin->options['sc_gallery_stats'])
  {
    // returns the array $stats
      fetch_gallery_stats();  
  }
  
  
//////////////// navbar and output
	$navbits = construct_navbits(array(
		'' => $vbphrase['gallery_navbit_headline']
	));

  $navbits = construct_navbits($navbits);
  eval('$navbar = "' . fetch_template('navbar') . '";');


///////////////// extract the GALLERYHOME
  eval('print_output("' . fetch_template('GALLERYHOME') . '");');

}


// ####################### ADVANCED SEARCH ###############################
if ($_REQUEST['do'] == 'search')
{

  // Check ON/OFF field
  if (!$vbulletin->options['sc_gallery_search'])
  { 
    standard_error($vbphrase['sc_gallery_search_off']);   
  }

  // Check allow guest to use search feature field
  if ($show['guest'])
  { 
    if (!$vbulletin->options['sc_gallery_search_guest'])
    { 
      print_no_permission();   
    } 
  }   
  
  
$vbulletin->input->clean_array_gpc('r', array(
	'contenttype' => TYPE_UINT,
	'query_keyword' => TYPE_STR
  ));

$searchquery_keyword = $vbulletin->GPC['query_keyword'];
$contenttype = $vbulletin->GPC['contenttype'];

// Flood check
if($searchquery_keyword)
{ 
			if ($vbulletin->options['searchfloodtime'] > 0)
			{
				// check for possible Denial of service attack
				$temptime = $db->query_first("
					SELECT last_search
					FROM " . TABLE_PREFIX . "sc_gallery_search 
					WHERE `userid` = " . $vbulletin->userinfo['userid'] . "
						OR `ipaddress` = '" . $db->escape_string(IPADDRESS) . "'
					ORDER BY `last_search` DESC LIMIT 0, 1
				");

				$timedelay = $vbulletin->options['searchfloodtime'];
        $flood_limit = $vbulletin->options['searchfloodtime'];
        
				if (TIMENOW - $temptime['last_search'] < $timedelay)
				{
					$timedelay = round($temptime['last_search'] + $timedelay - TIMENOW);

					eval(standard_error(fetch_error('sc_gallery_search_flood', $flood_limit, $timedelay)));
				}

				$db->free_result($temptime);
			}
}   
	
// Minimum characters limit error
  if($searchquery_keyword)
  { 
    $charlimit = $vbulletin->options['minsearchlength'];
    $charnum = strlen($searchquery_keyword);
      if ($charnum < $charlimit)
      {
        eval(standard_error(fetch_error('searchinvalidterm', $searchquery_keyword, $vbulletin->options['minsearchlength'])));
      }
  }    

// prepare query's conditions (1= Albums, 2=Pictures, 3=Comments)
    if ($contenttype == 1)
    {
    	if ($searchquery_keyword)
    	{
    		$searchwhere_albums = "AND (album.title LIKE '%" . $db->escape_string($searchquery_keyword) . "%' 
    						OR album.description LIKE '%" . $db->escape_string($searchquery_keyword) . "%'
    						OR user.username LIKE '%"  . $db->escape_string($searchquery_keyword) . "%')";
    		$searchquery_keyword = htmlspecialchars($searchquery_keyword);
    	}
    }
    elseif ($contenttype == 2)
    {	
    	if ($searchquery_keyword)
    	{         
    	 		$searchwhere_pictures = "AND (picture.caption LIKE '%" . $db->escape_string($searchquery_keyword) . "%' 
    						OR album.description LIKE '%" . $db->escape_string($searchquery_keyword) . "%'
    		 				OR user.username LIKE '%"  . $db->escape_string($searchquery_keyword) . "%')";
    		  $searchquery_keyword = htmlspecialchars($searchquery_keyword);
    	}
    }
    elseif ($contenttype == 3)
    {
    	if ($searchquery_keyword)
    	{        
    		$searchwhere_comments = "AND (picturecomment.pagetext LIKE '%" . $db->escape_string($searchquery_keyword) . "%' 
    						OR picturecomment.postusername LIKE '%"  . $db->escape_string($searchquery_keyword) . "%')";
    		$searchquery_keyword = htmlspecialchars($searchquery_keyword);
    	}	
    }
    elseif ($contenttype == 4)
    {
    	if ($searchquery_keyword)
    	{  
              /// if attachments search is open, build cache
                $show['cangetattachment'] = 1;
                $forum_cache = array();
                foreach ($vbulletin->forumcache AS $forumid => $foruminfo)
                {
                	$forumperms = $vbulletin->userinfo['forumpermissions']["$forumid"];
                	$foruminfo['options'] = intval($foruminfo['options']);
                  	foreach($vbulletin->bf_misc_forumoptions AS $optionname => $optionval)
                  	{
                  		$foruminfo["$optionname"] = (($foruminfo['options'] & $optionval) ? 1 : 0);
                  	}
                  	if (($forumperms & $vbulletin->bf_ugp_forumpermissions['canseethumbnails']))
                  	{
                  		$vbulletin->options['canseethumbnails'] = 1;
                  	}
                  	if (($forumperms & $vbulletin->bf_ugp_forumpermissions['cangetattachment']))
                  	{
                  		$vbulletin->options['viewattachedimages'] = (($vbulletin->options['viewattachedimages']) ? 1 : 0);
                  	}
                  	if (($forumperms & $vbulletin->bf_ugp_forumpermissions['canseethumbnails']) && ($forumperms & $vbulletin->bf_ugp_forumpermissions['cangetattachment']))
                  	{
                  		$forum_cache[] = $forumid;
                  	}
                }                  
    		$searchwhere_attachments = "AND (attachment.filename LIKE '%" . $db->escape_string($searchquery_keyword) . "%' 
						OR user.username LIKE '%"  . $db->escape_string($searchquery_keyword) . "%')";
    		$searchquery_keyword = htmlspecialchars($searchquery_keyword);
    	}	    
    }    
	
	
// Limit to results returning (set on admincp)
$limit = $vbulletin->options['maxresults'];
$search_complete = false;
$search_results = 0;

// Search Queries
if ($searchwhere_albums)
{      	
    // Query Search Albums
    	$albums = $db->query_read("
    		SELECT album.*,
    			picture.pictureid, 
          picture.userid, 
          picture.caption, 
          picture.extension, 
          picture.filesize, 
          picture.idhash, 
          picture.state,
    			picture.thumbnail_filesize, 
          picture.thumbnail_dateline, 
          picture.thumbnail_width, 
          picture.thumbnail_height,
    			user.username AS username
    		FROM " . TABLE_PREFIX . "album AS album
    			LEFT JOIN " . TABLE_PREFIX . "albumpicture AS albumpicture ON (album.coverpictureid = albumpicture.pictureid)
          LEFT JOIN " . TABLE_PREFIX . "picture AS picture ON (albumpicture.pictureid = picture.pictureid)
    			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (picture.userid = user.userid)
    		WHERE
    			(album.userid ='" . $vbulletin->userinfo['userid'] . "'
    			OR (album.state IN ('" . implode("', '", $state) . "')))
    			AND album.visible > 0 
    			$searchwhere_albums
    		ORDER BY album.lastpicturedate DESC
    		LIMIT $limit
    	");

        $search_results = $db->num_rows($albums);
      	$albumbits = '';
	      $picturebit_height = $vbulletin->options['album_thumbsize'] + (($usercss ? 0 : $stylevar['cellspacing']) + $stylevar['cellpadding']) * 12 + 4;
	      $picturebit_width = $vbulletin->options['album_thumbsize'] + (($usercss ? 0 : $stylevar['cellspacing']) + $stylevar['cellpadding']) * 4;
          
      	while ($album = $db->fetch_array($albums))
      	{
      		$album = prepare_pictureinfo_thumb($album, $album);
      
      		$album['picturecount'] = vb_number_format($album['visible']);
      		$album['picturedate'] = vbdate($vbulletin->options['dateformat'], $album['lastpicturedate'], true);
      
      		$album['title_html'] = $album['title'];
      		eval('$albumbits .= "' . fetch_template('gallerysearch_albumbit') . '";');

      	}
      $db->free_result($albums);   
		  $search_complete = true;
}      	
elseif ($searchwhere_pictures)
{
  // Query Search Pictures
  	$pictures = $db->query_read("
		SELECT 
			picture.pictureid, 
      picture.userid, 
      picture.caption, 
      picture.extension, 
      picture.filesize, 
      picture.idhash, 
      picture.state,
			picture.thumbnail_filesize, 
      picture.thumbnail_dateline, 
      picture.thumbnail_width, picture.thumbnail_height,
			album.albumid,
      album.title,
      album.lastpicturedate, 
      albumpicture.dateline,
			user.username,
      user.userid
  		FROM " . TABLE_PREFIX . "picture AS picture
			LEFT JOIN " . TABLE_PREFIX . "albumpicture AS albumpicture ON (albumpicture.pictureid = picture.pictureid)
			LEFT JOIN " . TABLE_PREFIX . "album AS album ON (album.albumid = albumpicture.albumid)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (picture.userid = user.userid)
  		WHERE
  			(album.userid ='" . $vbulletin->userinfo['userid'] . "'
  			OR (album.state IN ('" . implode("', '", $state) . "')))
  			AND album.visible > 0
  			$searchwhere_pictures
  		ORDER BY albumpicture.dateline DESC
  		LIMIT $limit
  	");
       
	     $picturebit_height = $vbulletin->options['album_thumbsize'] + (($usercss ? 0 : $stylevar['cellspacing']) + $stylevar['cellpadding']) * 16 + 4;
	     $picturebit_width = $vbulletin->options['album_thumbsize'] + (($usercss ? 0 : $stylevar['cellspacing']) + $stylevar['cellpadding']) * 4;   
        $search_results = $db->num_rows($pictures);
      	$picturebits = '';
      	while ($picture = $db->fetch_array($pictures))
      	{
          $picture = prepare_pictureinfo_thumb($picture, $picture);
      		$picture['picturedate'] = vbdate($vbulletin->options['dateformat'], $picture['dateline'], true);
      		$picture['coverdimensions'] = ($picture['thumbnail_width'] ? "width=\"$picture[thumbnail_width]\" height=\"$picture[thumbnail_height]\"" : '');
      
          eval('$picturebits .= "' . fetch_template('gallerysearch_picturebit') . '";');
      	}
      $db->free_result($pictures);   
		  $search_complete = true;
}
elseif ($searchwhere_comments)
{
    // Query Search Comments
  		$comments = $db->query_read("
			SELECT picturecomment.commentid,
             picturecomment.postuserid, 
             picturecomment.postusername, 
             picturecomment.dateline, 
             picturecomment.pagetext,
             album.albumid,
             user.userid,
             user.username,
             picture.pictureid,  
             picture.caption,
             IF(picture.thumbnail_filesize > 0, 1, 0) AS hasthumbnail
  			FROM " . TABLE_PREFIX . "picturecomment AS picturecomment
  			LEFT JOIN " . TABLE_PREFIX . "picture AS picture ON(picture.pictureid = picturecomment.pictureid)
        LEFT JOIN " . TABLE_PREFIX . "albumpicture AS albumpicture ON(picture.pictureid = albumpicture.pictureid)
  			LEFT JOIN " . TABLE_PREFIX . "album AS album ON(album.albumid = albumpicture.albumid)
  			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(picturecomment.postuserid = user.userid)
  			WHERE (album.userid ='" . $vbulletin->userinfo['userid'] . "'
  			OR (album.state IN ('" . implode("', '", $state) . "')))
        AND album.visible > 0 
        AND picturecomment.state = 'visible'	 
  			$searchwhere_comments
  			ORDER BY picturecomment.dateline DESC
  			LIMIT $limit
  		");
            	     
        $search_results = $db->num_rows($comments);
      	$commentbits = '';
      	while ($comment = $db->fetch_array($comments))
      	{
      		$comment['date'] = vbdate($vbulletin->options['dateformat'], $comment['dateline'], true);
      		$comment['time'] = vbdate($vbulletin->options['timeformat'], $comment['dateline'], true);
      		$comment['coverdimensions'] = ($comment['thumbnail_width'] ? "width=\"$comment[thumbnail_width]\" height=\"$comment[thumbnail_height]\"" : '');
      		
          eval('$commentbits .= "' . fetch_template('gallerysearch_commentbit') . '";');                  
      	}
      $db->free_result($comments);   
		  $search_complete = true;    
}
elseif ($searchwhere_attachments)
{ 
// Query Search Attachments
  $imagetypes = array('jpg', 'jpeg', 'gif', 'png', 'bmp');
	$attachments = $db->query_read("
		SELECT
			attachment.*, 
      IF(attachment.thumbnail_filesize > 0, 1, 0) AS hasthumbnail,
      post.postid, 
      user.username, 
      post.threadid, 
      thread.title AS threadtitle 
		FROM " . TABLE_PREFIX . "attachment AS attachment
		LEFT JOIN " . TABLE_PREFIX . "post AS post
			ON (attachment.postid = post.postid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (attachment.userid = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "thread AS thread
			ON (post.threadid = thread.threadid)
		WHERE attachment.extension IS NOT NULL
		  AND thread.forumid IN (".implode(',',$forum_cache).")
		  AND attachment.extension "." IN('".implode("','", $imagetypes)."')
      $searchwhere_attachments
		ORDER BY attachment.dateline DESC
		LIMIT $limit
	"); 
  
        $search_results = $db->num_rows($attachments);
      	$picturebits = '';
      	while ($attachment = $db->fetch_array($attachments))
      	{
          $attachment['picturedate'] = vbdate($vbulletin->options['dateformat'], $attachment['dateline'], true);
          $attachment['coverdimensions'] = ($attachment['thumbnail_width'] ? "width=\"$attachment[thumbnail_width]\" height=\"$attachment[thumbnail_height]\"" : '');
          
          eval('$picturebits .= "' . fetch_template('gallerysearch_attachmentbit') . '";');     	
      	}
      $db->free_result($attachments);   
		  $search_complete = true;
}


if ($search_complete)
{
  $db->query_write("INSERT INTO " . TABLE_PREFIX . "sc_gallery_search (userid, ipaddress, last_search)
        VALUES(" . $vbulletin->userinfo['userid'] . ", '" . $db->escape_string(IPADDRESS) . "', " . TIMENOW . ")
        ");      
} 
       
// navbits/navbar output
	$navbits = array(
		'gallery.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['gallery_navbit_headline'], $vbphrase['sc_gallery_search']
	);
  $navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
	
//extract the Page (Search)
  eval('print_output("' . fetch_template('gallerysearch_page') . '");');

}


// ####################### LATEST PICTURES ###############################
if ($_REQUEST['do'] == 'latestpictures')
{
$num_of_pics = $vbulletin->options['sc_gallery_latestpictures_num'];

    $vbulletin->input->clean_array_gpc('r', array(
    'perpage'    => TYPE_UINT,
    'pagenumber' => TYPE_UINT,
  ));
  
  $perpage = 25;
  $pagenumber = $vbulletin->GPC['pagenumber'];
  
  // returns $stats['pics_num']
  fetch_gallery_stats();

  // if latest pictures number on admincp field is bigger than the full number of pictures...
  if($num_of_pics > $stats['pics_num'])
  {
    $num_of_pics = $stats['pics_num'];
  }
    
  sanitize_pageresults($num_of_pics, $pagenumber, $perpage, 10000);
  
  $pagenav = construct_page_nav($pagenumber, $perpage, $num_of_pics,
  'gallery.php?do=latestpictures' . $vbulletin->session->vars['sessionurl'] . ($perpage ? "&amp;pp=$perpage" : '')
  );  
  
// Query for Latest Pictures
	$query_latestpictures = $db->query_read("
		SELECT 
			picture.pictureid, 
      picture.userid, 
      picture.caption, 
      picture.extension, 
      picture.filesize, 
      picture.idhash, 
      picture.state,
			picture.thumbnail_filesize, 
      picture.thumbnail_dateline, 
      picture.thumbnail_width, picture.thumbnail_height,
			album.albumid,
      album.title,
      album.lastpicturedate, 
      albumpicture.dateline,
			user.username,
      user.userid
		FROM " . TABLE_PREFIX . "picture AS picture
			LEFT JOIN " . TABLE_PREFIX . "albumpicture AS albumpicture ON (albumpicture.pictureid = picture.pictureid)
			LEFT JOIN " . TABLE_PREFIX . "album AS album ON (album.albumid = albumpicture.albumid)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (picture.userid = user.userid)
		WHERE
			(album.userid ='" . $vbulletin->userinfo['userid'] . "'
			OR (album.state IN ('" . implode("', '", $state) . "')))
			AND album.visible > 0
		ORDER BY albumpicture.dateline DESC
		LIMIT " . (($pagenumber - 1) * $perpage) . ", $perpage
	");

	$picturebit_height = $vbulletin->options['album_thumbsize'] + (($usercss ? 0 : $stylevar['cellspacing']) + $stylevar['cellpadding']) * 16 + 4;
	$picturebit_width = $vbulletin->options['album_thumbsize'] + (($usercss ? 0 : $stylevar['cellspacing']) + $stylevar['cellpadding']) * 4;

	$latestpictures_bits = '';
	while ($picture = $db->fetch_array($query_latestpictures))
	{
		$picture = prepare_pictureinfo_thumb($picture, $picture);

		$picture['picturecount'] = vb_number_format($picture['visible']);
		$picture['picturedate'] = vbdate($vbulletin->options['dateformat'], $picture['dateline'], true);

		$picture['title_html'] = $picture['caption'];
		$picture['albumtitle_html'] = $picture['title'];
		eval('$latestpictures_bits .= "' . fetch_template('gallerysearch_picturebit') . '";');
	}
      $db->free_result($query_latestpictures);
      
        	
// navbits/navbar output
	$navbits = array(
		'gallery.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['gallery_navbit_headline'], $vbphrase['sc_gallery_latest_pictures']
	);
  $navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
	
//extract the Page (Latest Pictures)
  eval('print_output("' . fetch_template('gallery_latestpictures') . '");');
 	
} 


// ####################### LATEST ALBUMS ###############################
if ($_REQUEST['do'] == 'latestalbums')
{ 
$num_of_albums = $vbulletin->options['sc_gallery_latestalbums_num'];

// pagenav construct
  $vbulletin->input->clean_array_gpc('r', array(
    'perpage'    => TYPE_UINT,
    'pagenumber' => TYPE_UINT,
  ));
  
  $perpage = 25;
  $pagenumber = $vbulletin->GPC['pagenumber'];

  // returns $stats['albums_num']
  fetch_gallery_stats();

  // if latest albums number on admincp field is bigger than the full number of albums...
  if($num_of_albums > $stats['albums_num'])
  {
    $num_of_albums = $stats['albums_num'];
  }
  
  sanitize_pageresults($num_of_albums, $pagenumber, $perpage, 9000);
  
  $pagenav = construct_page_nav($pagenumber, $perpage, $num_of_albums,
  'gallery.php?do=latestalbums' . $vbulletin->session->vars['sessionurl'] . ($perpage ? "&amp;pp=$perpage" : '')
  );  
        
// Query for Latest Albums
    	$query_latestalbums = $db->query_read("
    		SELECT album.*,
    			picture.pictureid, 
          picture.userid, 
          picture.caption, 
          picture.extension, 
          picture.filesize, 
          picture.idhash, 
          picture.state,
    			picture.thumbnail_filesize, 
          picture.thumbnail_dateline, 
          picture.thumbnail_width, 
          picture.thumbnail_height,
    			user.username AS username
    		FROM " . TABLE_PREFIX . "album AS album
    			LEFT JOIN " . TABLE_PREFIX . "picture AS picture ON (album.coverpictureid = picture.pictureid)
    			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (album.userid = user.userid)
    		WHERE
    			(album.userid ='" . $vbulletin->userinfo['userid'] . "'
    			OR (album.state IN ('" . implode("', '", $state) . "')))
    			AND album.visible > 0
    		ORDER BY album.createdate DESC
    		LIMIT " . (($pagenumber - 1) * $perpage) . ", $perpage
    	");

	$picturebit_height = $vbulletin->options['album_thumbsize'] + (($usercss ? 0 : $stylevar['cellspacing']) + $stylevar['cellpadding']) * 12 + 4;
	$picturebit_width = $vbulletin->options['album_thumbsize'] + (($usercss ? 0 : $stylevar['cellspacing']) + $stylevar['cellpadding']) * 4;
	
	$latestalbums_bits = '';
      	while ($album = $db->fetch_array($query_latestalbums))
      	{
      		$album = prepare_pictureinfo_thumb($album, $album);
      
      		$album['picturecount'] = vb_number_format($album['visible']);
      		$album['picturedate'] = vbdate($vbulletin->options['dateformat'], $album['lastpicturedate'], true);
      
      		$album['title_html'] = $album['title'];
      		eval('$latestalbums_bits .= "' . fetch_template('gallerysearch_albumbit') . '";');

      	}
      $db->free_result($query_latestalbums);   

// navbits/navbar output
	$navbits = array(
		'gallery.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['gallery_navbit_headline'], $vbphrase['sc_gallery_latest_albums']
	);
  $navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

//extract the Page (Latest Albums)
  eval('print_output("' . fetch_template('gallery_latestalbums') . '");'); 
}


// ####################### LATEST COMMENTS ###############################
if ($_REQUEST['do'] == 'latestcomments')
{
$num_of_comments = $vbulletin->options['sc_gallery_latestcomments_num'];

// pagenav construct
    $vbulletin->input->clean_array_gpc('r', array(
    'perpage'    => TYPE_UINT,
    'pagenumber' => TYPE_UINT,
  ));
      	
  $perpage = 25;
  $pagenumber = $vbulletin->GPC['pagenumber'];

  // returns $stats['comments_num']
  fetch_gallery_stats();

  // if latest comments number on admincp field is bigger than the full number of comments...
  if($num_of_comments > $stats['comments_num'])
  {
    $num_of_comments = $stats['comments_num'];
  }

  sanitize_pageresults($num_of_comments, $pagenumber, $perpage, 9000);
  
  $pagenav = construct_page_nav($pagenumber, $perpage, $num_of_comments,
  'gallery.php?do=latestcomments' . $vbulletin->session->vars['sessionurl'] . ($perpage ? "&amp;pp=$perpage" : '')
  );
  
  
// Query for Latest Comments
		$query_latestcomments = $db->query_read("
			SELECT picturecomment.commentid,
             picturecomment.postuserid, 
             picturecomment.postusername, 
             picturecomment.dateline, 
             picturecomment.pagetext,
             album.albumid,
             user.userid,
             user.username,
             picture.pictureid,  
             picture.caption,
             IF(picture.thumbnail_filesize > 0, 1, 0) AS hasthumbnail
			FROM " . TABLE_PREFIX . "picturecomment AS picturecomment
			LEFT JOIN " . TABLE_PREFIX . "picture AS picture ON(picture.pictureid = picturecomment.pictureid)
      LEFT JOIN " . TABLE_PREFIX . "albumpicture AS albumpicture ON(picture.pictureid = albumpicture.pictureid)
			LEFT JOIN " . TABLE_PREFIX . "album AS album ON(album.albumid = albumpicture.albumid)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(picturecomment.postuserid = user.userid)
  		WHERE (album.userid ='" . $vbulletin->userinfo['userid'] . "'
    		OR (album.state IN ('" . implode("', '", $state) . "')))
        AND album.visible > 0 
        AND picturecomment.state = 'visible'	 
    		ORDER BY picturecomment.dateline DESC
			LIMIT " . (($pagenumber - 1) * $perpage) . ", $perpage
		");
		
		
		while ($comment = $db->fetch_array($query_latestcomments))
		{
		$comment['date'] = vbdate($vbulletin->options['dateformat'], $comment['dateline'], true);
		$comment['time'] = vbdate($vbulletin->options['timeformat'], $comment['dateline'], true);
		$comment['coverdimensions'] = ($comment['thumbnail_width'] ? "width=\"$comment[thumbnail_width]\" height=\"$comment[thumbnail_height]\"" : '');
		
    eval('$latestcomments_bits .= "' . fetch_template('gallerysearch_commentbit') . '";');    
    }
    $db->free_result($query_latestcomments);

// navbits/navbar output
	$navbits = array(
		'gallery.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['gallery_navbit_headline'], $vbphrase['sc_gallery_latest_comments']
	);
  $navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
  
//extract the Page (Latest Comments)
  eval('print_output("' . fetch_template('gallery_latestcomments') . '");');
  
}


// ####################### MY COMMENTS ###############################
if ($_REQUEST['do'] == 'mycomments')
{
  // guests cannot see the page
  if ($show['guest'])
  {
    print_no_permission();  
  }

$userid = $vbulletin->userinfo['userid'];   
//////////// pagenav construct
    $vbulletin->input->clean_array_gpc('r', array(
    'perpage'    => TYPE_UINT,
    'pagenumber' => TYPE_UINT,
  ));
      	
  $perpage = 10;
  $pagenumber = $vbulletin->GPC['pagenumber'];  


// query for counting number of comments
		$mycomments_count = $db->query_read("
			SELECT picturecomment.commentid
			FROM " . TABLE_PREFIX . "picturecomment AS picturecomment
  		WHERE picturecomment.state = 'visible' AND picturecomment.postuserid = $userid 
		");  
 
    $rows = $db->num_rows($mycomments_count); 

    sanitize_pageresults($rows, $pagenumber, $perpage, 9000);
    
    $pagenav = construct_page_nav($pagenumber, $perpage, $rows,
    'gallery.php?do=mycomments' . $vbulletin->session->vars['sessionurl'] . ($perpage ? "&amp;pp=$perpage" : '')
    );  


// Query for My Comments
		$query_mycomments = $db->query_read("
			SELECT picturecomment.commentid,
             picturecomment.pictureid,
             picturecomment.postuserid, 
             picturecomment.postusername, 
             picturecomment.dateline, 
             picturecomment.pagetext,
             albumpicture.albumid,
             user.userid,
             user.username
			FROM " . TABLE_PREFIX . "picturecomment AS picturecomment
      LEFT JOIN " . TABLE_PREFIX . "albumpicture AS albumpicture ON(albumpicture.pictureid = picturecomment.pictureid)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(picturecomment.postuserid = user.userid)
  		WHERE picturecomment.state = 'visible' AND picturecomment.postuserid = $userid	 
    	ORDER BY picturecomment.dateline DESC
			LIMIT " . (($pagenumber - 1) * $perpage) . ", $perpage
		");
		
		
		while ($comment = $db->fetch_array($query_mycomments))
		{
		$comment['date'] = vbdate($vbulletin->options['dateformat'], $comment['dateline'], true);
		$comment['time'] = vbdate($vbulletin->options['timeformat'], $comment['dateline'], true);
		$comment['coverdimensions'] = ($comment['thumbnail_width'] ? "width=\"$comment[thumbnail_width]\" height=\"$comment[thumbnail_height]\"" : '');
		
    eval('$mycomments_bits .= "' . fetch_template('gallerysearch_commentbit') . '";');     
   
    }
    $db->free_result($query_mycomments);

		
// navbits/navbar output
	$navbits = array(
		'gallery.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['gallery_navbit_headline'], $vbphrase['sc_gallery_my_comments']
	);
  $navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
  
//extract the Page (My Comments)
  eval('print_output("' . fetch_template('gallery_mycomments') . '");');

}


// ################## PENDING UNCATEGORIZED ALBUMS ########################
if ($_REQUEST['do'] == 'pending')
{
  // guests cannot see the page
  if ($show['guest'])
  {
    print_no_permission();  
  }
  
$catid = 1;
// It returns the array $gallery with all info 
fetch_category_info($catid);

// Query for pending albums
	$albums = $db->query_read("
		SELECT album.*,
			picture.pictureid,
			IF(picture.thumbnail_filesize > 0, 1, 0) AS hasthumbnail, picture.thumbnail_dateline, picture.thumbnail_width, picture.thumbnail_height,
			user.username AS username
		FROM " . TABLE_PREFIX . "album AS album
			LEFT JOIN " . TABLE_PREFIX . "picture AS picture ON (album.coverpictureid = picture.pictureid)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (picture.userid = user.userid)
		WHERE album.userid ='" . $vbulletin->userinfo['userid'] . "'
    AND album.catid = '" . $catid . "' OR album.catid = 0 
		ORDER BY album.createdate DESC
	");

	$albumbits = '';
	$width = $vbulletin->options['sc_gallery_display_width'];
	while ($album = $db->fetch_array($albums))
	{ 
	  if ($vbulletin->options['sc_gallery_show_comments'])
    { 
          count_num_ofcomments($album);
    }
		$album['picturecount'] = vb_number_format($album['visible']);
		$album['picturedate'] = vbdate($vbulletin->options['dateformat'], $album['lastpicturedate'], true);
		$album['picturetime'] = vbdate($vbulletin->options['timeformat'], $album['lastpicturedate']);
		$album['createdate'] = vbdate($vbulletin->options['dateformat'], $album['createdate'], true);

		$album['description_html'] = $album['description'];
		$album['title_html'] = $album['title'];
		$album['coverdimensions'] = ($album['thumbnail_width'] ? "width=\"$album[thumbnail_width]\" height=\"$album[thumbnail_height]\"" : '');

    eval('$albumbits .= "' . fetch_template('gallery_pending_albumbit') . '";');
	}
  $db->free_result($albums);


// Clean notifications counter
  $db->query_write("
    UPDATE " . TABLE_PREFIX . "user
    SET gallerynotif_cnt = 0
    WHERE userid = ". $vbulletin->userinfo['userid'] ."
    "); 
        
/// Navbits and navbar output
	$navbits = array(
		'gallery.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['gallery_navbit_headline'], $vbphrase['sc_pending_albums']
	);
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
   
/// Extract pending albums page
   eval('print_output("' . fetch_template('gallery_pending') . '");');

}

// ################## ATTACHMENTS GALLERY ########################
if ($_REQUEST['do'] == 'attachments')
{
  // Check ON/OFF field
  if (!$vbulletin->options['sc_gallery_attach'])
  { 
    standard_error($vbphrase['sc_gallery_attachgallery_off']);   
  }

  $vbulletin->input->clean_array_gpc('r', array(
  'perpage'    => TYPE_UINT,
  'pagenumber' => TYPE_UINT,
  'term' => TYPE_STR
  ));
  
  $vbulletin->input->clean_array_gpc('g', array(
		'my'	=> TYPE_BOOL,
		'fid' => TYPE_UINT
	));  

///////////// search prepare
  $searchquery = $vbulletin->GPC['term'];

// Flood check
if($searchquery)
{ 
			if ($vbulletin->options['searchfloodtime'] > 0)
			{
				// check for possible Denial of service attack
				$temptime = $db->query_first("
					SELECT last_search
					FROM " . TABLE_PREFIX . "sc_gallery_search 
					WHERE `userid` = " . $vbulletin->userinfo['userid'] . "
						OR `ipaddress` = '" . $db->escape_string(IPADDRESS) . "'
					ORDER BY `last_search` DESC LIMIT 0, 1
				");

				$timedelay = $vbulletin->options['searchfloodtime'];
        $flood_limit = $vbulletin->options['searchfloodtime'];
        
				if (TIMENOW - $temptime['last_search'] < $timedelay)
				{
					$timedelay = round($temptime['last_search'] + $timedelay - TIMENOW);

					eval(standard_error(fetch_error('sc_gallery_search_flood', $flood_limit, $timedelay)));
				}

				$db->free_result($temptime);
			}
}

// search: where conditions
if ($searchquery)
{
		$search_to_attachments = "AND (attachment.filename LIKE '%" . $db->escape_string($searchquery) . "%' 
						OR user.username LIKE '%"  . $db->escape_string($searchquery) . "%')";
      $searchquery = htmlspecialchars($searchquery);
}      

// Minimum characters limit error
if($searchquery)
{ 
  $charlimit = $vbulletin->options['minsearchlength'];
  $charnum = strlen($searchquery);
    if ($charnum < $charlimit)
    {
      eval(standard_error(fetch_error('searchinvalidterm', $searchquery, $vbulletin->options['minsearchlength'])));
    }
}

// log the search for flood check
if ($searchquery)
{
  $db->query_write("INSERT INTO " . TABLE_PREFIX . "sc_gallery_search (userid, ipaddress, last_search)
        VALUES(" . $vbulletin->userinfo['userid'] . ", '" . $db->escape_string(IPADDRESS) . "', " . TIMENOW . ")
        ");      
} 

////////////////////////
  $perpage = 25;
  $pagenumber = $vbulletin->GPC['pagenumber'];
 
 $attach_gallery = true;
 $browsepics = true;   
 $imagetypes = array('jpg', 'jpeg', 'gif', 'png', 'bmp');
 $where = " AND attachment.extension "." IN('".implode("','", $imagetypes)."')";

   if($vbulletin->GPC['my'])
   {
    $userid = $vbulletin->userinfo['userid'];
   } 


// build forum cache by permissions
$show['cangetattachment'] = 1;
$forum_cache = array();
foreach ($vbulletin->forumcache AS $forumid => $foruminfo)
{
	$forumperms = $vbulletin->userinfo['forumpermissions']["$forumid"];
	$foruminfo['options'] = intval($foruminfo['options']);
  	foreach($vbulletin->bf_misc_forumoptions AS $optionname => $optionval)
  	{
  		$foruminfo["$optionname"] = (($foruminfo['options'] & $optionval) ? 1 : 0);
  	}
  	if (($forumperms & $vbulletin->bf_ugp_forumpermissions['canseethumbnails']))
  	{
  		$vbulletin->options['canseethumbnails'] = 1;
  	}
  	if (($forumperms & $vbulletin->bf_ugp_forumpermissions['cangetattachment']))
  	{
  		$vbulletin->options['viewattachedimages'] = (($vbulletin->options['viewattachedimages']) ? 1 : 0);
  	}
  	if (($forumperms & $vbulletin->bf_ugp_forumpermissions['canseethumbnails']) && ($forumperms & $vbulletin->bf_ugp_forumpermissions['cangetattachment']))
  	{
  		$forum_cache[] = $forumid;
  	}
}

// prepare option list array
	$forum_array = array();
	foreach ($forum_cache AS $t => $tforumid)
	{
		$forum_array["$tforumid"] = $vbulletin->forumcache["$tforumid"];
		$depth = count(explode(",", $forum_array["$tforumid"]['parentlist'])) - 2;
		$spacing = '';
		for ($i = 0; $i < $depth; $i++)
		{
			$spacing .= "&nbsp;&nbsp;";
		}
		$title = $spacing.$forum_array["$tforumid"]['title'];
    if ($vbulletin->GPC['fid'] == $tforumid) { $selected = "selected=\"selected\"";} else {$selected = '';}
    $forum_options .= "<option value=\"$tforumid\" $selected>$title</option>";
	}

  // no permission, otherwise will receive db error!
  if(empty($forum_cache))
  {
    print_no_permission();
  }

  // if get fid, change the where conds
  if(!$vbulletin->GPC['fid'])
  {
    $where_forumid = " AND thread.forumid IN (".implode(',',$forum_cache).")";
  }
  else 
  { 
    $fid = $vbulletin->GPC['fid'];
      if (in_array($fid, $forum_cache))
      {  
        $where_forumid = " AND thread.forumid IN ($fid)";
      }
      else
      {
        print_no_permission();
      } 
  }


// count results for pagenav
	$count = $db->query_first("
		SELECT
			COUNT(*) AS rows
		FROM " . TABLE_PREFIX . "attachment AS attachment
		LEFT JOIN " . TABLE_PREFIX . "post AS post
			ON (attachment.postid = post.postid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (attachment.userid = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "thread AS thread
			ON (post.threadid = thread.threadid)
		WHERE attachment.extension IS NOT NULL
			$where
			$where_forumid
			".($userid ? " AND attachment.userid = '$userid' " : "")."
	");

// construct pagenav	
    sanitize_pageresults($count['rows'], $pagenumber, $perpage, 10000);

// Variables for showing_albums_x_to_y_of_z
          if ($pagenumber == 1) {
           $limitlower = 1; }
          else {
          $limitlower = ($pagenumber - 1) * $perpage; }
        	$limitupper = ($pagenumber) * $perpage;
      
          	if ($limitupper > $count['rows'])
          	{
          		$limitupper = $count['rows'];
          		if ($limitlower > $count['rows'])
          		{
          			$limitlower = ($count['rows'] - $perpage) - 1;
          		}
          	}
          	if ($limitlower < 0)
          	{
          		$limitlower = 0;
          	}
    
    $count['pictures'] = $count['rows'];        	      
    if (!$searchquery){
    $pagenav_pics = construct_page_nav($pagenumber, $perpage, $count['rows'],
    'gallery.php?do=attachments' . $vbulletin->session->vars['sessionurl'] . ($fid ? "&amp;fid=$fid" : '') . ($perpage ? "&amp;pp=$perpage" : '') . ($vbulletin->GPC['my'] ? "&amp;my=true" : '')
    );
    }
    
      
// main attachments query
	$attachments = $db->query_read("
		SELECT
			attachment.*, 
      IF(attachment.thumbnail_filesize > 0, 1, 0) AS hasthumbnail,
      post.postid, 
      thread.threadid,
      user.username, 
      post.threadid, 
      thread.title AS threadtitle 
		FROM " . TABLE_PREFIX . "attachment AS attachment
		LEFT JOIN " . TABLE_PREFIX . "post AS post
			ON (attachment.postid = post.postid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (attachment.userid = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "thread AS thread
			ON (post.threadid = thread.threadid)
		WHERE attachment.extension IS NOT NULL
			$where
			$where_forumid
			$search_to_attachments
			".($userid ? " AND attachment.userid = '$userid' " : "")."
		ORDER BY attachment.dateline DESC
		LIMIT " . (($pagenumber - 1) * $perpage) . ", $perpage
	"); 

    $picturebit_height = $vbulletin->options['album_thumbsize'] + (($usercss ? 0 : $stylevar['cellspacing']) + $stylevar['cellpadding']) * 16 + 4;
    $picturebit_width = $vbulletin->options['album_thumbsize'] + (($usercss ? 0 : $stylevar['cellspacing']) + $stylevar['cellpadding']) * 4;
    
    $picturebits = '';
    while($attachment = $db->fetch_array($attachments))
  	{
      $attachment['picturedate'] = vbdate($vbulletin->options['dateformat'], $attachment['dateline'], true);
      $attachment['coverdimensions'] = ($attachment['thumbnail_width'] ? "width=\"$attachment[thumbnail_width]\" height=\"$attachment[thumbnail_height]\"" : '');
      if (strlen($attachment['filename']) > 15) {$bulls = '...';}
      $attachment['filename'] = substr($attachment['filename'], 0, 15) . $bulls;
      eval('$picturebits .= "' . fetch_template('gallerysearch_attachmentbit') . '";');
      unset($bulls);
  	}

// navbits/navbar output
	$navbits = array(
		'gallery.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['gallery_navbit_headline'], $vbulletin->options['sc_gallery_attachments_cattitle']
	);
  $navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
  
  $gallery['title'] = $vbulletin->options['sc_gallery_attachments_cattitle'];
	
/// Extract attachments gallery category
  eval('print_output("' . fetch_template('GALLERYDISPLAY') . '");');

}
?>



