<?php  
/*======================================================================*\
|| #################################################################### ||
|| # vBGallery by Scandal v1.0 for vBulletin 3.x                      # ||
|| # file: gallerydisplay.php v1.0                                    # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Scandal @ vBulletin.org                          # ||
|| #                                                                  # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'sc_gallery');
define('CSRF_PROTECTION', true);  

// #################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array(); 

// pre-cache templates used by all actions
$globaltemplates = array(
	'GALLERYDISPLAY',
	'gallerydisplay_category_level1',
	'gallerydisplay_category_level2',
	'gallerydisplay_category_level3',
	'gallerydisplay_category_level4',
	'gallerydisplay_albumbit_grid',
	'gallerysearch_picturebit',
	'galleryhome_loggedinuser',
	'galleryhome_activeusers',
  'gallery_navbar',
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_sc_gallery.php');
require_once('./includes/functions_album.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################
cache_permissions($userinfo, false);
if (!($canviewalbums = $permissions['albumpermissions'] & $vbulletin->bf_ugp_albumpermissions['canviewalbum']))
{
	print_no_permission();
}

// Check ON/OFF field
if (!$vbulletin->options['sc_gallery_onoff'])
{ 
  $message = $vbulletin->options['sc_gallery_close_message'];
      if ($message)
      {
       standard_error($message);
      }
      else
      {
       $message = 'Gallery is closed. Please try again later.';
       standard_error($message);
      }      
}

// ############################# INPUT #####################################
$vbulletin->input->clean_array_gpc('g', array(
		'c'	=> TYPE_INT,
		'view'	=> TYPE_STR,
		'my'	=> TYPE_BOOL
	));
	
$catid = $vbulletin->GPC['c'];

// Error if no category selected
if (!$catid)
{
  eval(standard_error(fetch_error('invalidid', $vbphrase['sc_gallery'], $vbulletin->options['contactuslink'])));
}

// ############################# SEARCH #####################################
$vbulletin->input->clean_array_gpc('r', array(
	'page' => TYPE_UINT,
	'term' => TYPE_STR
));

$searchquery = $vbulletin->GPC['term'];

// Flood check
if($searchquery)
{ 
			if ($vbulletin->options['searchfloodtime'] > 0)
			{
				// check for possible Denial of service attack
				$temptime = $db->query_first("
					SELECT last_search
					FROM " . TABLE_PREFIX . "sc_gallery_search 
					WHERE `userid` = " . $vbulletin->userinfo['userid'] . "
						OR `ipaddress` = '" . $db->escape_string(IPADDRESS) . "'
					ORDER BY `last_search` DESC LIMIT 0, 1
				");

				$timedelay = $vbulletin->options['searchfloodtime'];
        $flood_limit = $vbulletin->options['searchfloodtime'];
        
				if (TIMENOW - $temptime['last_search'] < $timedelay)
				{
					$timedelay = round($temptime['last_search'] + $timedelay - TIMENOW);

					eval(standard_error(fetch_error('sc_gallery_search_flood', $flood_limit, $timedelay)));
				}

				$db->free_result($temptime);
			}
}
// Minimum characters limit error
if($searchquery)
{ 
  $charlimit = $vbulletin->options['minsearchlength'];
  $charnum = strlen($searchquery);
    if ($charnum < $charlimit)
    {
      eval(standard_error(fetch_error('searchinvalidterm', $searchquery, $vbulletin->options['minsearchlength'])));
    }
}

// log the search for flood check
if ($searchquery)
{
  $db->query_write("INSERT INTO " . TABLE_PREFIX . "sc_gallery_search (userid, ipaddress, last_search)
        VALUES(" . $vbulletin->userinfo['userid'] . ", '" . $db->escape_string(IPADDRESS) . "', " . TIMENOW . ")
        ");      
} 

// by default GALLERYDISPLAY, displays albums not pictures
$browsepics = false;

// Set album state array for search results
$userinfo = cache_permissions($vbulletin->userinfo, false);
	
  $state=array('public');  
	if ($userinfo)
	{ // if is Super Moderator, Admin or Moderator, search returns and private-profile Albums/Pictures/Comments in them
		if ($userinfo['usergroupid']==5 OR $userinfo['usergroupid']==6 OR $userinfo['usergroupid']==7)
		{
			$state[]='private';
			$state[]='profile';
		}
	}
    	
	if ($searchquery)
	{
		$search_to_albums = "AND (album.title LIKE '%" . $db->escape_string($searchquery) . "%' 
						OR album.description LIKE '%" . $db->escape_string($searchquery) . "%'
						OR user.username LIKE '%"  . $db->escape_string($searchquery) . "%')";
		$search_to_pictures = "AND (picture.caption LIKE '%" . $db->escape_string($searchquery) . "%' 
    						OR album.description LIKE '%" . $db->escape_string($searchquery) . "%'
    		 				OR user.username LIKE '%"  . $db->escape_string($searchquery) . "%')";				
		$searchquery = htmlspecialchars($searchquery);
	}
	
// ############################# PAGENAV CONSTRUCT #################################
  $vbulletin->input->clean_array_gpc('r', array(
    'perpage'    => TYPE_UINT,
    'pagenumber' => TYPE_UINT,    
  ));
  
  $pagenumber = $vbulletin->GPC['pagenumber'];    
  
    
  if($vbulletin->GPC['view'] == 'pictures')
  { 
    if($vbulletin->GPC['my'])
    {
      $my_pics = "AND album.userid = " . $vbulletin->userinfo['userid'] . "";
    }
    $perpage = $vbulletin->options['sc_gallery_display_perpage_pics'];

    // Count Pictures
      	$num_pictures = $db->query_read("
      		SELECT picture.pictureid
      		FROM " . TABLE_PREFIX . "picture AS picture
      		LEFT JOIN " . TABLE_PREFIX . "albumpicture AS albumpicture ON (albumpicture.pictureid = picture.pictureid)
          LEFT JOIN " . TABLE_PREFIX . "album AS album ON (album.albumid = albumpicture.albumid)
          LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = picture.userid)
      		WHERE
      			(album.userid ='" . $vbulletin->userinfo['userid'] . "'
      			OR (album.state IN ('" . implode("', '", $state) . "')))
      			AND album.catid = $catid
      			$my_pics
      			$search_to_pictures
      		ORDER BY albumpicture.dateline DESC
      	"); 
    
    $count['pictures'] = $db->num_rows($num_pictures);

    sanitize_pageresults($count['pictures'], $pagenumber, $perpage, 100);
      // Variables for showing_pictures_x_to_y_of_z
          if ($pagenumber == 1) {
           $limitlower = 1; }
          else {
          $limitlower = ($pagenumber - 1) * $perpage; }
        	$limitupper = ($pagenumber) * $perpage;
      
          	if ($limitupper > $count['pictures'])
          	{
          		$limitupper = $count['pictures'];
          		if ($limitlower > $count['pictures'])
          		{
          			$limitlower = ($count['pictures'] - $perpage) - 1;
          		}
          	}
          	if ($limitlower < 0)
          	{
          		$limitlower = 0;
          	}	      
  }
  else
  { 
    if($vbulletin->GPC['my'])
     {
        $my_albums = "AND album.userid = " . $vbulletin->userinfo['userid'] . "";
     }
  $perpage = $vbulletin->options['sc_gallery_display_perpage_albums'];  
	$count = $db->query_first("
		SELECT COUNT(*) AS albums
		FROM " . TABLE_PREFIX . "album as album
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (album.userid = user.userid)
		WHERE (album.userid ='" . $vbulletin->userinfo['userid'] . "'
			OR (state IN ('" . implode("', '", $state) . "')))
			AND album.visible > 0
			AND album.catid = $catid
      $my_albums 
			$search_to_albums
	");
	  sanitize_pageresults($count['albums'], $pagenumber, $perpage, 50);
      // Variables for showing_albums_x_to_y_of_z
          if ($pagenumber == 1) {
           $limitlower = 1; }
          else {
          $limitlower = ($pagenumber - 1) * $perpage; }
        	$limitupper = ($pagenumber) * $perpage;
      
          	if ($limitupper > $count['albums'])
          	{
          		$limitupper = $count['albums'];
          		if ($limitlower > $count['albums'])
          		{
          			$limitlower = ($count['albums'] - $perpage) - 1;
          		}
          	}
          	if ($limitlower < 0)
          	{
          		$limitlower = 0;
          	}	  
	}

    	
// ######################### GALLERYDISPLAY ##############################
// #######################################################################

// ALBUMS PAGENAV EXTRACT
$pagenav_albums = construct_page_nav($pagenumber, $perpage, $count['albums'],
  'gallerydisplay.php?' . $vbulletin->session->vars['sessionurl'] . "c=$catid" . "&view=albums" .($perpage ? "&amp;pp=$perpage" : '')
  );

// PICTURES PAGENAV EXTRACT  
$pagenav_pics = construct_page_nav($pagenumber, $perpage, $count['pictures'],
  'gallerydisplay.php?' . $vbulletin->session->vars['sessionurl'] . "c=$catid" . "&view=pictures" .($perpage ? "&amp;pp=$perpage" : '')
  );
   
// It returns the array $gallery with all info 
fetch_category_info($catid);

// ######################### CONSTRUCT SUBCATEGORIES #####################

// ============================ 
  cache_gallery_cats();
  $depth = $vbulletin->options['sc_gallery_display_depth'];
  $chkk = 0;
    foreach ($cat_cache AS $row)
    { 
      
			// is this category a header category?
      if ($row['parentid'] == $catid)
      { 
          $categories_level2 = '';
          $show['subcat'] = false;
        	foreach ($cat_cache AS $subrow) 
          {      
            if ($subrow['parentid'] == $row['catid'])
            {   
                  $categories_level3 = '';
                  $show['subcat'] = false;
                  $subcatchk = 0;
                  foreach ($cat_cache AS $sub2row)
                  {
                      if ($sub2row['parentid'] == $subrow['catid'])
                      {   
                        $categories_level4 = '';  
                        foreach ($cat_cache AS $sub3row)
                        {
                          if ($sub3row['parentid'] == $sub2row['catid'])
                          {
                            if($vbulletin->options['sc_gallery_display_emptycat'] OR !$sub3row['albums_num'] == 0)
                            {
                              $row['albums_num_sum_l1'] += $sub3row['albums_num'];
                              $subrow['albums_num_sum_l2'] += $sub3row['albums_num'];
                              construct_gallery_category_url($sub3row);
                              count_num_ofpictures($sub3row);
                              $row['pics_num_sum_l1'] += $sub3row['pics_num'];
                              $subrow['pics_num_sum_l2'] += $sub3row['pics_num'];
                              
                              if($depth >= 4)
                              {
                                eval('$categories_level4 .= "' . fetch_template('gallerydisplay_category_level4') . '";');

                              }                           
                            }
                          }
                                               
                        
                        } 
                       
                       if($vbulletin->options['sc_gallery_display_emptycat'] OR !$sub2row['albums_num'] == 0)
                       { 
                          $row['albums_num_sum_l1'] += $sub2row['albums_num'];
                          $subrow['albums_num_sum_l2'] += $sub2row['albums_num'];       
                          construct_gallery_category_url($sub2row);
                          count_num_ofpictures($sub2row);
                          $row['pics_num_sum_l1'] += $sub2row['pics_num'];
                          $subrow['pics_num_sum_l2'] += $sub2row['pics_num'];
                          
                          if($depth >= 3)
                          { 
                            eval('$categories_level3 .= "' . fetch_template('gallerydisplay_category_level3') . '";');
              							$show['subcat'] = true;
              							$subcatchk++; 
              						}	
                        }       
                      }
                                        
                  }
                  
                  $row['albums_num_sum_l1'] += $subrow['albums_num'];
                  $subrow['albums_num_sum_l2'] += $subrow['albums_num'];
               
               if($vbulletin->options['sc_gallery_display_emptycat'] OR !$subrow['albums_num'] == 0 OR !$subrow['albums_num_sum_l2'] == 0)
                {  
                  construct_gallery_category_url($subrow);
                  count_num_ofpictures($subrow);
                  $row['pics_num_sum_l1'] += $subrow['pics_num'];
                  $subrow['pics_num_sum_l2'] += $subrow['pics_num'];
                  fetch_cat_last_pic($subrow);
                 
                 if($depth >= 2)
                 { 
                  eval('$categories_level2 .= "' . fetch_template('gallerydisplay_category_level2') . '";');
    						 }	
                }
            } 
           
           
          }
        
        
         
      if($vbulletin->options['sc_gallery_display_emptycat'] OR !$row['albums_num'] == 0 OR !$row['albums_num_sum_l1'] == 0)
       {
        $row['albums_num_sum_l1'] += $row['albums_num'];   
        construct_gallery_category_url($row);
        count_num_ofpictures($row);
        $row['pics_num_sum_l1'] += $row['pics_num']; 
        fetch_cat_last_pic($row);
        $show['catpreview'] = $vbulletin->options['sc_gallery_desc'];
        
        if($depth >= 1)
        {
        // complete category with subcategories
        eval('$galleries .= "' . fetch_template('gallerydisplay_category_level1') . '";');
          $chkk++;
					$show['galleries'] = true;
			   }
         	
        }       
          
      }
  }
  
// ################# MAIN QUERY - CONSTRUCT ALBUMBITS ######################
// if true albumbits will disappear for viewing of picturebits
   
	$albums = $db->query_read("
    		SELECT album.*,
    			picture.pictureid, 
          picture.userid, 
          picture.caption, 
          picture.extension, 
          picture.filesize, 
          picture.idhash, 
          picture.state,
    			picture.thumbnail_filesize, 
          picture.thumbnail_dateline, 
          picture.thumbnail_width, 
          picture.thumbnail_height,
    			user.username AS username
		FROM " . TABLE_PREFIX . "album AS album
			LEFT JOIN " . TABLE_PREFIX . "picture AS picture ON (album.coverpictureid = picture.pictureid)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (picture.userid = user.userid)
		WHERE
			(album.userid ='" . $vbulletin->userinfo['userid'] . "'
			OR (album.state IN ('" . implode("', '", $state) . "')))
			AND album.visible > 0
			AND album.catid = $catid 
			$search_to_albums
			$my_albums
		ORDER BY album.lastpicturedate DESC
		LIMIT " . (($pagenumber - 1) * $perpage) . ", $perpage
	");

	$albumbits = '';
	$pending = false;
	$width = $vbulletin->options['sc_gallery_display_width'];
	while ($album = $db->fetch_array($albums))
	{ 
    $album = prepare_pictureinfo_thumb($album, $album);
	  if ($vbulletin->options['sc_gallery_show_comments'])
    { 
          count_num_ofcomments($album);
    }
		$album['picturecount'] = vb_number_format($album['visible']);
		$album['picturedate'] = vbdate($vbulletin->options['dateformat'], $album['lastpicturedate'], true);
		$album['picturetime'] = vbdate($vbulletin->options['timeformat'], $album['lastpicturedate']);
		$album['createdate'] = vbdate($vbulletin->options['dateformat'], $album['createdate'], true);

		$album['description_html'] = $album['description'];
		$album['title_html'] = $album['title'];
		$album['coverdimensions'] = ($album['thumbnail_width'] ? "width=\"$album[thumbnail_width]\" height=\"$album[thumbnail_height]\"" : '');

    eval('$albumbits .= "' . fetch_template('gallerydisplay_albumbit_grid') . '";');
	}
  $db->free_result($albums);

// ######## MAIN QUERY2 - CONSTRUCT PICTUREBITS (Browse Pictures) ############
if ($vbulletin->GPC['view'] == 'pictures')
{ 
$browsepics = true;

// Query for Pictures
  	$pictures = $db->query_read("
		SELECT 
			picture.pictureid, 
      picture.userid, 
      picture.caption, 
      picture.extension, 
      picture.filesize, 
      picture.idhash, 
      picture.state,
			picture.thumbnail_filesize, 
      picture.thumbnail_dateline, 
      picture.thumbnail_width, picture.thumbnail_height,
			album.albumid,
      album.title,
      album.lastpicturedate, 
      albumpicture.dateline,
			user.username,
      user.userid
  		FROM " . TABLE_PREFIX . "picture AS picture
			LEFT JOIN " . TABLE_PREFIX . "albumpicture AS albumpicture ON (albumpicture.pictureid = picture.pictureid)
			LEFT JOIN " . TABLE_PREFIX . "album AS album ON (album.albumid = albumpicture.albumid)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (picture.userid = user.userid)
  		WHERE
  			(album.userid ='" . $vbulletin->userinfo['userid'] . "'
  			OR (album.state IN ('" . implode("', '", $state) . "')))
  			AND album.catid = $catid
  			$search_to_pictures
  			$my_pics
  		ORDER BY albumpicture.dateline DESC
  		LIMIT " . (($pagenumber - 1) * $perpage) . ", $perpage
  	"); 

    	$picturebit_height = $vbulletin->options['album_thumbsize'] + (($usercss ? 0 : $stylevar['cellspacing']) + $stylevar['cellpadding']) * 16 + 4;
    	$picturebit_width = $vbulletin->options['album_thumbsize'] + (($usercss ? 0 : $stylevar['cellspacing']) + $stylevar['cellpadding']) * 4;
   
      	$picturebits = '';
      	while ($picture = $db->fetch_array($pictures))
      	{
          $picture = prepare_pictureinfo_thumb($picture, $picture);
      		$picture['picturedate'] = vbdate($vbulletin->options['dateformat'], $picture['dateline'], true);
      		$picture['coverdimensions'] = ($picture['thumbnail_width'] ? "width=\"$picture[thumbnail_width]\" height=\"$picture[thumbnail_height]\"" : '');
          if (strlen($picture['caption']) > 15) {$bulls = '...';}
          $picture['title_html'] = substr($picture['caption'], 0, 15) . $bulls;
          eval('$picturebits .= "' . fetch_template('gallerysearch_picturebit') . '";');
          unset($bulls);
      	}
      $db->free_result($pictures);

}
    
// ################# NAVBITS AND NAVBAR OUTPUT ###########################
	$navbits = array(
		'gallery.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['gallery_navbit_headline'], $gallery['title']
	);
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

// #################### EXTRACT GALLERYDISPLAY ###########################
  eval('print_output("' . fetch_template('GALLERYDISPLAY') . '");');
  
?>



