<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBGallery by Scandal v1.0 for vBulletin 3.8                      # ||
|| # file: functions_sc_gallery.php v1.0                              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Scandal @ vBulletin.org                          # ||
|| #                                                                  # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
// ######################## FUNCTIONS ####################################
function cache_gallery_cats($gallery_catid = -1, $depth = 0)
{
	// returns an array of gallery categories with correct parenting and depth information

	global $db, $cat_cache, $count, $vbulletin;
	static $g_cache, $i;

  $userinfo = cache_permissions($vbulletin->userinfo, false);    	
    $state=array('public');  
    if ($userinfo)
   	{ // if is Super Moderator, Admin or Moderator, search returns and private-profile Albums/Pictures/Comments in them
    	if ($userinfo['usergroupid']==5 OR $userinfo['usergroupid']==6 OR $userinfo['usergroupid']==7)
    	{
    		$state[]='private';
    	  $state[]='profile';
    	}
    }
	
	if (!is_array($g_cache))
	{
	// check to see if we have already got the results from the database
		$g_cache = array();
		$gallery_cats = $db->query_read("
			SELECT sc_gallery.*, COUNT(CASE WHEN album.visible >0 AND album.state IN ('" . implode("', '", $state) . "') THEN album.catid ELSE NULL END) AS albums_num
			FROM " . TABLE_PREFIX . "sc_gallery AS sc_gallery
			LEFT JOIN " . TABLE_PREFIX . "album AS album USING(catid)
			GROUP BY sc_gallery.catid
			ORDER BY sc_gallery.displayorder
		");	
		while ($gallery_cat = $db->fetch_array($gallery_cats))
		{
			$g_cache["$gallery_cat[parentid]"]["$gallery_cat[displayorder]"]["$gallery_cat[catid]"] = $gallery_cat;
		}
		$db->free_result($gallery_cats);
	}

	// database has already been queried
	if (is_array($g_cache["$gallery_catid"]))
	{
		foreach ($g_cache["$gallery_catid"] AS $holder)
		{
			foreach ($holder AS $gallery_cat)
			{
				$cat_cache["$gallery_cat[catid]"] = $gallery_cat;
				$cat_cache["$gallery_cat[catid]"]['depth'] = $depth;
				unset($g_cache["$gallery_catid"]);
				cache_gallery_cats($gallery_cat['catid'], $depth + 1);
			} 
		} 
	}
}

// Give the URL for every category
function construct_gallery_category_url(&$category, $append = '')
{
	global $vbulletin;
    if($vbulletin->options['sc_gallery_display_type'] == 1)
      {
        $append = '&view=pictures';
      }

		$url = 'gallerydisplay.php?' . $vbulletin->session->vars['sessionurl'] . 'c=' . $category['catid'] . $append;

	$category['url'] = $url;

	return $url;
}


// Count the pictures of every category
function count_num_ofpictures(&$category)
{
  global $db, $vbulletin; 
      $userinfo = cache_permissions($vbulletin->userinfo, false);
    	 
      $state=array('public');  
    	if ($userinfo)
    	{ // if is Super Moderator, Admin or Moderator, search returns and private-profile Albums/Pictures/Comments in them
    		if ($userinfo['usergroupid']==5 OR $userinfo['usergroupid']==6 OR $userinfo['usergroupid']==7)
    		{
    			$state[]='private';
    			$state[]='profile';
    		}
    	}
  
  		$query_pics = $db->query_read("
			SELECT picture.pictureid
			FROM " . TABLE_PREFIX . "picture AS picture
			LEFT JOIN " . TABLE_PREFIX . "albumpicture AS albumpicture ON (albumpicture.pictureid = picture.pictureid)
			LEFT JOIN " . TABLE_PREFIX . "album AS album ON (album.albumid = albumpicture.albumid)
			WHERE album.catid = ". $category['catid'] ." 
       AND album.visible > 0 
       AND album.state IN ('" . implode("', '", $state) . "')
		");	
  
  $category['pics_num'] = $db->num_rows($query_pics);
  $db->free_result($query_pics);
}


// return all info about a category
function fetch_category_info(&$categoryid)
{
	global $gallery, $db;

  		$query = $db->query_read("
			SELECT sc_gallery.*
			FROM " . TABLE_PREFIX . "sc_gallery AS sc_gallery
			WHERE catid = ". $categoryid ."
		");	
  $gallery = $db->fetch_array($query);
  $db->free_result($query);
  
	return $gallery;
}


// returns an array with stats
function fetch_gallery_stats()
{
 global $stats, $db;
  
  $fetch_stats = $db->query_read("
	   SELECT *
		 FROM " . TABLE_PREFIX . "sc_gallery_stats AS sc_gallery_stats
		 ");
      
  $stats = $db->fetch_array($fetch_stats);
  $stats['albums_num'] = vb_number_format($stats['albums_num']); 
  $stats['pics_num'] = vb_number_format($stats['pics_num']);
  $stats['disk_space'] = vb_number_format(($stats['disk_space']), 1, true);
  $stats['comments_num'] = vb_number_format($stats['comments_num']); 
 
 return $stats;
}


// returns $gallery_activeusers for GALLERYHOME
function fetch_galleryhome_activeusers()
{
  global $db, $vbulletin, $gallery_activeusers, $stylevar, $vbphrase, $vbcollapse;
      $vbulletin->session->set('invbgallery', 1);

      // Who's Online viewing X picture?
      require_once(DIR . '/includes/functions_bigthree.php');
      $datecut = TIMENOW - $vbulletin->options['cookietimeout'];
      $browsers = '';
      $ingallery = $db->query_read("
          SELECT user.username, user.usergroupid, user.membergroupids,
          session.userid, session.inthread, session.invbgallery, session.location, session.lastactivity,
              IF(user.displaygroupid = 0, user.usergroupid, user.displaygroupid) AS displaygroupid,
              IF(user.options & " . $vbulletin->bf_misc_useroptions['invisible'] . ", 1, 0) AS invisible
          FROM " . TABLE_PREFIX . "session AS session
          LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = session.userid)
          WHERE session.lastactivity > $datecut
          ORDER BY " . iif($permissions['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canseehidden'], 'invisible ASC, ') . "username ASC, lastactivity DESC
      ");
      
      $numberguest = 0;
      $numberregistered = 0;    
      $doneuser = array();
      $nocomma = false;

      if ($vbulletin->userinfo['userid'])
      {  
          $vbulletin->userinfo['joingroupid'] = iif($vbulletin->userinfo['displaygroupid'], $vbulletin->userinfo['displaygroupid'], $vbulletin->userinfo['usergroupid']);
          $loggedin = array(
              'userid' => $vbulletin->userinfo['userid'],
              'username' => $vbulletin->userinfo['username'],
              'invisible' => $vbulletin->userinfo['invisible'],
              'invisiblemark' => $vbulletin->userinfo['invisiblemark'],
              'inthread' => $threadinfo['threadid'],
              'lastactivity' => TIMENOW,
              'musername' => fetch_musername($vbulletin->userinfo, 'joingroupid')
          );
          $numberregistered = 1;
          $numbervisible = 1;
          fetch_online_status($loggedin);

          
          eval('$gallery_activeusers_names .= "' . fetch_template('galleryhome_loggedinuser') . '";');
          $doneuser["{$vbulletin->userinfo['userid']}"] = 1;
      }

      $key = $db->num_rows($ingallery);
      $check = 0;
      while ($loggedin = $db->fetch_array($ingallery))
      {  
          $check++;
          if (empty($doneuser["$loggedin[userid]"]))
          {
              if ($loggedin['userid'] == 0) // Guest
              {
                  if ($loggedin['invbgallery'] == 1)
                  {
                      $numberguest++;
                  }
              }
              else
              {
                  if ($loggedin['invbgallery'] == 1)
                  {
                      $loggedin['musername'] = fetch_musername($loggedin);
                      $numberregistered++;
                        if ($key == $check)
                        {
                          $nocomma = true;
                        }
                      if (fetch_online_status($loggedin))
                      {     
                        eval('$gallery_activeusers_names .= "' . fetch_template('galleryhome_loggedinuser') . '";');                
                      }
                  }
              }
              if ($loggedin['userid'])
              {
                  $doneuser["$loggedin[userid]"] = 1;
              }
          }
      }
      if (!$vbulletin->userinfo['userid'] AND !$numberguest)
      {
          $numberguest = 1;
      }
      $totalviewing = $numberregistered + $numberguest;
      
      $db->free_result($ingallery);
      eval('$gallery_activeusers .= "' . fetch_template('galleryhome_activeusers') . '";');
                    
  return $gallery_activeusers;      
}


// returns last picture information for galleryghome & gallerydisplay
function fetch_cat_last_pic(&$category)
{
  global $db, $vbulletin;
   $userinfo = cache_permissions($vbulletin->userinfo, false);
    	
      $state=array('public');  
    	if ($userinfo)
    	{ // if is Super Moderator, Admin or Moderator, search returns and private-profile Albums/Pictures/Comments in them
    		if ($userinfo['usergroupid']==5 OR $userinfo['usergroupid']==6 OR $userinfo['usergroupid']==7)
    		{
    			$state[]='private';
    			$state[]='profile';
    		}
    	}
         
  		$query_last_pic = $db->query_read("
	      SELECT picture.pictureid, albumpicture.dateline, picture.caption, picture.userid, user.username, album.albumid
		    FROM " . TABLE_PREFIX . "picture AS picture
		    LEFT JOIN " . TABLE_PREFIX . "albumpicture AS albumpicture ON (albumpicture.pictureid = picture.pictureid)
		    LEFT JOIN " . TABLE_PREFIX . "album AS album ON (album.albumid = albumpicture.albumid)
		    LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = picture.userid)
		    WHERE album.catid = ". $category['catid'] ." AND album.visible > 0 AND album.state IN ('" . implode("', '", $state) . "')
		    ORDER BY albumpicture.dateline ASC
		    "); 
  
  while ($album = $db->fetch_array($query_last_pic))	
  {	
  $category['lastpictitle'] = $album['caption'];
  $category['pictureid'] = $album['pictureid'];
  $category['albumid'] = $album['albumid'];
  $category['userid'] = $album['userid'];
  $category['username'] = $album['username'];
  $category['lastpicdate'] = vbdate($vbulletin->options['dateformat'], $album['dateline'], true);
  $category['lastpictime'] = vbdate($vbulletin->options['timeformat'], $album['dateline'], true); 	
  }
  
  $db->free_result($query_last_pic);
  return $category;
}


// Count the comments of every album
function count_num_ofcomments(&$array)
{
  global $db;

  	$comments = $db->query_read("
	    SELECT picturecomment.commentid
		  FROM " . TABLE_PREFIX . "picturecomment AS picturecomment
		  LEFT JOIN " . TABLE_PREFIX . "picture AS picture ON(picture.pictureid = picturecomment.pictureid)
      LEFT JOIN " . TABLE_PREFIX . "albumpicture AS albumpicture ON (albumpicture.pictureid = picture.pictureid)		 
		  LEFT JOIN " . TABLE_PREFIX . "album AS album ON(albumpicture.albumid = album.albumid)
		  WHERE album.albumid = ". $array['albumid'] ."
		  "); 
		$array['commentcount'] = $db->num_rows($comments);
    
    $db->free_result($comments);
    return $array;  
}

// Attachments stats
function attachments_stats()
{
  global $db, $attach_stats;
  
  $attach = $db->query_read("
    SELECT pics_num_attach
    FROM " . TABLE_PREFIX . "sc_gallery_stats AS sc_gallery_stats
    ");
  $attach_stats = $db->fetch_array($attach);
  $db->free_result($attach);
    	
  return $attach_stats;  
}

// returns ATTACHMENTS last picture information for galleryghome
function fetch_attach_cat_last_pic(&$category)
{
  global $db, $vbulletin;
    
    $forums = array();
      foreach ($vbulletin->forumcache AS $forumid => $foruminfo)
      {
       $forums[] = $forumid;
      } 
           
      $imagetypes = array('jpg', 'jpeg', 'gif', 'png', 'bmp');   
  		$query_last_att_pic = $db->query_read("
	      SELECT attachment.attachmentid, attachment.filename, attachment.dateline, attachment.userid, user.username
		    FROM " . TABLE_PREFIX . "attachment AS attachment
		    LEFT JOIN " . TABLE_PREFIX . "post AS post ON (attachment.postid = post.postid)
		    LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (post.threadid = thread.threadid)
		    LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = attachment.userid)
		    WHERE attachment.extension "." IN('".implode("','", $imagetypes)."')
		    AND thread.forumid IN (".implode(',',$forums).")
		    ORDER BY attachment.dateline ASC
		    "); 
  
  while ($att = $db->fetch_array($query_last_att_pic))	
  {	
  $category['lastpictitle'] = $att['filename'];
  $category['attachmentid'] = $att['attachmentid'];
  $category['pictureid'] = $att['attachmentid'];
  $category['userid'] = $att['userid'];
  $category['username'] = $att['username'];
  $category['lastpicdate'] = vbdate($vbulletin->options['dateformat'], $att['dateline'], true);
  $category['lastpictime'] = vbdate($vbulletin->options['timeformat'], $att['dateline'], true); 	
  }
  
  $db->free_result($query_last_att_pic);
  return $category;
}    
?>
