<?php

/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// Set page titles
$pagetitle = $navbits[] = $vbphrase['dbtech_thanks_entries'];

// draw cp nav bar
THANKS::construct_nav('list');

$lookup = array();
foreach (THANKS::$cache['button'] as $button)
{
	$lookup["$button[varname]"] = $button['title'];
}

// Begin the page template
$page_templater = vB_Template::create('dbtech_thanks_list');
	$page_templater->register('pagetitle', $pagetitle);

// Various optional limitations
$varname 			= $vbulletin->input->clean_gpc('r', 'varname', 			TYPE_STR);
$userid 			= $vbulletin->input->clean_gpc('r', 'userid', 			TYPE_UINT);
$receiveduserid 	= $vbulletin->input->clean_gpc('r', 'receiveduserid', 	TYPE_UINT);
$contenttype 		= $vbulletin->input->clean_gpc('r', 'contenttype', 		TYPE_STR);
$contentid 			= $vbulletin->input->clean_gpc('r', 'contentid', 		TYPE_UINT);

$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);

// Shorthands to faciliate easy copypaste
$pagenumber = ($pagenumber ? $pagenumber : 1);
$perpage = ($perpage ? $perpage : 25);

$hook_query_where = '';

if ($varname)
{
	$hook_query_where .= 'AND entry.varname = ' . $db->sql_prepare($varname);
}
if ($userid)
{
	$hook_query_where .= 'AND entry.userid = ' . $db->sql_prepare($userid);
}
if ($receiveduserid)
{
	$hook_query_where .= 'AND entry.receiveduserid = ' . $db->sql_prepare($receiveduserid);
}
if ($contenttype)
{
	$hook_query_where .= 'AND entry.contenttype = ' . $db->sql_prepare($contenttype);
}
if ($contentid)
{
	$hook_query_where .= 'AND entry.contentid = ' . $db->sql_prepare($contentid);
}
$sqlsort = 'entry.dateline';
$sortorder = 'DESC';

// Count number of users
$count = $db->query_first_slave("
	SELECT COUNT(*) AS total
	FROM " . TABLE_PREFIX . "dbtech_thanks_entry AS entry
	LEFT JOIN " . TABLE_PREFIX . "post AS post ON(post.postid = entry.contentid)
	LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON(thread.threadid = post.threadid)
	$hook_query_join
	WHERE thread.forumid IN(" . implode(',', THANKS::fetch_forumids()) . ")
	$hook_query_where
");

if (!$count['total'])
{
	// Invalid instance
	eval(standard_error(fetch_error('nothing_to_do')));
}	

// Ensure every result is as it should be
sanitize_pageresults($count['total'], $pagenumber, $perpage);

// Find out where to start
$startat = ($pagenumber - 1) * $perpage;

// Constructs the page navigation
$pagenav = construct_page_nav(
	$pagenumber,
	$perpage,
	$count['total'],
	'thanks.php?' . $vbulletin->session->vars['sessionurl'] . 'do=list',
	"&amp;perpage=$perpage" .
		($varname ? "&amp;varname=$varname" : '') .
		($userid ? "&amp;userid=$userid" : '') .
		($receiveduserid ? "&amp;userid=$receiveduserid" : '') .
		($contenttype ? "&amp;contenttype=$contenttype" : '') .
		($contentid ? "&amp;contentid=$contentid" : '')
);

	// Page navigation registration
	$page_templater->register('pagenav', $pagenav);

// Fetch users
$results_q = $db->query_read_slave("
	SELECT 
		post.postid,
		post.title AS posttitle,
		thread.title AS threadtitle,
		thread.title AS title,
		thread.threadid,
		entry.varname,			
		entry.dateline,			
		entry.userid,
		entry.receiveduserid,
		user.username,
		user.usergroupid,
		user.infractiongroupid,
		user.displaygroupid,
		receiveduser.username AS receivedusername,
		receiveduser.usergroupid AS receivedusergroupid,
		receiveduser.infractiongroupid AS receivedinfractiongroupid,
		receiveduser.displaygroupid	 AS receiveddisplaygroupid		
	FROM " . TABLE_PREFIX . "dbtech_thanks_entry AS entry
	LEFT JOIN " . TABLE_PREFIX . "user AS user USING(userid)
	LEFT JOIN " . TABLE_PREFIX . "user AS receiveduser ON(receiveduser.userid = entry.receiveduserid)
	LEFT JOIN " . TABLE_PREFIX . "post AS post ON(post.postid = entry.contentid)
	LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON(thread.threadid = post.threadid)
	$hook_query_join
	WHERE thread.forumid IN(" . implode(',', THANKS::fetch_forumids()) . ")
	$hook_query_where
	ORDER BY $sqlsort $sortorder, entry.userid
	LIMIT $startat, " . $perpage
);

$results = '';
while ($results_r = $db->fetch_array($results_q))
{
	// Ensure we have the proper day selected for the grouping
	$day = vbdate($vbulletin->options['dateformat'], $results_r['dateline']);
	
	$received = array(
		'userid' 				=> $results_r['receiveduserid'],
		'username' 				=> $results_r['receivedusername'],
		'usergroupid' 			=> $results_r['receivedusergroupid'],
		'infractiongroupid' 	=> $results_r['receivedinfractiongroupid'],
		'displaygroupid' 		=> $results_r['receiveddisplaygroupid'],
	);
	
	// Grab the markup username
	fetch_musername($results_r);
	fetch_musername($received);
	
	if (intval($vbulletin->versionnumber) == 4)
	{
		// vB4 have SEO URLs
		$link = fetch_seo_url('member', $results_r);
		$link3 = fetch_seo_url('member', $received);
		$link2 = fetch_seo_url('thread', $results_r, array('p' => $results_r['postid']));
	}
	else
	{
		// vB3 don't
		$link = "member.php?" . $vbulletin->session->vars['sessionurl'] . "u=$results_r[userid]";
		$link3 = "member.php?" . $vbulletin->session->vars['sessionurl'] . "u=$received[userid]";
		$link2 = "showthread.php?" . $vbulletin->session->vars['sessionurl'] . "p=$results_r[postid]#post$results_r[postid]";
	}
	
	// Determine what title to use
	$title = unhtmlspecialchars($results_r['posttitle'] ? $results_r['posttitle'] : $results_r['threadtitle']);
	//$title = (intval($vbulletin->versionnumber) == 3 ? unhtmlspecialchars($title) : $title);

	$templater = vB_Template::create('dbtech_thanks_list_bit');
		$templater->register('username', '<a href="' . $link . '" target="_blank">' . $results_r['musername'] . '</a>');
		$templater->register('receivedusername', '<a href="' . $link3 . '" target="_blank">' . $received['musername'] . '</a>');
		$templater->register('post', '<a href="' . $link2 . '#post' . $results_r['postid'] . '" target="_blank">' . $title . '</a>');
		$templater->register('time', vbdate($vbulletin->options['dateformat'], $results_r['dateline']) . ' ' . vbdate($vbulletin->options['timeformat'], $results_r['dateline']));
		$templater->register('entrytype', $lookup["$results_r[varname]"]);
	$results .= $templater->render();			
}
$db->free_result($results_q);
unset($results_r);
	
	$page_templater->register('results', $results);
$HTML = $page_templater->render();
	
/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: button.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/