<?php

/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!$_REQUEST['action'])
{
	die();
}

if (!class_exists('vB_AJAX_XML_Builder'))
{
	// Ensure we have this
	require_once(DIR . '/includes/class_xml.php');
}

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// #######################################################################
if ($_REQUEST['action'] == 'entry')
{
	// Grab these
	$contentid = $vbulletin->input->clean_gpc('p', 'postid', TYPE_UINT);
	$varname = $vbulletin->input->clean_gpc('p', 'varname', TYPE_STR);
	
	$buttoninfo = array();
	foreach (THANKS::$cache['button'] as $button)
	{
		if (!$button['active'])
		{
			// Inactive button
			continue;
		}
		
		if ($button['varname'] == $varname)
		{
			// Copy this
			$buttoninfo = $button;
			break;
		}
	}
	
	if (empty($buttoninfo))
	{
		// Invalid varname
		die($vbphrase['dbtech_thanks_invalid_button']);
	}

	if (!THANKS::check_permissions($vbulletin->userinfo, $buttoninfo['permissions'], 'canclick'))
	{
		// We can't click this button
		die($vbphrase['dbtech_thanks_no_permissions_click']);
	}
	
	// Grab the post info
	if (!$post = $db->query_first("
		SELECT 
			post.postid,
			post.userid,
			post.dbtech_thanks_disabledbuttons AS disabledbuttons_post,
			thread.forumid,
			thread.dbtech_thanks_disabledbuttons AS disabledbuttons_thread
		FROM " . TABLE_PREFIX . "post AS post
		LEFT JOIN " . TABLE_PREFIX . "thread AS thread USING(threadid)
		WHERE postid = " . $db->sql_prepare($contentid)
	))
	{
		// Invalid post id
		die($vbphrase['dbtech_thanks_invalid_postid']);
	}
	
	if ($post['userid'] == $vbulletin->userinfo['userid'])
	{
		// Can't click for own posts
		die($vbphrase['dbtech_thanks_cant_click_own_posts']);
	}
	
	$foruminfo = $vbulletin->forumcache["$post[forumid]"];
	if (!THANKS::$is_pro)
	{
		// Lite-only shit
		$parentlist = explode(',', $foruminfo['parentlist']);
		if ($parentlist[0] == -1)
		{
			// This forum
			$noticeforum = $foruminfo['forumid'];		
		}
		else
		{
			$key = (count($parentlist) - 2);
			$noticeforum = $parentlist["$key"];
		}
	}
	else
	{
		// This forum
		$noticeforum = $foruminfo['forumid'];
	}
	
	if ((int)$vbulletin->forumcache["$noticeforum"]['dbtech_thanks_disabledbuttons'] & (int)$buttoninfo['bitfield'])
	{
		// Button was disabled for this forum
		die($vbphrase['dbtech_thanks_button_disabled_forum']);
	}
	
	if ((int)$post['disabledbuttons_thread'] & (int)$buttoninfo['bitfield'])
	{
		// Button was disabled for this thread
		die($vbphrase['dbtech_thanks_button_disabled_thread']);
	}
	
	if ((int)$post['disabledbuttons_post'] & (int)$buttoninfo['bitfield'])
	{
		// Button was disabled for this post
		die($vbphrase['dbtech_thanks_button_disabled_post']);
	}
	
	// Ensure this is an array
	THANKS::$entrycache = array();
	
	// Fetch rewards
	$results_q = $db->query_read_slave("
		SELECT
			entry.contentid,
			entry.varname,
			entry.dateline,
			user.userid,
			user.username,
			user.usergroupid,
			user.infractiongroupid,
			user.displaygroupid
		FROM " . TABLE_PREFIX . "dbtech_thanks_entry AS entry
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = entry.userid)
		WHERE contentid = " . $db->sql_prepare($contentid) . "
			AND entry.contenttype = 'post'
		ORDER BY entry.contentid ASC, entry.dateline DESC
	");
	while ($results_r = $db->fetch_array($results_q))
	{
		THANKS::$entrycache["$results_r[contentid]"]["$results_r[varname]"]['data']["{$results_r[userid]}"] = $results_r;
	}
	$db->free_result($results_q);
	unset($results_r);
	
	$excluded = array();
	foreach (THANKS::$cache['button'] as $button)
	{
		if (THANKS::$entrycache["$post[postid]"]["$button[varname]"]['data']["{$vbulletin->userinfo[userid]}"] AND $button['exclusivity'])
		{
			foreach (THANKS::$cache['button'] as $excludebutton)
			{
				if ((int)$button['exclusivity'] & (int)$excludebutton['bitfield'])
				{
					// This button is exclusive
					$excluded[] = $excludebutton['varname'];
				}
			}
		}
	}
	
	// We now have everything we need to build the entry info
	$entryinfo = array(
		'varname' 			=> $varname,
		'userid' 			=> $vbulletin->userinfo['userid'],
		'contenttype' 		=> 'post',
		'contentid' 		=> $contentid,
		'receiveduserid' 	=> $post['userid']
	);
	
	if (!in_array($entryinfo['varname'], $excluded))
	{
		// We clicked another button that prevented this button click
		if ($buttoninfo['reputation'])
		{
			$userinfo = fetch_userinfo($post['userid']);
		}
		
		if ($existing = $db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "dbtech_thanks_entry
			WHERE varname = " . $db->sql_prepare($varname) . "
				AND userid = " . $db->sql_prepare($vbulletin->userinfo['userid']) . "
				AND contenttype = " . $db->sql_prepare('post') . "
				AND contentid = " . $db->sql_prepare($contentid) . "
		"))
		{
			if (!THANKS::check_permissions($vbulletin->userinfo, $buttoninfo['permissions'], 'canunclick') OR !THANKS::$is_pro)
			{
				// We can't un-click this button
				die($vbphrase['dbtech_thanks_no_permissions_unclick']);
			}	
	
			// init data manager
			$dm =& THANKS::datamanager_init('Entry', $vbulletin, ERRTYPE_CP);
				$dm->set_existing($existing);
			$dm->delete();
			
			if ($buttoninfo['reputation'])
			{
				// Subtract reputation
				$userinfo['reputation'] -= $buttoninfo['reputation'];
			}
		}
		else
		{
			// init data manager
			$dm =& THANKS::datamanager_init('Entry', $vbulletin, ERRTYPE_CP);
			
			// button fields
			foreach ($entryinfo AS $key => $val)
			{
				// These values are always fresh
				$dm->set($key, $val);
			}
			
			// Save! Hopefully.
			$entryid = $dm->save();
			
			if (!$entryid)
			{
				// Unknown error
				die($vbphrase['dbtech_thanks_unknown_click_error']);
			}
			
			if ($buttoninfo['reputation'])
			{
				// Add reputation
				$userinfo['reputation'] += $buttoninfo['reputation'];
			}
			
			($hook = vBulletinHook::fetch_hook('dbtech_thanks_postsave')) ? eval($hook) : false;
		}
		
		if ($buttoninfo['reputation'])
		{
			// Determine this user's reputationlevelid.
			$reputationlevel = $db->query_first_slave("
				SELECT reputationlevelid
				FROM " . TABLE_PREFIX . "reputationlevel
				WHERE $userinfo[reputation] >= minimumreputation
				ORDER BY minimumreputation
				DESC LIMIT 1
			");
		
			// init user data manager
			$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_STANDARD);
				$userdata->set_existing($userinfo);
				$userdata->set('reputation', $userinfo['reputation']);
				$userdata->set('reputationlevelid', intval($reputationlevel['reputationlevelid']));
			$userdata->save();
		}
	}
	
	// Ensure this is an array
	THANKS::$entrycache = array();
	
	// Fetch rewards
	$results_q = $db->query_read_slave("
		SELECT
			entry.contentid,
			entry.varname,
			entry.dateline,
			user.userid,
			user.username,
			user.usergroupid,
			user.infractiongroupid,
			user.displaygroupid
		FROM " . TABLE_PREFIX . "dbtech_thanks_entry AS entry
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = entry.userid)
		WHERE contentid = " . $db->sql_prepare($contentid) . "
			AND entry.contenttype = 'post'
		ORDER BY entry.contentid ASC, entry.dateline DESC
	");
	while ($results_r = $db->fetch_array($results_q))
	{
		THANKS::$entrycache["$results_r[contentid]"]["$results_r[varname]"]['data'][] = $results_r;
	}
	$db->free_result($results_q);
	unset($results_r);	
	
	// Prepare entry cache
	THANKS::prepare_entry_cache();
		
	$excluded = array();
	foreach (THANKS::$cache['button'] as $button)
	{
		if (THANKS::$entrycache["$post[postid]"]["$button[varname]"]['data_full']["{$vbulletin->userinfo[userid]}"] AND $button['exclusivity'])
		{
			foreach (THANKS::$cache['button'] as $excludebutton)
			{
				if ((int)$button['exclusivity'] & (int)$excludebutton['bitfield'])
				{
					// This button is exclusive
					$excluded[] = $excludebutton['varname'];
				}
			}
		}
	}
	
	$entries = '';
	$actions = '';
	foreach (THANKS::$cache['button'] as $button)
	{
		if (!$button['active'])
		{
			// Inactive button
			continue;
		}
		
		if (!empty(THANKS::$entrycache["$post[postid]"]["$button[varname]"]['data']))
		{
			$templater = vB_Template::create('dbtech_thanks_postbit_entries_entrybit');
				$templater->register('post', $post);		
				$templater->register('button', $button);
				$templater->register('users', implode(', ', (array)THANKS::$entrycache["$post[postid]"]["$button[varname]"]['data']));
				$templater->register('otherusers', implode(', ', (array)THANKS::$entrycache["$post[postid]"]["$button[varname]"]['totals']));
			$entries .= $templater->render();
		}
		
		/*
			Note for Deceptor or Darkwaltz4 if they find their way in here:
			I made these if checks separate because it makes debugging easier should one of these checks fail.
			Before, I had to var_dump() different parts of the ridiculously huge if check to find out which failed.
			
			Get off my internets. I don't care about sexy code, I care about easily debuggable code.
			K
			THX
			BAI
			
			- Belazor
		*/
		if ((int)$vbulletin->forumcache["$noticeforum"]['dbtech_thanks_disabledbuttons'] & (int)$button['bitfield'])
		{
			// Button was disabled for this forum
			continue;
		}
		
		if ((int)$post['disabledbuttons_thread'] & (int)$button['bitfield'])
		{
			// Button was disabled for this thread
			continue;
		}
		
		if ((int)$post['disabledbuttons_post'] & (int)$button['bitfield'])
		{
			// Button was disabled for this post
			continue;
		}
		
		if (!THANKS::check_permissions($vbulletin->userinfo, $button['permissions'], 'canclick'))
		{
			// We can't click this button
			continue;
		}
		
		if (THANKS::$entrycache["$post[postid]"]["$button[varname]"]['data']["{$vbulletin->userinfo[userid]}"] AND (!THANKS::check_permissions($vbulletin->userinfo, $button['permissions'], 'canunclick') OR !THANKS::$is_pro))
		{
			// We can't un-click this button
			continue;
		}
		
		if (in_array($button['varname'], $excluded))
		{
			// We clicked another button that prevented this button click
			continue;
		}
		
		$templater = vB_Template::create('dbtech_thanks_postbit_entries_actionbit');
			$templater->register('post', 	$post);		
			$templater->register('button', 	$button);
			$templater->register('phrase', 	(!THANKS::$entrycache["$post[postid]"]["$button[varname]"]['data']["{$vbulletin->userinfo[userid]}"] ? $button['actiontext'] : $button['undotext']));
		$actions .= $templater->render();
	}
	
	// Do the XML
	$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');	
		$xml->add_group('thanks');
			$xml->add_tag('entries', $entries);
			$xml->add_tag('actions', $actions);
		$xml->close_group();
	$xml->print_xml();	
}


/*=======================================================================*\
|| ##################################################################### ||
|| # SVN: $RCSfile: button.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>