<?php

/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'button' OR empty($_REQUEST['action']))
{
	print_cp_header($vbphrase['dbtech_thanks_button_management']);
	
	// Table header
	$headings = array();
	$headings[] = $vbphrase['title'];
	$headings[] = $vbphrase['varname'];
	$headings[] = $vbphrase['description'];
	$headings[] = $vbphrase['active'];
	$headings[] = preg_replace('/<dfn>.*<\/dfn>/isU', '', $vbphrase['dbtech_thanks_action_text']);
	$headings[] = preg_replace('/<dfn>.*<\/dfn>/isU', '', $vbphrase['dbtech_thanks_undo_text']);
	$headings[] = $vbphrase['reputation'];
	
	// Hook goes here
	
	$headings[] = $vbphrase['edit'];
	if (THANKS::$is_pro) $headings[] = $vbphrase['delete'];
	
	
	if (count(THANKS::$cache['button']))
	{
		print_form_header('thanks', 'button');
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_thanks_button_management'], count($headings));
		print_cells_row($headings, 0, 'thead');
		
		foreach (THANKS::$cache['button'] as $buttonid => $button)
		{
			// Table data
			$cell = array();
			$cell[] = $button['title'];
			$cell[] = $button['varname'];
			$cell[] = $button['description'];
			$cell[] = ($button['active'] ? $vbphrase['yes'] : '<span class="col-i"><strong>' . $vbphrase['no'] . '</strong></span>');
			$cell[] = $button['actiontext'];
			$cell[] = $button['undotext'];
			$cell[] = $button['reputation'];
			
			// Hook goes here
			
			$cell[] = construct_link_code($vbphrase['edit'], 'thanks.php?' . $vbulletin->session->vars['sessionurl'] . 'do=button&amp;action=modify&amp;buttonid=' . $buttonid);
			if (THANKS::$is_pro) $cell[] = construct_link_code($vbphrase['delete'], 'thanks.php?' . $vbulletin->session->vars['sessionurl'] . 'do=button&amp;action=delete&amp;buttonid=' . $buttonid);
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
		
		if (THANKS::$is_pro) print_submit_row($vbphrase['dbtech_thanks_add_new_button'], false, count($headings));
		else print_table_footer();	
	}
	else
	{
		if (!THANKS::$is_pro) print_stop_message('dbtech_thanks_invalid_x', $vbphrase['dbtech_thanks_button'], 0);
		
		print_form_header('thanks', 'button');
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_thanks_button_management'], count($headings));
		print_description_row($vbphrase['dbtech_thanks_no_buttons'], false, count($headings));
		print_submit_row($vbphrase['dbtech_thanks_add_new_button'], false, count($headings));	
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$buttonid = $vbulletin->input->clean_gpc('r', 'buttonid', TYPE_UINT);
	$button = ($buttonid ? THANKS::$cache['button']["$buttonid"] : false);
	
	if (!is_array($button))
	{
		// Non-existing button
		$buttonid = 0;
	}
	
	if ($buttonid)
	{
		// Edit
		print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_thanks_editing_x_y'], $vbphrase['dbtech_thanks_button'], $button['title'])));
		print_form_header('thanks', 'button');
		construct_hidden_code('action', 'update');
		construct_hidden_code('buttonid', $buttonid);
		print_table_header(construct_phrase($vbphrase['dbtech_thanks_editing_x_y'], $vbphrase['dbtech_thanks_button'], $button['title']));
	}
	else
	{
		if (!THANKS::$is_pro) print_stop_message('dbtech_thanks_invalid_x', $vbphrase['dbtech_thanks_button'], 0);
		
		// Add
		print_cp_header($vbphrase['dbtech_thanks_add_new_button']);
		print_form_header('thanks', 'button');
		construct_hidden_code('action', 'update');
		print_table_header($vbphrase['dbtech_thanks_add_new_button']);
		
		$button = array(
			'varname'		=> 'recommends',
			'title' 		=> 'Recommend',
			'description' 	=> '"Recommend" this post.',
			'active' 		=> 1,
			'actiontext' 	=> 'Recommend this post',
			'listtext' 		=> 'recommended this post',
			'undotext' 		=> 'Unrecommend',
			'reputation'	=> 1
		);
	}
	
	print_description_row($vbphrase['dbtech_thanks_main_settings'], false, 2, 'optiontitle');	
	if ($buttonid)
	{
		construct_hidden_code('button[varname]', 	$button['varname']);		
		print_label_row($vbphrase['varname'], 		$button['varname']);
	}
	else
	{
		print_input_row($vbphrase['varname'], 						'button[varname]', 		$button['varname']);
	}
	print_input_row($vbphrase['title'], 							'button[title]', 		$button['title']);	
	print_textarea_row($vbphrase['description'],					'button[description]',	$button['description']);
	print_yes_no_row($vbphrase['active'],							'button[active]',		$button['active']);
	print_description_row($vbphrase['dbtech_thanks_button_settings'], false, 2, 'optiontitle');
	print_textarea_row($vbphrase['dbtech_thanks_action_text'], 		'button[actiontext]', 	$button['actiontext']);
	print_textarea_row($vbphrase['dbtech_thanks_list_text'], 		'button[listtext]', 	$button['listtext']);
	if (THANKS::$is_pro) print_textarea_row($vbphrase['dbtech_thanks_undo_text'], 		'button[undotext]', 	$button['undotext']);
	print_input_row($vbphrase['reputation'], 						'button[reputation]', 	$button['reputation']);
	
	print_table_break();
	
	// Table header
	$headings = array();
	$headings[] = $vbphrase['usergroup'];
	$headings[] = $vbphrase['dbtech_thanks_can_click'];
	$headings[] = $vbphrase['dbtech_thanks_can_require_click'];
	if (THANKS::$is_pro)
	{
		$headings[] = $vbphrase['dbtech_thanks_can_disable_click'];
		$headings[] = $vbphrase['dbtech_thanks_can_unclick'];
	}
	
	$cells = array();
	$cells[] = 'canclick';
	$cells[] = 'canreqclick';
	if (THANKS::$is_pro)
	{
		$cells[] = 'candisableclick';
		$cells[] = 'canunclick';
	}
	
	print_table_header($vbphrase['dbtech_thanks_permissions'], count($headings));
	print_cells_row($headings, 0, 'thead');
	foreach ($vbulletin->usergroupcache as $usergroupid => $usergroup)
	{
		// Table data
		$cell = array();
		$cell[] = $usergroup['title'];
		foreach ($cells as $permtitle)
		{
			$cell[] = '<center>
				<input type="hidden" name="button[permissions][' . $usergroupid . '][' . $permtitle . ']" value="0" />
				<input type="checkbox" name="button[permissions][' . $usergroupid . '][' . $permtitle . ']" value="1"' . ($button['permissions']["$usergroupid"]["$permtitle"] ? ' checked="checked"' : '') . ($vbulletin->debug ? ' title="name=&quot;button[permissions][' . $usergroupid . '][' . $permtitle . ']&quot;"' : '') . '/>
			</center>';
		}
		
		// Print the data
		print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
	}
	print_table_break();
	
	// Table header
	$headings = array();
	$headings[] = $vbphrase['dbtech_thanks_button'];
	$headings[] = $vbphrase['dbtech_thanks_is_exclusive'];
	
	print_table_header($vbphrase['dbtech_thanks_button_exclusivity'], count($headings));
	print_description_row($vbphrase['dbtech_thanks_button_exclusivity_descr'], false, count($headings));
	print_cells_row($headings, 0, 'thead');
	foreach (THANKS::$cache['button'] as $button_id => $button_info)
	{
		if ($button_id == $buttonid)
		{
			// Can't set to own button, lol
			continue;
		}
		
		// Table data
		$cell = array();
		$cell[] = $button_info['title'];
		$cell[] = '<center>
			<input type="hidden" name="button[exclusivity][' . $button_id . ']" value="0" />
			<input type="checkbox" name="button[exclusivity][' . $button_id . ']" value="' . $button_info['bitfield'] . '"' . (((int)$button['exclusivity'] & (int)$button_info['bitfield']) ? ' checked="checked"' : '') . ($vbulletin->debug ? ' title="name=&quot;button[exclusivity][' . $button_id . ']&quot;"' : '') . '/>
		</center>';
		
		// Print the data
		print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
	}
	print_table_break();
	
	print_submit_row(($buttonid ? $vbphrase['save'] : $vbphrase['dbtech_thanks_add_new_button']), $vbphrase['reset'], count($headings));	
}

// #############################################################################
if ($_POST['action'] == 'update')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'buttonid' 	=> TYPE_UINT,
		'button' 	=> TYPE_ARRAY,
	));
	
	// init data manager
	$dm =& THANKS::datamanager_init('Button', $vbulletin, ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($vbulletin->GPC['buttonid'])
	{
		if (!$existing = THANKS::$cache['button']["{$vbulletin->GPC[buttonid]}"])
		{
			// Couldn't find the button
			print_stop_message('dbtech_thanks_invalid_x', $vbphrase['dbtech_thanks_button'], $vbulletin->GPC['buttonid']);
		}
		
		// Set existing
		$dm->set_existing($existing);
		
		// Added
		$phrase = $vbphrase['dbtech_thanks_edited'];
	}
	else
	{
		if (!THANKS::$is_pro) print_stop_message('dbtech_thanks_invalid_x', $vbphrase['dbtech_thanks_button'], 0);
		
		// Added
		$phrase = $vbphrase['dbtech_thanks_added'];
	}
	
	// button fields
	foreach ($vbulletin->GPC['button'] AS $key => $val)
	{
		if (!$vbulletin->GPC['buttonid'] OR $existing["$key"] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}
	
	// Save! Hopefully.
	$dm->save();
	
	define('CP_REDIRECT', 'thanks.php?do=button');
	print_stop_message('dbtech_thanks_x_y', $vbphrase['dbtech_thanks_button'], $phrase);	
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$vbulletin->input->clean_gpc('r', 'buttonid', TYPE_UINT);
	
	print_cp_header(construct_phrase($vbphrase['dbtech_thanks_delete_x'], $vbphrase['dbtech_thanks_button']));
	print_delete_confirmation('dbtech_thanks_button', $vbulletin->GPC['buttonid'], 'thanks', 'button', 'dbtech_thanks_button', array('action' => 'kill'), '', 'title');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'buttonid' 	=> TYPE_UINT,
		'kill' 		=> TYPE_BOOL
	));
	
	if (!$existing = THANKS::$cache['button']["{$vbulletin->GPC[buttonid]}"])
	{
		// Couldn't find the button
		print_stop_message('dbtech_thanks_invalid_x', $vbphrase['dbtech_thanks_button'], $vbulletin->GPC['buttonid']);
	}
	
	// init data manager
	$dm =& THANKS::datamanager_init('Button', $vbulletin, ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	define('CP_REDIRECT', 'thanks.php?do=button');
	print_stop_message('dbtech_thanks_x_y', $vbphrase['dbtech_thanks_button'], $vbphrase['dbtech_thanks_deleted']);	
}


print_cp_footer();

/*=======================================================================*\
|| ##################################################################### ||
|| # SVN: $RCSfile: button.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>