<?php

if ($vbulletin->GPC['dbtech_thanks_in_posting'])
{
	if (!class_exists('vB_Template'))
	{
		// Ensure we have this
		require_once(DIR . '/dbtech/thanks/includes/class_template.php');
	}
	
	foreach (THANKS::$cache['button'] as $button)
	{
		if (!$button['active'])
		{
			// Inactive button
			continue;
		}
		
		if ((int)$vbulletin->forumcache["$noticeforum"]['dbtech_thanks_disabledbuttons'] & (int)$button['bitfield'])
		{
			// Button was disabled for this forum
			continue;
		}
		
		if (THANKS::check_permissions($vbulletin->userinfo, $button['permissions'], 'candisableclick') AND THANKS::$is_pro)
		{
			// We can require click
			$templater = vB_Template::create('dbtech_thanks_post_form');
				$templater->register('name', 'disabledbuttons[' . $button['buttonid'] . ']');
				$templater->register('phrase', construct_phrase($vbphrase['dbtech_thanks_disable_x'], $button['title']));
				$templater->register('checked', (((int)$vbulletin->GPC['dbtech_thanks_postinfo']['dbtech_thanks_disabledbuttons'] & (int)$button['bitfield']) ? ' checked="checked"' : ''));
			$disablesmiliesoption .= $templater->render();			
		}
		
		if (THANKS::check_permissions($vbulletin->userinfo, $button['permissions'], 'canreqclick'))
		{
			foreach (array('content', 'attach') as $type)
			{
				// We can require click
				$templater = vB_Template::create('dbtech_thanks_post_form');
					$templater->register('name', 'requiredbuttons[' . $type . '][' . $button['buttonid'] . ']');
					$templater->register('phrase', construct_phrase($vbphrase['dbtech_thanks_require_x_to_see_y'], $button['title'], $vbphrase['dbtech_thanks_' . $type]));
					$templater->register('checked', (((int)$vbulletin->GPC['dbtech_thanks_postinfo']['dbtech_thanks_requiredbuttons_' . $type] & (int)$button['bitfield']) ? ' checked="checked"' : ''));
				$disablesmiliesoption .= $templater->render();
			}
		}
	}
}
//$vbulletin->GPC['dbtech_thanks_postinfo']