$.noConflict(true)(function($)
{
	// Define some variables
	var ftd = $(document),
		lastClick = 0;
	
	// Just to be sure
	thanksOptions.floodTime = parseInt(thanksOptions.floodTime);
	
	if (thanksOptions.vbversion > 3)
	{
		// Clicks of the "display post" (vB4 only)
		ftd.on('click', 'a[name=dbtech_thanks_downranked]', function()
		{
			// Shorthand
			var postid = $(this).attr('data-postid');
			
			// Display the post
			_displayPost(postid);
		});
	}
	
	// Clicks of the buttons
	ftd.on('click', 'a[name=dbtech_thanks_button]', function()
	{
		if (thanksOptions.floodTime > 0)
		{
			var d = new Date();
			var timenow = parseInt(d.getTime() / 1000);
			
			if ((timenow - lastClick) < thanksOptions.floodTime)
			{
				alert(vbphrase['dbtech_thanks_must_wait_x_seconds']
					.replace('%time%', thanksOptions.floodTime)
					.replace('%time2%', (timenow - lastClick))
				);
				return false;
			}
			
			lastClick = timenow;
		}
		
		// Shorthand
		var postid = $(this).attr('data-postid');
		
		if (typeof thanksOptions.thanksEntries[postid] == 'undefined')
		{
			thanksOptions.thanksEntries[postid] = {};
		}
		
		// Raeg.
		thanksOptions.thanksEntries[postid][$(this).attr('data-button')] = parseInt(thanksOptions.thanksEntries[postid][$(this).attr('data-button')]) - 1;
		
		// Re-colours the post
		_colourPost(postid);
		
		var extraParams = {
			'securitytoken' : SECURITYTOKEN,
			'do'			: 'ajax',
			'action'		: 'entry',
			'varname'		: $(this).attr('data-button'),
			'contenttype'	: thanksOptions.contenttype,
			'p'				: postid
		};
		var type = 'POST';
		
		var jqxhr = $.ajax({
			type: type,
			url: 'thanks.php',
			data: (SESSIONURL ? SESSIONURL + '&' : '') + $.param(extraParams)
		})
		.done(function(data)
		{
			var tagData = $(data), origData = data;
			data = {thanksEntries : {}, colorOptions : {}};

			var singleVals = ['entries', 'actions'];

			// Only attribute val we have
			if (tagData.find('colorOption').length)
			{
				tagData.find('colorOption').each(function()
				{
					var tagData2 = $(this);

					if (typeof data.colorOptions[tagData2.attr('varname')] == 'undefined')
					{
						// Ensure this is an object
						data.colorOptions[tagData2.attr('varname')] = {};
					}

					data.colorOptions[tagData2.attr('varname')][tagData2.attr('numclicks')] = {
						color : tagData2.text(),
						settings : tagData2.attr('settings')
					};
				});
			}

			if (tagData.find('thanksEntry').length)
			{
				tagData.find('thanksEntry').each(function()
				{
					data.thanksEntries[$(this).text()] = $(this).attr('numclicks');
				});
			}

			for (var i in singleVals)
			{
				data[singleVals[i]] = '';
				if (tagData.find(singleVals[i]).length)
				{
					// Store this
					data[singleVals[i]] = tagData.find(singleVals[i]).text();
				}
				else
				{
					// This should always exist, set error
					data['error'] = origData;
				}
			}

			if (data.error)
			{
				alert(data.error);
				
				// Log the error to the console
				console.error(timeStamp() + "AJAX Error: %s", data.error);
				
				return true;		
			}
			
			// Set entries
			$('#dbtech_thanks_entries_' + postid).html(data.entries);
			$('#dbtech_thanks_actions_' + postid).html(data.actions);
			
			if (typeof data.thanksEntries != 'undefined')
			{
				// Update options
				thanksOptions.thanksEntries[postid] = data.thanksEntries;
				
				switch (thanksOptions.contenttype)
				{
					case 'post':
						// Re-colours the post
						_colourPost(postid);
						
						// Displays the post
						_displayPost(postid);
						break;
						
					case 'blog':
						// Display the blog
						//$('#entry_text_' + thanksOptions.threadId).load('entry.php?b=' + thanksOptions.threadId + ' #entry_text_' + thanksOptions.threadId);
						break;
				}
			}
			if (data.colorOptions)
			{
				// Update options
				thanksOptions.colorOptions = data.colorOptions;
			}
		});
	});
	
	if (thanksOptions.contenttype == 'post')
	{
		for (var postId in thanksOptions.thanksEntries)
		{
			// Colour each post
			_colourPost(postId);
		}
	}
	
	// #########################################################################
	// Colours a post display
	function _colourPost(postid)
	{
		if (typeof thanksOptions.thanksEntries[postid] == 'undefined')
		{
			// We didn't have any entries for this
			return false;
		}
		
		for (var varName in thanksOptions.colorOptions)
		{
			if (typeof thanksOptions.thanksEntries[postid][varName] == 'undefined')
			{
				// We didn't have any entries for this
				continue;
			}
			
			// Raeg.
			thanksOptions.thanksEntries[postid][varName] = parseInt(thanksOptions.thanksEntries[postid][varName]);
			
			for (var threshold in thanksOptions.colorOptions[varName])
			{
				// Raeg
				threshold = parseInt(threshold);
				
				if (thanksOptions.vbversion == 3)
				{
					$('#post' + postid + ' tbody td').each(function(index, element)
					{
						if ($(this).is('.alt1, .alt2'))
						{
							$(this).addClass(function(index, currentClass)
							{
								var exploded = currentClass.split(' ');
								for (var i in exploded)
								{
									if (exploded[i].toString().match(/\bthanks_highlight_/))
									{
										// Remove the class
										$(this).removeClass(exploded[i]);
									}
								}
								
								return (thanksOptions.thanksEntries[postid][varName] >= threshold ? 'thanks_highlight_' + thanksOptions.colorOptions[varName][threshold]['color'] : '');
							});
						}
					});
				}
				else
				{
					var searchString = '#post_' + postid + ' .posthead,#post_' + postid + ' .postfoot .textcontrols,#post_' + postid + ' .postdetails,#post_' + postid + ' .postdetails .userinfo,#post_' + postid + ' .postdetails .userinfo_noavatar,#post_' + postid + ' .postbody';
					
					
					if (searchString == '')
					{
						// Not colouring anything
						return '';
					}
					
					$(searchString)
					.addClass(function(index, currentClass)
					{
						var exploded = currentClass.split(' ');
						for (var i in exploded)
						{
							if (exploded[i].toString().match(/\bthanks_highlight_/))
							{
								// Remove the class
								$(this).removeClass(exploded[i]);
							}
							
							if (exploded[i].toString().match(/\btextcontrols/) && thanksOptions.thanksEntries[postid][varName] >= threshold)
							{
								// Set new CSS
								$('.postbitlegacy .postfoot .textcontrols span a').css('background-color', 'transparent');
								$('.postbitlegacy .postfoot .textcontrols span.seperator').css('border-right', '1px #000000 solid');
							}
						}
						
						return (thanksOptions.thanksEntries[postid][varName] >= threshold ? 'thanks_highlight_' + thanksOptions.colorOptions[varName][threshold]['color'] : '');
					});
				}

				console.log('Colouring post ' + postid + ' with colour ' + thanksOptions.colorOptions[varName][threshold]['color']);
				return true;
			}
		}
	}
	
	// #########################################################################
	// Refreshes a post display
	function _displayPost(postid)
	{
		var postCount = $('#postcount' + postid).attr('name');
		
		var extraParams = {
			'securitytoken' : SECURITYTOKEN,			
			'p'				: postid,
			'postcount' 	: (typeof postCount != 'undefined' ? parseInt(postCount) : thanksOptions.postCount)
		};
		var type = 'POST';
		
		var jqxhr = $.ajax({
			type: type,
			url: 'showpost.php',
			data: (SESSIONURL ? SESSIONURL + '&' : '') + $.param(extraParams)
		})
		.done(function(data)
		{
			var postbit = $('postbit', data).text();
			
			if (thanksOptions.vbversion == 3)
			{
				var postWrapper = $('#post' + postid);
				//var postWrapper2 = YAHOO.util.Dom.get('post' + postid);
			}
			else
			{
				var postWrapper = $('#post_' + postid);
				//var postWrapper2 = YAHOO.util.Dom.get('post_' + postid);				
			}
			
			//var postWrapper = $('#dbtech_ajaxthreads_postid_' + index)			
			
			if (postbit)
			{
				var newpostbit = string_to_node(postbit);
				
				// Replace post
				//postWrapper2.parentNode.replaceChild(newpostbit, postWrapper2);
				postWrapper.replaceWith(newpostbit);
					
				// Init the postbit
				PostBit_Init(newpostbit, postid);
				
				// Re-colours the post
				_colourPost(postid);
			}
		});
		return false;
	};

	// #########################################################################
	// Debugging function, generates a timestamp of when something occurred
	function timeStamp()
	{
		var d = new Date();
		
		return '[' + d.getHours() + ':' + d.getMinutes() + ':' + d.getSeconds() + '] ';
	};

});