$.noConflict(true)(function($)
{
	// Define some variables
	// Define some variables
	var ftd = $(document),
		currentTab;
	
	
	// Tab changes
	$('a[name="thankstab"]').on('click', function(e)
	{
		// Ensure the anchor doesn't add
		e.preventDefault();
		
		var thisTab = $(this),
			tabList = thisTab.parent().parent().children('dd'),
			currentTab;
		
		tabList.each(function(index, element)
		{
			if ($(element).hasClass('selected'))
			{
				// Set current tab
				currentTab = $(element).children('a').attr('data-tabid');
				return true;
			}
		});
		
		if (thisTab.attr('data-tabid') == currentTab)
		{
			// No need to do anything
			return true;
		}
		
		// Clean up old tab / view
		$('a[name="thankstab"][data-tabid="' + currentTab + '"]').parent().removeClass('selected');
		$('div[name="thanksview"][data-tabid="' + currentTab + '"]').fadeOut('fast')
		
		// Update current tab storage
		currentTab = thisTab.attr('data-tabid');
		
		// Set selected on new tab
		thisTab.parent().addClass('selected');
		$('div[name="thanksview"][data-tabid="' + currentTab + '"]').fadeIn('fast').promise().done(function()
		{
			$('select[name="varname"]').trigger('change');
		});
	});
	
	// Clicks of the buttons
	ftd.on('change', 'select[name="varname"]', function()
	{
		var val = $(this).val(),
			blockId = $(this).attr('data-blockid');
			
		$('ul[name="display"][data-varname!="' + val + '"][data-blockid="' + blockId + '"]').fadeOut('fast').promise().done(function()
		{
			// Remove this element from the DOM
			$('ul[name="display"][data-varname="' + val + '"][data-blockid="' + blockId + '"]').fadeIn('fast');
		});
		
	});
	
	$('select[name="varname"]').each(function(index, element)
	{
		$('ul[name="display"][data-varname="' + $(this).val() + '"][data-blockid="' + $(this).attr('data-blockid') + '"]').fadeIn('fast');
	});
});