<?php
do
{
	if ($vbulletin->options['dbtech_thanks_disabledintegration'] & 8)
	{
		// Disabled integration
		break;
	}

	$ids = THANKS::$db->fetchAllSingleKeyed('
		SELECT usernoteid
		FROM $usernote AS usernote
		WHERE usernote.userid = ?
		ORDER BY usernote.dateline
		LIMIT :limitStart, :limitEnd
	', 'usernoteid', 'usernoteid', array(
		$userinfo['userid'],
		':limitStart' => ($limitlower - 1),
		':limitEnd' => $vbulletin->GPC['perpage']
	));
	
	// $cache_postids
	$post_ids = 'contentid IN (0' . implode(',', $ids) . ')';
	
	if ($post_ids)
	{
		// Init this
		THANKS::$entrycache = array(
			'data' 			=> array(),
			'display' 		=> array(),
			'others' 		=> array(),
			'clickcount' 	=> array(),
		);
		
		$results = THANKS::$db->fetchAll('
			SELECT
				entry.*,
				user.userid,
				user.username,
				user.usergroupid,
				user.membergroupids,
				user.infractiongroupid,
				user.displaygroupid
				:vBShop
			FROM (SELECT * FROM $dbtech_thanks_entry WHERE :postIds AND contenttype = \'usernote\') AS entry
			LEFT JOIN $user AS user USING(userid)
			ORDER BY entry.entryid DESC
		', array(
			':vBShop' 	=> ($vbulletin->products['dbtech_vbshop'] ? ", user.dbtech_vbshop_purchase" : ''),
			':postIds' 	=> $post_ids
		));
		foreach ($results as $result)
		{
			THANKS::$entrycache['data'][$result['contentid']][$result['varname']][$result['userid']] = $result;
		}
		
		if (THANKS::$isPro)
		{
			$results = THANKS::$db->fetchAll('
				SELECT entryid, varname, userid
				FROM $dbtech_thanks_entry AS entry
				WHERE userid = ?
					AND entry.contenttype = \'usernote\'
					AND dateline >= ?
			', array(
				$vbulletin->userinfo['userid'],
				(TIMENOW - 86400),	
			));
			foreach ($results as $result)
			{
				// Increment counter
				THANKS::$entrycache['clickcount'][$result['varname']]++;
			}
		}
		
		// Prepare entry cache
		THANKS::processEntryCache();	
	}
		
	// Grab the statistics stuff
	require(DIR . '/dbtech/thanks/hooks/statistics.php');
}
while (false);
?>